# 2021CCL-中文空间语义理解评测

* 任务简介

  * 本次评测设置了三个任务来考察机器的空间认知能力，分别是：（1）中文空间语义正误判断；（2）中文空间语义异常归因合理性判断；（3）中文空间语义判断与归因联合任务。要求机器在识别中文空间语义异常的同时，也能够对异常的原因加以解释。
  * 官网：http://ccl.pku.edu.cn:8084/SpaCE2021/ 、https://github.com/2030NLP/SpaCE2021

* 时间：2021.4~2021.7

* 数据示意

  > 子任务1-中文空间语义正误判断：判断给定中文文本是否存在空间关系异常。

  | 文本                                                         | 是否异常 | 说明           |
  | ------------------------------------------------------------ | -------- | -------------- |
  | 信一送**过来**，他后了悔。他知道亲家的脾气多硬，多倔。要是钱先生见信后还不肯跟日本人合作，那金三不就是把孩子往死里送了吗？ | 否       | 正常           |
  | 他此言一出，厅**顶**群道尽皆耸然动容。天虚沉吟未答，石清又道：“小弟夫妇执掌本门之后，这碗腊八粥，便由我们二人**上**侠客岛**去**尝一尝。” | 是       | 道士不会在厅顶 |

  

  > 子任务2-中文空间语义异常归因合理性判断：判断给定归因是否可以用来解释给定中文文本中所存在的空间关系异常。  
  >
  > 归因类型：词语搭配问题、词语语义冲突、上下文信息冲突、常识问题。

  

  <table>
      <tr>
          <td>文本</td>
          <td>抬轿之人只要脚步稍慢，轿中软鞭挥出，刷刷几下，重重打在<span style='color:red'>上面</span>的轿夫<span style='color:blue'>背上</span>，在<span style='color:blue'>前</span>的轿夫不敢慢步，在<span style='color:blue'>后</span>的轿夫也只得<span style='color:blue'>跟着</span>飞奔，几名官差<span style='color:blue'>跟随在后</span>。</td>
      </tr>
      <tr>
          <td>是否异常</td>
          <td>是</td>
      </tr>
      <tr>
          <td>归因</td>
          <td>“上面的轿夫”不符合常识：轿夫抬轿不可能在轿子上面</td>
      </tr>
      <tr>
          <td>归因是否正确</td>
          <td>正确</td>
      </tr>
  </table>

  | 归因类型       | 文本                                                         | 归因                                             |
  | -------------- | ------------------------------------------------------------ | ------------------------------------------------ |
  | 词语搭配问题   | 在这种**教学方式项**，教师除全面掌握和运用教材外，还必须善于用言语在课堂上表达出来，因此教师语言表达能力在传授知识中占有十分重要的地位。 | “教学方式”和“项”不宜搭配                         |
  | 词语语义冲突   | 只见谢烟客**走进**一个**山洞前边**，过了一会，洞中有黑烟冒出，却是在烹煮食物，又过少时，香气一阵阵地冒出来，那少年腹中饥饿，走进洞去，见是老大一个山洞。 | “山洞前边”和“走进”语义冲突                       |
  | 上下文信息冲突 | 突然间轿中飞出一物，已**罩住了他脑袋**。那人登时眼前漆黑一片，大惊之下忙向后跃，再抓起**罩在脚上之物**，用力掷落，却是一顶官帽。 | “罩住了他脑袋”与上下文“罩在脚上之物”存在信息冲突 |
  | 常识问题       | 抬轿之人只要脚步稍慢，轿中软鞭挥出，刷刷几下，重重打在**上面的轿夫**背上，在前的轿夫不敢慢步，在后的轿夫也只得跟着飞奔，几名官差跟随在后。 | “上面的轿夫”不符合常识，轿夫抬轿不可能在轿子上面 |

  

  > 子任务3-中文空间语义判断与归因联合任务：首先判断给定中文文本是否存在空间关系异常，若存在异常，再判断给定归因是否可以用来解释该异常。

  <table>
      <tr>
          <td>文本</td>
          <td>正在<span style='color:blue'>山上</span>对着白云唱歌的薄平看到<span style='color:blue'>远远的山坡上</span>走<span style='color:blue'>来</span>的王实味，慌忙<span style='color:red'>躲进</span>一个山洞里，王实味<span style='color:blue'>漫山遍野里</span>找呀，喊呀，一直折腾到天黑，薄平就是<span style='color:red'>不进去</span>。</td>
      </tr>
      <tr>
          <td>是否异常</td>
          <td>是</td>
      </tr>
      <tr>
          <td>归因</td>
          <td>“薄平就是不进去”不符合常识：人不可能进山洞</td>
      </tr>
      <tr>
          <td>归因是否正确</td>
          <td>错误（应该是上下文信息冲突）</td>
      </tr>
  </table>
  
  
* 数据说明

  > 数据实例

  ```json
  {
      "qID": "3-dev-37",
      "context": "石清见城外那道冰沟有三丈来阔，不易跃过。寻常城墙内都有护城河，此处气候严寒，护城河中河水都结成了冰，但这沟挖得极深，沟边滑溜溜地结成一片冰壁，不论人兽，掉将下去都是极难上来。",
      "reason": "“城墙内”不符合常识：护城河都在城墙外",
      "judge1": false,
      "judge2": true
  }
  ```

  * qID：试题编号
  * context：文本材料
  * reason：子任务2及子任务3中，对文本材料中空间关系异常的归因。
  * judge1：子任务1中，对文本是否存在空间异常的判断。true表示句子成立，无异常；false表示句子不成立，有异常。
  * judge2：子任务2及子任务3中，对归因是否能够解释文本材料的空间关系异常的判断。true表示归因成立；false表示归因不成立。

  > [CCL2021中文空间语义理解评测数据集使用许可](https://github.com/2030NLP/SpaCE2021/blob/main/data/LICENSE.md)   
  >
  > [dev with answer](http://ccl.pku.edu.cn:8084/SpaCE2021/download) 

  |             子任务             | train |  dev  | test  | total  |                             下载                             |                             备注                             |
  | :----------------------------: | :---: | :---: | :---: | :----: | :----------------------------------------------------------: | :----------------------------------------------------------: |
  |      中文空间语义正误判断      | 4,237 |  806  |  794  | 5,837  | [√](https://github.com/2030NLP/SpaCE2021/tree/main/data/pack1) |       三个数据集之间，所使用的原始语料没有交集，下同。       |
  | 中文空间语义异常归因合理性判断 | 5,989 | 2,088 | 1,952 | 10,029 |                             同上                             | （1）任一数据集所使用的context与子任务1的验证集和测试集无交集。<br>（2）训练集所使用的context与子任务1的训练集有交集 |
  | 中文空间语义判断与归因联合任务 |   0   | 1,203 | 1,167 | 2,370  |                             同上                             | （1）不提供训练集 <br> （2）验证集和测试集所使用的context与子任务1的相应数据集相同 |

* 竞赛方案

  |                             方案                             |                           汇报题目                           | task1 Acc | task2 Acc | task3 F1 |                        代码                        |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :-------: | :-------: | :------: | :------------------------------------------------: |
  | 4（[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 02:47:32~ 03:03:07） | 基于空间方位词表的中文空间关系抽取模型，胡松林（天津大学 新传学院） |   0.68    |   0.77    |   0.66   |                         ×                          |
  | 3（[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 03:03:45~03:14:10） | Prompting在中文空间语义理解中的应用与实践，余伟（国防科技大学 计算机学院） |   0.73    |   0.75    |   0.66   |                         ×                          |
  | 2（[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 03:15:29~03:26:40） | 中文空间语义理解评测技术报告，苏江文（国网信通产业集团福建亿榕信息技术有限公司） |   0.72    |   0.81    |   0.62   |                         ×                          |
  | 1（[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 03:28:10~03:45:40） | 基于ERNIE的中文空间语义理解，张帅（中航(上海)航空无线电电子技术有限公司） |   0.73    |   0.84    |   0.65   |                         ×                          |
  |                           baseline                           |                              *                               |   0.67    |   0.73    |   0.53   | [√](https://github.com/2030NLP/SpaCE2021-Baseline) |
  |                            other                             |                              *                               |   0.70    |   0.80    |    *     |      [√](https://github.com/JunnYu/space2021)      |

  

* 推荐资料

  中文空间语义理解评测总体报告 （[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 02:31:15~02:46:30）