# 2020CCKS新冠知识图谱构建与问答评测-子任务1：新冠百科知识图谱类型推断

* 任务简介

  * 本评测任务围绕新冠百科知识图谱构建中的**实体类型推断（Entity Type Inference）**展开。评测从实体百科（包括百度百科、互动百科、维基百科、医学百科）页面出发，从给定的数据中推断相关实体的类型。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_7_1/

* 时间：2020.3~2020.9

* 数据示例

  > 输入  

  entity.txt：需要进行类型预测的所有实体，其中包含相关实体和噪音实体。  

  entity_page_1.xml，entity_page_2.xml，entity_page_3.xml，entity_page_4.xml：分别来自百度百科，互动百科，中文维基百科，医学百科的实体页面内容。保证 entity.txt 中的任意实体至少被一个页面文件所涵盖。实体页面文件中包含类型推断可能会用到的名称、标签、简介等信息。  

  type.txt：包含 7 个目标类型，分别是病毒、细菌、疾病、药物、医学专科、检查科目、症状（非目标类型输出为 NoneType）。  

  > entity.txt

  ```
  烟草花叶病毒
  大肠杆菌
  艾滋病
  盐酸西普利嗪
  内科
  太阳
  ```

  > entity_page_1.xml（其它xml文件也是类似的）

  ![entity_page_1.xml](https://www.biendata.xyz/media/competition/2020/03/30/15855371102657318133.png?raw=true)

  > type.txt

  ```
  病毒
  细菌
  疾病
  药物
  医学专科
  检查科目
  症状
  ```

  > 输出

  ``` 
  烟草花叶病毒    病毒
  大肠杆菌    细菌
  艾滋病    疾病
  盐酸西普利嗪    药物
  内科    医学专科
  太阳    NoneType
  ```

  实体“太阳”不在给定的 7 种目标类型当中，因此输出为 NoneType。

* 数据说明

  | 训练集 | 开发集 | 测试集 |                             下载                             |
  | :----: | :----: | :----: | :----------------------------------------------------------: |
  | 5,000  | 20,000 | 14,321 | [官网](https://www.biendata.xyz/competition/ccks_2020_7_1/data/) |

  实体页面约17.5W，允许对训练数据进行标注。  

  ps：存在一个实体有两个类型的情况，数据中用 “类型1;类型2” 来表示，在评估时推断出其中一个即为正确。

* 竞赛方案

  |                             方案                             |                           评测论文                           | 代码 |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :--: |
  | [top1](https://picture.iczhiku.com/weixin/message1605489965549.html) |                              ×                               |  ×   |
  |                             top2                             | [新冠知识图谱构建与问答评测子任务一：新冠百科知识图谱类型推断 评测报告](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_1_2.pdf) |  ×   |
  |                             top3                             | [A BERT-Based Framework for Chinese Medical Entity Type Inference](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_1_3.pdf) |  ×   |

* 推荐资料

  https://pypi.org/project/theta/  