# 2020ccks 面向中文短文本的实体链指任务

* 任务简介

  * 输入：中文短文本以及该短文本中的实体集合。
  * 输出：输出文本指中文短文本的实体链指结果。每个结果包含：实体mention、在中文短文本中的位置偏移、其在给定知识库中的id，如果为NIL情况，需要再给出实体的上位概念类型。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_el/

* 参赛时间：2020.3~2020.9

* 数据格式

  输入：

  ```json
  {
      "text_id":"1",
      "text":"《琅琊榜》海宴_【原创小说|权谋小说】",
      "mention_data":[
          {
              "mention":"琅琊榜",
              "offset":"1"
          },
          {
              "mention":"海宴",
              "offset":"5"
          },
          {
              "mention":"原创小说",
              "offset":"9"
          },
          {
              "mention":"权谋小说",
              "offset":"14"
          }
      ]
  }
  ```

  输出：

  ```json
  {
      "text_id":"1",
      "text":"《琅琊榜》海宴_【原创小说|权谋小说】",
      "mention_data":[
          {
              "kb_id":"2135131",
              "mention":"琅琊榜",
              "offset":"1"
          },
          {
              "kb_id":"10572965",
              "mention":"海宴",
              "offset":"5"
          },
          {
              "kb_id":"215143",
              "mention":"原创小说",
              "offset":"9"
          },
          {
              "kb_id":" NIL_Work ",
              "mention":"权谋小说",
              "offset":"14"
          }
      ]
  }
  ```

  知识库：该任务的知识库来自百度百科知识库。知识库中的每个实体都包含一个subject_id(知识库id)，一个subject名称，实体的别名，对应的概念类型，以及与此实体相关的一系列二元组< predicate，object>（<属性，属性值>）信息形式。知识库中每行代表知识库的一条记录（一个实体信息），每条记录为json数据格式。

  ```json
  {
      "subject_id":"1000131",
      "subject":"小王子",
      "alias":[
          "Le Petit Prince",
          "The Little Prince",
          "リトルプリンス 星の王子さまと私",
          "小王子"
      ],
      "type":[
          "Work"
      ],
      "data":[
          {
              "predicate":"外文名",
              "object":"Le Petit Prince"
          },
          {
              "predicate":"发行公司",
              "object":"派拉蒙影业"
          },
          {
              "predicate":"类型",
              "object":"奇幻"
          }
      ]
  }
  ```

* 数据说明

  * 本次竞赛的数据从自然网页标题、多模标题、搜索query中抽取得到，通过人工众包标注，知识库实体重复率约5%，实体上位概念准确率95.27%，数据集标注准确率95.32%。

  | 数据集 |                       下载                        |
  | :----: | :-----------------------------------------------: |
  | 80,000 | https://ai.baidu.com/broad/subordinate?dataset=kg |

  ![NIL实体的上位类型集合](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87/pic/1.png?raw=true)

* 竞赛方案

  |                             方案                             |                           评测论文                           | 代码 |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :--: |
  |   [top1](https://www.bilibili.com/video/BV1jK4y177Ya?p=22)   | [《面向中文短文本的多因子融合实体链指研究》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_2_1.pdf) |  ×   |
  |                             top2                             | [《知识增强的实体消歧与实体类别判断》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_2_2.pdf) |  ×   |
  |                             top3                             | [《Improving Entity Linking by a Novel Pipeline Method For Chinese Short Text》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_2_3.pdf) |  ×   |
  |                             top7                             | [《基于多任务层投影 ERNIE 的短文本实体链接及实体分类方法》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_2_8.pdf) |      |
  | [总体报告](https://www.bilibili.com/video/BV1jK4y177Ya?p=21) |                              ×                               |  ×   |

  

