# 2020CCKS面向试验鉴定的命名实体识别

* 任务简介

  * 要求从文本中识别出“试验要素”、“性能指标”、“系统组成”、“任务场景”等内容
  * 官网：https://www.biendata.xyz/competition/ccks_2020_8/

* 时间：2020.3~2020.9

* 数据示例

  输入：1.试验鉴定相关自然语言文本集合：D = {d<sub>1</sub>, ... d<sub>N</sub>}, d<sub>i</sub> = <w<sub>i1</sub>, ... w<sub>in</sub>> 2.预定义类别： C = {c<sub>1</sub>, ... c<sub>m</sub>}

  > 美国洛马公司在新墨西哥州白沙导弹靶场，完成**“微型碰撞杀伤”拦截弹**重新设计后的第二次飞行试验，进一步检验了拦截弹的**敏捷性**和**气动性能**，标志着其成熟度进一步提升。“微型碰撞杀伤”拦截弹采取**直接碰撞杀伤技术**，主要用于提高**美国陆军**应对**火箭弹威胁**的能力。

  输出：实体mention和所属类别对的集合：{<m<sub>1</sub>, c<sub>m1</sub>>, <m<sub>2</sub>, c<sub>m2</sub>>, ... <m<sub>p</sub>, c<sub>mp</sub>>}，其中m<sub>i</sub> = <d<sub>i</sub>, b<sub>i</sub>, e<sub>i</sub>>是出现在文档d<sub>i</sub>中的试验鉴定实体mention，b<sub>i</sub>和e<sub>i</sub>分别表示m<sub>i</sub>在d<sub>i</sub>中的起止位置， c<sub>mi</sub> ∈ C表示所属的预定义类别。要求实体mention之间不重叠，即 e<sub>i</sub> < b<sub>i+1</sub> 。多次出现的实体只标注一次。

  ````json
  {
  	"begin_pos":21,"end_pos":31,"试验要素"
  	"begin_pos":56,"end_pos":58,"性能指标"
  	"begin_pos":60,"end_pos":63,"性能指标"
  	"begin_pos":91,"end_pos":98,"系统组成"
  	"begin_pos":106,"end_pos":109,"任务场景"
  	"begin_pos":112, "end_pos":116,"任务场景"
  }
  ````

  预定义类别：

  > （1）试验要素：试验鉴定工作的对象，如列为考核目标的武器装备（系统级）、技术、战术、人员、对象之间的能力等；支持完成试验鉴定所需的条件，如陪试品、参试装备、测试、测量、靶标、仿真等；装备的基本情况等。
  >
  > 例如：RS-24弹道导弹、SPY-1D相控阵雷达、紫菀防空导弹（Aster）、F-35“闪电”II型联合攻击战斗机、“阿利·伯克”级Flight IIA型驱逐舰“约翰芬”号、协同通信与指挥、连续波测量雷达、电影经纬仪、无人机靶标等。

  > （2）性能指标：试验要素在技术、使用等性能方面的定性、定量描述，如重量、射程、可靠性等。
  >
  > 例如：测量精度、圆概率偏差、失效距离、准备时间、反激光毁伤、发射方式等。

  > （3）系统组成：被试对象的组成部分，如子系统、部件、采用的技术等。
  >
  > 例如：动能杀伤飞行器（KKV）、中波红外导引头、助推器、整流罩、箔条红外混合诱饵弹、碰撞杀伤技术、柔性摆动喷管技术、端羟基聚丁二烯等。

  > （4）任务场景：试验要素在发挥其实际效用和价值中涉及的信息，如人员、对抗目标、体系能力等。
  >
  > 例如：法国海军、导弹预警、恐怖袭击、迫击炮威胁、排级作战等。

* 数据说明

  |        | 文本 | 试验要素 | 性能指标 | 系统组成 | 任务场景 | 标注总数 |                             下载                             |
  | :----: | :--: | :------: | :------: | :------: | :------: | :------: | :----------------------------------------------------------: |
  | 训练集 | 400  |   1188   |   854    |   694    |   662    |   3398   | [√](http://openkg.cn/dataset/ent-rec) 、[ccks_8_data_v2.zip](https://github.com/AI-confused/CCKS2020_Military_NER_Baseline/blob/master/ccks_8_data_v2.zip) |

  

* 竞赛方案

  |                           方案                           |                           评测论文                           |                     代码                     |
  | :------------------------------------------------------: | :----------------------------------------------------------: | :------------------------------------------: |
  | [top1](https://www.bilibili.com/video/BV1jK4y177Ya?p=32) | [《基于异构编码和词增强的试验鉴定命名实体识别方法》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_8_1.pdf) | [√](https://github.com/hy-struggle/ccks_ner) |
  |                           top2                           | [《基于 BERT 与二级融合的小样本命名实体识别》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_8_2.pdf) |                      ×                       |
  | [top4](https://www.bilibili.com/video/BV1jK4y177Ya?p=33) | [《基于领域迁移和任务迁移相结合的试验鉴定文本命名实体识别》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_8_4.pdf) |                      ×                       |

* 推荐资料

  https://github.com/loujie0822/DeepIE

