# 2021CCL-跨领域句法分析评测

* 任务简介

  * 使用除目标领域外的其它给定领域得到一个在目标领域泛化性能良好的依存句法解析器。例如当目标领域为ZX时，可以使用其他五个领域（包括BC）的训练数据，即BC/PB/PC/FIN/LEG-Train。[call for participation](http://hlt.suda.edu.cn/images/0/04/%E4%BE%9D%E5%AD%98%E5%8F%A5%E6%B3%95%E9%A2%86%E5%9F%9F%E7%A7%BB%E6%A4%8D%E8%AF%84%E6%B5%8Bccl2021-cfp-v5.0.pdf) 
  * 官网：http://hlt.suda.edu.cn/index.php/CCL2021 （8:00~18:00可访问）

* 时间：2021.4~2021.8

* 数据示例

  > 第10列的概率为2.0时表明为人工标注，否则为模型自动补全

  ```
  1	被	_	LB	LB	_	19	adv	_	2.0000
  2	1987	_	CD	CD	_	3	att	_	0.9999
  3	年	_	M	M	_	5	att	_	2.0000
  4	6	_	CD	CD	_	5	att	_	0.9520
  5	月	_	NN	NN	_	7	att	_	2.0000
  6	25	_	CD	CD	_	7	att	_	0.9873
  7	日	_	M	M	_	9	adv	_	2.0000
  8	国务院	_	NN	NN	_	9	subj	_	1.0000
  9	发布	_	VV	VV	_	16	att	_	2.0000
  10	的	_	DEC	DEC	_	9	adjct	_	1.0000
  11	《	_	PU	PU	_	10	punc	_	2.0000
  12	中华人民共和国	_	NR	NR	_	14	att	_	2.0000
  13	建筑	_	NN	NN	_	14	att	_	0.9994
  14	税	_	NN	NN	_	16	att	_	0.6252
  15	暂行	_	JJ	JJ	_	16	att	_	0.9889
  16	条例	_	NN	NN	_	1	pobj	_	2.0000
  17	》	_	PU	PU	_	16	punc	_	2.0000
  18	明令	_	NN	NN	_	19	adv	_	2.0000
  19	废止	_	VV	VV	_	0	root	_	2.0000
  20	。	_	PU	PU	_	19	punc	_	2.0000
  ```

  Train/Dev/Unlabeled数据文件均为“CoNLL”格式，在CoNLL格式中，每个词语占一行，每行10列，无值列用下划线 '_' 代替，列的分隔符为制表符'\t'，行的分隔符为换行符'\n'；句子与句子之间用空行'\n'分隔。 下面介绍一下我们本次评测使用到的列：  

  - 1.当前词在句子中的序号，从1开始；
  - 2.当前词语或标点；
  - 4.当前词语的词性；
  - 7.当前词语的核心词；
  - 8.当前词语与核心词的依存关系；
  - 10.依存弧的概率；

* 数据说明

  > BC：平衡语料  
  >
  > PB：产品博客  
  >
  > PC：产品评论  
  >
  > FIN：财经资讯  
  >
  > LEG：法律资讯  
  >
  > ZX：网络小说  
  >
  > 注：BC作为基础数据，只作为源领域。后五个领域既可以作为源领域，也可以作为目标领域。另外，针对后五个领域，官方还提供了大规模的无标注数据。  
  >
  > 要申请数据集，请查看官网要求  

  | domain | train | dev  | test | unlabeled | 下载 |
  | :----: | :---: | :--: | :--: | :-------: | :--: |
  |   BC   | 26.1K |  1K  |  2K  |     0     |  ×   |
  |   PB   |  5K   | 1.3K | 2.5K |   291K    |  ×   |
  |   PC   | 6.8K  | 1.3K | 2.6K |   349K    |  ×   |
  |  FIN   |  5K   |  1K  | 1.8K |   118K    |  ×   |
  |  LEG   |  5K   |  1K  | 1.9K |   150K    |  ×   |
  |   ZX   | 1.5K  | 0.5K |  1K  |    33K    |  ×   |

  

* 竞赛方案（closed track）

  > UAS=核心节点正确的词数/总词数  
  >
  > LAS=核心节点正确、并且对应依存关系类型也正确的词数/总词数

  |                         方案 / rank                          |                 汇报题目                 | avg UAS | avg LAS |                             代码                             |
  | :----------------------------------------------------------: | :--------------------------------------: | :-----: | :-----: | :----------------------------------------------------------: |
  | official baseline （[link](http://192.168.126.172/index.php/CCL2021#:~:text=75.64-,baseline%20%E7%AE%80%E4%BB%8B,-baseline%E6%A8%A1%E5%9E%8B) ） |                    *                     |  67.32  |  59.67  |           [√](https://github.com/yzhangcs/parser)            |
  | 1 （[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 01:01:12~01:14:39，[ppt](http://hlt.suda.edu.cn/index.php/%E6%96%87%E4%BB%B6:CCL2021-report-%E5%8D%8E%E4%B8%9C%E5%B8%88%E8%8C%83.pdf) ） | 《基于自监督对比学习的跨域依存句法分析》 |  67.78  |  60.16  | [√](https://github.com/JT-Ushio/AntNLP_XDomain_DEP_Parser-CCL2021) （分支里） |
  | 3 （[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 00:46:45~01:00:30，[ppt](http://hlt.suda.edu.cn/index.php/%E6%96%87%E4%BB%B6:CCL2021-report-%E5%A4%A9%E5%A4%A7.pdf) ） | 《多源零样本场景下的跨领域依存句法分析》 |  63.86  |  53.98  |                              ×                               |
  | 4 （[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 00:30:49~00:45:43，[ppt](http://hlt.suda.edu.cn/index.php/%E6%96%87%E4%BB%B6:CCL2021-report-%E5%8C%97%E9%82%AE.pdf) ） | 《多源跨域依存分析场景下的交叉标注算法》 |  50.70  |  39.70  |                              ×                               |
  | 5 （[video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) 00:16:03~00:30:13） |      《依存句法分析的领域适应学习》      |  31.81  |  15.35  |                              ×                               |

  

* 推荐资料

  [《2021CCL技术评测情况报告》](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9rp) 

  [跨领域句法分析评测总体报告](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qj) （00:03:00~00:15:28）、[ppt](http://hlt.suda.edu.cn/index.php/%E6%96%87%E4%BB%B6:CCL2021-report-%E8%8B%8F%E5%A4%A7.pdf) 