# 2020CCKS新冠知识图谱构建与问答评测-子任务3：新冠科研抗病毒药物图谱的链接预测

* 任务简介

  * 对于给定的新冠科研抗病毒药物图谱，其中存在n 个已知的三元组，任务的目标是给定三元组的头实体和关系，或者给定三元组的关系和尾实体，即（h,r,?）或（?,r,t）的形式，来预测“?” 所代表的实体。在CCKS2020 新冠科研抗病毒药物图谱的链接预测中，考虑多种关系预测：病毒-药物关系预测、蛋白-蛋白交互预测，病毒-病毒蛋白交互预测等，这些共同构成全局的关系预测。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_7_3/

* 时间：2020.3~2020.9

* 数据示例

  > 输入  
  >
  > • schema.json：知识图谱的图谱模式（Schema），即定义了知识图谱的实体类型（Entity）、实体属性名（Attribution key）和实体间的关系（Relationship）。  
  > • entities.json：实体列表，即病毒、药物、蛋白（宿主蛋白和病毒蛋白）。  
  > • attrs.json：实体属性列表，包括病毒的宿主、病毒所属的族系列表、药物的类型、药物的分类、蛋白的类型等。  
  > • relationships.json：实体与实体之间的关系列表，即[effect]病毒-药物作用，[produce]病毒-病毒蛋白产生关系，[Interaction、binding]病毒蛋白-宿主蛋白的相互作用等。  
  > • link_prediction.json：待评测的头实体或者尾实体和关系组成的对。  
  > • virus2sequence.json：存放病毒的碱基序列。  

  schema.json

  ```json
  {
      "entity_type": ["Virus", "Drug", "Protein"],
      "attrs": {
       	"Virus": ["lineage", "host"],
      	"Drug": ["drug_type", "drug_category"],
      	"Protein": ["protein_type", "cellular_location"]
       },
      "releationships":[
          ["Drug", "effect", "Virus"],
          ["Virus", "produce", "Protein"],
          ["Protein", "interaction", "Protein"],
          ["Protein", "binding", "Protein"]
      ]
  }
  ```

  entities.json

  ```json
  {
      "Virus": ["ENTITY_14", "ENTITY_23", "ENTITY_26", ...],
      "Drug": ["ENTITY_66", "ENTITY_80", "ENTITY_320", ...],
      "Protein": ["ENTITY_1", "ENTITY_2", "ENTITY_3", ...]
  }
  ```

  attrs.json

  ```json
  {
      "attrs": [
          ["ENTITY_1", "protein_type", "Host Protein"], 
          ...
      ]
  }
  ```

  releationships.json

  ```json
  {
      "relationships": [
          ["ENTITY_229", "produce": "ENTITY_647"],
          ...
      ]
  }
  ```

  link_prediction.json

  ```json
  {
      "relationships":[
          ["ENTITY_2824", "binding", "?"],
          ["?", "interaction", "ENTITY_2063"],
          ...
      ]
  }
  ```

  virus2sequence.json

  ```json
  {
      "ENTITY_4973": "ACTACAATAATTCATGTATAAAACTAA...",
      "ENTITY_4680": "",
      ...
  }
  ```

  > 输出
  >
  > result.json：针对每个部分缺失的实体关系对所预测的对应 top 10 头或尾缺失实体队列集合（按可能性从高到低排序）。选手需要从队列中删除训练集已有链接的实体数据，防止占用并浪费队列位置。

  result.json

  ```json
  {
      "results":[
          [A1, B1, C1, ...],
          [A2, B2, C2, ...],
          ...
      ]
  }
  ```

  

* 数据说明

  | 训练集 | A榜测试集 | B榜测试集 |                             下载                             |
  | :----: | :-------: | :-------: | :----------------------------------------------------------: |
  | 40,000 |   4,256   |   5,000   | [官网](https://www.biendata.xyz/competition/ccks_2020_7_3/data/) |

  

* 竞赛方案

  | 方案 |                           评测论文                           | 代码 |
  | :--: | :----------------------------------------------------------: | :--: |
  | top1 | [基于 MDistMult 模型的新冠科研抗病毒药物图谱的链接预测](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_3_1.pdf) |  ×   |
  | top2 | [基于 RotatE 和贝叶斯学习的新冠知识图谱链接预测](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_3_2.pdf) |  ×   |
  | top3 | [Link Prediction based on Tensor Decomposition for the Knowledge Graph of COVID-19 Antiviral Drug](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_3_3.pdf) |  ×   |

  