# 2018法研杯-刑期预测

* 任务简介
  * 根据刑事法律文书中的案情描述和事实部分，预测被告人的刑期长短
  * 官网：http://cail.cipsc.org.cn:2018/instruction
  
* 时间：2018.5~2018.9

* 数据示例

  ```json
  {
      "fact":"2015年11月5日上午，被告人胡某在平湖市乍浦镇的嘉兴市多凌金牛制衣有限公司车间内，与被害人孙某因工作琐事发生口角，后被告人胡某用木制坐垫打伤被害人孙某左腹部。经平湖公安司法鉴定中心鉴定：孙某的左腹部损伤已达重伤二级。",
      "meta":
      {
          "relevant_articles": [234],  
          "accusation": ["故意伤害"], 
          "criminals": ["段某"],  
          "term_of_imprisonment": 
          {
              "death_penalty": false,  
              "imprisonment": 12, 
              "life_imprisonment": false
          }
      }
  }
  ```

  * fact：事实描述
  * meta：标注信息
    * criminals：被告（数据中均只含一个被告）
    * accusation：罪名
    * relevant_articles：相关法条
    * punish_of_money：罚款（单位：元）
    * term_of_imprisonment：刑期（单位：月）
      * death_penalty：是否死刑
      * imprisonment：有期徒刑
      * life_imprisonment：是否无期

* 数据说明

  |          |   train   |  dev   |  test   |                             下载                             |
  | :------: | :-------: | :----: | :-----: | :----------------------------------------------------------: |
  |  练习赛  |  154,592  | 17,131 | 32,508  | [√](https://cail.oss-cn-qingdao.aliyuncs.com/CAIL2018_ALL_DATA.zip) |
  | 第一阶段 | 1,710,856 |   *    | 217,016 |                             同上                             |
  | 封闭测试 |     *     |   *    | 748,203 |                             同上                             |

  数据集论文：[《CAIL2018: A Large-Scale Legal Dataset for Judgment Prediction》](https://arxiv.org/abs/1807.02478) 

* 竞赛方案

  |                          方案/rank                           | score |                             代码                             |
  | :----------------------------------------------------------: | :---: | :----------------------------------------------------------: |
  | 5([paper](http://jcip.cipsc.org.cn/CN/abstract/abstract2923.shtml) ) | 77.06 |                              ×                               |
  |                           baseline                           | 47.83 | [√](https://github.com/thunlp/CAIL2018/tree/master/baseline) |

  

* 推荐资料

  相关论文很多，可根据数据集论文引文自行查找  

  [《面向判决文书的刑事案件刑期预测研究》](https://scjg.cnki.net/kcms/detail/detail.aspx?filename=1021523239.nh&dbcode=CMFD&dbname=CMFD2021&v=MTEwNjM0emg0WG5EMExUZzJYMmhzeEZyQ1VSN3VmYnVSckZpSGhWcnpQVkYyNUg3YTZIZFBQcHBFYlBJUitDMzg=&uid=WEEvREcwSlJHSldSdmVqM1BLVXBGdDhrUHEwUWRwNmJMaG5wUGhmcGx6QT0=$9A4hF_YAuvQ5obgVAqNKPCYcEjKensW4IQMovwHtwkF4VYPoHbKxJw!!) 

