# 2021医疗实体及关系识别挑战赛

* 任务简介

  * 对于给定的一组电子病历中的医技报告单文档，以及预先定义好的实体类别和关系类别，需要给出每个实体在文档中出现的起止位置，以及对应的实体类别;同时对于识别出来的实体，需要进一步判断是否存在预先定义好的关系。
  * 官网：http://challenge.xfyun.cn/topic/info?type=medical-entity

* 时间：2021.7~2021.10

* 数据示例

  > 原始句子和实体是字典的格式，每个实体由4部分构成，即<begin,end,tag,content>,其中begin表示该实体在文本中的开始位置，end表示该实体在文本中的结束位置，tag表示该实体的类型，content表示实体内容。

  ```json
  {
      "sent": "全 身 骨 骼 显 影 清 晰 ， 双 侧 髋 关 节 放 射 性 分 布 増 浓 ， 余 骨 放 射 性 分 布 均 匀 ， 未 见 明 显 异 常 放 射 性 分 布 区 。",
      "ners": [
          [0, 4, "器官组织", "全身骨骼"],
          [6, 8, "阴性表现", "清晰"],
          [9, 14, "器官组织", "双侧髋关节"],
          [14, 19, "属性", "放射性分布"],
          [19, 21, "阳性表现", "増浓"],
          [22, 24, "器官组织", "余骨"],
          [24, 29, "属性", "放射性分布"]
      ]
  }
  ```

  > 本次比赛共有18种实体类型

  ```
  修饰描述
  否定描述
  器官组织
  属性
  异常现象
  手术
  指代
  数量
  期象
  检查手段
  测量值
  疾病
  病理分型
  病理分期
  病理分级
  累及部位
  阳性表现
  阴性表现
  ```

  

  > 实体之间的关系由3部分构成，（头实体、尾实体、关系）。如([6, 8, "阴性表现", "清晰" ],[0, 4, "器官组织", "全身骨骼"],属性)，表示头实体为[6, 8, "阴性表现", "清晰"]，尾实体为[0, 4, "器官组织", "全身骨骼"])，二者之间存在属性关系。**训练集中尾实体为空的数据是为了表明关系的方向性，不计入统计指标**。

  ```
  [6, 8, "阴性表现", "清晰"]	[0, 4, "器官组织", "全身骨骼"]	属性
  [14, 19, "属性", "放射性分布"]	[9, 14, "器官组织", "双侧髋关节"]	 属性
  [19, 21, "阳性表现", "増浓"]	[14, 19, "属性", "放射性分布"]	属性
  [22, 24, "器官组织", "余骨"]	[36, 44, "异常现象", "异常放射性分布区"]	属性
  [24, 29, "属性", "放射性分布"]	[22, 24, "器官组织", "余骨"]	属性
  ```

  

* 数据说明

  | train | A榜 test | B榜 test |                             下载                             |
  | :---: | :------: | :------: | :----------------------------------------------------------: |
  | 4,000 |  1,000   |  1,000   | [√](https://github.com/yeqingzhao/relation-extraction/tree/master/data) |

  

* 竞赛方案

  > 评测指标用score代替，详细计算过程请访问官网

  |                         方案/rank B                          | A score | B score |                          代码                          |
  | :----------------------------------------------------------: | :-----: | :-----: | :----------------------------------------------------: |
  | 1（[video](https://www.bilibili.com/video/BV1hq4y1r7xB?p=13) （36:27~）） | 0.92129 | 0.92011 |                           ×                            |
  | 2（[知乎](https://zhuanlan.zhihu.com/p/415628366) 、[video](https://www.bilibili.com/video/BV1hq4y1r7xB?p=13) （22:15~36:05）） | 0.9108  | 0.91681 | [√](https://github.com/yeqingzhao/relation-extraction) |
  | 3（[video ](https://www.bilibili.com/video/BV1hq4y1r7xB?p=13) （00:48~21:55）） | 0.91191 | 0.90958 |                           ×                            |

  

* 推荐资料

  暂无