# 2020语言与智能技术竞赛：事件抽取任务

* 任务简介

  * 事件抽取任务的目标是通过给定目标事件类型和角色类型集合及句子，识别句子中所有目标事件类型的事件，并根据论元角色集合抽取事件所对应的论元。其中目标事件类型（event_type）和论元角色（role）限定了抽取的范围，例如：（event_type：胜负，role：时间，胜者，败者，赛事名称）、（event_type：夺冠，role：夺冠事件，夺冠赛事，冠军）。最终将抽取的所有事件论元按如下形式进行输出: {“id”: “id1”, “event_list”: [{“event_type”:“T1”, “arguments”: [{“role”:“R1”, “argument”:“A1”},…]}, {“event_type”:“T2”, “arguments”: [{“role”:“R2”, “argument”:“A2”},…]}]}，比赛将对参赛者最终输出的论元列表进行评估。
  * 官网：https://aistudio.baidu.com/aistudio/competition/detail/32

* 参赛时间：2020.3~2020.5

* 数据格式

  输入：包含事件信息的一个或多个连续完整句子。

  ```json
  {
     "text":"历经4小时51分钟的体力、意志力鏖战，北京时间9月9日上午纳达尔在亚瑟·阿什球场，以7比5、6比3、5比7、4比6和6比4击败赛会5号种子俄罗斯球员梅德韦杰夫，夺得了2019年美国网球公开赛男单冠军。",
     "id":"6a10824fe9c7b2aa776aa7e3de35d45d"
  }
  ```

  输出：属于预先定义的事件类型、类型角色的论元结果。

  ```json
  {
      "id":"6a10824fe9c7b2aa776aa7e3de35d45d",
      "event_list":[
          {
              "event_type":"竞赛行为-胜负",
              "arguments":[
                  {
                      "role":"时间",
                      "argument":"北京时间9月9日上午"
                  },
                  {
                      "role":"胜者",
                      "argument":"纳达尔"
                  },
                  {
                      "role":"败者",
                      "argument":"5号种子俄罗斯球员梅德韦杰夫"
                  },
                  {
                      "role":"赛事名称",
                      "argument":"2019年美国网球公开赛"
                  }
              ]
          },
          {
              "event_type":"竞赛行为-夺冠",
              "arguments":[
                  {
                      "role":"时间",
                      "argument":"北京时间9月9日上午"
                  },
                  {
                      "role":"夺冠赛事",
                      "argument":"2019年美国网球公开赛"
                  },
                  {
                      "role":"冠军",
                      "argument":"纳达尔"
                  }
              ]
          }
      ]
  }
  ```

* 数据说明

  | 训练集 | 验证集 | 测试集A | 测试集B |                             下载                             |
  | :----: | :----: | :-----: | ------- | :----------------------------------------------------------: |
  | 12,000 | 1,500  |  3,500  | 30,000  | [Baidu Research Open-Access Dataset - Download](https://ai.baidu.com/broad/download) （官方暂未开放下载） <br> [千言数据集：信息抽取](https://aistudio.baidu.com/aistudio/competition/detail/46/?isFromLUGE=TRUE) |

  本次竞赛采用百度最近发布的中文事件抽取数据集，包含65个事件类型的17000个具有事件信息的句子（20000个事件）。事件类型根据百度风云榜的热点榜单选取确定，具有较强的代表性。65个事件类型中不仅包含「结婚、辞职、地震」等传统事件抽取评测中常见的事件类型，还包含了「点赞」等极具时代特征的事件类型，具体的事件类型及对应角色见[表1](https://ai.bdstatic.com/file/CFC0D74220704FFD9D1571239E57F4FC) 。数据集中的句子来自百度信息流资讯文本，相比传统的新闻资讯，文本表达自由度更高，事件抽取的难度也更大。

* 竞赛方案

  |                             方案                             | 代码 |
  | :----------------------------------------------------------: | :--: |
  | [top1](http://live.baidu.com/m/media/pclive/pchome/live.html?room_id=4008201814&source=h5pre) （2:01:12开始） |  ×   |
  | 邱震宇-MRC做事件抽取（[文章](https://zhuanlan.zhihu.com/p/141237763) 、[代码](https://github.com/qiufengyuyi/event_extraction) ） |  √   |
  | 苏剑林（[文章](https://kexue.fm/archives/7321) 、[代码](https://github.com/bojone/lic2020_baselines) ） |  √   |
  | [OneWaymyway-两段式抽取](https://aistudio.baidu.com/aistudio/projectdetail/545914) |  √   |
  | [和你在一起^_^](https://blog.csdn.net/weixin_42462804/article/details/106253193) |  ×   |
  | [other](https://github.com/percent4/multi-label-classification-4-event-type) |  √   |
  | baseline（[github](https://github.com/PaddlePaddle/Research/tree/master/KG/DuEE_baseline/DuEE-PaddleHub) 、[AIstudio](https://aistudio.baidu.com/aistudio/projectdetail/381711) ） |  √   |
  
* 参考资料

  [2020语言与智能技术竞赛--事件抽取方案整理 - 知乎 (zhihu.com)](https://zhuanlan.zhihu.com/p/151741570)

