# 2020CCKS面向金融领域的篇章级事件主体与要素抽取

* 任务简介
  * 本次评测包括两个子任务：（1）事件主体抽取：旨在从文本中抽取事件类型和对应的事件主体。即给定文本T，抽取T中所有的事件类型集合S，对于S中的每个事件类型s，从文本T中抽取s的事件主体。其中各事件类型的主题实体类型为公司名称或人名或机构名称；（2）篇章事件要素抽取：旨在从文本中抽取事件类型和对应的事件要素。即给定文本T，抽取T中所有的事件类型集合S，对于S中的每个事件类型s，从文本T中抽取是的事件要素。
  * 官网：[子任务一](https://www.biendata.xyz/competition/ccks_2020_4_1/) ，[子任务二](https://www.biendata.xyz/competition/ccks_2020_4_2/)
  
* 数据示例

  > 子任务一

  |                             样例                             |                             说明                             |
  | :----------------------------------------------------------: | :----------------------------------------------------------: |
  | 2444634 世联君汇预计2017年净利下滑近8成至853万元中超电缆(002471)再遭中超集团减持5%股份  业绩下滑  世联君汇 | **训练集**每行 4 列，数据以“\t”分隔，格式为：文本id\t文本内容\t事件类型\t事件主体 |
  | 2527248 腾讯证券5月23日讯，ST康得收到关注函：公司控股股东康得投资集团有限公司信托贷款出现违约，康得新光电作为担保方承担连带担保责任 | **验证集**每行 2 列，数据以“\t”分隔，格式为：文本id\t文本内容。提交结果格式：文本id\t事件类型\t事件主体 |

  > 子任务二

  |                             样例                             |                             说明                             |
  | :----------------------------------------------------------: | :----------------------------------------------------------: |
  | {"content": "公告编号：2017-016证券代码：830796&nbsp;证券简称：云南路桥&nbsp;主办券商：太平洋证券云南路桥股份有限公司关于公司债务人进入破产重整程序的公告本公司及董事会全体成员保证公告内容的真实、准确和完整，没有虚假记载、误导性陈述或者重大遗漏，并对其内容的真实性、准确性和完整性承担个别及连带法律责任。一、事件概述：近日，云南路桥股份有限公司（以下简称“公司”）收到《广西壮族自治区南宁市中级人民法院通知书》（（2016）桂01民破8号之二）和广西阳鹿高速公路有限公司管理人《通知书》（（2016）阳鹿破管字第31号）。以上两份文件具体内容如下：1、南宁市中级人民法院根据招商银行股份有限公司南宁分行的申请裁定受理广西阳鹿高速公路有限公司破产重整一案，并指定广西万益律师事务所担任广西阳鹿高速公路有限公司管理人。2、广西阳鹿高速公路有限公司债权人于2017年4月12日前向管理人申报债权，提供相关材料。3、第一次债权人会议将于2017年4月21日上午9时在南宁市中级人民法院第1号法庭召开。二、事件影响：广西阳鹿高速公路有限公司是广西阳朔至鹿寨高速公路的业主，与公司不存在关联关系。截止破产申请受理日，广西阳鹿高速公路有限公司仍欠公司112,030,207.17元工程款及履约保证金，公司对该笔债务提取了5%的坏账准备。目前该债务人的破产重整事宜未对公司生产经营等方面产生实际影响，但如果该债务人最终破产清算，公司债权不能得到实现或者", "doc_id": "2315532", "events": [{"event_id": "4624616", "受理法院": "广西壮族自治区南宁市中级人民法院", "公司名称": "广西阳鹿高速公路有限公司", "event_type": "破产清算"}]} | {“content”:”XXX”,”doc_id”:”XXX”,”events”:[{“event_id”: "xxx", "event_type": "xxx", “eventElement1”:”xxx”,”eventElement2”:”xxx”}]} |

  详细说明：[评测任务书-面向金融领域的篇章级事件主体与要素抽取](http://sigkg.cn/ccks2020/wp-content/uploads/2020/03/5-CCKS2020%E6%8A%80%E6%9C%AF%E8%AF%84%E6%B5%8B-%E9%9D%A2%E5%90%91%E9%87%91%E8%9E%8D%E9%A2%86%E5%9F%9F%E7%9A%84%E7%AF%87%E7%AB%A0%E7%BA%A7%E4%BA%8B%E4%BB%B6%E4%B8%BB%E4%BD%93%E4%B8%8E%E8%A6%81%E7%B4%A0%E6%8A%BD%E5%8F%96.docx) 

* 数据说明

  |          | 训练集 | 开发集 |          测试集          |                             下载                             |
  | :------: | :----: | :----: | :----------------------: | :----------------------------------------------------------: |
  | 子任务一 | 20,000 | 1,000  | 1,000（混淆数据298,000） | [√](https://github.com/hy-struggle/ccks-ee-subject/tree/master/multi_pointer/ccks%204_1%20Data)，[官网](https://www.biendata.xyz/competition/ccks_2020_4_1/rules/?next_url=/competition/ccks_2020_4_1/data/) |
  | 子任务二 | 5,000  | 1,000  | 1,000（混淆数据27,000）  | [官网](https://www.biendata.xyz/competition/ccks_2020_4_2/rules/?next_url=/competition/ccks_2020_4_2/data/) |

  

* 竞赛方案

  |                             方案                             |                           评测论文                           |                        代码                         |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :-------------------------------------------------: |
  | 子任务一：top1（[文章](https://www.yanxishe.com/columnDetail/21749) 、[video](https://www.bilibili.com/video/BV1jK4y177Ya?p=27) ） | [ppt](https://hub-cache.baai.ac.cn/hub-pdf/20201123/CCKS2020-PPT/%E8%AF%84%E6%B5%8B/%E4%BB%BB%E5%8A%A1%E5%9B%9B%20%E5%9F%BA%E4%BA%8EBERT%E7%9A%84%E4%BA%8B%E4%BB%B6%E4%B8%BB%E4%BD%93%E6%8A%BD%E5%8F%96.pdf) |                          ×                          |
  |                     子任务一：技术创新奖                     | [《基于多任务联合训练的事件主体抽取模型》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_5_1_0.pdf) |                          ×                          |
  |                       子任务一：top25                        |                              ×                               | [√](https://github.com/hy-struggle/ccks-ee-subject) |
  |                       子任务一：other                        |                              ×                               |     [√](https://zhuanlan.zhihu.com/p/133783503)     |
  | 子任务二：top1 & 技术创新奖（[文章](https://bbs.huaweicloud.com/blogs/209117) 、[video](https://www.bilibili.com/video/BV1jK4y177Ya?p=28) ） | [《A Prior Information Enhanced Extraction Framework for Document-level Financial Event Extraction》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_5_2_1.pdf) 、 [ppt](https://hub-cache.baai.ac.cn/hub-pdf/20201123/CCKS2020-PPT/%E8%AF%84%E6%B5%8B/%E4%BB%BB%E5%8A%A1%E4%BA%94%20A%20Prior%20Information%20Enhanced%20Extraction%20Framework%20for%20Document-level%20Financial%20Event%20Extraction.pdf) |                          ×                          |
  |                        子任务二：top2                        | [《上市公司公告事件要素抽取研究》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_5_2_2.pdf) |                          ×                          |
  
* 推荐资料

  https://github.com/loujie0822/DeepIE  
  
  https://pypi.org/project/theta/  