# 2020CCKS面向中文电子病历的医疗实体及事件抽取-子任务2：医疗事件抽取

* 任务简介

  * 本任务为中文病历医疗事件抽取任务，即给定主实体为肿瘤的电子病历文本数据，定义肿瘤事件的若干属性，如肿瘤大小，肿瘤原发部位等，识别并抽取事件及属性，进行文本结构化。本任务提供少量标注数据、大量非标注数据集及词表，旨在训练数据有限的情况下，利用非标注文本和半监督等方法提升模型性能。更接近真实世界的场景。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_2_2/

* 时间：2020.3-2020.9

* 数据示例

  |                             原文                             | 肿瘤原发部位 | 原发病灶大小 |           转移部位           |
  | :----------------------------------------------------------: | :----------: | :----------: | :--------------------------: |
  | 1、支气管炎、肺气肿;2、左肺上叶肿块考虑周围性肺癌;左肺门淋巴结增大,考虑为转移;3、右肺中叶改变,考虑为发育不全;4、右侧肩胛下内侧弹力纤维瘤;5、气管憩室;6、甲状腺右叶低密度灶;胃窦壁增厚,请结合临床。左肺上叶可见类圆形肿块影,大小约2.0*3.0CM,CT值约32HU,增强CT扫描:三期CT值分别为43HU、53HU、75HU,可见部分支气管分支闭塞、狭窄;右肺中叶体积减小,见片状高密度影,内可见轻度扩张支气管影;两肺透过度增强,两肺野内见多发囊状透光区;两肺纹理稀疏、紊乱。左肺门淋巴结稍大,直径约1.4CM。纵隔内多发小淋巴结。两胸腔无积液征象。主动脉及冠脉钙化。右侧肩胛下内侧见片状软组织密度影,约为2.2CM*5.1CM。气管憩室。    甲状腺右叶密度减低,强化程度低于正常甲状腺组织。胃窦壁增厚。 |   左肺上叶   |  2.0*3.0CM   |         左肺门淋巴结         |
  | 1. 胃体部胃壁增厚,考虑为胃癌,侵及浆膜层,合并小弯侧及腹主动脉旁多发淋巴结转移,胃左动脉供血;2. 肝左叶小囊肿;3. 右肾上极小囊肿。胃体部胃壁增厚,平扫时CT值约为35HU,增强后呈不均匀强化,动脉期、静脉期及平衡期CT值分别约为59HU、74HU及73HU;最厚处厚度约为1.7CM,胃腔狭窄,浆膜面模糊;胃小弯侧及肾水平以上腹主动脉旁可见多发增大淋巴结影,大者短径约为1.4CM;CTA重建示胃左动脉进入病灶,胃网膜左动脉及胃右动脉显示欠清。    肝脏边缘光滑,各叶比例协调,肝左叶可见小圆形低密度影,密度均匀,增强后未见强化,直径约为0.4CM,边缘光滑,界限清晰。右肾上极可见小圆形低密度影,界清光滑。脾脏、胰腺、左肾形态及大小未见异常,其内未见异常密度影,增强后未见异常强化影。胆囊形态及大小未见异常,壁未见增厚,其内未见异常密度影及异常强化影。    膀胱充盈良好,壁未见增厚,其内未见异常密度影,双侧输尿管未见扩张。盆腔内未见积液征象。 |    胃体部    |              | 小弯侧及腹主动脉旁多发淋巴结 |

  事件主实体：肿瘤  

  属性1：原发部位 【某种疾病最先发生的组织或器官】  

  属性2：病灶大小 【原发部位的大小】  

  属性3：转移部位 【某种疾病从最先发生的组织或器官转移到的其它组织或器官】  

  每个文本的一个属性可能出现0个或多个属性实体，比如多个原发部位。  

  ![example](https://www.biendata.xyz/media/competition/2020/03/26/15852184810443294123.png?raw=true)

* 数据说明

  | 标注数据 | 非标注数据 | 词表 | 测试集 |                             下载                             |
  | :------: | :--------: | :--: | :----: | :----------------------------------------------------------: |
  |   1400   |    1300    | 863  |  100   | [官网](https://www.biendata.xyz/competition/ccks_2021_clinic/data/) |

* 竞赛方案

  |                             方案                             |                           评测论文                           | 代码 |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :--: |
  | [top1 & 技术创新奖](https://www.bilibili.com/video/BV1jK4y177Ya?p=24) | [《基于预训练语言模型的小样本医疗事件抽取》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_2_1.pdf) |  ×   |
  |                             top2                             | [《CCKS2020 Medical Event Extraction Based on Named Entity Recognition》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_2_2.pdf) |  ×   |
  |                             top3                             | [《一种中文医疗事件的联合抽取方法》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_2_3.pdf) |  ×   |

* 推荐资料

  https://pypi.org/project/theta/