# 2019中文NL2SQL挑战赛

* 任务简介

  * 首届中文NL2SQL挑战赛，使用金融以及通用领域的表格数据作为数据源，提供在此基础上标注的自然语言与SQL语句的匹配对，希望选手可以利用数据训练出可以准确转换自然语言到SQL的模型。
  * 官网：https://tianchi.aliyun.com/competition/entrance/231716/introduction

* 参赛时间：2019.6~2019.9

* 数据格式：

  * 提供的数据集主要由3个文件组成，以训练集为例，包括train.json、train.tables.json及train.db。

  * train.json文件中，每一行为一条数据样本。数据样例及字段说明例如下：

    ```json
    {
         "table_id": "a1b2c3d4", # 相应表格的id
         "question": "世茂茂悦府新盘容积率大于1，请问它的套均面积是多少？", # 自然语言问句
        "sql":{ # 真实SQL
            "sel": [7], # SQL选择的列 
            "agg": [0], # 选择的列相应的聚合函数, '0'代表无
            "cond_conn_op": 0, # 条件之间的关系
            "conds": [
                [1,2,"世茂茂悦府"], # 条件列, 条件类型, 条件值，col_1 == "世茂茂悦府"
                [6,0,1]
            ]
        }
    }
    ```

    其中，SQL的表达字典说明如下：

    ```json
    op_sql_dict = {0:">", 1:"<", 2:"==", 3:"!="}
    agg_sql_dict = {0:"", 1:"AVG", 2:"MAX", 3:"MIN", 4:"COUNT", 5:"SUM"}
    conn_sql_dict = {0:"", 1:"and", 2:"or"}
    ```

    train.tables.json 文件中，每一行为一张表格数据。数据样例及字段说明例如下：

    ```json
    {
        "id":"a1b2c3d4", # 表格id
        "name":"Table_a1b2c3d4", # 表格名称
        "title":"表1：2019年新开工预测 ", # 表格标题
        "header":[ # 表格所包含的列名
            "300城市土地出让",
            "规划建筑面积(万㎡)",
            ……
        ],
        "types":[ # 表格列所相应的类型
            "text",
            "real",
            ……
        ],
        "rows":[ # 表格每一行所存储的值
            [
                "2009年7月-2010年6月",
                168212.4,
                ……
            ]
        ]
    }
    ```

    tables.db为sqlite格式的数据库形式的表格文件。各个表的表名为tables.json中相应表格的name字段。为避免部分列名中的特殊符号导致无法存入数据库文件，表格中的列名为经过归一化的字段，col_1, col_2, …, col_n。

* 数据说明：

  | 训练集 | 测试集 |                  获取方式                   |
  | :----: | :----: | :-----------------------------------------: |
  | 40000  | 10000  | https://github.com/ZhuiyiTechnology/TableQA |

* 参赛方案：

  |                             方案                             | 代码 |
  | :----------------------------------------------------------: | :--: |
  | top1（[攻略](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.6.694d5fc6rFoWZD&postId=78781)、[答辩ppt](https://github.com/nudtnlp/tianchi-nl2sql-top1/blob/master/%E5%A4%A9%E6%B1%A0NL2SQL%E5%86%A0%E5%86%9B%E6%96%B9%E6%A1%88.pdf) 、[paper](https://ieeexplore.ieee.org/ielx7/6287639/8948470/09020099.pdf?tp=&arnumber=9020099&isnumber=8948470&ref=aHR0cHM6Ly9saW5rLnpoaWh1LmNvbS8/dGFyZ2V0PWh0dHBzJTNBLy9pZWVleHBsb3JlLmllZWUub3JnL3N0YW1wL3N0YW1wLmpzcCUzRnRwJTNEJTI2YXJudW1iZXIlM0Q5MDIwMDk5)） |  ×   |
  | top2（[攻略](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.3.694d5fc6rFoWZD&postId=78855)） |  ×   |
  | top3（[攻略](https://github.com/beader/tianchi_nl2sql?spm=5176.12282029.0.0.19a2324eDhNhiJ)、[答辩ppt](https://github.com/beader/tianchi_nl2sql/blob/master/imgs/ModelS%E7%AD%94%E8%BE%A9ppt.pdf)） |  √   |
  |  [top6](https://github.com/eguilg/nl2sql) （有代码无方案）   |  √   |
  | [baseline](https://github.com/ZhuiyiTechnology/nl2sql_baseline) |  √   |

  