# BasicPawn - SourcePawn Editor
BasicPawn is a very lightweight and basic SourcePawn Editor that uses dynamic Autocompletion and IntelliSense like any other IDE or Advanced Editor. It supports SourcePawn, Transitional SourcePawn and even AMX Mod X.
BasicPawn also has some special features like the simple debugger to debug your plugins and the plugin system to create your own BasicPawn plugins.

[Offical BasicPawn Website](https://getbasicpawn.spdns.org/)

Supported:
- SourceMod (SourcePawn & Transitional SourcePawn)
- AMX Mod X (Debugger not supported yet and some Pawn features are not supported)
- Pawn (Not fully supported)

Features:
- Simple Windows Forms UI
- Dynamic autocompletion (Methods, Variables, Methodmaps, Enums etc.)
- IntelliSense
- Simple Debugger
- Plugin System
- Customizable Syntax
- Light/Dark Theme
- Unlimited custom Highlight colors
- Customizable configs
- Supports old and new SourcePawn syntax
- Runs on Wine as well

**See [AlliedModders BasicPawn thread](https://forums.alliedmods.net/showthread.php?t=289127) for more information.**

## [Third Party Legal Notices](Third%20Party%20Legal%20Notices.txt)

## Requirements
 - [**.NET Framework 3.5**](https://www.microsoft.com/net/download/dotnet-framework/net35-sp1)
 - [**.NET Framework 3.5 (Linux Wine)**](https://appdb.winehq.org/objectManager.php?sClass=version&iId=10166)
 - [**.NET Framework (Linux Wine)**](https://appdb.winehq.org/objectManager.php?sClass=application&iId=2586)
 
 *Some of the BasicPawn plugins require a newer .NET Framework version.*
 
## Last Supported SourcePawn Compiler
Due to major compiler changes, BasicPawn became incompatible with newer versions of the SourcePawn compiler.
Any version above ``1.11-git6724`` will not work with BasicPawn until i fix the issue.
Download the last supported compiler here:
[SourceMod 1.11-git6724](https://sm.alliedmods.net/smdrop/1.11/sourcemod-1.11.0-git6742-windows.zip)

## Plugins
**Download: Click on 'Download'**
 - [FTP Plugin](Plugin%20Releases/BasicPawnPluginFTP)
 - [Automatic Error Reporting](Plugin%20Releases/BasicPawnPluginAutoErrorReport)
 - [Translation Editor](Plugin%20Releases/BasicPawnPluginTranslationEditor)
 - [Lysis Decompiler](Plugin%20Releases/BasicPawnPluginLysisDecompiler)
 - [SmartPawn Obfuscator](Plugin%20Releases/BasicPawnPluginSmartPawnObfuscator)
 - [more...](Plugin%20Releases)

## Syntax Styles
**Download: Right click on 'Raw' -> Save as...**
 - [Monokai](Custom%20Syntax%20Styles/Monokai)
 - [Visual Studio 2017 Dark](Custom%20Syntax%20Styles/Visual%20Studio%202017%20Dark)
 - [PlasticCodeWrap Dark](Custom%20Syntax%20Styles/PlasticCodeWrap%20Dark)
 - [more...](Custom%20Syntax%20Styles)

## Support us
### [![Donate](https://i.imgur.com/jnnHW0C.jpg)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=5ZBGDRQ7T5M6G&source=url)

## Screenshots
![](https://i.imgur.com/wWrKGTl.png)
