# ThunderDesign.Net-PCL.HttpClientService
[![CI](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/actions/workflows/CI.yml/badge.svg)](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/actions/workflows/CI.yml)
[![CD](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/actions/workflows/CD.yml/badge.svg)](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/actions/workflows/CD.yml)
[![Nuget](https://img.shields.io/nuget/v/ThunderDesign.Net-PCL.HttpClientService)](https://www.nuget.org/packages/ThunderDesign.Net-PCL.HttpClientService)
[![License](https://img.shields.io/github/license/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService)](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/blob/main/LICENSE)
[![Net](https://img.shields.io/badge/.net%20standard-v1.1%20--%20v2.1-blue)](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/blob/main/README.md)

A wrapper around 'System.Net.Http.HttpClient' enhancing AutoRedirect and Cookies. Can be used in all application types.

----

### Highlights include:

- DataObjects
  - ResponseContentData
  - ResponseData
- EventArgs
  - CookieContainerChangedEventArgs
- EventHandlers
  - CookieContainerChangedEventHandler
- Extentions
  - CookieContainerExtention
- Http
  - HttpClientAutoRedirect
- Service
  - HttpClientService
----

## Installation

Grab the latest [ThunderDesign.Net-PCL.HttpClientService NuGet](https://www.nuget.org/packages/ThunderDesign.Net-PCL.HttpClientService) package and install in your solution.

> Install-Package ThunderDesign.Net-PCL.HttpClientService

Use the `-version` option to specify an [older version](https://www.nuget.org/packages/ThunderDesign.Net-PCL.HttpClientService#versions-tab) to install.

## Examples

*(TIP: Clone repo, open the solution, build it and run sample app.)*
- Xamarin
  - [SimpleHttpClient Example](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/tree/main/samples/Xamarin/SimpleHttpClient)

## Please Contribute!

This is an open source project that welcomes contributions/suggestions/bug reports from those who use it. If you have any ideas on how to improve the library, please [post an issue here on GitHub](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/issues). Please check out the [How to Contribute](https://github.com/ThunderDesign/ThunderDesign.Net-PCL.HttpClientService/blob/main/.github/CONTRIBUTING.md).
