﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

namespace OpenBudgeteer.Core.Data.MySql.Migrations;

public partial class DateTimeDataType : Migration
{
    protected override void Up(MigrationBuilder migrationBuilder)
    {
        migrationBuilder.Sql
        ("UPDATE BucketVersion " +
         $"SET BucketTypeZParam = '{DateTime.MinValue:yyyy-MM-dd}' " +
         "WHERE BucketTypeZParam IS NULL");

        migrationBuilder.Sql
        ("UPDATE Bucket " +
         $"SET IsInactiveFrom = '{DateTime.MaxValue:yyyy-MM-dd}' " +
         "WHERE IsInactiveFrom IS NULL");

        migrationBuilder.AlterColumn<DateTime>(
            name: "ValidFrom",
            table: "BucketVersion",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4");

        migrationBuilder.AlterColumn<DateTime>(
            name: "BucketTypeZParam",
            table: "BucketVersion",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4",
            oldNullable: true);

        migrationBuilder.AlterColumn<DateTime>(
            name: "MovementDate",
            table: "BucketMovement",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4",
            oldNullable: true);

        migrationBuilder.AlterColumn<DateTime>(
            name: "ValidFrom",
            table: "Bucket",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4");

        migrationBuilder.AlterColumn<DateTime>(
            name: "IsInactiveFrom",
            table: "Bucket",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4",
            oldNullable: true);

        migrationBuilder.AlterColumn<DateTime>(
            name: "TransactionDate",
            table: "BankTransaction",
            nullable: false,
            oldClrType: typeof(string),
            oldType: "longtext CHARACTER SET utf8mb4",
            oldNullable: true);
    }

    protected override void Down(MigrationBuilder migrationBuilder)
    {
        migrationBuilder.AlterColumn<string>(
            name: "ValidFrom",
            table: "BucketVersion",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: false,
            oldClrType: typeof(DateTime));

        migrationBuilder.AlterColumn<string>(
            name: "BucketTypeZParam",
            table: "BucketVersion",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: true,
            oldClrType: typeof(DateTime));

        migrationBuilder.AlterColumn<string>(
            name: "MovementDate",
            table: "BucketMovement",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: true,
            oldClrType: typeof(DateTime));

        migrationBuilder.AlterColumn<string>(
            name: "ValidFrom",
            table: "Bucket",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: false,
            oldClrType: typeof(DateTime));

        migrationBuilder.AlterColumn<string>(
            name: "IsInactiveFrom",
            table: "Bucket",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: true,
            oldClrType: typeof(DateTime));

        migrationBuilder.AlterColumn<string>(
            name: "TransactionDate",
            table: "BankTransaction",
            type: "longtext CHARACTER SET utf8mb4",
            nullable: true,
            oldClrType: typeof(DateTime));
    }
}