<h1><a href="https://thatsinewave.github.io/OSINT-Toolkit/steam-scams.html" target="_blank">Steam Scam FAQ</a></h1>
      <h3>Example of a common trade scam: I have been reported and will be banned</h3>
      <p>Any claim that you've been accidentally or falsely reported for fraud or any other infraction is always the introduction to a scam. If someone did report your account falsely, and you're concerned about being banned, you can rest assured that Steam disregards false reports. Do not follow any instructions provided by anyone claiming to have accidentally reported your account.</p>
      <h2>Confidence Scams</h2>
      <p><b>Some confidence scammers (scammers, cons, con artists) target Steam users by threatening their accounts or claiming to represent Steam Support, Valve, or a trusted individual or service.</b></p>
      <p><b>1. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#scamsteam" target="_blank">What is a confidence scam?</a></b></p>
      <p>A confidence scam is a trick involving deceit with the goal of defrauding a victim in some way. A scammer may target a Steam user to hijack their account to use or sell, hijack their account to hold for ransom, or gather information from a victim to defraud them elsewhere. Though not unique to Steam, online confidence scams may target Steam users because Steam accounts are valuable, and if taken over, can give the scammer a way to pressure the victim and propagate the scam further.</p>
      <p></p>
      <p></p>
      <p><b>2. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#scamtypes" target="_blank">What scam types might target Steam users?</a></b></p>
      <p>Most scams targeting Steam users (unrelated to Trade Scams) involve an attempt to gain control of a victim's account and then hold the account hostage for payment. You should never pay a scammer even if they've gained full control of your account. You can recover your account from a scammer any time using Steam Support, and a scammer who is already defrauding you is not likely to actually return the account even if you pay. Instead, they would likely just demand additional payments.</p>
      <p></p>
      <p></p>
      <p><b>3. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#avoidscams" target="_blank">How do I protect myself from scams?</a></b></p>
      <p>You can avoid scams by always remaining skeptical in online interactions, especially those involving pressure, threats, demands, or claims that come from a position of authority. You should be mindful of unexpected claims made even by a trusted friend, as you can't be sure they haven't fallen for a scam themselves and thus turned control of their account over to a scammer.</p>
      <p></p>
      <p></p>
      <p><b>4. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#fallenscam" target="_blank">What do I do if I've fallen for a scam?</a></b></p>
      <p>If you've given away control of your account to a scammer, you should immediately take steps to recover the account through <a href="https://help.steampowered.com/en/wizard/HelpWithAccountStolen" target="_blank">Steam Support</a>. Despite what a scammer might claim, you can always recover your account through Steam Support even if the scammer has changed all the account's information including its password, email, and phone number.</p>
      <p></p>
      <p></p>
      <p><b>5. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#falsereport" target="_blank">My account has been accidentally or falsely reported. What do I need to do?</a></b></p>
      <p>You don't need to do anything to protect your account from false or mistaken reports. They're simply disregarded by the Steam team.</p>
      <p></p>
      <p></p>
      <p><b>6. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#friendscam" target="_blank">What should I do if I receive a suspicious message from a friend?</a></b></p>
      <p>You can use Steam's reporting tools on your friend's Steam Community profile page to report your friend's account as hijacked. If the hijacking can be confirmed, Steam's moderation team will lock the account until the owner is able to recover it.</p>
      <p></p>
      <p></p>
      <p><b>7. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#reportcon" target="_blank">How do I report a scammer</a></b></p>
      <p>Most confidence scams take place largely outside of Steam. To report the scammer, you should use the reporting feature of the platform that the scammer is using to chat with you, and you should also block all further communication.</p>
      <p></p>
      <p></p>
      <h2>Trade Scams</h2>
      <p><b>Trade scams are a scam whose goal involves obtaining a victim's Steam Inventory items.</b></p>
      <p><b>1. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#whatisascam" target="_blank">What is a trade scam?</a></b></p>
      <p>A trade scam is when a Steam user convinces another user to make a deal (trade, gift or market transaction) under false pretenses. Scams usually involve deception in order to convince a user that they are getting a good or fair deal when in fact they are not. For more information on scams please read below and view <a href="https://help.steampowered.com/en/faqs/view/18A5-167F-C27B-64A0" target="_blank">Recommended Trading Practices</a> and the <a href="https://help.steampowered.com/en/faqs/view/3B6E-B322-2400-8D24" target="_blank">Steam Item Restoration Policy</a></p>
      <p></p>
      <p></p>
      <p><b>2. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#bestways" target="_blank">What are the best ways to avoid getting scammed?</a></b></p>
      <p><b>Do not trade for anything that cannot be added into the Steam trading window. The most common examples of these types of trades include:</b></p>
      <p>• You don't need to rush to complete a trade. If you receive an offer, take your time to thoroughly review the contents. Once you confirm a trade offer, there is no way to reverse it.</p>
      <p>• Ignore pressure to trust the other user. If you are trading with a user who insists that you trust them, they are probably attempting to scam you. Please note that +rep comments can be generated easily by malicious groups.</p>
      <p>• Mouse over every item to ensure that the item/gift properties are correct. Information about the item/gift will be shown in the tooltip, including the quality, name, description and any effects.</p>
      <p>• Do not trade items in separate or future trades. If another user requests that you do multiple trades, they could be scamming you. Always insist on completing the entire trade in one single offer.</p>
      <p>• Ensure that you are trading with the correct user. Scammers may try to impersonate your friends and other trusted traders. It is your responsibility to know who you are trading with.</p>
      <p></p>
      <p></p>
      <p><b>3. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#whattrades" target="_blank">What kind of trades should I avoid?</a></b></p>
      <p>• Trading items/gifts for money outside the Steam Community market. You cannot add Wallet credit, PayPal, gift cards or any form of money to trade offers.</p>
      <p>• Trading items/gifts for CD Keys. You cannot add a CD Key into the trade window. CD Keys that are offered can be for a different game, fake, used or region restricted.</p>
      <p>• Trading items/gifts for nothing in return and expecting to get an item or gift in a later trade. There is no reason to not trade everything in one trade. You may add unlimited items/gifts to a single trade.</p>
      <p>For more information, please see <a href="https://help.steampowered.com/en/faqs/view/46A2-2B3C-95CC-8878" target="_blank">Steam Trading FAQ</a> and <a href="https://help.steampowered.com/en/faqs/view/18A5-167F-C27B-64A0" target="_blank">Recommended Trading Practices</a> articles.</p>
      <p></p>
      <p></p>
      <p><b>4. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#whatscams" target="_blank">What specific trading scams should I be aware of?</a></b></p>
      <p>Users should always double-check the contents of a proposed trade before accepting, even if that means inspecting each item in a multiple-item trade. Be sure to verify the item and its quality before confirming any trade. There are a number of common scams users may attempt to deceive you out of your items:</p>
      <p>• <b>Item switching</b> - You discuss a trade offer with another user beforehand, and the item they put into the trade offer looks like the item, but isn't as valuable as the original offer.</p>
      <p>• <b>CS:GO quality switch</b> - A user offers you a specific quality CS:GO item (Factory New), but the item in the offer is of a lower quality (Field-Tested). Often the item switch is made in a counter-offer.</p>
      <p>• <b>Hidden item</b> - A user offers a trade that includes a lot of your low value items (cards, crates, etc.), but also includes a high value item hidden somewhere in the middle.</p>
      <p>• <b>Begging/spamming</b> - A user spams trade offers requesting high value items for nothing or little in return in hopes that you mis-click and accept the offer.</p>
      <p>• <b>Forward confirmation email</b> - A user convinces you to forward your confirmation email to their email address. They then confirm the trade using the link in the message. Do not forward trade confirmation emails or links and do not provide additional information to another user asking for information used for your account.</p>
      <p>• <b>Money For Items</b> - A user offers to send you money in the form of PayPal, PaySafeCard, Steam Wallet codes, Steam Digital Gift Cards, etc. The scammer usually sends you a fake payment code after the trade is completed. In the case of Steam Digital Gift Cards, the scammer may even appear to pay you first, but be planning to charge the Digital Gift Card back later or buy the gift card with a fraudulent credit card.</p>
      <p>• <b>CD keys for items</b> - A user offers to send you a Wallet Credit code or a game's CD Key in exchange for your items. The scammer usually sends you a fake CD Key after the trade is completed.</p>
      <p>• <b>Users offering item duplication</b> - A user offers to duplicate your items, but first you have to trade away your items. After receiving your items, the user blocks your messages and keeps your items.</p>
      <p>• <b>Users acting as trade bots</b> - A user impersonating a trade bot(s) tells you that you have to trade them some items. After you've accepted the trade and sent the user the items, they block you on Steam and keep your items.</p>
      <p>• <b>Middleman trades</b> - If you are performing a trade that sits within Steam's trading guidelines (more info here - https://help.steampowered.com/en/faqs/view/18A5-167F-C27B-64A0), there is no need for a middleman. Any time you choose to trust any other user with one of your items, you are allowing them the opportunity to scam you.</p>
      <p>• <b>Verification accounts</b> - A user wants you to trade an item for "verification". The user will give a made-up excuse to convince you to do this, such as needing to make sure the item is not a duplicate or to ensure the item is not bugged. These users will then keep your item(s) and block you, getting away with the items.</p>
      <p>• <b>Fund transfer via the Steam Market</b> - A user offers to send you Steam Wallet funds by buying one of your low value items at a high price in the market. Most of these offers are done using fraudulent funds.</p>
      <p>• <b>Voice comm software/join our tournament team (malware)</b> - A user convinces you to install malware hidden in a voice communication, anti-cheat, or other type of software by claiming that they need you to install it so that you can play in a tournament.</p>
      <p>• <b>Offering fraudulent items for resale</b> - Malicious users will sometimes acquire unusual items (often with fraudulent credit cards) and then attempt to trade them to you for more well known items with established value. Prior to doing this they may also manipulate the Steam Community Market price of these unusual items by using stolen credit cards. Watch out for claims that they will overpay or that you can quicksell (qs) the items for an immediate profit. Consider why the user would be willing to take a loss by trading the items to you instead of selling them themselves. As an excuse, these users will sometimes say they need tradeable keys or other tradeable items. Do not accept these trades as the value of the unusual items has been falsified and the subsequent Market transactions may be reversed due to fraudulent activity.</p>
      <p></p>
      <p></p>
      <p><b>5. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#scamvshijack" target="_blank">What is the difference between a scam and a hijack?</a></b></p>
      <p>A scam is when a user deceives another user into willingly (at the time) completing a trade, market transaction, or sending a gift. After the trade is completed, the person who was scammed either doesn't receive what was promised, or the items involved are not what was agreed upon.</p>
      <p>A hijacking is when an account or a computer is taken over by someone else without the account owner's permission. This is often done with malware or a virus. In some cases the hijacker will convince a user to hand over their login information by providing a fake Steam or a third-party trading site. Hijackers most commonly steal accounts to gain items or games, and sometimes commit fraud. Hijackers often use stolen accounts to commit more hijackings. In these cases, the account will be locked until the rightful owner contacts steam support about the hijacking.</p>
      <p>Additional information about hijacked accounts can be found in <a href="https://help.steampowered.com/en/faqs/view/0A94-F308-34A5-1988" target="_blank">this article</a></p>
      <p></p>
      <p></p>
      <p><b>6. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#reportscammer" target="_blank">How do I report a scammer?</a></b></p>
      <p>If you've been scammed or another user has attempted to scam you, please use the Report feature built into Steam. This is the best way to bring scammers to the attention of steam support so actions may be taken:</p>
      <p>• Go to the profile of the offending user</p>
      <p>• Click the '...' drop-down located at the top right of the page</p>
      <p>• Choose 'Report Player'</p>
      <p>• Select the violation, and follow the prompts to submit the report</p>
      <p>If a user you've reported for scamming has had action taken on their account, you'll be notified with a message in Steam. See the <a href="https://help.steampowered.com/en/faqs/view/4D07-D139-587C-2080" target="_blank">How to Report a Scammer</a> article.</p>
      <p></p>
      <p></p>
      <p><b>7. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#whathappens" target="_blank">What action is taken when a scammer is found?</a></b></p>
      <p>If evidence exists that a Steam user is scamming, Steam Support will ban the account from using the Steam Community, including trading and using the Steam Market. The length of the ban is dependent on the severity and quantity of the scams. In some cases, scammers will be banned permanently. If a scammer has multiple accounts, all of their accounts may be subject to the ban as well.</p>
      <p>In rare cases, scammers will hijack an account and use it to commit scams, fraud, or other hijackings. In these cases, the account will be locked until the rightful owner contacts steam support and appropriate action is taken.</p>
      <p></p>
      <p></p>
      <p><b>8. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#noreturn" target="_blank">Why doesn't Steam return scammed items?</a></b></p>
      <p>The community assigns an item a value that is at least partially determined by that item's scarcity. If more copies of the item are added to the economy through inventory rollbacks, the value of every other instance of that item would be reduced.</p>
      <p>Steam support sympathize with people who fall victim to scams, but they provide enough information on the website and within the trading system to help users make good trading decisions. For more information on this, please see <a href="http://store.steampowered.com/news/20631/?snr=100601___" target="_blank">this post</a>.</p>
      <p></p>
      <p></p>
      <p><b>9. <a href="https://help.steampowered.com/en/faqs/view/70E6-991B-233B-A37B#whynoinfo" target="_blank">Why won’t Steam Support provide information on why an account was trade banned or locked?</a></b></p>
      <p>By limiting the provided data, Steam Support prevents malicious users from learning how to avoid getting caught in the future. Steam Support relies on several data points to arrive at a decision to ban or lock an account. Users intent on committing malicious activity, most often done to other users, are constantly trying to gain this data to use in future scams, fraud and hijackings.</p>
      <p>While most trade bans are permanent, in some circumstances a user may receive a temporary trade ban. In these cases, when the ban is automatically lifted the offending account also gets placed into trade probation. Probationary status allows other users to know that a user has recently committed a trading related offense, so they can make better decisions about whether they want to trade with that user. Please note, probationary status does not prevent users from trading.</p>
      <p></p>
      <p></p>