<div align="center">

# [**OSINT Toolkit**](https://thatsinewave.github.io/OSINT-Toolkit)

Welcome to the OSINT Toolkit repository! This repository serves as a comprehensive catalog for tools and websites useful in Open Source Intelligence (OSINT) investigations. Whether you're a cybersecurity professional, a journalist, or just curious about information gathering, this toolkit provides resources to aid your endeavors.

</div>

<div align="center">

## ☕ [Support my work on Ko-Fi](https://ko-fi.com/thatsinewave)

</div>

## Categories

1. [**Digital Forensics and Security**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#1-digital-forensics-and-security)
2. [**Discord OSINT Tools**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#2-discord-osint-tools)
3. [**General Information Gathering**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#3-general-information-gathering)
4. [**Live Analysis on URLs and Files**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#4-live-analysis-on-urls-and-files)
5. [**Open Source Intelligence**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#5-open-source-intelligence)
6. [**URL Safety Checks**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#6-url-safety-checks)
7. [**Reporting Tools**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#7-reporting-tools)
8. [**SINEWAVE's Tools**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#8-sinewaves-tools)
9. [**Toolkit FAQ**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#9-toolkit-faq)
10. [**Steam Scam FAQ**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#10-steam-scam-faq)
11. [**Discord Scam FAQ**](https://github.com/ThatSINEWAVE/OSINT-Toolkit?tab=readme-ov-file#11-discord-scam-faq)

Feel free to explore each category to discover various tools and websites relevant to your OSINT investigations.

Please refer to the individual sections below for detailed information on each category and the tools/sites included. If you're interested in contributing to this repository, please see the "Contributing" section at the end of this README.

## Contributing

Your contributions to this OSINT toolkit are highly appreciated! 
If you know of any valuable tools or websites that are not listed here, please feel free to contribute by submitting a pull request. 
Here's how you can contribute:

1. Fork this repository.
2. Add your tool/website to the appropriate category, providing a brief description and any relevant information.
3. Ensure your additions follow the existing format.
4. Create a pull request and explain your changes.

Thank you for helping to make this OSINT toolkit a valuable resource for the community!

### Contributors

- Thanks to [**Sanchita Chaurasia**](https://github.com/sanchitachaurasia) for the amazing work making the complete frontend overhaul, improving the site completely.

<div align="center">

# [Join my discord server](https://discord.gg/2nHHHBWNDw)

</div>

## 1. [**Digital Forensics and Security**](https://thatsinewave.github.io/OSINT-Toolkit/digital-forensics.html):

1. [**General Image Forensics**](https://29a.ch/photo-forensics/#forensic-magnifier/):
   - A comprehensive image forensics tool offering a variety of features. It allows users to scrutinize and analyze digital images, making it valuable for detecting alterations or hidden details within images.

2. [**Database Checker**](https://dehashed.com/):
   - Dehashed is a database checker that may require a subscription for full functionality. It assists in searching and analyzing databases, potentially revealing information about compromised or leaked data.

3. [**Leakedcheck_bot on Telegram**](https://www.t.me/Leakedcheck_bot/):
   - Using this Telegram bot, users can input license plates, emails, passwords, or phone numbers to retrieve public information about individuals. It serves as a quick and accessible tool for obtaining information related to the provided data.

4. [**Breached Email Checker**](https://exposed.lol/):
   - This tool checks if an email has been compromised in a data breach. Additionally, it can accept and analyze passwords in clear text, providing users with insights into potential security risks associated with their email accounts.

5. [**Google Hacking Database**](https://www.exploit-db.com/google-hacking-database/):
   - A repository of publicly available information obtained through Google dorks. It hosts a comprehensive list of search queries (dorks) that can be used to uncover specific data on the internet.

6. [**Censys**](https://search.censys.io/):
   - Censys is a search engine designed for locating devices and networks on the internet. It enables users to search for specific criteria, such as device type, location, and operating system, providing valuable information for security assessments and vulnerability identification.

7. [**Facebook Comment Picker**](https://commentpicker.com/find-facebook-id.php/):
   - This tool is useful for researching Facebook profiles by extracting information from Facebook comments. It assists in finding Facebook IDs, aiding in the identification and analysis of user profiles on the social media platform.

## 2. [**Discord OSINT Tools**](https://thatsinewave.github.io/OSINT-Toolkit/discord-osint.html):

1. [**ToolsCord**](https://toolscord.com/):
   - An all-in-one toolbox designed for gathering information about servers, bots, and users on Discord. ToolsCord offers a comprehensive set of tools to assist users in exploring and analyzing Discord-related data, making it a versatile resource for server and user investigation.

2. [**Discord Lookup**](https://discordlookup.com/):
   - Discord Lookup is a primary tool for users seeking information on Discord. It provides a variety of tools for searching, decoding, and viewing user and server information. The platform offers a centralized hub for Discord-related investigations, streamlining the process for users looking to gather comprehensive data.

3. [**Unfurl by DFIR.Blog**](https://dfir.blog/unfurl/):
Description: Unfurl is a tool specifically designed for extracting additional timestamp information from Discord-related URLs of interest. It focuses on Discord IDs, such as those for users, channels, servers, or file attachments. Unfurl can reveal embedded timestamps, aiding in understanding when a particular Discord object was created.

4. [**Top.gg**](https://top.gg/):
   - Top.gg is a platform that, when navigated to with a user's ID (https://top.gg/user/), provides information about their profile. This includes details about bots and servers reviewed on Top.gg, Discord username, and other relevant information. Even after an account deletion, this information may be preserved if the user signed in to Top.gg using Discord.

5. [**Snow Stamp by Pixelatomy**](https://pixelatomy.com/snow-stamp/):
   - Snow Stamp is a snowflake timestamp converter designed for extracting date information from Discord's unique snowflake IDs. It is a valuable tool for understanding the timing of various Discord events, as each snowflake ID carries embedded timestamp data.

6. [**DiscordLeaks by Unicorn Riot**](https://discordleaks.unicornriot.ninja/discord/):
   - DiscordLeaks is a platform that covers leaked messages from servers compromised in the past. It provides constant updates and focuses on servers associated with white supremacism and neo-nazis. DiscordLeaks can be used to uncover interesting facts about individuals, offering insights into their affiliations and activities within Discord communities.

## 3. [**General Information Gathering**](https://thatsinewave.github.io/OSINT-Toolkit/general-info.html):

1. [**Bellingcat's Online Investigation Toolkit**](https://docs.google.com/spreadsheets/d/18rtqh8EG2q1xBo2cLNyhIDuK9jrPGwYr9DI2UncoqJQ):
   - This online toolkit, curated by Bellingcat, provides resources for online investigations. It includes a variety of tools and techniques for researching and analyzing information on the internet.

2. [**Hunter.io**](https://hunter.io/):
   -  Hunter.io is a popular tool for finding email addresses using web crawlers. It assists users in discovering email addresses associated with a particular domain, making it valuable for outreach and contact purposes.

3. [**Shodan**](https://shodan.io/):
    - Shodan is an internet-connected device search engine. It assists in finding specific devices based on various criteria, offering insights into potential vulnerabilities and aiding in targeted cyber assessments. Shodan provides both free and paid plans.

4. [**IntelX**](https://intelx.io/):
    - IntelX is a large search engine for leaked databases. It enables users to search and access information from various data breaches, aiding in the identification and analysis of compromised data.

5. [**Epieos**](https://epieos.com/):
    - Epieos is a platform for email and phone number searches. It assists users in retrieving information related to individuals based on their email addresses or phone numbers.

6. [**What's My Name**](https://whatsmyname.app/):
    - A username searcher tool that allows users to search for a specific username across multiple platforms. It aids in identifying online profiles associated with a particular username.

7. [**0t.rocks MultiSearch**](https://search.0t.rocks/):
    - A multi-search tool that enables users to simultaneously search across multiple platforms and databases. It streamlines the process of gathering information from various sources.

8. [**FaceCheck.ID**](https://facecheck.id/):
    - An AI-based face recognition tool that can analyze and identify faces in images. FaceCheck.ID provides a solution for facial recognition applications, potentially aiding in the verification or identification of individuals.

9. [**GeoEstimation by TIB**](https://labs.tib.eu/geoestimation/):
    - GeoEstimation is a tool for estimating geographical locations based on provided data. It utilizes technology to determine the likely geographic origin of a given set of information.

10. [**Insecam**](http://www.insecam.org/):
    - Insecam hosts a global camera database, allowing users to access publicly available camera feeds from around the world. It raises awareness about the importance of securing surveillance cameras and privacy.

## 4. [**Live Analysis on URLs and Files**](https://thatsinewave.github.io/OSINT-Toolkit/live-analysis.html):

1. [**Triage URL and File Analysis Dashboard**](https://tria.ge/dashboard/):
    - Triage provides a user-friendly URL and File Analysis Dashboard, empowering users to evaluate the security status of websites. By submitting a URL or uploading a file, users gain access to detailed information about potential threats. The dashboard includes historical data, associated risks, and insights that aid in identifying malicious online content.

2. [**VirusTotal File Scanner**](https://www.virustotal.com/gui/home/upload/):
    - VirusTotal's File Scanner is a robust tool for analyzing the safety of files. Users can either upload a file or enter a web address for scanning by multiple antivirus engines. The platform generates a comprehensive report detailing potential malware, viruses, and security issues associated with the provided file or URL, offering valuable insights for security assessments.

3. [**Hybrid Analysis**](https://www.hybrid-analysis.com/):
    - Hybrid Analysis is a comprehensive platform designed for analyzing and understanding the behavior of files and URLs. Users can submit URLs for thorough examination, gaining insights into potential threats, malware behavior, and overall security risks. The platform combines automated analysis with community-driven contributions to deliver detailed reports, enhancing users' ability to assess the security implications of the submitted URLs.

4. [**Media Analyzer Pro**](https://media-analyzer.pro/app):
    - Media Analyzer Pro offers advanced analysis tools for various media formats, including images, videos, and documents. Users can analyze media files for potential security threats, such as embedded malware or malicious code

## 5. [**Open Source Intelligence**](https://thatsinewave.github.io/OSINT-Toolkit/open-source-intel.html):

1. [**OSINTLeak**](https://beta.osintleak.com/dashboard/):
    - An email breach finder tool that helps users identify if their email accounts have been compromised. OSINTLeak provides insights into potential security risks associated with email addresses.

2. [**OSINT Framework**](https://osintframework.com/):
    - A curated list of free open-source intelligence (OSINT) tools. OSINT Framework provides a comprehensive collection of resources, making it a valuable reference for individuals conducting online investigations.

3. [**OSINTDojo Resources**](https://www.osintdojo.com/resources/):
    - A collection of resources for open-source intelligence (OSINT) practitioners. OSINTDojo Resources offers valuable tools, guides, and references to enhance the effectiveness of online investigations.

4. [**IntelX**](https://intelx.io/):
    - IntelX is a large search engine for leaked databases. It enables users to search and access information from various data breaches, aiding in the identification and analysis of compromised data.

5. [**Breach Directory**](https://breachdirectory.org/):
    - This tool allows users to view parts of breached email passwords and their hashes. It provides insights into compromised accounts, helping individuals assess the security of their email accounts.

6. [**Hashes.com Hash Decryptor**](https://hashes.com/en/decrypt/hash/):
    - A hash decryptor tool that can decipher a significant percentage of hashes obtained from breached directories. It aids in revealing the original passwords associated with the hashed data.

7. [**OSINT Industries**](https://osint.industries/):
    - This platform allows users to explore websites where people are registered using their phone numbers and emails. It supports open-source intelligence (OSINT) gathering by providing information on user registrations across various online platforms.

8. [**GeoSpy.AI**](https://geospy.ai/):
    - A tool that utilizes artificial intelligence for image location analysis. GeoSpy.AI assists in determining the geographical location of images, making it valuable for geospatial intelligence and investigation purposes.

## 6. [**URL Safety Checks**](https://thatsinewave.github.io/OSINT-Toolkit/url-safety.html):

1. [**VirusTotal URL Scanner**](https://www.virustotal.com/gui/home/url/):
   - VirusTotal's URL Scanner enables users to assess the security status of URLs by scanning them with multiple antivirus engines. The platform provides a thorough analysis of submitted URLs, checking for potential malware, viruses, and other security issues. It offers a comprehensive report to aid users in understanding the safety of the provided web addresses.

2. [**IPVoid Screenshot Tool**](https://www.ipvoid.com/capture-website-screenshot/):
   - The IPVoid Screenshot Tool allows users to capture quick and convenient screenshots of websites. By entering the URL of the website, the tool generates visual snapshots of webpages. This feature aids in visual inspection and documentation of online content, providing a practical solution for users who need to capture and analyze webpage layouts.

3. [**URLScan Search**](https://urlscan.io/search/):
   - URLScan Search is a web service designed for investigating and analyzing URLs. Users can search for specific URLs or domains to access a wealth of information, including historical data and associated threats. This tool provides detailed insights, helping users comprehensively understand the background and potential risks associated with a given web address.

4. [**Cloudflare Radar Scan**](https://radar.cloudflare.com/scan/):
   - Cloudflare Radar Scan is a service that offers insights into the security and performance of websites. By scanning a website, it assesses potential vulnerabilities, security issues, and performance metrics. The tool is valuable for website owners and administrators who want to proactively address concerns, ensuring a safer and more efficient online presence.

5. [**PhishTank**](https://www.phishtank.com):
   - PhishTank is a collaborative clearinghouse for data and information about phishing on the Internet. It provides a platform for users to report and verify phishing websites, helping to protect internet users from falling victim to phishing scams.

6. [**AbuseIPDB**](https://www.abuseipdb.com):
   - buseIPDB is a free service that offers a database of IP addresses reported for malicious activity, such as hacking attempts, spamming, and other forms of abuse. Users can search for IP addresses to determine if they have been reported for suspicious behavior, helping to identify and block potential threats to network security.

7. [**Sucuri SiteCheck**](https://sitecheck.sucuri.net): 
   - Sucuri SiteCheck is a comprehensive security scanner that analyzes websites for malware, blacklist status, website errors, and out-of-date software. Users can enter a URL to check its security status and receive detailed reports on any issues found.

## 7. [**Reporting Tools**](https://thatsinewave.github.io/OSINT-Toolkit/reporting.html):

1. [**Discord Report Center**](https://discord.com/report):
    - The Discord Report Center provides users with a direct channel to report illegal activity from other users. This method bypasses the automated Right-Click > Report method. However, user feedback suggests that the effectiveness of this reporting system can be limited, with responses from Discord support being infrequent. Despite its accessibility, users may experience delays and may not receive timely resolutions to their reports. Please note that this information is based on user experiences and may be subject to change.

2. [**Netcraft Phishing**](https://report.netcraft.com/report):
    - Netcraft's Phishing Site Feed provides a platform for reporting suspected phishing websites. Users can submit URLs they believe to be phishing sites, contributing to a collective effort to identify and combat online phishing attacks.

3. [**Phish.Report**](https://phish.report):
    - Phish.Report is a community-driven platform dedicated to reporting and analyzing phishing emails. Users can submit suspicious emails, allowing others to review and assess potential threats. By crowd sourcing information about phishing attempts, Phish.Report helps raise awareness and provides valuable insights into the tactics used by cybercriminals.

## 8. [**SINEWAVE's Tools**](https://thatsinewave.github.io/OSINT-Toolkit/sinewave-tools.html):

1. [**Malicious URLs DB**](https://thatsinewave.github.io/Malicious-URLs-DB); 
    - This serves as a curated JSON file containing lists of websites associated with malicious activities with a nice web interface that allows you to analyse the data. The list is compiled based on personal findings of the repository owner and are intended to help identify and mitigate threats posed by these sites.

2. [**Password Generator**](https://thatsinewave.github.io/Password-Generator):
    - This repository contains a simple password generator application implemented in Python using the CustomTkinter library for the graphical user interface as a script or directly in your browser. The application allows users to generate up to random passwords with various customizable options.

3. [**Discord Invite Finder**](https://github.com/ThatSINEWAVE/Discord-Invite-Finder):
    - This Python script is designed to search for active Discord invites links by generating random invite IDs and checking their status. It utilizes the Discord API to verify whether an invitation is active or not and saves the results in JSON format.

4. [**URL Analysis Tool**](https://github.com/ThatSINEWAVE/URL-Analysis-Tool): 
    - This repository contains a Python-based tool for analyzing URLs and detecting potential threats using various cybersecurity services like VirusTotal and URLScan.io. The tool combines the scan results with WHOIS information and provides a user-friendly interface to tweet the analysis findings or custom messages.

5. [**IP Information Discord Bot**](https://github.com/ThatSINEWAVE/IP-Lookup-Bot): 
    - This is a Discord bot that allows users to check detailed information about any IP address using the ip-api.com API. The bot provides information such as country, city, region, district, zip code, latitude, longitude, timezone, currency, ISP, organization, AS number, AS name, reverse DNS, mobile status, proxy status, and hosting status.

6. [**GuardianWatch-Bot**](https://github.com/ThatSINEWAVE/GuardianWatch-Bot): 
    - This bot is your go-to tool for gathering and organizing information about Discord server members efficiently. Written entirely in Python and leveraging the power of Discord's Bot API along with the Google Sheets API, this bot offers versatility and ease of use across its three distinct modes: gsheets-mode, csv-mode, and combined-mode.

7. [**LinkWarden-Bot**](https://github.com/ThatSINEWAVE/LinkWarden-Bot):
    - This Discord bot, designed for personal and community use, enhances server security by scrutinizing links shared within Discord channels. It leverages the VirusTotal API, WHOIS lookups, and urlscan.io scans to provide comprehensive real-time analysis, helping maintain a safe online environment for members.

8. [**Netcraft API Client**](https://github.com/ThatSINEWAVE/Netcraft-API-Client):
    - This Python script provides a command-line interface for interacting with the Netcraft API. It allows users to perform various actions such as reporting malicious URLs, malicious emails, and incorrectly blocked URLs, as well as retrieving details about submitted reports.

9. [**DNS-Filters**](https://github.com/ThatSINEWAVE/DNS-Filters):
    - This repository houses a curated collection of DNS filter lists, accumulated over several years. These lists are designed to enhance network security and efficiency by blocking unwanted or harmful domains.

10. [**The Discord Invite Project**](https://thatsinewave.github.io/Discord-Invite-Project):
    - This repository serves as an educational and research platform exploring the concept of creating a database to track and analyze Discord invite links. The project aims to assist in Open Source Intelligence (OSINT) investigations by providing tools to identify and study Discord servers, including potentially malicious ones.

11. [**Discord Honeypot System - CONCEPT**](https://github.com/ThatSINEWAVE/Discord-Honeypot-System)
    - The Discord Honeypot System is a sophisticated monitoring tool designed to enhance server security and moderation efficiency. Utilizing multiple Discord accounts, each running in dedicated Virtual Machines (VMs) or Docker containers, this Python-based system automates the surveillance of direct message (DM) activity. Its primary objective is to detect, capture, and relay suspicious or unwanted DM communications to a specific channel within a designated server for further action by the moderation team.

12. [**Discord Identity Generator**](https://thatsinewave.github.io/Discord-Identity):
    - This project is a Discord profile identity generator hosted on GitHub Pages. It enables users to create random Discord profiles with unique usernames, about me sections, nicknames, pronouns, and profile images with up to 100 quadrillion unique profiles.

## 9. [**Toolkit FAQ**](https://thatsinewave.github.io/OSINT-Toolkit/toolkit-faq.html)
- The Toolkit FAQ comprises a comprehensive collection of curated lists, each tailored to specific aspects of digital investigation, cybersecurity, and online threat mitigation. From digital forensics to open-source intelligence (OSINT) gathering, each list offers a wealth of resources and platforms aimed at empowering professionals in their efforts to ensure digital security and integrity. These lists encompass tools and services designed to streamline processes, enhance analysis, and facilitate reporting on various online threats. Whether it's investigating data breaches, analyzing URLs for potential threats, or managing security within Discord communities, the Toolkit FAQ provides a diverse range of solutions to address the evolving challenges of cybersecurity and digital investigations.
- The contents of this page can also be viewed in the [**Toolkit-FAQ.md file**](https://github.com/ThatSINEWAVE/OSINT-Toolkit/blob/main/faq/Toolkit-FAQ.md)

## 10. [**Steam Scam FAQ**](https://thatsinewave.github.io/OSINT-Toolkit/steam-scams.html)
- The Steam FAQ offers a comprehensive guide aimed at equipping users with the knowledge and strategies necessary to safeguard against common scams and fraudulent activities encountered on the Steam platform. Covering topics ranging from confidence scams to trade scams, the FAQ provides users with valuable insights into the deceptive tactics employed by scammers and offers practical advice on how to identify and avoid falling victim to such schemes. With a focus on promoting skepticism, vigilance, and proactive reporting, the FAQ empowers Steam users to protect their accounts and belongings, contributing to a safer and more secure gaming environment for all.
- The contents of this page can also be viewed in the [**Steam-Scam-FAQ.md file**](https://github.com/ThatSINEWAVE/OSINT-Toolkit/blob/main/faq/Steam-Scams-FAQ.md)

## 11. [**Discord Scam FAQ**](https://thatsinewave.github.io/OSINT-Toolkit/discord-scams.html)
- The Discord FAQ is a comprehensive guide aimed at informing users about prevalent scams and fraudulent activities encountered within the Discord community. Covering a wide array of topics such as impersonation, free Nitro scams, QR code and download scams, compromised accounts, and reporting malicious content/behavior, the FAQ equips users with essential knowledge and strategies to safeguard themselves against online threats. By promoting skepticism, vigilance, and proactive reporting, it fosters a safer and more secure environment for Discord users, enhancing trust and confidence within the platform's vibrant community.
- The contents of this page can also be viewed in the [**Discord-Scam-FAQ.md file**](https://github.com/ThatSINEWAVE/OSINT-Toolkit/blob/main/faq/Discord-Scams-FAQ.md)

## [**License**](https://thatsinewave.github.io/OSINT-Toolkit/license.html)

This repository is provided under the [**GLWTS Public License**](https://github.com/ThatSINEWAVE/OSINT-Toolkit/blob/main/LICENSE). 

By utilizing the contents of this repository, you agree to abide by the terms of this license.