import { NextRequest } from "next/server"

import { ImageResponse } from "@vercel/og"

export const config = {
  runtime: "edge"
}

export default function (req: NextRequest) {
  try {
  } catch (e: any) {
    console.error(`${e.message}`)
    return new Response(`Failed to generate the image`, {
      status: 500
    })
  }

  return new ImageResponse(
    (
      <div
        style={{
          display: "flex",
          fontSize: 40,
          color: "black",
          background: "white",
          width: "100%",
          height: "100%",
          textAlign: "center",
          justifyContent: "center",
          alignItems: "center"
        }}
      >
        <svg width="500" height="200" viewBox="0 0 500 200" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M0 100C0 155.23 44.77 200 100 200C155.23 200 200 155.23 200 100C200 44.77 155.23 0 100 0C44.77 0 0 44.77 0 100ZM100 180C63.68 180 33.395 154.185 26.48 119.9C24.85 111.79 31.715 105 40 105H160C168.285 105 175.155 111.785 173.52 119.9C166.6 154.19 136.32 180 100 180Z"
            fill="#2563EB"
          />
          <path
            d="M233.08 143.384V140.184L234.232 140.056C237.219 139.629 239.651 139.032 241.528 138.264C243.491 137.496 245.155 136.259 246.52 134.552C247.971 132.76 249.336 130.328 250.616 127.256L281.592 52.12H285.944L316.152 127.256C317.859 131.437 319.693 134.509 321.656 136.472C323.619 138.435 326.307 139.587 329.72 139.928L332.28 140.184V143.384L316.408 143L295.928 143.384V140.184L298.488 139.928C301.475 139.587 303.608 138.947 304.888 138.008C306.168 137.069 306.808 135.747 306.808 134.04C306.808 132.333 306.211 130.029 305.016 127.128L298.36 110.488H262.264L255.352 127.128C254.755 128.664 254.243 130.072 253.816 131.352C253.389 132.547 253.176 133.613 253.176 134.552C253.176 136.173 253.859 137.411 255.224 138.264C256.675 139.117 259.021 139.672 262.264 139.928L264.824 140.184V143.384L248.568 143L233.08 143.384ZM263.928 106.392H296.824L280.696 65.816L263.928 106.392ZM335.495 143.384V140.184L338.055 139.928C341.042 139.587 343.303 139.16 344.839 138.648C346.46 138.051 347.57 136.856 348.167 135.064C348.764 133.187 349.063 130.157 349.063 125.976V69.144C349.063 64.8773 348.764 61.848 348.167 60.056C347.57 58.264 346.46 57.112 344.839 56.6C343.303 56.0027 341.042 55.5333 338.055 55.192L335.495 54.936V51.736L354.439 52.12H354.567L373.511 51.736V54.936L370.951 55.192C368.05 55.5333 365.788 56.0027 364.167 56.6C362.546 57.112 361.436 58.264 360.839 60.056C360.242 61.848 359.943 64.8773 359.943 69.144V125.976C359.943 130.157 360.242 133.187 360.839 135.064C361.436 136.856 362.546 138.051 364.167 138.648C365.788 139.16 368.05 139.587 370.951 139.928L373.511 140.184V143.384L354.567 143H354.439L335.495 143.384ZM409.917 144.408C404.285 144.408 399.378 143.213 395.197 140.824C391.016 138.349 387.73 134.979 385.341 130.712C383.037 126.36 381.885 121.411 381.885 115.864C381.885 109.891 383.165 104.6 385.725 99.992C388.285 95.2987 391.698 91.6293 395.965 88.984C400.317 86.2533 405.096 84.888 410.301 84.888C416.872 84.888 421.992 86.9787 425.661 91.16C429.416 95.3413 431.293 100.845 431.293 107.672C431.293 108.696 431.25 109.549 431.165 110.232C431.08 110.915 430.994 111.384 430.909 111.64H392.253C392.168 112.835 392.125 114.029 392.125 115.224C392.125 119.747 392.85 123.971 394.301 127.896C395.752 131.736 397.928 134.808 400.829 137.112C403.816 139.416 407.442 140.568 411.709 140.568C415.72 140.568 419.261 139.459 422.333 137.24C425.49 134.936 427.922 131.565 429.629 127.128L432.701 128.28C429.117 139.032 421.522 144.408 409.917 144.408ZM410.301 88.088C405.01 88.088 400.872 89.9653 397.885 93.72C394.984 97.4747 393.192 102.467 392.509 108.696H408.765C412.605 108.696 415.506 108.269 417.469 107.416C419.517 106.477 420.882 105.368 421.565 104.088C422.333 102.723 422.717 101.4 422.717 100.12C422.717 96.3653 421.437 93.4213 418.877 91.288C416.317 89.1547 413.458 88.088 410.301 88.088ZM440.709 143.384V140.44L442.757 140.184C445.232 139.843 447.109 139.459 448.389 139.032C449.754 138.52 450.693 137.453 451.205 135.832C451.717 134.125 451.973 131.352 451.973 127.512V100.888C451.973 97.56 451.504 95.128 450.565 93.592C449.712 92.056 448.432 91.1173 446.725 90.776C445.018 90.3493 443.013 90.136 440.709 90.136V87.192C444.208 87.192 447.578 87.064 450.821 86.808C454.064 86.552 457.434 86.168 460.933 85.656L459.525 100.376H460.037C461.914 94.6587 464.218 90.648 466.949 88.344C469.68 86.04 472.624 84.888 475.781 84.888C479.365 84.888 481.754 85.784 482.949 87.576C484.144 89.2827 484.741 90.9467 484.741 92.568C484.741 94.4453 484.186 95.9813 483.077 97.176C481.968 98.3707 480.474 98.968 478.597 98.968C476.805 98.968 475.44 98.5413 474.501 97.688C473.562 96.8347 473.093 95.8533 473.093 94.744C473.093 93.8907 473.178 93.08 473.349 92.312C473.605 91.544 473.733 90.9467 473.733 90.52C473.733 89.6667 473.136 89.24 471.941 89.24C470.746 89.24 469.466 89.7947 468.101 90.904C466.821 92.0133 465.712 93.5493 464.773 95.512C464.005 97.1333 463.28 98.9253 462.597 100.888C461.914 102.851 461.36 104.984 460.933 107.288V127.512C460.933 131.352 461.189 134.125 461.701 135.832C462.213 137.453 463.109 138.52 464.389 139.032C465.754 139.459 467.674 139.843 470.149 140.184L472.197 140.44V143.384L456.453 143L440.709 143.384Z"
            fill="black"
          />
        </svg>
      </div>
    ),
    {
      width: 1200,
      height: 600
    }
  )
}
