import { NextApiRequest, NextApiResponse } from "next"

import { createServerSupabaseClient } from "@supabase/auth-helpers-nextjs"

export default async function avatarCreate(req: NextApiRequest, res: NextApiResponse) {
  const supabase = createServerSupabaseClient({ req, res })

  const {
    data: { user }
  } = await supabase.auth.getUser()

  if (!user) {
    return res.status(401).json({ error: "Unauthorized" })
  }

  const { username, name, bio, source_twitter, avatar_url } = req.body as {
    username: string
    name: string
    bio: string
    source_twitter: string
    avatar_url: string
  }

  const avatarCreateInput = {
    id: username.toLowerCase(), // TODO: ID automatically generated by Supabase
    username: username.toLowerCase(), // TODO: 不知道 supabase 如何忽略大小写
    name,
    avatar_url,
    bio,
    source_twitter,
    status: "requested",
    owner_id: user.id
  }

  const { data, error } = await supabase.from("avatars").insert(avatarCreateInput).select("*").single()

  if (error) {
    return res.status(500).json({ error: error.message })
  }

  return res.status(200).json(data)
}
