import Document, { Head, Html, Main, NextScript } from "next/document"

import { SelfHostingAlert } from "~/components/lp/SelfHostAlert"

class MyDocument extends Document {
  render() {
    return (
      <Html className="h-full scroll-smooth bg-base-200 antialiased [font-feature-settings:'ss01']" lang="en">
        <Head>
          <link rel="preconnect" href="https://fonts.googleapis.com" />
          <link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="anonymous" />
          <link
            rel="stylesheet"
            href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Lexend:wght@400;500&display=swap"
          />
        </Head>
        <body className="loading flex min-h-screen flex-col ">
          <SelfHostingAlert />
          <Main />
          <NextScript />
        </body>
      </Html>
    )
  }
}

export default MyDocument
