﻿// FFXIV TexTools
// Copyright © 2019 Rafael Gonzalez - All Rights Reserved
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

using HelixToolkit.Wpf.SharpDX;
using HelixToolkit.Wpf.SharpDX.Model.Scene;

namespace FFXIV_TexTools.Custom
{
    public class CustomMeshGeometryModel3D : MeshGeometryModel3D
    {
        /// <summary>
        /// The internal file path source that this mesh stems from.
        /// </summary>
        public string Source;
        protected override SceneNode OnCreateSceneNode()
        {
            var node = base.OnCreateSceneNode();

            node.OnSetRenderTechnique = effectsManager =>
            {
                return effectsManager[CustomEffectsManager.CustomShaderNames.CustomShader];
            };

            return node;
        }
    }
}