import {ICommon_Model_User} from './../model/user';
import {ECommon_Platform_Type, ECommon_Services} from './../types';
import {ICommon_Route_Res_User_List, ICommon_Route_Res_User_Profile, ICommon_Route_Res_User_TeamList} from './response';
import {ECommon_HttpApi_Method} from "./types";
import {Permission_Types} from "../permission/permission";
import {ICommon_Model_User_Setting} from "../model/user_setting";

const api={
    baseUrl:"/user",
    service:ECommon_Services.User,
    routes:{
        login:{//用户登录
            method:ECommon_HttpApi_Method.POST,
            path:"/login",
            req:<{
                username:string,
                password:string,
                lang:string,
                platform:ECommon_Platform_Type
            }>{},
            res:<Omit<ICommon_Model_User,"password">>{},
            ignoreValidate:true
        },
        checkUser:{//检查用户是否可用
            method:ECommon_HttpApi_Method.GET,
            path:"/check_user",
            req:<{
                name:string           
            }>{},
            res:<boolean>{},
            ignoreValidate:true
        },
        logout:{//登出
            method:ECommon_HttpApi_Method.POST,
            path:"/logout",
            req:{},
            res:{},
        },
        loginAdmin:{//管理员登录
            method:ECommon_HttpApi_Method.POST,
            path:"/admin_login",
            req:<{
                username:string,
                password:string
            }>{},
            res:<Omit<ICommon_Model_User,"password">>{},
            ignoreValidate:true
        },
        logoutAdmin:{//管理员登出
            method:ECommon_HttpApi_Method.POST,
            path:"/admin_logout",
            req:{},
            res:{},
        },
        refresh:{//刷新用户信息
            method:ECommon_HttpApi_Method.GET,
            path:"/refresh",
            req:{},
            res:<Omit<ICommon_Model_User,"password">>{},
        },
        update:{//更新用户信息
            method:ECommon_HttpApi_Method.PUT,
            path:"/item",
            req:<Partial<Omit<ICommon_Model_User,"id" | "password" | "created_time" | "modified_time" | "role">> & {userId?:string}>{},
            res:<Omit<ICommon_Model_User,"password">>{},
        },
        register:{
            method:ECommon_HttpApi_Method.POST,
            path:"/register",
            req:<{
                username:string,
                password:string
            }>{},
            res:{},
            ignoreValidate:true
        },
        create:{//创建用户
            method:ECommon_HttpApi_Method.POST,
            path:"/item",
            req:<Partial<Omit<ICommon_Model_User,"id"  | "created_time" | "modified_time">> & {
                username:string,
                password:string,
                role?:number
            }>{},
            res:<Omit<ICommon_Model_User,"password">>{}
        },
        remove:{//删除用户
            method:ECommon_HttpApi_Method.DELETE,
            path:"/item",
            req:<{
                userId:string
            }>{},
            res:{},
        },
        active:{//禁用、启用用户
            method:ECommon_HttpApi_Method.PUT,
            path:"/active",
            req:<{
                active:number,
                userId:string
            }>{},
            res:{},
        },
        list:{
            method:ECommon_HttpApi_Method.GET,
            path:"/list",
            req:<{
                keyword?:string,
                page:number,
                size:number             
            }>{},
            res:<ICommon_Route_Res_User_List>{},
        },
        resetPassword:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/reset_password",
            req:<{
                userId?:string,
                password:string             
            }>{},
            res:{},
        },
        teamList:{
            method:ECommon_HttpApi_Method.GET,
            path:"/team_list",
            req:<{
                userId?:string,
                keyword?:string
            }>{},
            res:<ICommon_Route_Res_User_TeamList>{},
            permission:[Permission_Types.Organization.READ]
        },
        profile:{
            method:ECommon_HttpApi_Method.GET,
            path:"/profile",
            req:<{
                organizationUserId?:string
            }>{},
            res:<ICommon_Route_Res_User_Profile>{},
        },
        infos:{
            method:ECommon_HttpApi_Method.GET,
            path:"/infos",
            req:<{
                userIds:string       
            }>{},
            res:<Omit<ICommon_Model_User,"password"|"created_time"|"modified_time">[]>{},
        },
        filterUser:{
            method:ECommon_HttpApi_Method.GET,
            path:"/filter",
            req:<{
                name:string      
            }>{},
            res:<{
                name:string,
                id:string,
                photo:string
            }[]>{},
        },
        confirmRegister:{
            method:ECommon_HttpApi_Method.POST,
            path:"/register/confirm",
            req:<{
                username:string,
                code:string,
                openId?:string
            }>{},
            res:{},
            ignoreValidate:true
        },
        resendCode:{
            method:ECommon_HttpApi_Method.POST,
            path:"/register/code",
            req:<{
                username:string
            }>{},
            res:{},
            ignoreValidate:true
        },
        resetCode:{
            method:ECommon_HttpApi_Method.POST,
            path:"/reset/code",
            req:<{
                username:string
            }>{},
            res:{},
            ignoreValidate:true
        },
        reset:{
            method:ECommon_HttpApi_Method.POST,
            path:"/reset",
            req:<{
                username:string,
                password:string,
                code:string
            }>{},
            res:{},
            ignoreValidate:true
        },
        setting:{
            method:ECommon_HttpApi_Method.GET,
            path:"/setting",
            req:{},
            res:<ICommon_Model_User_Setting>{},
        },
        setWallpaper:{
            method:ECommon_HttpApi_Method.POST,
            path:"/setting/wallpaper",
            req:<{
                photo?:string
            }>{},
            res:<{
                path:string
            }>{},
        },
        setMeetingBackgroundImg:{
            method:ECommon_HttpApi_Method.POST,
            path:"/setting/meeting_background_img",
            req:<{
                photo?:string
            }>{},
            res:<{
                path:string
            }>{},
        },
        changeLang:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/lang",
            req:<{
                lang:string
            }>{},
            res:{},
        },
        wechatCode:{
            method:ECommon_HttpApi_Method.GET,
            path:"/wechat/code",
            req:<{
                code:string
            }>{},
            res:<{
                openId:string
            }>{},
            ignoreValidate:true
        },
        wechatLogin:{
            method:ECommon_HttpApi_Method.POST,
            path:"/wechat/login",
            req:<{
                openId:string,
                lang:string,
                platform:ECommon_Platform_Type
            }>{},
            res:<Omit<ICommon_Model_User,"password">>{},
            ignoreValidate:true
        },
        bindWechat:{
            method:ECommon_HttpApi_Method.POST,
            path:"/wechat/bind",
            req:<{
                openId:string,
                username:string,
                password:string
            }>{},
            res:{},
            ignoreValidate:true
        }
    }
}

export default api