import {Permission_Types} from '../permission/permission';
import {ICommon_Model_Organization} from './../model/organization';
import {ECommon_Services, ECommon_User_Online_Status} from './../types';
import {
    ICommon_Route_Res_Member_Tag_Member,
    ICommon_Route_Res_Organization_FilterUserAndTeam,
    ICommon_Route_Res_Organization_List,
    ICommon_Route_Res_Organization_Statics,
    ICommon_Route_Res_Organization_User,
    ICommon_Route_Res_Organization_User_Item,
    ICommon_Route_Res_Organization_User_List,
    ICommon_Route_Res_Organization_User_Profile,
    ICommon_Route_Res_Role_Item,
    ICommon_Route_Res_Role_List
} from './response';
import {ECommon_HttpApi_Method} from "./types";
import {ICommon_Model_Member_Tag} from "../model/member_tag";
import {ECommon_IM_Message_EntityType} from "../model/im_unread_message";

const api={
    baseUrl:"/organization",
    service:ECommon_Services.User,
    routes:{
        list:{
            method:ECommon_HttpApi_Method.GET,
            path:"/list",
            req:<{
                                
            }>{},
            res:<ICommon_Route_Res_Organization_List>{}
        },
        info:{
            method:ECommon_HttpApi_Method.GET,
            path:"/item",
            req:<{
                 organizationId:string               
            }>{},
            res:<ICommon_Model_Organization>{},
            permission:[Permission_Types.Organization.READ]
        },
        create:{
            method:ECommon_HttpApi_Method.POST,
            path:"/item",
            req:<{
                 name:string,
                 description?:string,
                 photo?:string             
            }>{},
            res:<ICommon_Model_Organization>{},
        },
        update:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/item",
            req:<{
                organizationId:string
                 name?:string,
                 description?:string,
                 photo?:string,
                 active?:number             
            }>{},
            res:<ICommon_Model_Organization>{},
            permission:[Permission_Types.Organization.EDIT]
        },
        remove:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/item",
            req:<{
                organizationId:string        
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        listUser:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user/list",
            req:<{
                organizationId?:string,
                organizationUserIds?:string[]
                page:number,
                size:number,
                keyword?:string     
            }>{},
            res:<ICommon_Route_Res_Organization_User_List>{},
            permission:[Permission_Types.Organization.READ]
        },
        addUser:{
            method:ECommon_HttpApi_Method.POST,
            path:"/user",
            req:<{
                organizationId:string,
                username:string,
                roleId:string,
                nickname:string,
                active:number,
                title?:string,
                job?:string,
                email?:string,
                phone?:string,
                location?:string,
                remark?:string
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        updateUser:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/user",
            req:<{
                organizationUserId?:string,
                roleId?:string,
                nickname?:string,
                active?:number,
                department?:string,
                job?:string,
                email?:string,
                phone?:string,
                location?:string,
                remark?:string
            }>{},
            res:<ICommon_Route_Res_Organization_User_Item>{},
            permission:[Permission_Types.Organization.READ]
        },
        deleteUser:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/user",
            req:<{
                organizationUserId:string,
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        user:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user",
            req:<{
                organizationUserId:string
            }>{},
            res:<ICommon_Route_Res_Organization_User>{},
            permission:[Permission_Types.Organization.READ]
        },
        enter:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/enter",
            req:<{
                organizationId:string,
            }>{},
            res:<{
                organizationUserId:string
            }>{},
            permission:[Permission_Types.Organization.READ]
        },
        listRole:{
            method:ECommon_HttpApi_Method.GET,
            path:"/rolelist",
            req:<{
                organizationId:string,
            }>{},
            res:<ICommon_Route_Res_Role_List>{},
            permission:[Permission_Types.Organization.READ]
        },
        addRole:{
            method:ECommon_HttpApi_Method.POST,
            path:"/role",
            req:<{
                organizationId:string,
                name :string,
                description?:string,
                value:number
            }>{},
            res:<ICommon_Route_Res_Role_Item>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        editRole:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/role",
            req:<{
                roleId:string,
                name?:string,
                description?:string,
                value?:number
            }>{},
            res:<ICommon_Route_Res_Role_Item>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        removeRole:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/role",
            req:<{
                roleId:string,
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        listTag:{
            method:ECommon_HttpApi_Method.GET,
            path:"/tag/list",
            req:<{
                keyword?:string
            }>{},
            res:<ICommon_Model_Member_Tag[]>{},
            permission:[Permission_Types.Organization.READ]
        },
        listTagMember:{
            method:ECommon_HttpApi_Method.GET,
            path:"/tag/member/list",
            req:<{
                memberTagId:string
            }>{},
            res:<ICommon_Route_Res_Member_Tag_Member[]>{},
            permission:[Permission_Types.Organization.READ]
        },
        addTag:{
            method:ECommon_HttpApi_Method.POST,
            path:"/tag",
            req:<{
                name:string,
                description?:string
            }>{},
            res:<ICommon_Model_Member_Tag>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        getTag:{
            method:ECommon_HttpApi_Method.GET,
            path:"/tag",
            req:<{
                memberTagId:string
            }>{},
            res:<ICommon_Model_Member_Tag>{},
            permission:[Permission_Types.Organization.READ]
        },
        editTag:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/tag",
            req:<{
                memberTagId:string
                name?:string,
                description?:string
            }>{},
            res:<ICommon_Model_Member_Tag>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        removeTag:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/tag",
            req:<{
                memberTagId:string
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        addTagMember:{
            method:ECommon_HttpApi_Method.POST,
            path:"/tag/member",
            req:<{
                memberTagId:string,
                memberId:string
            }>{},
            res:<ICommon_Route_Res_Member_Tag_Member>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        removeTagMember:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/tag/member",
            req:<{
                memberTagId:string,
                memberId:string
            }>{},
            res:<ICommon_Route_Res_Member_Tag_Member>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        setTagMember:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/tag/member",
            req:<{
                memberTagIds:string,
                memberId:string
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        listMemberTag:{
            method:ECommon_HttpApi_Method.GET,
            path:"/member/tag/list",
            req:<{
                memberId:string
            }>{},
            res:<ICommon_Model_Member_Tag[]>{},
            permission:[Permission_Types.Organization.READ]
        },
        getPermission:{
            method:ECommon_HttpApi_Method.GET,
            path:"/permission",
            req:<{
                organizationId:string
            }>{},
            res:<{
                value:number
            }>{},
            permission:[Permission_Types.Organization.READ]
        },
        userProfile:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user/profile",
            req:<{
                organizationUserId:string
            }>{},
            res:<ICommon_Route_Res_Organization_User_Profile>{},
            permission:[Permission_Types.Organization.READ]
        },
        userTeamInfos:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user/userteaminfos",
            req:<{
                ids:{
                    id:string,
                    type:ECommon_IM_Message_EntityType
                }[]
            }>{},
            res:<{
                [id:string]:{
                    id:string,
                    name:string,
                    photo:string,
                    type:ECommon_IM_Message_EntityType,
                    status?:ECommon_User_Online_Status
                }
            }>{},
            permission:[Permission_Types.Organization.READ]
        },
        filterAvailableUserAndTeam:{
            method:ECommon_HttpApi_Method.GET,
            path:"/userteam/filter",
            req:<{
                keyword:string,
                exceptMe:number
            }>{},
            res:<ICommon_Route_Res_Organization_FilterUserAndTeam>{},
            permission:[Permission_Types.Organization.READ]
        },
        changeUserStatus:{
            method:ECommon_HttpApi_Method.PUT,
            path:"/user/status",
            req:<{
                status:ECommon_User_Online_Status.ONLINE|ECommon_User_Online_Status.BUSY
            }>{},
            res:{},
            permission:[Permission_Types.Organization.READ]
        },
        getUserStatus:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user/status",
            req:<{
                organizationUserId?:string
            }>{},
            res:<{
                status:ECommon_User_Online_Status
            }>{},
            permission:[Permission_Types.Organization.READ]
        },
        getUserStatusList:{
            method:ECommon_HttpApi_Method.GET,
            path:"/user/statuslist",
            req:<{
                organizationUserIds:string[]
            }>{},
            res:<{
                [organizationUserIds:string]:ECommon_User_Online_Status
            }>{},
            permission:[Permission_Types.Organization.READ]
        },
        createUser:{
            method:ECommon_HttpApi_Method.POST,
            path:"/user/offline/new",
            req:<{
                organizationId:string,
                password:string,
                username:string,
                roleId:string,
                nickname:string,
                active:number,
                title?:string,
                job?:string,
                email?:string,
                phone?:string,
                location?:string,
                remark?:string
            }>{},
            res:<ICommon_Route_Res_Organization_User_Item>{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        resetUserPassword:{
            method:ECommon_HttpApi_Method.POST,
            path:"/user/offline/password",
            req:<{
                organizationUserId:string,
                password:string
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        deleteUserForOffline:{
            method:ECommon_HttpApi_Method.DELETE,
            path:"/user/offline",
            req:<{
                organizationUserId:string
            }>{},
            res:{},
            permission:[Permission_Types.Organization.ADMIN]
        },
        quit:{
            method:ECommon_HttpApi_Method.POST,
            path:"/user/quit",
            req:{},
            res:{},
            permission:[Permission_Types.Organization.READ]
        },
        statics:{
            method:ECommon_HttpApi_Method.GET,
            path:"/statics",
            req:{},
            res:<ICommon_Route_Res_Organization_Statics>{},
            permission:[Permission_Types.Organization.READ]
        },
    }
}

export default api