# Contributing to Jetpack Compose Components

🎉 First off, thank you for considering contributing to this project! We appreciate your interest in making this toolkit even better. 🎉

## How to Contribute

We welcome contributions of all kinds, including:

- **Bug Reports:** If you find a bug, please open an issue with a clear description, steps to reproduce, and the expected behavior.
- **Feature Requests:** Have an idea for a new component or enhancement? Open an issue to discuss it with the community.
- **Code Contributions:** We love pull requests!  If you'd like to fix a bug, add a new component, or improve existing code, follow these steps:

    1. **Fork the Repository:** Click the "Fork" button at the top right of the repository page.
    2. **Create a Branch:** Create a new branch for your changes.  Use a descriptive name like `fix/bottom-nav-overflow` or `add/circular-progress-bar`.
    3. **Make Your Changes:** Implement your changes, following the project's coding style and conventions.
    4. **Write Tests:** If applicable, add or update tests to ensure your changes work as expected.
    5. **Commit Your Changes:** Commit your changes with clear and concise commit messages.
    6. **Push to Your Fork:** Push your changes to your forked repository.
    7. **Open a Pull Request:** Go to the original repository and click "New Pull Request".  Select your forked repository and branch, and provide a detailed description of your changes.

## Coding Style and Conventions

- **Kotlin:** We use Kotlin for all development.
- **Jetpack Compose:** Follow the best practices and guidelines for Jetpack Compose development.
- **Code Formatting:** Use the default Android Studio code formatter (or a consistent formatter if you prefer).
- **Naming Conventions:** Use clear and descriptive names for variables, functions, and classes.
- **Documentation:** Provide KDoc style comments for all public APIs.

## Review Process

Our maintainers will review your pull request as soon as possible. We may ask for changes or provide feedback to help improve your contribution.

## Code of Conduct

We expect all contributors to adhere to our [Code of Conduct](CODE_OF_CONDUCT.md).  Please treat everyone with respect and create a welcoming and inclusive environment.

## Questions?

If you have any questions or need help getting started, feel free to open an issue or reach out to us on [Slack](https://join.slack.com/t/tanishranjan-repos/shared_invite/zt-2lydif64h-YbFL1NHlLT2n5df8ZYLxjQ).

## Thank You!

Thank you again for your interest in contributing to Jetpack Compose Components!  We look forward to your contributions.