
![banner](Assets/banner.png)
# Algorithm Visualizer

A better visualization of different algorithms made with React. 

Visit : https://tamimehsan.github.io/AlgorithmVisualizer/

![Visitor Count](https://visitor-badge.laobi.icu/badge?page_id=TamimEhsan.AlgorithmVisualizer)

Explore more than 24 algorithms with step by step visualization simplifying the learning process and making it more engaging for a better understanding. 

So far there are 6 segments  
- Pathfinder
- Prime Numbers
- Sorting Algorithms
- N Queen
- Convex Hull
- Binary Search Game
- Recursion Tree
- Turing Machine

I have implemented a total of `24 algorithms` so far. And will try to add more later.  

## Algorithms implemented 

- Graph Search
  - DFS
  - BFS
  - Dijkstra
  - A star
  - Recursive Maze Creation
- Sorting
  - Bubble sort
  - Selection sort
  - Insertion sort
  - Heap sort
  - Merge sort
  - Quick sort
- Sieve of Eratosthenes
- Archimedes Spiral
- N Queen Backtracking
- Graham Scan for Convex Hull
- Binary Search
- Recursion
  - Fibonacci Number
  - Binomial Coefficient
  - Derangement
  - Fast Exponentiation
  - Stirling Number of Second Kind

- Turing Machine
  - Bitwise NOT
  - Increment one
  - 2's Compliment



### Contribution
I am not sure if anyone would like to contribute to this project or not. But any kind of contributions are welcomes. Also if you like this please star this repo. It keeps me motivated.

### Special Features addition timeline

- Commit 16: Added Flip Move animation to inplace sorting components
- Commit 20: Added Tree Structure
- 13 Dec 2024: Release v2.0.0: Migrate the project from legacy project to next js with shadcn ui [#3](https://github.com/TamimEhsan/AlgorithmVisualizer/pull/3)

### Acknowledgement

I took inspirations from the following sources for some of the segments.
- `Pathfinder`: [The Projects That Got Me Into Google](https://youtu.be/n4t_-NjY_Sg)
- `Archimedes Spiral for Primes`: [Why do prime numbers make these spirals? ](https://youtu.be/EK32jo7i5LQ)
- `Recursion tree visualizer`: [Recursion Tree Visualizer](https://github.com/brpapa/recursion-tree-visualizer)
- `Turing Machine`: [Tursi](https://github.com/schaetzc/tursi)

### Run locally

Make sure you have node installed in your system. Then run
```bash
npm i
npm run dev
```
This will start the app in `http://localhost:3000/AlgorithmVisualizer`

### Inspiration for next sections

- [University of San Francisco Site](https://www.cs.usfca.edu/~galles/visualization/Algorithms.html) 
- ​[algorithm-visualizer](https://github.com/algorithm-visualizer)
- [National University of Singapore Site](https://visualgo.net/en)

