const webpack = require('webpack');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const WasmPackPlugin = require("@wasm-tool/wasm-pack-plugin");
const path = require("path");

module.exports = {
  entry: "./src/index.tsx",
  output: {
    path: path.resolve(__dirname, "dist"),
    filename: "bundle.[hash].js"
  },
  devServer: {
    compress: true,
      port: 8081,
    hot: true,
    static: './dist',
    historyApiFallback: true,
    open: true
  },
  resolve: {
      extensions: ['.tsx', '.ts', '.js', '.json', '.wasm', '.css', '.scss'],
  },
  module: {
    rules: [
        {
            test: /.(t|j)(s|sx)$/,
            exclude: /node_modules/,
            use: {
                loader: "ts-loader"
            }
        },
        {
            test: /.s?css$/,
            use: [
                {
                    loader: 'style-loader'
                },
                {
                    loader: "@teamsupercell/typings-for-css-modules-loader",
                    options: {
                        banner: "// Generated by @teamsupercell/typings-for-css-modules-loader\n// Builds fail when this file is missing, which happens in CI pipelines; package.json just arranges for a second build which succeeds since the first creates this file."
                    }
                },
                {
                    loader: "css-loader",
                    options: {
                        modules: {
                            mode: "local",
                            localIdentName: "[path][name]__[local]"
                        }
                    }
                },
                {
                    loader: "sass-loader",
                    options: {
                        sourceMap: true,
                        warnRuleAsWarning: true,
                    }
                },
            ]
        },
        {
            enforce: 'pre',
            test: /\.js$/,
            loader: 'source-map-loader'
        }
    ]
  },
  plugins: [
      new webpack.WatchIgnorePlugin({
          paths: [/css\.d\.ts$/]
      }),
      new HtmlWebpackPlugin({
          template: __dirname + "/public/index.html",
          filename: "index.html"
      }),
      new WasmPackPlugin({
        crateDirectory: path.resolve(__dirname, "."),
        watchDirectories: [
          "../base/src",
          "../base/src/collections",
          "../base/src/instruction",
          "../base/src/onescomplement",
          "../base/src/onescomplement/signed",
          "../base/src/onescomplement/unsigned",
          "../cpu/src",
          "../cpu/src/control",
          "../cpu/src/io"
        ].map(relative => path.resolve(__dirname, relative))
      }),
  ],
  mode: "development",
  devtool: 'inline-source-map',
  experiments: {
    asyncWebAssembly: true,
  },
};
