# Building the Command-Line Code

The following parts of the TX-2 Simulator are built as command-line
tools:

* The assembler
* The disassembler
* A simple command-line based simulator

## To Build The Code

To be able to build the code, [install the Rust build
tools](https://doc.rust-lang.org/cargo/getting-started/installation.html).

## Trying It Out

Right now the simulator doesn't have enough I/O support to be usable
interactively, and only implements enough instructions to get part-way
through the boot process.  So there is not much to see, yet.

To try it out, you can simply run

```
cargo run --bin cli -- examples/hello.tape
```

The simulator should print `HELLO, WORLD` several times and then stop.
It stops with an error message because the last instruction in the
program is not a valid instruction; this is currently the only way
that a user program can stop the simulator.

The `hello.tape` program had been generated by running the assemlber
to convert `assembler/examples/hello.tx2as` into an executable tape
image like this:

```
cargo run --bin  tx2m4as -- --output hello.tape assembler/examples/hello.tx2as
```

You can assemble and run your own test programs too.  See [our
documentation](https://tx-2.github.io/documentation.html) to find out
about the assembly language of he TX-2.  Both the assembler and
simulator are quite limited at the moment; if you come across a
limitation you'd like to see fixed, please see the
[Contributing][#contributing] section below.

### Getting More Detail on the Internals

This section of the document explains how to get information about
what the simulator is doing as it runs.

If you do want to see more detail, you can get it by setting the
`RUST_LOG` environment variable when you run the code:

```
RUST_LOG=debug cargo run --bin cli -- examples/hello.tape
```

For even more detail:

```
RUST_LOG=trace cargo run --bin cli
```

Full details on how to configure the logging output are in the
[documentation for the tracing-subscriber
crate](https://docs.rs/tracing-subscriber/0.2.25/tracing_subscriber/filter/struct.EnvFilter.html),
though the [analogous docmenation for
env_logger](https://docs.rs/env_logger/0.7.1/env_logger/#enabling-logging)
is probably more accessible.
