# Hotel Booking Management System

The Hotel Booking Management System is a simple web application developed using PHP, MySQL, JavaScript, HTML, CSS, Bootstrap, Ajax, and jQuery. The system features an admin dashboard to monitor customer bookings, manage users, approve reservations, update statuses, and more.

## Features

### Admin Dashboard

- **Booking**: Monitor customer bookings
- **Rooms**: Manage room availability
- **Booked**: View booked entries with ID, category, reference, status, and search functionality
- **Check In**: Filter by category, ID, and room status
- **Check Out**: View and search check-out entries
- **Room Category List**: Manage room categories with form, price, image, and edit/delete options
- **Rooms**: Manage rooms with form, category, availability, status, edit/delete options
- **Users**: Manage users with name, username, password, user type, ID, edit/delete options
- **Site Settings**: Configure hotel name, email, contact number, about content

### User Dashboard

- **Room**: View available rooms
- **Home**: Access the homepage
- **About Us**: Learn about the hotel
- **Booking**: Book a room

## Technologies Used

- **Name of Project**: Hotel Booking Management System
- **Language Used**: PHP
- **Database Used**: MySQL
- **Design Interface**: Bootstrap, JavaScript, HTML, Ajax, jQuery
- **Browsers**: Opera, Mozilla, Google Chrome, IE8
- **Software**: WAMP/XAMPP/LAMP/MAMP

## Note

One folder was not uploaded due to its large size. Please download it separately from the provided link.

## How to Setup This Project

1. **Download XAMPP**: Install XAMPP from the official website.
2. **Text Editor**: Use Notepad++ or Sublime Text.
3. **Download Project**: Download the zip file or use WinRAR to extract it.
4. **Extract Files**: Extract the file and copy the “Hotel_Booking_Management_System” folder.
5. **Paste Folder**: Paste the folder into the root directory (e.g., `C:\xampp\htdocs`).
6. **Open PHPMyAdmin**: Navigate to [PHPMyAdmin](http://localhost/phpmyadmin).
7. **Create Database**: Create a database named `hotel_db`.
8. **Import SQL File**: Import the `hotel_db.sql` file from the SQL folder inside the zip package.
9. **Run the Script**: Access the project at [http://localhost/Hotel_Booking_Management_System](http://localhost/Hotel_Booking_Management_System).
10. **Login**: Use the credentials `Username: admin` / `Password: admin123`.
