# Contributing

## Creating a Pull Request

Pull requests are the best way to make changes and fix bugs.

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed anything mentioned in the README, update the README or let me know in the PR that it needs to be updated.

## Any contributions you make will be under the GPLv3 Software License

When you submit code changes, your submissions are understood to be under the same [GPLv3 License](https://choosealicense.com/licenses/gpl-3.0/) that covers the project.

## Suggestions

Suggestions are welcome!

- It is not already being discussed in the [issue tracker](https://github.com/StringPotatoTheory/convert-chatterino-logs-into-json/issues)
  - If it has and is marked as OPEN, go ahead and share your own thoughts about the topic!
  - If it has and is marked as CLOSED, please read the ticket and depending on whether the suggestion was accepted consider if it is worth opening a new issue or not.

## Report bugs

Report a bug by [opening a new issue here](https://github.com/StringPotatoTheory/convert-chatterino-logs-into-json/issues).

### Write bug reports with detail, and the Chatterino log file / lines that caused the problem

**A good bug report** should have:

- Check that the bug is not already discussed in the [issue tracker](https://github.com/StringPotatoTheory/convert-chatterino-logs-into-json/issues)
- A quick summary and / or background
- Steps to reproduce
  - Be specific!
  - Provide error messages (terminal output, runs with verbose mode)
  - The Chatterino logs or the line(s) that caused the problem
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

## References

This document was adapted from the open-source contribution guidelines for [Distrobox](https://github.com/89luca89/distrobox/blob/main/CONTRIBUTING.md).
