## 全局变量
| Name | Description | Default |
| ----- | ----- | ----- |
| @DefaultTextSize | 主文字大小 | 14px |
| @SmallTextSize | 小号文字大小 | 12px |
| @DefaultColor | 默认文字颜色 | \#b3b3b3 |
| @PrimaryColor | 默认主颜色 | \#ff0000 |
| @SecondaryColor | 默认次颜色 | \#04be02 |
| @BarBackColor | 工具栏背景色 | \#000000 |
| @BarTextColor | 工具栏文字颜色 | \#fff |
| @HorizontalPadding | 区块水平内边距 | 12px |
| @VerticalPadding | 区域垂直内边距 | 10px |
| @TransitionDuration | 默认动画过渡时间 | .3s |

## 1像素边框颜色
| Name | Description | Default |
| ----- | ----- | ----- |
| @BorderColor | 边框颜色 | \#ccc |

## 徽标
| Name | Description | Default |
| ----- | ----- | ----- |
| @BadgeTextColor | 文字颜色 | \#fff |
| @BadgeBackColor | 背景颜色 | \#f74c31 |
| @BadgeTextSize | 文字大小 | @SmallTextSize |
| @BadgeHeight | 高度 | 16px |

## 小红点儿
| Name | Description | Default |
| ----- | ----- | ----- |
| @RedDotColor | 颜色 | @PrimaryColor |
| @RedDotSize | 大小 | 6px |

## Action Sheet
| Name | Description | Default |
| ----- | ----- | ----- |
| @ActionSheetBackColor | 背景色 | \#e0e0e0 |
| @ActionSheetButtonHeight | 按钮高度 | @ButtonHeight |
| @ActionSheetButtonBackColor | 按钮背景色 | \#fff |

## Alert
| Name | Description | Default |
| ----- | ----- | ----- |
| @AlertTitleHeight | 标题栏最小高度 | 50px |
| @AlertTitlePadding | 标题底边距 | 15px |

## Box
| Name | Description | Default |
| ----- | ----- | ----- |

## Button
| Name | Description | Default |
| ----- | ----- | ----- |
| @ButtonHeight | 按钮默认高度 | 40px |
| @ButtonTextSize | 按钮默认文字大小 | @DefaultTextSize |
| @ButtonDefaultColor | 按钮文字颜色 | \#444 |
| @ButtonDefaultBorder | 按钮边框颜色 | \#ddd |
| @ButtonDefaultBackColor | 按钮背景色 | \#f4f4f4 |
| @ButtonPrimaryColor | 按钮文字颜色 | \#fff |
| @ButtonPrimaryBorder | 按钮边框颜色 | \#367fa9 |
| @ButtonPrimaryBackColor | 按钮背景色 | \#3c8dbc |
| @ButtonSuccessColor | 按钮文字颜色 | \#fff |
| @ButtonSuccessBorder | 按钮边框颜色 | \#008d4c |
| @ButtonSuccessBackColor | 按钮背景色 | \#00a65a |
| @ButtonInfoColor | 按钮文字颜色 | \#fff |
| @ButtonInfoBorder | 按钮边框颜色 | \#00acd6 |
| @ButtonInfoBackColor | 按钮背景色 | \#00c0ef |
| @ButtonDangerColor | 按钮文字颜色 | \#fff |
| @ButtonDangerBorder | 按钮边框颜色 | \#d73925 |
| @ButtonDangerBackColor | 按钮背景色 | \#e40013 |
| @ButtonWarningColor | 按钮文字颜色 | \#fff |
| @ButtonWarningBorder | 按钮边框颜色 | \#e08e0b |
| @ButtonWarningBackColor | 按钮背景色 | \#f39c12 |

## Card
| Name | Description | Default |
| ----- | ----- | ----- |
| @CardBackColor | 卡片背景颜色 | \#fff |
| @CardTransitionDuration | 收缩动画过渡时间 | @TransitionDuration |
| @CardCardSpace | 上下两个卡片之间的间距 | 15px |
| @CardHorizontalPadding | 卡片水平内边距 | @HorizontalPadding |
| @CardVerticalPadding | 卡片内容区垂直内边距 | 10px |
| @CardHeaderHeight | 卡片头高度 | 45px |
| @CardHeaderTextSize | 卡片头文字大小 | 16px |
| @CardContentTextSize | 卡片内容区文字大小 | 15px |
| @CardFooterHeight | 卡片尾高度 | 40px |
| @CardFooterTextSize | 卡片尾文字大小 | 13px |
| @CardFooterTextColor | 卡片尾文字颜色 | \#5f646e |

## Cell
| Name | Description | Default |
| ----- | ----- | ----- |
| @CellBackColor | 背景颜色 | \#fff |
| @CellMinHeight | 最小高度 | 45px |
| @CellHorizontalPadding | 水平内边距 | @HorizontalPadding |
| @CellIconTextSpace | 左图标与文字之间的距离 | 15px |
| @CellArrowColor | 右箭头的颜色 | \#cecece |
| @CellArrowScale | 右箭头的缩放比例 | 0.8 |
| @CellTextSize | 文字大小 | 15px |

## Checkbox
| Name | Description | Default |
| ----- | ----- | ----- |
| @CheckBoxHeight | 复选框高度 | 20px |
| @CheckBoxRadius | 勾选框的圆角半径 | 2px |
| @CheckBoxSpace | 勾选框与文字之间的距离 | 10px |
| @CheckBoxTextSize | 文字大小 | @CheckBoxHeight - 6px |
| @CheckBoxTextColor | 文字颜色 | \#243441 |
| @CheckBoxBackColor | 勾选框背景色 | \#fff |
| @CheckBoxBorderColor | 勾选框边框颜色 | \#c1caca |
| @CheckBoxCheckColor | 勾的颜色 | \#fff |
| @CheckBoxDisabledBackColor | 禁用状态下勾选框背景色 | \#e6e6e6 |
| @CheckBoxDisabledBorderColor | 禁用状态下勾选框边框颜色 | @CheckBoxBorderColor |
| @CheckBoxDisabledCheckColor | 禁用状态下勾的颜色 | \#b1b1b1 |
| @CheckBoxCheckedBackColor | 选中状态下勾选框背景色 | @PrimaryColor |
| @CheckBoxCheckedBorderColor | 选中状态下勾选框边框颜色 | @PrimaryColor |
| @CheckBoxCheckedCheckColor | 选中状态下勾的颜色 | @CheckBoxCheckColor |
| @CheckBoxDisabledCheckedBackColor | 禁用并选中状态下勾选框背景色 | @CheckBoxDisabledBackColor |
| @CheckBoxDisabledCheckedBorderColor | 禁用并选中状态下勾选框边框颜色 | @CheckBoxBorderColor |
| @CheckBoxDisabledCheckedCheckColor | 禁用并选中状态下勾的颜色 | @CheckBoxDisabledCheckColor |

## Confirm
| Name | Description | Default |
| ----- | ----- | ----- |
| @ConfirmTitleHeight | 标题栏最小高度 | @AlertTitleHeight |
| @ConfirmTitlePadding | 标题底边距 | @AlertTitlePadding |

## Dialog
| Name | Description | Default |
| ----- | ----- | ----- |
| @DialogWidth | 对话框宽度 | 85% |
| @DialogBackColor | 对话框背景颜色 | \#fafafc |
| @DialogRadius | 对话框圆角半径 | 5px |
| @DialogHeaderPadding | 标题栏内边距 | 15px 20px 10px |
| @DialogHeaderTextSize | 标题栏文字大小 | 17px |
| @DialogContentPadding | 内容区内边距 | 20px |
| @DialogContentTextSize | 内容区文字大小 | 15px |
| @DialogFooterHeight | 尾部高度 | 42px |
| @DialogFooterTextSize | 尾部文字大小 | @DialogHeaderTextSize |
| @DialogPrimaryColor | 底部按钮主颜色 | @PrimaryColor |
| @DialogDefaultColor | 底部按钮默认色 | @DefaultColor |

## Drop Load
| Name | Description | Default |
| ----- | ----- | ----- |
| @DropLoadTipTextSize | 提示文字大小 | @SmallTextSize |
| @DropLoadDownHeight | 提示区域高度 | 50px |

## Grid
| Name | Description | Default |
| ----- | ----- | ----- |

## Input
| Name | Description | Default |
| ----- | ----- | ----- |
| @InputPadding | 输入框内边距 | 5px |
| @InputTextSize | 输入框文字大小 | @DefaultTextSize |
| @InputInvalidColor | 输入错误时的边框提示颜色 | @PrimaryColor |
| @InputMessageWidth | 输入错误提示信息的宽度 | 70% |
| @InputMessageTextSize | 输入错误提示信息的文字大小 | @SmallTextSize |
| @InputMessageTextColor | 输入错误提示信息的文字颜色 | \#fff |
| @InputMessageBackColor | 输入错误提示信息的背景色 | \#363636 |

## Justify
| Name | Description | Default |
| ----- | ----- | ----- |

## Marquee
| Name | Description | Default |
| ----- | ----- | ----- |
| @MarqueeTransitionDuration | 切换动画过渡时间 | .2s |
| @MarqueeHeight | 高度 | 30px |
| @MarqueeBackColor | 背景色 | \#efefef |
| @MarqueeTextColor | 文字颜色 | @PrimaryColor |
| @MarqueeTextSize | 文字大小 | @DefaultTextSize |
| @MarqueeIconScale | 图标缩放比例 | 0.6 |

## Mask
| Name | Description | Default |
| ----- | ----- | ----- |
| @MaskBackColor | 背景色 | rgba(0, 0, 0, .4) |

## Navbar
| Name | Description | Default |
| ----- | ----- | ----- |
| @NavbarHeight | 高度 | 50px |
| @NavbarIconWidth | 左右图标栏宽度 | 50px |
| @NavbarBackColor | 背景色 | @BarBackColor |
| @NavbarTextColor | 文字颜色 | @BarTextColor |
| @NavbarTextSize | 文字大小 | 18px |

## Number
| Name | Description | Default |
| ----- | ----- | ----- |
| @NumberWidth | 输入框宽度 | 30px |
| @NumberHeight | 高度 | @NumberWidth |

## Picker
| Name | Description | Default |
| ----- | ----- | ----- |
| @PickerLineHeight | 单行元素高度 | 35px |
| @PickerSplitColor | 分割线颜色 | \#eee |
| @PickerTextSize | 元素文字主大小 | 16px |

## Popup
| Name | Description | Default |
| ----- | ----- | ----- |
| @PopupBackColor | 弹出层背景色 | \#fff |
| @PopupTopHeight | 上弹出层最小高度 | 50px |
| @PopupTopTextColor | 上弹出层文字颜色 | \#fff |
| @PopupTopBackColor | 上弹出层背景色 | rgba(0, 0, 0, .7) |

## Popup Picker
| Name | Description | Default |
| ----- | ----- | ----- |
| @PopupPickerHeaderHeight | 标题栏高度 | 44px |
| @PopupPickerHeaderBackColor | 标题栏背景色 | \#d5d5d6 |
| @PopupPickerHeaderTextSize | 标题栏文字大小 | 16px |
| @PopupPickerHeaderButtonPadding | 标题栏按钮左右内边距 | 20px |
| @PopupPickerHeaderButtonTextColor | 标题栏按钮文字颜色 | \#777 |

## Progressbar
| Name | Description | Default |
| ----- | ----- | ----- |
| @ProgressbarHeight | 进度条高度 | 8px |
| @ProgressbarBackColor | 进度条背景色 | \#b3b3b3 |
| @ProgressbarColor | 进度条颜色 | \#2db7f5 |

## Prompt
| Name | Description | Default |
| ----- | ----- | ----- |
| @PromptInputHeight | 输入框高度 | 40px |
| @PromptInputPadding | 输入框内边距 | @InputPadding |
| @PromptInputTextSize | 输入框文字大小 | @InputTextSize |
| @PromptInputInvalidColor | 输入错误时的边框提示颜色 | @InputInvalidColor |
| @PromptMessageTextSize | 输入错误提示信息的文字大小 | @InputMessageTextSize |
| @PromptMessageTextColor | 输入错误提示信息的文字颜色 | @InputInvalidColor |
| @PromptMessageInputSpace | 输入错误提示信息与输入框边距 | 5px |

## Radio
| Name | Description | Default |
| ----- | ----- | ----- |
| @RadioHeight | 单选框高度 | @CheckBoxHeight |
| @RadioSpace | 勾选框与文字之间的距离 | @CheckBoxSpace |
| @RadioTextSize | 文字大小 | @CheckBoxTextSize |
| @RadioTextColor | 文字颜色 | @CheckBoxTextColor |
| @RadioBackColor | 勾选框背景色 | @CheckBoxBackColor |
| @RadioBorderColor | 勾选框边框颜色 | @CheckBoxBorderColor |
| @RadioCheckColor | 勾的颜色 | @CheckBoxCheckColor |
| @RadioDisabledBackColor | 禁用状态下勾选框背景色 | @CheckBoxDisabledBackColor |
| @RadioDisabledBorderColor | 禁用状态下勾选框边框颜色 | @CheckBoxDisabledBorderColor |
| @RadioDisabledCheckColor | 禁用状态下勾的颜色 | @CheckBoxDisabledCheckColor |
| @RadioCheckedBackColor | 选中状态下勾选框背景色 | @CheckBoxCheckedBackColor |
| @RadioCheckedBorderColor | 选中状态下勾选框边框颜色 | @CheckBoxCheckedBorderColor |
| @RadioCheckedCheckColor | 选中状态下勾的颜色 | @CheckBoxCheckedCheckColor |
| @RadioDisabledCheckedBackColor | 禁用并选中状态下勾选框背景色 | @CheckBoxDisabledCheckedBackColor |
| @RadioDisabledCheckedBorderColor | 禁用并选中状态下勾选框边框颜色 | @CheckBoxDisabledCheckedBorderColor |
| @RadioDisabledCheckedCheckColor | 禁用并选中状态下勾的颜色 | @CheckBoxDisabledCheckedCheckColor |

## Rater
| Name | Description | Default |
| ----- | ----- | ----- |
| @RaterColor | 未选中状态的默认颜色 | \#ccc |
| @RaterActiveColor | 选中状态的颜色 | \#ffad34 |
| @RaterGutter | 星与星之间的间距 | 2px |
| @RaterStarSize | 星的大小 | 25px |

## Row
| Name | Description | Default |
| ----- | ----- | ----- |
| @RowHorizontalPadding | 水平内边距 | @HorizontalPadding |
| @RowBackColor | 背景色 | \#fff |
| @RowMinHeight | 最小高度 | 45px |
| @RowTextSize | 文字大小 | 15px |
| @RowTitleWidth | 标题栏最小宽度 | 80px |

## Slider
| Name | Description | Default |
| ----- | ----- | ----- |
| @SliderTitlePadding | 标题栏内边距 | 10px |
| @SliderTitleBackColor | 标题栏背景颜色 | rgba(0,0,0,.7) |
| @SliderTitleTextColor | 标题栏文字颜色 | \#fff |
| @SliderTitleTextSize | 标题栏文字大小 | @DefaultTextSize |
| @SliderDotsDistance | 点的上或下边距 | 8px |
| @SliderDotSize | 点的大小 | 6px |
| @SliderDotColor | 点的默认颜色 | \#d0cdd1 |
| @SliderDotActiveColor | 点的当前颜色 | \#323232 |
| @SliderGutter | 多张图片时，图片之间的间距 | 0 |

## Spinner
| Name | Description | Default |
| ----- | ----- | ----- |
| @SpinnerSize | 指示器默认大小 | 28px |
| @SpinnerColor | 指示器默认颜色 | \#ccc |

## Submit
| Name | Description | Default |
| ----- | ----- | ----- |

## Switch
| Name | Description | Default |
| ----- | ----- | ----- |
| @SwitchWidth | 宽度 | 50px |
| @SwitchHeight | 高度 | @SwitchWidth * 0.6 |
| @SwitchTextSize | 文字大小 | @SwitchHeight / 2 |
| @SwitchTextSpace | 与提示文字之间的距离 | 5px |
| @SwitchTextColor | 文字颜色 | \#243441 |
| @SwitchBorderColor | 边框颜色 | \#dfdfdf |
| @SwitchBackColor | 背景颜色 | \#fdfdfd |
| @SwitchColor | 默认颜色 | \#fff |
| @SwitchCheckedColor | 选中颜色 | @SecondaryColor |

## Tabbar
| Name | Description | Default |
| ----- | ----- | ----- |
| @TabbarHeight | 高度 | 55px |
| @TabbarBackColor | 背景色 | @BarBackColor |
| @TabbarTextColor | 文字颜色 | \#5e5e5e |
| @TabbarTextSize | 文字大小 | 13px |
| @TabbarTextActiveColor | 当前文字颜色 | @BarTextColor |

## TabControl
| Name | Description | Default |
| ----- | ----- | ----- |
| @TabControlTransitionDuration | 过渡动画时间 | @TransitionDuration |
| @TabControlTransitionTiming | 横线过渡动画效果 | cubic-bezier(0.35, 0, 0.25, 1) |
| @TabControlTabTextSize1 | 当type=1时的Tab文字大小 | @DefaultTextSize |
| @TabControlTabHeight1 | 当type=1时的Tab高度 | 44px |
| @TabControlTabLineWidth | 当type=1时的横线宽度 | 2px |
| @TabControlTabDefaultColor1 | 当type=1时的Tab默认颜色 | \#b2b2b2 |
| @TabControlTabActiveColor1 | 当type=1时的Tab高亮颜色 | \#000 |
| @TabControlTabBackColor1 | 当type=1时的Tab背景颜色 | \#fff |
| @TabControlTabTextSize2 | 当type=2时的Tab文字大小 | @TabControlTabTextSize1 |
| @TabControlTabHeight2 | 当type=2时的Tab高度 | 30px |
| @TabControlTabDefaultColor2 | 当type=2时的Tab默认颜色 | \#fff |
| @TabControlTabActiveColor2 | 当type=2时的Tab高亮颜色 | \#007aff |
| @TabControlTabBackColor2 | 当type=2时的Tab背景颜色 | \#fff |
| @TabControlTabBorderWidth | 当type=2时的边框宽度 | 2px |
| @TabControlTabBorderRadius | 当type=2时的圆角半径 | 6px |

## TextArea
| Name | Description | Default |
| ----- | ----- | ----- |
| @TextAreaPadding | 文本框内边距 | @InputPadding |
| @TextAreaTextSize | 文本框文字大小 | @InputTextSize |
| @TextAreaTipTextSize | 文本框提示区文字大小 | @InputMessageTextSize |
| @TextAreaTipTextColor | 文本框提示区文字颜色 | \#e0e0e0 |

## Toast
| Name | Description | Default |
| ----- | ----- | ----- |
| @ToastMaxWidth | 提示框最大宽度 | 80% |
| @ToastRadius | 提示框圆角半径 | 5px |
| @ToastPadding | 提示框内边距 | 10px |
| @ToastBackColor | 提示框背景色 | rgba(0, 0, 0, 0.7) |
| @ToastTextColor | 提示框文字颜色 | \#fff |
| @ToastTextSize | 提示框文字大小 | @DefaultTextSize |
| @ToastIconSize | 提示框图标大小 | 30px |
| @ToastTransitionDuration | 提示框动画过渡时间 | @TransitionDuration |

## Upload
| Name | Description | Default |
| ----- | ----- | ----- |
| @UploadWidth | 上传按钮宽度 | 60px |
| @UploadHeight | 上传按钮高度 | 60px |
| @UploadBorderWidth | 上传按钮边框线宽度 | 2px |
| @UploadBorderColor | 上传按钮边框线颜色 | \#ccc |
| @UploadBorderStyle | 上传按钮边框线样式 | dashed |
| @UploadBorderRadius | 上传按钮边框圆角半径 | 5px |
