/*
 * SonarQube PHP Plugin
 * Copyright (C) 2010-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.plugins.php.reports.phpunit.xml;

import java.util.ArrayList;
import java.util.List;

/**
 * The ProjectNode represent the analyzed project in the PhpUnit coverage report file.
 */
public class ProjectNode {

  /**
   * The project files.
   */
  private List<FileNode> files = new ArrayList<>();

  /**
   * The project files.
   */
  private List<PackageNode> packages = new ArrayList<>();

  /**
   * The project name.
   */
  private String name;

  /**
   * Gets the name.
   *
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the name.
   *
   * @param name the new name
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Gets the files.
   *
   * @return the files
   */
  public List<FileNode> getFiles() {
    return files;
  }

  /**
   * Gets the packages.
   *
   * @return the packages
   */
  public List<PackageNode> getPackages() {
    return packages;
  }
}
