/*
 * SonarQube PHP Plugin
 * Copyright (C) 2010-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.plugins.php.api.visitors;

import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.visitors.PHPCheckContext;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.AttributeTree;
import org.sonar.plugins.php.api.tree.declaration.BuiltInTypeTree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ConstantDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.DnfIntersectionTypeTree;
import org.sonar.plugins.php.api.tree.declaration.DnfTypeTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.IntersectionTypeTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.PropertyHookListTree;
import org.sonar.plugins.php.api.tree.declaration.PropertyHookTree;
import org.sonar.plugins.php.api.tree.declaration.ReturnTypeClauseTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.declaration.UnionTypeTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerBracketTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerFunctionTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ArrowFunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.CallableConvertTree;
import org.sonar.plugins.php.api.tree.expression.CastExpressionTree;
import org.sonar.plugins.php.api.tree.expression.CompoundVariableTree;
import org.sonar.plugins.php.api.tree.expression.ComputedVariableTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExecutionOperatorTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.HeredocStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.ListExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MatchConditionClauseTree;
import org.sonar.plugins.php.api.tree.expression.MatchDefaultClauseTree;
import org.sonar.plugins.php.api.tree.expression.MatchExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.PrefixedCastExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ReferenceVariableTree;
import org.sonar.plugins.php.api.tree.expression.SpreadArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ThrowExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableVariableTree;
import org.sonar.plugins.php.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.EchoTagStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.EmptyStatementTree;
import org.sonar.plugins.php.api.tree.statement.EnumCaseTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionListStatementTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.GlobalStatementTree;
import org.sonar.plugins.php.api.tree.statement.GotoStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.InlineHTMLTree;
import org.sonar.plugins.php.api.tree.statement.LabelTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StaticStatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.tree.statement.TraitAliasTree;
import org.sonar.plugins.php.api.tree.statement.TraitMethodReferenceTree;
import org.sonar.plugins.php.api.tree.statement.TraitPrecedenceTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.tree.statement.UnsetVariableStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseClauseTree;
import org.sonar.plugins.php.api.tree.statement.UseStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;

public abstract class PHPVisitorCheck implements VisitorCheck {
  public static final int MAX_DEPTH = 1500;
  private int depth;
  private CheckContext context;

  @Override
  public void init() {
    // Default behavior : do nothing.
  }

  @Override
  public void visitToken(SyntaxToken token) {
    scan(token);
  }

  @Override
  public void visitTrivia(SyntaxTrivia trivia) {
    // Do nothing is the default behavior (There is no children to visit)
  }

  @Override
  public void visitVariableDeclaration(VariableDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitNamespaceName(NamespaceNameTree tree) {
    scan(tree);
  }

  @Override
  public void visitUseClause(UseClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitMethodDeclaration(MethodDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitParameterList(ParameterListTree tree) {
    scan(tree);
  }

  @Override
  public void visitParameter(ParameterTree tree) {
    scan(tree);
  }

  @Override
  public void visitUseTraitDeclaration(UseTraitDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitTraitPrecedence(TraitPrecedenceTree tree) {
    scan(tree);
  }

  @Override
  public void visitTraitAlias(TraitAliasTree tree) {
    scan(tree);
  }

  @Override
  public void visitTraitMethodReference(TraitMethodReferenceTree tree) {
    scan(tree);
  }

  @Override
  public void visitClassDeclaration(ClassDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitConstDeclaration(ConstantDeclarationTree tree) {
    scan(tree);
  }

  @Override
  public void visitStaticStatement(StaticStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitDeclareStatement(DeclareStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitInlineHTML(InlineHTMLTree tree) {
    scan(tree);
  }

  @Override
  public void visitGlobalStatement(GlobalStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitUseStatement(UseStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitUnsetVariableStatement(UnsetVariableStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitDefaultClause(DefaultClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitCaseClause(CaseClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitSwitchStatement(SwitchStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitMatchConditionClause(MatchConditionClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitMatchDefaultClause(MatchDefaultClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitMatchExpression(MatchExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitWhileStatement(WhileStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitDoWhileStatement(DoWhileStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitElseifClause(ElseifClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitIfStatement(IfStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitElseClause(ElseClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitBlock(BlockTree tree) {
    scan(tree);
  }

  @Override
  public void visitForStatement(ForStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitForEachStatement(ForEachStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitThrowStatement(ThrowStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitEmptyStatement(EmptyStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitReturnStatement(ReturnStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitContinueStatement(ContinueStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitBreakStatement(BreakStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitCatchBlock(CatchBlockTree tree) {
    scan(tree);
  }

  @Override
  public void visitTryStatement(TryStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitGotoStatement(GotoStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitExpressionStatement(ExpressionStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitExpressionListStatement(ExpressionListStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitEchoTagStatement(EchoTagStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayAssignmentPattern(ArrayAssignmentPatternTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayAssignmentPatternElement(ArrayAssignmentPatternElementTree tree) {
    scan(tree);
  }

  @Override
  public void visitLabel(LabelTree tree) {
    scan(tree);
  }

  @Override
  public void visitNamespaceStatement(NamespaceStatementTree tree) {
    scan(tree);
  }

  @Override
  public void visitThrowExpression(ThrowExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitCastExpression(CastExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitPrefixedCastExpression(PrefixedCastExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitPrefixExpression(UnaryExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitBinaryExpression(BinaryExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitVariableIdentifier(VariableIdentifierTree tree) {
    scan(tree);
  }

  @Override
  public void visitNameIdentifier(NameIdentifierTree tree) {
    scan(tree);
  }

  @Override
  public void visitLiteral(LiteralTree tree) {
    scan(tree);
  }

  @Override
  public void visitExpandableStringCharacters(ExpandableStringCharactersTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayAccess(ArrayAccessTree tree) {
    scan(tree);
  }

  @Override
  public void visitMemberAccess(MemberAccessTree tree) {
    scan(tree);
  }

  @Override
  public void visitCompoundVariable(CompoundVariableTree tree) {
    scan(tree);
  }

  @Override
  public void visitComputedVariable(ComputedVariableTree tree) {
    scan(tree);
  }

  @Override
  public void visitExpandableStringLiteral(ExpandableStringLiteralTree tree) {
    scan(tree);
  }

  @Override
  public void visitExecutionOperator(ExecutionOperatorTree tree) {
    scan(tree);
  }

  @Override
  public void visitYieldExpression(YieldExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitListExpression(ListExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitAssignmentExpression(AssignmentExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitVariableVariable(VariableVariableTree tree) {
    scan(tree);
  }

  @Override
  public void visitReferenceVariable(ReferenceVariableTree tree) {
    scan(tree);
  }

  @Override
  public void visitSpreadArgument(SpreadArgumentTree tree) {
    scan(tree);
  }

  @Override
  public void visitFunctionCall(FunctionCallTree tree) {
    scan(tree);
  }

  @Override
  public void visitCallableConvert(CallableConvertTree tree) {
    scan(tree);
  }

  @Override
  public void visitLexicalVariables(LexicalVariablesTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayPair(ArrayPairTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayInitializerFunction(ArrayInitializerFunctionTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrayInitializerBracket(ArrayInitializerBracketTree tree) {
    scan(tree);
  }

  @Override
  public void visitScript(ScriptTree tree) {
    scan(tree);
  }

  @Override
  public void visitCompilationUnit(CompilationUnitTree tree) {
    scan(tree);
  }

  @Override
  public void visitFunctionExpression(FunctionExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitArrowFunctionExpression(ArrowFunctionExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitNewExpression(NewExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitAnonymousClass(AnonymousClassTree tree) {
    scan(tree);
  }

  @Override
  public void visitPostfixExpression(UnaryExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitConditionalExpression(ConditionalExpressionTree tree) {
    scan(tree);
  }

  @Override
  public void visitType(TypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitUnionType(UnionTypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitIntersectionType(IntersectionTypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitDnfType(DnfTypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitDnfIntersectionType(DnfIntersectionTypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitBuiltInType(BuiltInTypeTree tree) {
    scan(tree);
  }

  @Override
  public void visitReturnTypeClause(ReturnTypeClauseTree tree) {
    scan(tree);
  }

  @Override
  public void visitPropertyHookList(PropertyHookListTree tree) {
    scan(tree);
  }

  @Override
  public void visitPropertyHook(PropertyHookTree tree) {
    scan(tree);
  }

  @Override
  public void visitHeredoc(HeredocStringLiteralTree tree) {
    scan(tree);
  }

  @Override
  public void visitCallArgument(CallArgumentTree tree) {
    scan(tree);
  }

  @Override
  public void visitAttributeGroup(AttributeGroupTree tree) {
    scan(tree);
  }

  @Override
  public void visitAttribute(AttributeTree tree) {
    scan(tree);
  }

  @Override
  public void visitEnumCase(EnumCaseTree tree) {
    scan(tree);
  }

  @Override
  public CheckContext context() {
    return context;
  }

  protected void scan(Tree tree) {
    Iterator<Tree> childrenIterator = ((PHPTree) tree).childrenIterator();
    Tree child;

    while (childrenIterator.hasNext()) {
      child = childrenIterator.next();
      if (child != null && depth < MAX_DEPTH) {
        depth++;
        child.accept(this);
        depth--;
      }
    }
  }

  protected <T extends Tree> void scan(List<T> trees) {
    for (T tree : trees) {
      tree.accept(this);
    }
  }

  @Override
  public final List<PhpIssue> analyze(PhpFile file, CompilationUnitTree tree) {
    return analyze(new PHPCheckContext(file, tree, null));
  }

  @Override
  public List<PhpIssue> analyze(PhpFile file, CompilationUnitTree tree, SymbolTable symbolTable) {
    return analyze(new PHPCheckContext(file, tree, null, symbolTable));
  }

  @Override
  public List<PhpIssue> analyze(CheckContext context) {
    depth = 0;
    this.context = context;
    visitCompilationUnit(context.tree());
    return context().getIssues();
  }

  protected final QualifiedName getFullyQualifiedName(NamespaceNameTree namespaceNameTree) {
    Symbol symbol = context().symbolTable().getSymbol(namespaceNameTree.name());
    if (symbol == null) {
      throw new IllegalStateException("Symbol not found for " + namespaceNameTree + " at " + context.getPhpFile() + ":" + ((PHPTree) namespaceNameTree).getFirstToken().line());
    }
    return symbol.qualifiedName();
  }

  @Override
  public PreciseIssue newIssue(Tree tree, String message) {
    return context().newIssue(this, tree, message);
  }
}
