/*
 * SonarQube PHP Plugin
 * Copyright (C) 2010-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.plugins.php.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class TestIssue {

  public static class Location {

    private String message;
    private int line;
    private Integer startColumn = null;
    private Integer endColumn = null;
    private Integer endLine = null;

    private Location(@Nullable String message, int line) {
      this.message = message;
      this.line = line;
    }

    public String message() {
      return message;
    }

    public int line() {
      return line;
    }

    public Integer startColumn() {
      return startColumn;
    }

    public Integer endColumn() {
      return endColumn;
    }
  }

  private Double effortToFix = null;

  private Location primaryLocation;
  private List<Location> secondaryLocations = new ArrayList<>();

  private TestIssue(@Nullable String message, int line) {
    primaryLocation = new Location(message, line);
  }

  public static TestIssue create(@Nullable String message, int lineNumber) {
    return new TestIssue(message, lineNumber);
  }

  public TestIssue message(String message) {
    this.primaryLocation.message = message;
    return this;
  }

  public TestIssue columns(int startColumn, int endColumn) {
    startColumn(startColumn);
    endColumn(endColumn);
    return this;
  }

  public TestIssue startColumn(int startColumn) {
    this.primaryLocation.startColumn = startColumn;
    return this;
  }

  public TestIssue endColumn(int endColumn) {
    this.primaryLocation.endColumn = endColumn;
    return this;
  }

  public TestIssue effortToFix(double effortToFix) {
    this.effortToFix = effortToFix;
    return this;
  }

  public TestIssue endLine(int endLine) {
    this.primaryLocation.endLine = endLine;
    return this;
  }

  public TestIssue secondary(Integer... lines) {
    return this.secondary(Arrays.asList(lines));
  }

  public TestIssue secondary(List<Integer> secondaryLines) {
    for (int line : secondaryLines) {
      secondaryLocations.add(new Location(null, line));
    }
    return this;
  }

  public int line() {
    return primaryLocation.line;
  }

  public Integer startColumn() {
    return primaryLocation.startColumn;
  }

  public Integer endLine() {
    return primaryLocation.endLine;
  }

  public Integer endColumn() {
    return primaryLocation.endColumn;
  }

  public String message() {
    return primaryLocation.message;
  }

  public Double effortToFix() {
    return effortToFix;
  }

  public List<Location> secondaryLocations() {
    return secondaryLocations;
  }

}
