/*
 * SonarQube PHP Plugin
 * Copyright (C) 2010-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
plugins {
  id("org.sonarsource.php.java-conventions")
  id("org.sonarsource.php.code-style-convention")
  id("java-library")
  id("java-test-fixtures")
  id("maven-publish")
}

description = "SonarSource PHP Analyzer :: Frontend"

dependencies {
  api(libs.sonar.analyzer.test.commons)
  api(libs.sslr.core)
  api(libs.sonar.regex.parsing)

  implementation(libs.sonar.plugin.api)
  implementation(libs.commons.lang)

  testImplementation(libs.junit.jupiter)
  testImplementation(libs.mockito.core)
  testImplementation(libs.assertj.core)
  testImplementation(libs.sonar.plugin.api.test.fixtures)
  testImplementation(libs.sonar.plugin.api.impl)
  testImplementation(libs.sslr.testing.harness)
  testImplementation(libs.sonar.testing.harness)

  testFixturesImplementation(libs.sonar.plugin.api.impl)
}

publishing {
  repositories {
    mavenLocal()
  }
  publications {
    create<MavenPublication>("mavenJava") {
      from(components["java"])
    }
  }
}
