/*
 * SonarQube PHP Plugin
 * Copyright (C) 2010-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.php.checks.security;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.argumentmatching.ArgumentVerifierValueContainment;
import org.sonar.php.checks.utils.argumentmatching.FunctionArgumentCheck;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key = "S5547")
public class RobustCipherAlgorithmCheck extends FunctionArgumentCheck {
  private static final String MESSAGE = "Use a strong cipher algorithm";

  @Override
  public void visitFunctionCall(FunctionCallTree tree) {
    ArgumentVerifierValueContainment mcryptMatcher = ArgumentVerifierValueContainment.builder()
      .position(0)
      .name("cipher")
      .values(Set.of(
        "mcrypt_des",
        "mcrypt_des_compat",
        "mcrypt_tripledes",
        "mcrypt_3des",
        "mcrypt_blowfish",
        "mcrypt_rc2",
        "mcrypt_rc4"))
      .build();

    checkArgument(tree, "mcrypt_encrypt", mcryptMatcher);

    ArgumentVerifierValueContainment opensslMatcher = ArgumentVerifierValueContainment.builder()
      .position(1)
      .name("method")
      .values(Set.of(
        "bf-cbc",
        "bf-cfb",
        "bf-ecb",
        "bf-ofb",
        "des-cbc",
        "des-cfb",
        "des-cfb1",
        "des-cfb8",
        "des-ecb",
        "des-ede",
        "des-ede3",
        "des-ede3-cbc",
        "des-ede3-cfb",
        "des-ede3-cfb1",
        "des-ede3-cfb8",
        "des-ede3-ofb",
        "des-ede-cbc",
        "des-ede-cfb",
        "des-ede-ofb",
        "des-ofb",
        "desx-cbc",
        "rc2-40-cbc",
        "rc2-64-cbc",
        "rc2-cbc",
        "rc2-cfb",
        "rc2-ecb",
        "rc2-ofb",
        "rc4",
        "rc4-40",
        "rc4-hmac-md5"))
      .build();

    checkArgument(tree, "openssl_encrypt", opensslMatcher);

    super.visitFunctionCall(tree);
  }

  @Override
  protected void createIssue(ExpressionTree tree) {
    context().newIssue(this, tree, MESSAGE);
  }
}
