import React from 'react';
import cx from 'classnames';
import { Button } from 'antd';
// import { MenuFoldOutlined, MenuUnfoldOutlined } from '@ant-design/icons';
import { RiMenuLine, RiMenu3Line } from 'react-icons/ri';

import style from './style.module.less';

interface IProps {
  onCallbackSidebarTarget?: () => void;
  className?: string;
  collapsed?: boolean;
}

export const SidemenuTarget = (props: IProps): JSX.Element => {
  return (
    <Button
      type="link"
      onClick={props.onCallbackSidebarTarget}
      className={cx(style['sidebar-target-wrapper'], {
        [style['sidebar-target-wrapper--collapsed']]: props.collapsed,
      })}
    >
      {props.collapsed ? <RiMenuLine /> : <RiMenu3Line />}
    </Button>
  );
};
