import cx from 'classnames';
import { AxiosError } from 'axios';
import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { Switch, message } from 'antd';
import { SwitchSize } from 'antd/es/switch';

import { fetcher } from '@leaa/dashboard/src/libs';
import { errorMsg } from '@leaa/dashboard/src/utils';
import { envConfig } from '@leaa/dashboard/src/configs';
import { IHttpError, IHttpRes } from '@leaa/dashboard/src/interfaces';

import style from './style.module.less';

interface IProps {
  apiPath: string;
  id: string;
  value?: number;
  size?: SwitchSize;
  onSuccessCallback?: () => void;
  className?: string;
}

export const TableColumnStatusSwitch = (props: IProps) => {
  const { t } = useTranslation();

  const [status, setStatus] = useState<boolean>(Boolean(props.value));
  const [loading, setLoadin] = useState(false);

  const onChange = (v: boolean) => {
    setLoadin(true);

    fetcher
      .put(`${envConfig.API_URL}/${envConfig.API_VERSION}/${props.apiPath}/${props.id}`, { status: Number(v) })
      .then((res: IHttpRes<{ status: number }>) => {
        setStatus(Boolean(res.data.data?.status));

        message.success(
          <span>
            {t('_comp:TableColumnStatusSwitch.updatedSuccessfully', { id: props.id })}
            <Switch checked={Boolean(res.data.data?.status)} size="small" className={style['tips-switch']} />
          </span>,
        );

        if (props.onSuccessCallback) props.onSuccessCallback();
      })
      .catch((err: AxiosError<IHttpError>) => errorMsg(err.response?.data?.message || err.message))
      .finally(() => setLoadin(false));
  };

  return (
    <div className={cx(style['table-column-status-switch-comp-wrapper'], props.className)}>
      <Switch checked={status} onChange={onChange} size={props.size} loading={loading} />
    </div>
  );
};
