-- Adminer 4.7.7 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `actions`;
CREATE TABLE `actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` enum('article','config','seed','playground','index','auth','user','permission','role','category','action','attachment','ax','authtoken','setting','tag','coupon','promo','product','address','division','export','zan','test','i18n') COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ONLY log guestToken',
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `diff` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `addresses`;
CREATE TABLE `addresses` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `province` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consignee` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip` int(11) NOT NULL DEFAULT '0',
  `phone` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `articles`;
CREATE TABLE `articles` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(220) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(220) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` int(11) NOT NULL DEFAULT '0',
  `released_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_1123ff6815c5b8fec0ba9fec37` (`slug`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `articles` (`id`, `created_at`, `updated_at`, `deleted_at`, `title`, `slug`, `user_id`, `description`, `content`, `status`, `released_at`) VALUES
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'2020-07-20 08:51:49',	'2020-07-20 08:53:57',	NULL,	'I fell in love with a tiny, 2 TB, ultra quiet SSD hard drive',	'i-fell-in-love-with-a-tiny-2-tb-ultra-quiet-ssd-hard-drive',	NULL,	NULL,	'\n<p class=\"gnt_ar_b_p\">Meanwhile, I dealt with my storage problem by consolidating media and moving them from drives to drives. It\'s under control now. I also put as many of the files as possible&nbsp; onto online backup.</p>\n<p class=\"gnt_ar_b_p\">One concern is how long this new external SSD + Jeff relationship will last. Hard drives don\'t live forever and eventually go bad, and SSD drives also suffer the same fate. A blog post by online backup service Backblaze says a good SSD drive should last <a href=\"https://www.backblaze.com/blog/how-reliable-are-ssds/\" target=\"_blank\" rel=\"noopener\" data-t-l=\"|inline|intext|n/a\" class=\"gnt_ar_b_a\">three to five years.</a></p>\n<p class=\"gnt_ar_b_p\">So it will be a short, but hopefully fruitful union. But since I backup everything twice, if not more, I look forward to reporting back to you in 2024 with tales of my new 10 TB, and ultra quiet SSD drive.</p>',	1,	NULL),
('7bfa9f5b-1c9a-420e-9f2c-628dda789a94',	'2020-07-20 08:51:49',	NULL,	NULL,	'iPhoneを「REC MOUNT+」でマウントしまくり!!!',	'iphonewo-rec-mount-demauntosimakuri',	NULL,	NULL,	'まあ、このテの製品としてはわりとよくあるシステムではある。が、REC MOUNT+の場合、けっこう定番的な製品で入手性が良く、デバイス用ケースやマウントのラインナップも幅広い。自転車向け、モーターサイクル向け、クルマ向けにランニング向け、さらには家庭内で使えるマウントなども用意されている。\n\nマウントシステムとして統一しやすく、各シーンでの流用が利く。例えばREC MOUNT+ケースに入れたiPhoneを、自転車からモーターサイクルへ、さらにクルマへと手軽に装着し直すことができるし、必要とあらばベルトに装着することも可能。\n\n',	1,	NULL),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'2020-07-20 08:51:49',	NULL,	NULL,	'TypeORM is an ORM that can run in NodeJS, Browser, Cordova, PhoneGap, Ionic, React Native, NativeScript, Expo, and Electron platforms and can be used with TypeScript and JavaScript (ES5, ES6, ES7, ES8).',	'typeorm-is-an-orm-that-can-run-in-nodejs-browser-cordova-phonegap-ionic-react-native-nativescript-expo-and-electron-platforms-and-can-be-used-with-typescript-and-javascript-es5-es6-es7-es8-.',	NULL,	NULL,	'TypeORM is an ORM that can run in NodeJS, Browser, Cordova, PhoneGap, Ionic, React Native, NativeScript, Expo, and Electron platforms and can be used with TypeScript and JavaScript (ES5, ES6, ES7, ES8). Its goal is to always support the latest JavaScript features and provide additional features that help you to develop any kind of application that uses databases - from small applications with a few tables to large scale enterprise applications with multiple databases.\n\nTypeORM supports both Active Record and Data Mapper patterns, unlike all other JavaScript ORMs currently in existence, which means you can write high quality, loosely coupled, scalable, maintainable applications the most productive way.\n\nTypeORM is highly influenced by other ORMs, such as Hibernate, Doctrine and Entity Framework.',	1,	NULL),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'2020-07-20 08:51:49',	NULL,	NULL,	'报道称三星正努力提升5nm EUV产能 高通骁龙875G芯片组或受影响',	'bao-dao-cheng-san-xing-zheng-nu-li-ti-sheng5nm-euv-chan-neng-gao-tong-xiao-long875g-xin-pian-zu-huo-shou-ying-xiang',	NULL,	NULL,	'DigiTimes 近日报道称，三星正在努力提升自家的 5nm EUV 产能。过去几年，这家韩国科技巨头一直在努力追赶台积电。为了抢到更多客户，三星已规划从 5nm 进阶至 3nm 工艺。遗憾的是，若该公司无法顺利提升 5nm EUV 产能，那高通未来旗舰芯片组（骁龙 875G SoC / 骁龙 X60 5G 基带）的发布也可能受到影响。',	1,	NULL),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'2020-07-20 08:51:49',	'2020-07-20 08:54:04',	NULL,	'Microsoft to launch cloud video game service, Project xCloud, in September',	'microsoft-to-launch-cloud-video-game-service-project-xcloud-in-september',	NULL,	NULL,	'N/A',	1,	NULL),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'2020-07-20 08:51:49',	NULL,	NULL,	'New Highly-Critical SAP Bug Could Let Attackers Take Over Corporate Servers',	'new-highly-critical-sap-bug-could-let-attackers-take-over-corporate-servers',	NULL,	NULL,	'<div class=\"articlebody clear cf\" id=\"articlebody\"><div dir=\"ltr\" style=\"text-align: left;\" trbidi=\"on\">\n<div class=\"separator\" style=\"clear: both; text-align: left;\">\n<a href=\"https://thehackernews.com/images/-z8Uzw7Wp2Zk/Xw1bORR-XAI/AAAAAAAAAjM/4WKXCZsAtEw0zA9nzsUj0BUhmpjsEtR6wCLcBGAsYHQ/s728-e100/sap.jpg\" imageanchor=\"1\" style=\"clear: left; float: left; margin-bottom: 15px; margin-right: 1em; margin-left: 0px;\"><img border=\"0\" data-original-height=\"380\" data-original-width=\"728\" src=\"https://thehackernews.com/images/-z8Uzw7Wp2Zk/Xw1bORR-XAI/AAAAAAAAAjM/4WKXCZsAtEw0zA9nzsUj0BUhmpjsEtR6wCLcBGAsYHQ/s728-e100/sap.jpg\"></a></div>\nSAP has patched a <a href=\"https://wiki.scn.sap.com/wiki/pages/viewpage.action?pageId=552599675\" target=\"_blank\">critical vulnerability</a> impacting the LM Configuration Wizard component in NetWeaver Application Server (AS) Java platform, allowing an unauthenticated attacker to take control of SAP applications.<br>\n<br>\nThe bug, dubbed RECON and tracked as <b>CVE-2020-6287</b>, is rated with a maximum CVSS score of 10 out of 10, potentially affecting over 40,000 SAP customers, according to cybersecurity firm Onapsis, which <a href=\"https://www.onapsis.com/recon-sap-cyber-security-vulnerability\" target=\"_blank\">uncovered the flaw</a>.<br>\n<div class=\"ad_two clear\" style=\"text-align: left;\"><center class=\"cf\"><div id=\"967ecfad-bf6b-429e-9a39-9770c8b7d188\" class=\"_ap_apex_ad\" max-height=\"290\" style=\"text-align: left;\"> <script> var adpushup = adpushup || {}; adpushup.que = adpushup.que || []; adpushup.que.push(function() { adpushup.triggerAd(\"967ecfad-bf6b-429e-9a39-9770c8b7d188\"); });</script></div></center></div><br>\n\"If successfully exploited, a remote, unauthenticated attacker can obtain unrestricted access to SAP systems through the creation of high-privileged users and the execution of arbitrary operating system commands with the privileges of the SAP service user account, which has unrestricted access to the SAP database and is able to perform application maintenance activities, such as shutting down federated SAP applications,\" the US Cybersecurity and Infrastructure Security Agency (CISA) said in an <a href=\"https://us-cert.cisa.gov/ncas/alerts/aa20-195a\" target=\"_blank\">advisory</a>.<br>\n<br>\n\"The confidentiality, integrity, and availability of the data and processes hosted by the SAP application are at risk by this vulnerability,\" it added.<br>\n<br>\nThe vulnerability is present by default in SAP applications running on top of SAP NetWeaver AS Java 7.3 and newer (up to SAP NetWeaver 7.5), putting several SAP business solutions at risk, including but not limited to SAP Enterprise Resource Planning, SAP Product Lifecycle Management, SAP Customer Relationship Management, SAP Supply Chain Management, SAP Business Intelligence, and SAP Enterprise Portal.<br>\n<br>\nAccording to Onapsis, RECON is caused due to a lack of authentication in the web component of the SAP NetWeaver AS for Java, thus granting an attacker to perform high-privileged activities on the susceptible SAP system.<br>\n<br>\n\"A remote, unauthenticated attacker can exploit this vulnerability through an HTTP interface, which is typically exposed to end users and, in many cases, exposed to the internet,\" CISA said.<br>\n<div class=\"ad_two clear\" style=\"text-align: left;\"><center class=\"cf\"><div id=\"8c2d7f94-a9c5-43b2-83a4-cdcf711ae05e\" class=\"_ap_apex_ad\" max-height=\"290\" style=\"text-align: left;\"> <script> var adpushup = adpushup || {}; adpushup.que = adpushup.que || []; adpushup.que.push(function() { adpushup.triggerAd(\"8c2d7f94-a9c5-43b2-83a4-cdcf711ae05e\"); }); </script> </div></center></div><br>\nBy exploiting the flaw to create a new SAP user with maximum privileges, the intruder can compromise SAP installations to execute arbitrary commands, such as modifying or extracting highly sensitive information as well as disrupting critical business processes.<br>\n<br>\nAlthough there\'s no evidence of any active exploitation of the vulnerability, CISA cautioned that the patches\' availability could make it easier for adversaries to reverse-engineer the flaw to create exploits and target unpatched systems.<br>\n<br>\nGiven the severity of RECON, it\'s recommended that organizations apply critical patches as soon as possible and scan SAP systems for all known vulnerabilities and analyze systems for malicious or excessive user authorizations.</div>\n<br>\n<div class=\"cf note-b\" style=\"text-align: left;\">Found this article interesting? Follow THN on <a href=\"https://www.facebook.com/thehackernews\" rel=\"noopener\" target=\"_blank\">Facebook</a>, <a href=\"https://twitter.com/thehackersnews\" rel=\"noopener\" target=\"_blank\">Twitter <i class=\"icon-font icon-twitter\"></i></a> and <a href=\"https://www.linkedin.com/company/thehackernews/\" rel=\"noopener\" target=\"_blank\">LinkedIn</a> to read more exclusive content we post.</div>\n</div>',	1,	NULL),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'2020-07-20 08:51:49',	NULL,	NULL,	'スマートホームサービス対応のガス警報器を発売、エンコアードジャパンと新コスモス電機',	'sumatohomusabisu-dui-yingnogasu-jing-bao-qiwo-fa-mai-enkoadoziyapanto-xinkosumosu-dian-ji',	NULL,	NULL,	'ソフトバンク子会社のエンコアードジャパンと新コスモス電機は、スマートホームサービスに対応したガス警報器「快適ウォッチ SMART（スマート） XW-735」を開発した。都市ガス向けのガス警報器となり、東邦ガスでは「みまもり警報器」として8月21日から、西部ガスでは「快適ウォッチ SMART」として9月1日から取り扱う。\n\nこれまでのガス警報器は、ガス漏れや一酸化炭素濃度の検出のための装置であった。新コスモス電機では、これに加えて熱中症や室内の乾燥を検知し、ユーザーに知らせる「快適ウォッチ」を発売した。今回、「快適ウォッチ」に、エンコアードジャパンのスマートホーム関連サービスを組み込み、スマートフォンアプリと連携したガス警報器を開発したという。\n\n今回のガス警報器には、ガス漏れ検知などの基本機能とリモートアラーム機能、簡易セキュリティ機能、熱中症予防機能、家族みまもり機能、帰宅確認機能などに対応する。\n\nガス漏れ検知、一酸化炭素検知、熱中症予防、乾燥予防機能は、警報器のセンサーで検知し、警報器本体からの通知とともに、設定したスマートフォンアプリに通知が届く。外出中や離れて暮らす家族の異常をすぐに確認できる。\n\nまた、付属するコネクトセンサーを利用して、スマートホームサービスを利用できる。\n\n玄関ドアにセンサーを取り付ければ簡易セキュリティ機能として、玄関ドアが開いたときにアプリから通知される。アプリから操作することで、警報音や威嚇するメッセージを再生することもできるという。\n\n離れて暮らす高齢者の部屋やトイレのドアにセンサーを取り付けると生活みまもり機能が利用できる。設定した時間以上ドアの開閉を検知できないとアプリから通知される。病気などで動けなくなったなどをいち早く確認できる。',	1,	NULL),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'2020-07-20 08:51:49',	NULL,	NULL,	'《集合啦！动物森友会》夏日新CM公开 夏日同游其乐融融！',	'ji-he-la-dong-wu-sen-you-hui-xia-ri-xincm-gong-kai-xia-ri-tong-you-qi-le-rong-rong',	NULL,	NULL,	'今日（7月20日），任天堂官方公开了《集合啦！动物森友会》两段夏日新CM，该作已经登陆任天堂Switch平台，夏天的免费更新资料第2弹将于8月上旬发布，一起来欣赏一下此次官方公开的新CM。',	1,	NULL),
('dfeb2f67-b56d-4d58-a0b6-2d897b901a64',	'2020-07-20 08:51:49',	NULL,	NULL,	'DualSense手柄上手体验，全新触觉反馈让你沉浸游戏世界',	'dualsense-shou-bing-shang-shou-ti-yan-quan-xin-chu-jue-fan-kui-rang-ni-chen-jin-you-xi-shi-jie',	NULL,	NULL,	'首先他提到了他认为 DualSense 最大的一点改变，是L2 及R2 按钮上的自动调整触发器，并说明这对游戏的影响是深远的。触觉回馈同样也是他认为DualSense 很值得一谈的点，并不像一般手柄的振动，全新升级的触觉回馈可以让玩家获得更高的沉浸体验。\n\n在用 DualSense 来游玩《Astro\'s Playroom》的时候，他也展示了 DualSense 的诸多不同特点。在诸多场景里，DualSense 都会透过其扬声器以及触觉回馈来带给玩家更深的带入感。',	1,	NULL),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'2020-07-20 08:51:49',	'2020-07-20 08:54:11',	NULL,	'仅有米粒大小！LG发布全球最小蓝牙模块，苹果有望采用',	'jin-you-mi-li-da-xiao-lg-fa-bu-quan-qiu-zui-xiao-lan-ya-mo-kuai-ping-guo-you-wang-cai-yong',	NULL,	NULL,	'<p>根据外媒最新报导，LG 集团下属尖端物料和元件制造商 LG Innotek 共同宣布，他们开发出了世界最小蓝牙模组。据悉，该模组仅仅只有 6x4 mm大小，大概是一粒米的大小，比之前日本厂商保持的最小蓝牙模组记录缩小了1/4。\n\n虽然是世界最小蓝牙模组，但是却“麻雀虽小五脏俱全”。该模组以高精度、高集成技术为基础，在一粒米的空间内塞进了通信芯片、电阻器、电感等 20 多个元件，不仅仅性能全面，甚至还要比一些提体积更大的蓝牙模组性能提升 30%，可在复杂、苛刻的环境中进行收发数据。除此之外，该模组与 LG Innotek 的「天线集成」技术进行了集成，将蓝牙天线也囊括在内，可通过最大化天线面积提升通信性能。\n\n\n\n值得一提的是，LG Innotek 是苹果的供应商之一，如果量产顺利的话，或许苹果会考虑应用在未来的iPhone、AirPods、Apple Watch 等产品中。</p>',	1,	NULL),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'2020-07-20 08:51:49',	'2020-07-20 08:54:17',	NULL,	'グーグル、新しい「エモい」絵文字を今秋リリース――Android 11で利用可能へ',	'guguru-xinsii-emoi-hui-wen-ziwo-jin-qiuririsu----android-11de-li-yong-ke-nenghe',	NULL,	NULL,	'<div class=\"contents-section contents-section-layer-1\" id=\"contents-section-1\"><div class=\"image-wrap frame-border-none\"><div class=\"inner\"><div class=\"row\"><div class=\"column\" style=\"width:480px;\"><div class=\"img-wrap-h\" style=\"width:480px;height:200px;\"><div class=\"img-wrap-w\"><a href=\"/img/ktw/docs/1266/517/html/cont01.jpg.html\" class=\"resource\" rel=\"nofollow\"><img src=\"/img/ktw/docs/1266/517/cont01_l.jpg\" class=\"resource\" style=\"width:480px;height:200px;\" id=\"cont01_l.jpg\"></a></div></div></div></div></div></div><p> グーグルは、嬉し泣きなどの表現や多様性を取り入れた新しい絵文字を、今年秋ごろにリリースする。今秋リリースのAndroid 11でも利用できる予定。 </p><p> グーグルは、昨年に絵文字の標準とガイドラインを定めるUcode コンソーシアムに新しい絵文字の提案を行っており、提案した絵文字が公開される。 </p><p> 新しく公開される絵文字には、多様な表現のほか、ベールの男性やタキシードの女性、赤ちゃんにミルクを飲ませる男性や女性など、多様性を受け入れたものも含まれる。 </p><div class=\"image-wrap frame-border-none\"><div class=\"inner\"><div class=\"row\"><div class=\"column\" style=\"width:512px;\"><div class=\"img-wrap-h\" style=\"width:512px;height:186px;\"><div class=\"img-wrap-w\"><img src=\"/img/watch/parts/icon/loading.png\" class=\"resource\" style=\"width:512px;height:186px;\" id=\"cont02.gif\" ajax=\"/img/ktw/docs/1266/517/cont02.gif\"></div></div></div></div></div></div><p> このほか、メキシコなどの子供のお祭りに使われる人形「ピニャータ」やホッキョクグマなどの新しい動物たちも登場する。食事に関するものでは、タピオカミルクティーやティーポットなどが追加される。 </p><div class=\"image-wrap frame-border-none\"><div class=\"inner\"><div class=\"row\"><div class=\"column\" style=\"width:480px;\"><div class=\"img-wrap-h\" style=\"width:480px;height:174px;\"><div class=\"img-wrap-w\"><a href=\"/img/ktw/docs/1266/517/html/cont03.gif.html\" class=\"resource\" rel=\"nofollow\"><img src=\"/img/watch/parts/icon/loading.png\" class=\"resource\" style=\"width:480px;height:174px;\" id=\"cont03_l.gif\" ajax=\"/img/ktw/docs/1266/517/cont03_l.gif\"></a></div></div></div></div></div></div><p> また、既存の絵文字見直され、表現の修正やダークモード向けのデザインも公開する。動物の絵文字は、モントレーベイ水族館やビクトリア昆虫館の専門家と協力し、より詳細に表現している。 </p><div class=\"image-wrap\"><div class=\"inner\"><div class=\"row\"><div class=\"column\" style=\"width:512px;\"><div class=\"img-wrap-h\" style=\"width:512px;height:186px;\"><div class=\"img-wrap-w\"><img src=\"/img/watch/parts/icon/loading.png\" class=\"resource\" style=\"width:512px;height:186px;\" id=\"cont04.gif\" ajax=\"/img/ktw/docs/1266/517/cont04.gif\"></div></div></div></div></div></div><p> このほか、温かみのあるキャラクターなどが追加される。 </p><div class=\"image-wrap frame-border-none\"><div class=\"inner\"><div class=\"row\"><div class=\"column\" style=\"width:400px;\"><div class=\"img-wrap-h\" style=\"width:400px;height:300px;\"><div class=\"img-wrap-w\"><a href=\"/img/ktw/docs/1266/517/html/cont05.gif.html\" class=\"resource\" rel=\"nofollow\"><img src=\"/img/watch/parts/icon/loading.png\" class=\"resource\" style=\"width:400px;height:300px;\" id=\"cont05_l.gif\" ajax=\"/img/ktw/docs/1266/517/cont05_l.gif\"></a></div></div></div></div></div></div></div>',	1,	NULL);

DROP TABLE IF EXISTS `articles_categories_categories`;
CREATE TABLE `articles_categories_categories` (
  `articlesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categoriesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`articlesId`,`categoriesId`),
  KEY `IDX_9c28108e84d0948e9567d29e40` (`articlesId`),
  KEY `IDX_d69c4c523152c22941ed15738b` (`categoriesId`),
  CONSTRAINT `FK_9c28108e84d0948e9567d29e400` FOREIGN KEY (`articlesId`) REFERENCES `articles` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_d69c4c523152c22941ed15738ba` FOREIGN KEY (`categoriesId`) REFERENCES `categories` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `articles_categories_categories` (`articlesId`, `categoriesId`) VALUES
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'4722bf4f-8a85-40b8-b577-e1de1a3dd2ec'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'4722bf4f-8a85-40b8-b577-e1de1a3dd2ec'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'd7420b26-7116-4673-899d-b94972676a57'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'4722bf4f-8a85-40b8-b577-e1de1a3dd2ec');

DROP TABLE IF EXISTS `articles_tags_tags`;
CREATE TABLE `articles_tags_tags` (
  `articlesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tagsId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`articlesId`,`tagsId`),
  KEY `IDX_0adb8d108330d74e4a7f7d29de` (`articlesId`),
  KEY `IDX_dcd523dc6473a35e6cb0cbf9f2` (`tagsId`),
  CONSTRAINT `FK_0adb8d108330d74e4a7f7d29de2` FOREIGN KEY (`articlesId`) REFERENCES `articles` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_dcd523dc6473a35e6cb0cbf9f2d` FOREIGN KEY (`tagsId`) REFERENCES `tags` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `articles_tags_tags` (`articlesId`, `tagsId`) VALUES
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'23d1354e-2dfe-4d66-b836-8240a2407569'),
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'5c7cae77-e8cf-4917-9606-770c5b343cff'),
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'6d7bff4b-4bed-4419-9a4b-82c5edb9dc12'),
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'a0327454-3490-4d3c-92ab-02b07f023085'),
('0e95ea95-c45d-4bb8-baf0-db1336f6a7ed',	'ff321bde-e4b3-4ac5-a85a-f6dd3a925dd9'),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'424483a6-dfb1-4f4e-97c3-bdd6b9ae1b16'),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'6b1f77c0-4b19-4ab8-b6fb-a651c8ea100c'),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'81e1a70f-027a-477f-927f-ec7546578f7e'),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'9dd01cd3-85cc-46b4-bfcc-9cf84b8dea7a'),
('7ce247a7-fa82-441a-88b5-6111a57a5f0a',	'a687cd5e-e234-40ed-99e7-7e2eb6dec41e'),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'24b9c3f0-f35f-49b5-91d2-9e97b2998cbc'),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'69e9b9e6-3776-4ae6-befd-e534d3cc0562'),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'728d0ea4-bb14-4508-bc0c-b5e7bd364ea3'),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'771e7f0d-a933-4370-9e71-952ab72412af'),
('7ce2c144-da18-4ae4-968a-501e15161cce',	'e789d9c1-0b57-4c50-aebe-e8c1710458f7'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'565461de-9755-4d24-80e5-5c8a673d577c'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'670791b5-ee9a-4e3a-93d3-72aa4c358919'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'939f97fa-edda-492a-94c6-35dd3aa52c9c'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'c690aa39-6051-4799-9e54-2824eeb768e0'),
('8b7fec05-85fb-4cc8-ab4d-8e4bd59cbd89',	'fa1ae95b-7a33-4026-b970-ace6ef3ab1ce'),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'13d38c40-778d-41fe-b9d9-8360805f1ae1'),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'32bd822a-c459-4648-a6a1-e317d078aa8b'),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'78582fc0-5d6c-4699-976d-75ed35d263f1'),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'a6d5ae72-3112-4fe9-8cbb-5d4b8460e5a6'),
('adf06863-029e-41e7-959f-2ab07d5d3b2a',	'd92f8853-4911-4f90-a50e-1134bb454f0e'),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'39bc641d-2809-46ed-a51f-4a2c24090acf'),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'498f1a4b-a4bc-4896-8d50-ff5aea0d4648'),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'4bf13e6f-d38e-451d-bcf7-5bf550bfbd30'),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'bcbd3d00-0795-4204-a206-7260dc775a2a'),
('d1be3e76-b594-4015-a224-cce3e4cb0d61',	'eab35469-6616-4a2e-91d1-1eccab36d0cf'),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'05e7e3de-b215-4f05-aa4a-e6dfd0704156'),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'0bcf36c7-49ba-4920-947d-a0a64a1366ba'),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'8aa8b0af-c24b-40a8-a318-bd9ca31cf140'),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'aa2f0c50-128e-47dc-b0f9-a4615b607c8c'),
('da400f9e-eeb3-485a-94fd-a4d6ff2a19da',	'bcbf1e94-ffa8-46e4-a99f-3ecc539ae0a8'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'0b4413b1-e710-4a1f-9485-66d133637d85'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'97475809-cb45-41c1-8870-9eb3047e5830'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'9f685082-c208-4125-af6a-9c4d2ef5a8cf'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'c26d8a04-06f7-41fe-a683-13918ca2adf7'),
('e08b671a-6bb2-4b76-9218-6ca6b86af874',	'e1855436-2f8b-40c6-9c54-84c91f999057'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'2460e58f-f7ce-400c-b4b3-56470438f506'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'35e23535-93cf-4db2-8c24-da629c5d519f'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'4b56b22f-aa45-49f6-86c9-f9f0cd22c943'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'7d0ca0d5-d487-4502-a4e7-3c85954288a9'),
('e0b13563-2f13-4314-8aec-1d2641af95ac',	'e1367a2e-09dc-43b9-91ae-51b1ed21137d');

DROP TABLE IF EXISTS `attachments`;
CREATE TABLE `attachments` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'e.g. product',
  `type_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'e.g. gallery',
  `type_platform` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'e.g. mb/pc',
  `ext` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL DEFAULT '0',
  `height` int(11) NOT NULL DEFAULT '0',
  `size` int(11) NOT NULL DEFAULT '0',
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'support multi-urls, e.g.: https://a.com/a.jpg|https://a.com/a_2x.jpg',
  `at2x` int(11) NOT NULL DEFAULT '0',
  `in_local` int(11) NOT NULL DEFAULT '0',
  `in_oss` int(11) NOT NULL DEFAULT '0',
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `attachments` (`id`, `created_at`, `updated_at`, `deleted_at`, `title`, `alt`, `type`, `filename`, `description`, `link`, `module_id`, `module_name`, `type_name`, `type_platform`, `ext`, `width`, `height`, `size`, `path`, `external_url`, `at2x`, `in_local`, `in_oss`, `user_id`, `sort`, `status`) VALUES
('1178c6ab-cdb9-47cb-a7bb-27463768d9cc',	'2020-07-20 08:51:49',	NULL,	NULL,	'002',	'002',	'image',	'6db325c5-9c95-4952-94eb-eef33b2e0802.png',	NULL,	NULL,	'1',	'ax',	'gallery',	'mb',	'.png',	1100,	500,	151768,	'/attachments/2019/08/6db325c5-9c95-4952-94eb-eef33b2e08a7.jpg',	'https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/002.png|https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/002@2x.png',	1,	1,	0,	NULL,	2,	1),
('4fa6ea8f-e1c5-464c-9f0b-ae2b4d0bc7c7',	'2020-07-20 08:51:49',	NULL,	NULL,	'001',	'001',	'image',	'6db325c5-9c95-4952-94eb-eef33b2e0801.png',	NULL,	NULL,	'1',	'ax',	'gallery',	'mb',	'.png',	1100,	500,	151768,	'/attachments/2019/08/6db325c5-9c95-4952-94eb-eef33b2e08a7.jpg',	'https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/001.png|https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/001@2x.png',	1,	1,	0,	NULL,	1,	1),
('c904038a-cad3-4792-84f3-d0e0ec71efae',	'2020-07-20 08:51:49',	NULL,	NULL,	'003',	'003',	'image',	'6db325c5-9c95-4952-94eb-eef33b2e0803.png',	NULL,	NULL,	'1',	'ax',	'gallery',	'mb',	'.png',	1100,	500,	151768,	'/attachments/2019/08/6db325c5-9c95-4952-94eb-eef33b2e08a7.jpg',	'https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/003.png|https://code.aliyun.com/solidzoro/ipfs/raw/master/statics/images/banners/003@2x.png',	1,	1,	0,	NULL,	3,	1);

DROP TABLE IF EXISTS `auths`;
CREATE TABLE `auths` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `open_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `union_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` enum('wechat','miniprogram','weibo','github') COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ticket_at` datetime DEFAULT NULL,
  `access_token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh_token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nickname` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sex` int(11) NOT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `province` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_95cadbede93c900dcdec3f2110` (`open_id`),
  KEY `open_id` (`open_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `axs`;
CREATE TABLE `axs` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_db7126486164fc0a5d15de118c` (`title`),
  UNIQUE KEY `IDX_c69cb452eea9e3dbaabd35f4dd` (`slug`),
  KEY `title` (`title`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `axs` (`id`, `created_at`, `updated_at`, `deleted_at`, `title`, `slug`, `description`, `status`) VALUES
('b71b62ec-2186-4e74-ab0b-09d278459cf5',	'2020-07-20 08:55:14',	NULL,	NULL,	'首页 Banner',	'index_banner',	NULL,	1);

DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `nsleft` int(11) NOT NULL DEFAULT '1',
  `nsright` int(11) NOT NULL DEFAULT '2',
  `parentId` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_8b0be371d28245da6e4f4b6187` (`name`),
  UNIQUE KEY `IDX_420d9f679d41281f282f5bc7d0` (`slug`),
  KEY `name` (`name`),
  KEY `slug` (`slug`),
  KEY `FK_9a6f051e66982b5f0318981bcaa` (`parentId`),
  CONSTRAINT `FK_9a6f051e66982b5f0318981bcaa` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `categories` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `slug`, `parent_id`, `description`, `nsleft`, `nsright`, `parentId`) VALUES
('0a91ca97-988c-4079-9400-cbac538454cf',	'2020-07-20 08:51:49',	NULL,	NULL,	'FILCO',	'filco',	'6e0ead2d-bfe4-4aa8-930d-7deb6d37da5e',	NULL,	14,	15,	'6e0ead2d-bfe4-4aa8-930d-7deb6d37da5e'),
('272ef527-1294-45a2-a0ad-65fcc5bfbbe0',	'2020-07-20 08:51:48',	NULL,	NULL,	'Digit',	'digit',	'a5c59fe5-cb0e-46f5-9297-1f4f2d3ad379',	NULL,	8,	9,	'a5c59fe5-cb0e-46f5-9297-1f4f2d3ad379'),
('4722bf4f-8a85-40b8-b577-e1de1a3dd2ec',	'2020-07-20 08:51:48',	NULL,	NULL,	'Frontend',	'frontend',	'a50e099e-92f1-40c0-97b9-ec2ed0648d42',	NULL,	2,	3,	'a50e099e-92f1-40c0-97b9-ec2ed0648d42'),
('6e0ead2d-bfe4-4aa8-930d-7deb6d37da5e',	'2020-07-20 08:51:48',	'2020-07-20 08:51:49',	NULL,	'Brands',	'brands',	NULL,	'品牌分类',	1,	16,	NULL),
('71b4fcc6-3943-4073-878b-81d95b152b75',	'2020-07-20 08:51:48',	NULL,	NULL,	'Backend',	'backend',	'a50e099e-92f1-40c0-97b9-ec2ed0648d42',	NULL,	4,	5,	'a50e099e-92f1-40c0-97b9-ec2ed0648d42'),
('8a7d5434-7de9-4c61-a52b-5c2d789a9f4b',	'2020-07-20 08:51:49',	NULL,	NULL,	'Apple',	'apple',	'6e0ead2d-bfe4-4aa8-930d-7deb6d37da5e',	NULL,	12,	13,	'6e0ead2d-bfe4-4aa8-930d-7deb6d37da5e'),
('a50e099e-92f1-40c0-97b9-ec2ed0648d42',	'2020-07-20 08:51:48',	'2020-07-20 08:51:49',	NULL,	'Articles',	'articles',	NULL,	'文章分类',	1,	16,	NULL),
('a5c59fe5-cb0e-46f5-9297-1f4f2d3ad379',	'2020-07-20 08:51:48',	'2020-07-20 08:51:49',	NULL,	'Products',	'products',	NULL,	'商品分类',	1,	16,	NULL),
('af2e71b9-19cd-4f85-9531-2d694f0ea1d5',	'2020-07-20 08:51:48',	NULL,	NULL,	'Home Appliance',	'home-appliance',	'a5c59fe5-cb0e-46f5-9297-1f4f2d3ad379',	NULL,	10,	11,	'a5c59fe5-cb0e-46f5-9297-1f4f2d3ad379'),
('d7420b26-7116-4673-899d-b94972676a57',	'2020-07-20 08:51:48',	NULL,	NULL,	'Help',	'help',	'a50e099e-92f1-40c0-97b9-ec2ed0648d42',	NULL,	6,	7,	'a50e099e-92f1-40c0-97b9-ec2ed0648d42');

DROP TABLE IF EXISTS `divisions`;
CREATE TABLE `divisions` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `code` int(11) NOT NULL,
  `province_code` int(11) DEFAULT NULL,
  `city_code` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_b96faa3f412978357707758c83` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_48ce552495d14eae9b187bb671` (`name`),
  UNIQUE KEY `IDX_d090ad82a0e97ce764c06c7b31` (`slug`),
  KEY `name` (`name`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `permissions` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `slug`) VALUES
('009210e9-c9f0-4462-8e1c-3db88d50d02a',	'2020-07-20 08:51:44',	NULL,	NULL,	'User List Read',	'user.list-read'),
('020cdeef-de66-47e5-8cb7-d81fa9720632',	'2020-07-20 08:51:46',	NULL,	NULL,	'Division List Read',	'division.list-read'),
('0b9d4cba-80b4-4507-94f4-59d98b0bac24',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role Item Read',	'role.item-read'),
('0d4e0cbc-f5c9-44c8-acc0-3a719decfb38',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment Item Create',	'attachment.item-create'),
('0d56f44d-77d9-4d61-8cbd-5dcd7ecf6011',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad Item Create',	'ax.item-create'),
('0f0a8e90-d8e3-4571-97b6-8712515f4980',	'2020-07-20 08:51:45',	NULL,	NULL,	'Tag Item Read',	'tag.item-read'),
('0f148eef-d4ad-44db-92e2-0a6fff35eac4',	'2020-07-20 08:51:46',	NULL,	NULL,	'Oauth Item Create',	'oauth.item-create'),
('10b2d4fa-b76c-4b42-a195-194314d914ea',	'2020-07-20 08:51:44',	NULL,	NULL,	'Lab',	'lab.root'),
('15bf1782-598c-43d4-8b9a-0f1270ffa480',	'2020-07-20 08:51:45',	NULL,	NULL,	'Tag Item Create',	'tag.item-create'),
('18b82201-1d22-44e7-be8c-1fad4fccd3d8',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad Item Update',	'ax.item-update'),
('1b1f99b3-9740-43fe-85cc-d3bb8f5dccab',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission Item Delete',	'permission.item-delete'),
('1b4044fc-a441-4358-a915-b2edf7cedb9a',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Redeem (To Any User)',	'coupon.item-redeem--to-all-user-id'),
('1cd02616-4b95-4284-8801-f49b547266ee',	'2020-07-20 08:51:44',	NULL,	NULL,	'User List Read (All User Id)',	'user.list-read--all-user-id'),
('1d479484-1624-4441-a09d-ff24fbb56359',	'2020-07-20 08:51:44',	NULL,	NULL,	'User Item Create',	'user.item-create'),
('201a2ae0-6892-4b55-b1fc-6cd71440decf',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment List Read (All Status)',	'attachment.list-read--all-status'),
('20a491da-487b-4c7f-80e0-62ba2e7098d1',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission Item Read (All User Id)',	'permission.item-read--all-user-id'),
('20f86bff-22ef-4abd-b330-029da0b8f2b6',	'2020-07-20 08:51:44',	NULL,	NULL,	'User List Read (All Status)',	'user.list-read--all-status'),
('240511ea-7008-43ee-9440-a09213e8bec5',	'2020-07-20 08:51:46',	NULL,	NULL,	'Action List Read',	'action.list-read'),
('25e4927a-d93c-40c8-a87d-20575c8f231c',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan Item User Delete',	'zan.item-user-delete'),
('261bd6ae-8577-41e5-9992-11b2951a5bd8',	'2020-07-20 08:51:44',	NULL,	NULL,	'User Item Update',	'user.item-update'),
('2960029c-bc4c-4d1a-a9b6-538ff4c89c6c',	'2020-07-20 08:51:46',	NULL,	NULL,	'Oauth Item Delete',	'oauth.item-delete'),
('3024fd24-f806-4aba-b270-ba9645c1039b',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting Item Update',	'setting.item-update'),
('330fc079-843b-4ace-9b03-55ce96bda820',	'2020-07-20 08:51:45',	NULL,	NULL,	'User Item Delete',	'user.item-delete'),
('33740d5a-c7c7-4e7f-b8bc-fd552bcf3ac9',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting Item Read (Private)',	'setting.item-read--private'),
('33afa1a6-7ee9-445c-90cb-ddbee6bc84e4',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Read (All User Id)',	'coupon.item-read--all-user-id'),
('34724c52-a0b9-43a3-ad50-0328e9c265f3',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article List Read (All Status)',	'article.list-read--all-status'),
('34ec632d-fc94-4cb2-ae22-051861ab5a56',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article List Read (All User Id)',	'article.list-read--all-user-id'),
('35b7cc35-2ad7-4b41-9ccb-f86f459534e5',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role Item Delete',	'role.item-delete'),
('35f341a0-23b0-4efa-917d-9b6e3561be01',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting List Read',	'setting.list-read'),
('362860a2-ee14-43fd-bd35-f28c18d441d7',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission Item Create',	'permission.item-create'),
('3aa1dae2-981d-4bd5-9cae-8705e4fd313d',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product Item Delete',	'product.item-delete'),
('3e35bd75-e3d5-44c6-8f38-a0dbb99533b2',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan Item Update',	'zan.item-update'),
('3ebac69e-3cb8-45d1-81a7-2effcb0135c2',	'2020-07-20 08:51:46',	NULL,	NULL,	'Division Item Read',	'division.item-read'),
('416a1d0f-217d-4dce-b1c2-c25da766db10',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission List Read',	'permission.list-read'),
('45aa41bb-4eec-4d7c-b822-fb3580e77def',	'2020-07-20 08:51:44',	NULL,	NULL,	'User Item Read (All User Id)',	'user.item-read--all-user-id'),
('46c544c5-832f-4fd0-af26-3a689675188f',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan Item Read',	'zan.item-read'),
('4c2c97fe-3886-4a28-adb1-9b1091b3dca8',	'2020-07-20 08:51:45',	NULL,	NULL,	'Category Item Create',	'category.item-create'),
('4c8c3da1-78fe-48df-933c-e2206964ab5b',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Read',	'promo.item-read'),
('4d787377-2987-4168-b205-2ea1a499b9eb',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address Item Read (All Status)',	'address.item-read--all-users'),
('5218ed0b-eecf-4760-8eba-9be2dfc4c9f3',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Create',	'coupon.item-create'),
('55217c09-bf76-44a9-8753-d3c9b1b4f86d',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Read (All User Id)',	'article.item-read--all-user-id'),
('58bffea5-8854-4c27-8a47-ecf68e62f5ad',	'2020-07-20 08:51:44',	NULL,	NULL,	'User Item Read',	'user.item-read'),
('5fe48b63-197d-4c04-825c-22b50799910f',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission List Read (All User Id)',	'permission.list-read--all-user-id'),
('616da99a-d61b-4b02-a2bc-0d2c3677ee55',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Delete',	'promo.item-delete'),
('64ed3ac2-6972-44a3-b95d-0547719d7d74',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Update',	'promo.item-update'),
('668b4dca-57bf-4f73-b3ac-2446bea201ae',	'2020-07-20 08:51:46',	NULL,	NULL,	'Division Item Delete',	'division.item-delete'),
('69426c5a-09f7-4681-b9d8-65d0fd71b259',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Read',	'article.item-read'),
('6af40bed-4357-41f1-99bb-364f0536646f',	'2020-07-20 08:51:44',	NULL,	NULL,	'Test',	'test.root'),
('6b423730-ec46-4fc3-8f08-ee2cc043c3aa',	'2020-07-20 08:51:46',	NULL,	NULL,	'Division Item Create',	'division.item-create'),
('6e64016a-f6b8-4944-b55f-0068a8409cc9',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Redeem',	'promo.item-redeem'),
('72c75a12-fd79-42f1-89bf-da92062003ae',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Create',	'promo.item-create'),
('73745a7a-8ff1-4160-879d-882ed3a1723d',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting List Read (Private)',	'setting.list-read--private'),
('75f193ac-a138-4598-bb17-d05ac08c68a2',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role Item Read (All User Id)',	'role.item-read--all-user-id'),
('7702a960-b002-44b8-adb8-2239b8f9d383',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address Item Create',	'address.item-create'),
('78231e07-cedb-4006-a968-bc18b249ed7f',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address List Read (All Users)',	'address.list-read--all-users'),
('78aac9cb-d74c-45e7-a880-8a28c8c3290b',	'2020-07-20 08:51:46',	NULL,	NULL,	'Action Item Delete',	'action.item-delete'),
('7a2c778f-15b9-45ab-9478-16dea10eab12',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Update',	'coupon.item-update'),
('80b5c438-130e-4cc6-a083-5090218aac2b',	'2020-07-20 08:51:46',	NULL,	NULL,	'Auth List Read',	'auth.list-read'),
('810ceaa1-fe02-4aa0-87e2-e66ec2b4cbd4',	'2020-07-20 08:51:45',	NULL,	NULL,	'Category Item Delete',	'category.item-delete'),
('875732f8-f9ff-4f58-b3ca-af5d69a0602b',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Create',	'article.item-create'),
('88c570c1-9b8a-4676-9948-6438f9f38eac',	'2020-07-20 08:51:45',	NULL,	NULL,	'Promo List Read',	'promo.list-read'),
('8b2c7793-65e4-4a33-be9c-7baa30898e7e',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product List Read (All Status)',	'product.list-read--all-status'),
('8b4be73e-8c54-49b0-895f-73ad824438d4',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon List Read (All Status)',	'coupon.list-read--all-status'),
('8eae12e2-ebda-46be-ae29-9df77b9fa103',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address List Read',	'address.list-read'),
('92a4d7ec-7a16-4083-b43d-fd8c0fc88135',	'2020-07-20 08:51:45',	NULL,	NULL,	'Category Item Read',	'category.item-read'),
('9474a50c-5acf-4b00-a376-c3075dd2deac',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product Item Create',	'product.item-create'),
('96a59f56-c1ae-4617-95c9-7607f1bc4347',	'2020-07-20 08:51:45',	NULL,	NULL,	'Category Item Update',	'category.item-update'),
('97e5ac9d-90ed-4e61-90a8-2d9cd9a43131',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product Item Read (All Status)',	'product.item-read--all-status'),
('98978f85-a8c9-4346-8747-c1b987adbc69',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon List Read',	'coupon.list-read'),
('98bdd687-f9e6-485d-b237-8b384f26e9d3',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment Item Delete',	'attachment.item-delete'),
('9a875b2c-fbc6-49c4-a3ad-2765228832fb',	'2020-07-20 08:51:46',	NULL,	NULL,	'Oauth List Read',	'oauth.list-read'),
('9bd6ed93-ea99-47e6-be52-e8dcd9731b48',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment Item Update',	'attachment.item-update'),
('a25cc19d-5cdc-444b-829c-d5624d2da5d3',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Delete',	'coupon.item-delete'),
('a428e1f7-a005-4103-89b3-c908d8162d2c',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Read',	'coupon.item-read'),
('a8368e54-a1fe-46d1-8533-5fd7e5cc6455',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address Item Delete',	'address.item-delete'),
('a9dd8d53-c56d-4f72-9119-ba634611da5f',	'2020-07-20 08:51:46',	NULL,	NULL,	'Action Item Create',	'action.item-create'),
('aa8e6b3d-c74e-4d18-9ff4-b69871f08823',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Read (All Status)',	'promo.item-read--all-status'),
('ae23bf7f-a6d3-4888-8028-605557789aaa',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product List Read',	'product.list-read'),
('b077f768-3d0f-40d4-8d9c-7b9e8cbec5c8',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment Item Read (All Status)',	'attachment.item-read--all-status'),
('b35e7c7b-aa8d-4139-8d73-493c33e098dc',	'2020-07-20 08:51:45',	NULL,	NULL,	'Tag List Read',	'tag.list-read'),
('b609109a-a9dc-435e-b587-a3a047802424',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment List Read',	'attachment.list-read'),
('b954688e-b8f6-42c4-9ac4-84f52ec3f980',	'2020-07-20 08:51:46',	NULL,	NULL,	'Promo Item Redeem (To Any User)',	'promo.item-redeem--to-all-user-id'),
('ba473a31-7355-4383-b295-2250fa65eeb4',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role List Read',	'role.list-read'),
('bd5ed7a9-bd3d-4373-99f2-8aaee740c91f',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Redeem',	'coupon.item-redeem'),
('c068a172-6b2e-40fc-98b0-9ac06e6c6169',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product Item Read',	'product.item-read'),
('c0965905-b7bb-4d64-92a8-033671450fe8',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan Item Create',	'zan.item-create'),
('c2f9bd6d-6602-412f-9ea2-c4733b0dec4c',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad Item Delete',	'ax.item-delete'),
('c4752d31-9306-4901-94a6-328d9e9699e7',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address Item Read',	'address.item-read'),
('c485222c-fe81-4435-a599-3f016e3a6b42',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad Item Read (All Status)',	'ax.item-read--all-status'),
('c6534b36-dc4f-4795-ac9f-29c42e7f2b10',	'2020-07-20 08:51:44',	NULL,	NULL,	'User Item Read (All Status)',	'user.item-read--all-status'),
('c8a427a8-e464-4ee9-a4c6-8c4688d133bc',	'2020-07-20 08:51:46',	NULL,	NULL,	'Action Item Read',	'action.item-read'),
('c9f10729-3726-44f2-87b6-bffa3dfd3f44',	'2020-07-20 08:51:45',	NULL,	NULL,	'Promo List Read (All Status)',	'promo.list-read--all-status'),
('ce8cf138-0e3a-4b66-ad90-6d61254c0629',	'2020-07-20 08:51:45',	NULL,	NULL,	'Tag Item Update',	'tag.item-update'),
('cf7772fc-3720-4923-868c-1802ca702f68',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission Item Update',	'permission.item-update'),
('cffcfa93-fddc-4eb0-a300-af420b2ee058',	'2020-07-20 08:51:46',	NULL,	NULL,	'Oauth Item Read',	'oauth.item-read'),
('d0879c2d-e1dc-4310-a684-66be422466e7',	'2020-07-20 08:51:45',	NULL,	NULL,	'Attachment Item Read',	'attachment.item-read'),
('d0b88f93-23fd-4e84-bb73-e23f95cfc2ea',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role Item Update',	'role.item-update'),
('d3f1357d-eb27-424c-a6d8-6f00b61ad951',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Read (All Status)',	'article.item-read--all-status'),
('d5555c2f-838e-4574-bf1c-34291a735371',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role List Read (All User Id)',	'role.list-read--all-user-id'),
('d639b068-9a0f-43ed-827d-4cfae2ad6249',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article List Read',	'article.list-read'),
('da143af7-b568-44f3-9d66-bb5eb57a1bec',	'2020-07-20 08:51:46',	NULL,	NULL,	'Address Item Update',	'address.item-update'),
('dc755239-4b2c-4eb6-84b6-497a6943c579',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad List Read',	'ax.list-read'),
('e0050de8-6e18-45ef-b8a7-fb38b242942b',	'2020-07-20 08:51:44',	NULL,	NULL,	'Playground',	'playground.root'),
('e125cda0-4565-4b24-850f-ee2ebeae1b9a',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan List Read',	'zan.list-read'),
('e2bc6d9b-b1fb-4b5e-ac3f-e14e7b7d0c06',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon List Read (All User Id)',	'coupon.list-read--all-user-id'),
('e3f17729-0791-4577-8948-c28c98fff49b',	'2020-07-20 08:51:46',	NULL,	NULL,	'Product Item Update',	'product.item-update'),
('e5013b98-9926-44ca-8672-85b7b92b5692',	'2020-07-20 08:51:45',	NULL,	NULL,	'Coupon Item Read (All Status)',	'coupon.item-read--all-status'),
('e7367f7a-505d-4632-847b-bf090ba00318',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting Item Create',	'setting.item-create'),
('e7c3f322-4eec-4d96-ae8b-3cc48eaf6efd',	'2020-07-20 08:51:46',	NULL,	NULL,	'Division Item Update',	'division.item-update'),
('eba88f16-2ce3-46fc-b6e7-15e422c9795b',	'2020-07-20 08:51:46',	NULL,	NULL,	'Zan Item Delete',	'zan.item-delete'),
('ec9b443a-1c8c-44ed-b539-a69dc5768b17',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad Item Read',	'ax.item-read'),
('eec092af-e0af-4ebe-9ad0-e9dbde4005ae',	'2020-07-20 08:51:45',	NULL,	NULL,	'Permission Item Read',	'permission.item-read'),
('f2ff3955-eecd-46e6-9b20-af958e33eb70',	'2020-07-20 08:51:45',	NULL,	NULL,	'Role Item Create',	'role.item-create'),
('f5e75795-ea91-4770-a315-d3f5448351c2',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Delete',	'article.item-delete'),
('f77141f4-abb7-4340-a4c7-7859c03cc75c',	'2020-07-20 08:51:45',	NULL,	NULL,	'Ad List Read (All Status)',	'ax.list-read--all-status'),
('f80475d7-45c1-4413-bd52-e429448a65af',	'2020-07-20 08:51:45',	NULL,	NULL,	'Article Item Update',	'article.item-update'),
('f8110fed-0859-4eed-8039-02aeff02fd6e',	'2020-07-20 08:51:45',	NULL,	NULL,	'Category List Read',	'category.list-read'),
('fc39b003-4758-497a-822a-6e1555590a2a',	'2020-07-20 08:51:46',	NULL,	NULL,	'Auth Item Delete',	'auth.item-delete'),
('fcff0f88-8940-461a-8c9e-abe2bdb95789',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting Item Delete',	'setting.item-delete'),
('fea90ae8-9ac4-487b-b96b-579c28fad697',	'2020-07-20 08:51:45',	NULL,	NULL,	'Setting Item Read',	'setting.item-read'),
('fed7cabb-55df-4884-a6bc-bf0f3900af61',	'2020-07-20 08:51:45',	NULL,	NULL,	'Tag Item Delete',	'tag.item-delete');

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_648e3f5447f725579d7d4ffdfb` (`name`),
  UNIQUE KEY `IDX_881f72bac969d9a00a1a29e107` (`slug`),
  KEY `name` (`name`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `roles` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `slug`) VALUES
('239cccca-e313-4c56-ba4b-591590c9d74d',	'2020-07-20 08:51:46',	NULL,	NULL,	'Admin',	'admin'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'2020-07-20 08:51:46',	NULL,	NULL,	'Staff',	'staff'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'2020-07-20 08:51:46',	NULL,	NULL,	'Attachment Manager',	'attachment-manager');

DROP TABLE IF EXISTS `roles_permissions_permissions`;
CREATE TABLE `roles_permissions_permissions` (
  `rolesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissionsId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`rolesId`,`permissionsId`),
  KEY `IDX_dc2b9d46195bb3ed28abbf7c9e` (`rolesId`),
  KEY `IDX_fd4d5d4c7f7ff16c57549b72c6` (`permissionsId`),
  CONSTRAINT `FK_dc2b9d46195bb3ed28abbf7c9e3` FOREIGN KEY (`rolesId`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_fd4d5d4c7f7ff16c57549b72c6f` FOREIGN KEY (`permissionsId`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `roles_permissions_permissions` (`rolesId`, `permissionsId`) VALUES
('239cccca-e313-4c56-ba4b-591590c9d74d',	'009210e9-c9f0-4462-8e1c-3db88d50d02a'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'020cdeef-de66-47e5-8cb7-d81fa9720632'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'0b9d4cba-80b4-4507-94f4-59d98b0bac24'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'0d4e0cbc-f5c9-44c8-acc0-3a719decfb38'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'0d56f44d-77d9-4d61-8cbd-5dcd7ecf6011'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'0f0a8e90-d8e3-4571-97b6-8712515f4980'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'0f148eef-d4ad-44db-92e2-0a6fff35eac4'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'10b2d4fa-b76c-4b42-a195-194314d914ea'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'15bf1782-598c-43d4-8b9a-0f1270ffa480'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'18b82201-1d22-44e7-be8c-1fad4fccd3d8'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'1b1f99b3-9740-43fe-85cc-d3bb8f5dccab'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'1b4044fc-a441-4358-a915-b2edf7cedb9a'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'1cd02616-4b95-4284-8801-f49b547266ee'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'1d479484-1624-4441-a09d-ff24fbb56359'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'201a2ae0-6892-4b55-b1fc-6cd71440decf'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'20a491da-487b-4c7f-80e0-62ba2e7098d1'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'20f86bff-22ef-4abd-b330-029da0b8f2b6'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'240511ea-7008-43ee-9440-a09213e8bec5'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'25e4927a-d93c-40c8-a87d-20575c8f231c'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'261bd6ae-8577-41e5-9992-11b2951a5bd8'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'2960029c-bc4c-4d1a-a9b6-538ff4c89c6c'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'3024fd24-f806-4aba-b270-ba9645c1039b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'330fc079-843b-4ace-9b03-55ce96bda820'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'33740d5a-c7c7-4e7f-b8bc-fd552bcf3ac9'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'33afa1a6-7ee9-445c-90cb-ddbee6bc84e4'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'34724c52-a0b9-43a3-ad50-0328e9c265f3'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'34ec632d-fc94-4cb2-ae22-051861ab5a56'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'35b7cc35-2ad7-4b41-9ccb-f86f459534e5'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'35f341a0-23b0-4efa-917d-9b6e3561be01'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'362860a2-ee14-43fd-bd35-f28c18d441d7'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'3aa1dae2-981d-4bd5-9cae-8705e4fd313d'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'3e35bd75-e3d5-44c6-8f38-a0dbb99533b2'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'3ebac69e-3cb8-45d1-81a7-2effcb0135c2'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'416a1d0f-217d-4dce-b1c2-c25da766db10'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'45aa41bb-4eec-4d7c-b822-fb3580e77def'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'46c544c5-832f-4fd0-af26-3a689675188f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'4c2c97fe-3886-4a28-adb1-9b1091b3dca8'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'4c8c3da1-78fe-48df-933c-e2206964ab5b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'4d787377-2987-4168-b205-2ea1a499b9eb'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'5218ed0b-eecf-4760-8eba-9be2dfc4c9f3'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'55217c09-bf76-44a9-8753-d3c9b1b4f86d'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'58bffea5-8854-4c27-8a47-ecf68e62f5ad'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'5fe48b63-197d-4c04-825c-22b50799910f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'616da99a-d61b-4b02-a2bc-0d2c3677ee55'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'64ed3ac2-6972-44a3-b95d-0547719d7d74'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'668b4dca-57bf-4f73-b3ac-2446bea201ae'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'69426c5a-09f7-4681-b9d8-65d0fd71b259'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'6af40bed-4357-41f1-99bb-364f0536646f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'6b423730-ec46-4fc3-8f08-ee2cc043c3aa'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'6e64016a-f6b8-4944-b55f-0068a8409cc9'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'72c75a12-fd79-42f1-89bf-da92062003ae'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'73745a7a-8ff1-4160-879d-882ed3a1723d'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'75f193ac-a138-4598-bb17-d05ac08c68a2'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'7702a960-b002-44b8-adb8-2239b8f9d383'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'78231e07-cedb-4006-a968-bc18b249ed7f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'78aac9cb-d74c-45e7-a880-8a28c8c3290b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'7a2c778f-15b9-45ab-9478-16dea10eab12'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'80b5c438-130e-4cc6-a083-5090218aac2b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'810ceaa1-fe02-4aa0-87e2-e66ec2b4cbd4'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'875732f8-f9ff-4f58-b3ca-af5d69a0602b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'88c570c1-9b8a-4676-9948-6438f9f38eac'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'8b2c7793-65e4-4a33-be9c-7baa30898e7e'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'8b4be73e-8c54-49b0-895f-73ad824438d4'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'8eae12e2-ebda-46be-ae29-9df77b9fa103'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'92a4d7ec-7a16-4083-b43d-fd8c0fc88135'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'9474a50c-5acf-4b00-a376-c3075dd2deac'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'96a59f56-c1ae-4617-95c9-7607f1bc4347'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'97e5ac9d-90ed-4e61-90a8-2d9cd9a43131'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'98978f85-a8c9-4346-8747-c1b987adbc69'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'98bdd687-f9e6-485d-b237-8b384f26e9d3'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'9a875b2c-fbc6-49c4-a3ad-2765228832fb'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'9bd6ed93-ea99-47e6-be52-e8dcd9731b48'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'a25cc19d-5cdc-444b-829c-d5624d2da5d3'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'a428e1f7-a005-4103-89b3-c908d8162d2c'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'a8368e54-a1fe-46d1-8533-5fd7e5cc6455'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'a9dd8d53-c56d-4f72-9119-ba634611da5f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'aa8e6b3d-c74e-4d18-9ff4-b69871f08823'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'ae23bf7f-a6d3-4888-8028-605557789aaa'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'b077f768-3d0f-40d4-8d9c-7b9e8cbec5c8'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'b35e7c7b-aa8d-4139-8d73-493c33e098dc'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'b609109a-a9dc-435e-b587-a3a047802424'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'b954688e-b8f6-42c4-9ac4-84f52ec3f980'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'ba473a31-7355-4383-b295-2250fa65eeb4'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'bd5ed7a9-bd3d-4373-99f2-8aaee740c91f'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c068a172-6b2e-40fc-98b0-9ac06e6c6169'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c0965905-b7bb-4d64-92a8-033671450fe8'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c2f9bd6d-6602-412f-9ea2-c4733b0dec4c'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c4752d31-9306-4901-94a6-328d9e9699e7'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c485222c-fe81-4435-a599-3f016e3a6b42'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c6534b36-dc4f-4795-ac9f-29c42e7f2b10'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c8a427a8-e464-4ee9-a4c6-8c4688d133bc'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'c9f10729-3726-44f2-87b6-bffa3dfd3f44'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'ce8cf138-0e3a-4b66-ad90-6d61254c0629'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'cf7772fc-3720-4923-868c-1802ca702f68'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'cffcfa93-fddc-4eb0-a300-af420b2ee058'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'd0879c2d-e1dc-4310-a684-66be422466e7'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'd0b88f93-23fd-4e84-bb73-e23f95cfc2ea'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'd3f1357d-eb27-424c-a6d8-6f00b61ad951'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'd5555c2f-838e-4574-bf1c-34291a735371'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'd639b068-9a0f-43ed-827d-4cfae2ad6249'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'da143af7-b568-44f3-9d66-bb5eb57a1bec'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'dc755239-4b2c-4eb6-84b6-497a6943c579'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e0050de8-6e18-45ef-b8a7-fb38b242942b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e125cda0-4565-4b24-850f-ee2ebeae1b9a'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e2bc6d9b-b1fb-4b5e-ac3f-e14e7b7d0c06'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e3f17729-0791-4577-8948-c28c98fff49b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e5013b98-9926-44ca-8672-85b7b92b5692'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e7367f7a-505d-4632-847b-bf090ba00318'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'e7c3f322-4eec-4d96-ae8b-3cc48eaf6efd'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'eba88f16-2ce3-46fc-b6e7-15e422c9795b'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'ec9b443a-1c8c-44ed-b539-a69dc5768b17'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'eec092af-e0af-4ebe-9ad0-e9dbde4005ae'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'f2ff3955-eecd-46e6-9b20-af958e33eb70'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'f5e75795-ea91-4770-a315-d3f5448351c2'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'f77141f4-abb7-4340-a4c7-7859c03cc75c'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'f80475d7-45c1-4413-bd52-e429448a65af'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'f8110fed-0859-4eed-8039-02aeff02fd6e'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'fc39b003-4758-497a-822a-6e1555590a2a'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'fcff0f88-8940-461a-8c9e-abe2bdb95789'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'fea90ae8-9ac4-487b-b96b-579c28fad697'),
('239cccca-e313-4c56-ba4b-591590c9d74d',	'fed7cabb-55df-4884-a6bc-bf0f3900af61'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'009210e9-c9f0-4462-8e1c-3db88d50d02a'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'1cd02616-4b95-4284-8801-f49b547266ee'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'1d479484-1624-4441-a09d-ff24fbb56359'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'20f86bff-22ef-4abd-b330-029da0b8f2b6'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'261bd6ae-8577-41e5-9992-11b2951a5bd8'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'330fc079-843b-4ace-9b03-55ce96bda820'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'45aa41bb-4eec-4d7c-b822-fb3580e77def'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'58bffea5-8854-4c27-8a47-ecf68e62f5ad'),
('711c6baa-ac8c-4694-abc2-9d94a6ce2ad0',	'c6534b36-dc4f-4795-ac9f-29c42e7f2b10'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'0d4e0cbc-f5c9-44c8-acc0-3a719decfb38'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'201a2ae0-6892-4b55-b1fc-6cd71440decf'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'98bdd687-f9e6-485d-b237-8b384f26e9d3'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'9bd6ed93-ea99-47e6-be52-e8dcd9731b48'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'b077f768-3d0f-40d4-8d9c-7b9e8cbec5c8'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'b609109a-a9dc-435e-b587-a3a047802424'),
('f7611ad1-b532-4967-a5cb-0e682ec160c8',	'd0879c2d-e1dc-4310-a684-66be422466e7');

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `value` text COLLATE utf8mb4_unicode_ci,
  `sort` int(11) NOT NULL DEFAULT '0',
  `private` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_ca7857276d2a30f4dcfa0e42cd` (`name`),
  UNIQUE KEY `IDX_14378107ac6bb5b9577f6810d5` (`slug`),
  KEY `name` (`name`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `settings` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `slug`, `type`, `description`, `options`, `value`, `sort`, `private`) VALUES
('379ba62c-d6ed-4bdf-bb3f-002b0297afb7',	'2020-07-20 08:51:44',	NULL,	NULL,	'Currency Symbol',	'currency_symbol',	'radio',	'Currency Symbol',	'$\n¥',	'$',	4,	0),
('5bf68ef3-2f27-4023-a8c7-f5458eb95f07',	'2020-07-20 08:51:44',	NULL,	NULL,	'Site Keywords',	'site_keywords',	'input',	'站点关键字，使用英文 , 分隔',	NULL,	'Leaa, mono-repo, C\'est la vie. project 1h 4 1d',	3,	0),
('7316e6cc-742f-4ce9-8e94-d825600c6c72',	'2020-07-20 08:51:44',	NULL,	NULL,	'Site Name',	'site_name',	'input',	'站点名，最大 220 字',	NULL,	'Leaa_DEV',	1,	0),
('c1dadf6f-ed5a-4f0a-b3d6-e151740eef3b',	'2020-07-20 08:51:44',	NULL,	NULL,	'Site Description',	'site_description',	'textarea',	'站点描述， 最大 220 字',	NULL,	'Leaa - project 1h 4 1d',	2,	0);

DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `views` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_d90243459a697eadb8ad56e909` (`name`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tags` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `icon`, `description`, `views`) VALUES
('05e7e3de-b215-4f05-aa4a-e6dfd0704156',	'2020-07-20 08:52:46',	NULL,	NULL,	'森友会',	NULL,	NULL,	0),
('0b4413b1-e710-4a1f-9485-66d133637d85',	'2020-07-20 08:53:41',	NULL,	NULL,	'最小',	NULL,	NULL,	0),
('0bcf36c7-49ba-4920-947d-a0a64a1366ba',	'2020-07-20 08:52:46',	NULL,	NULL,	'CM',	NULL,	NULL,	0),
('13d38c40-778d-41fe-b9d9-8360805f1ae1',	'2020-07-20 08:53:26',	NULL,	NULL,	'SAP',	NULL,	NULL,	0),
('23d1354e-2dfe-4d66-b836-8240a2407569',	'2020-07-20 08:52:54',	NULL,	NULL,	'drive',	NULL,	NULL,	0),
('2460e58f-f7ce-400c-b4b3-56470438f506',	'2020-07-20 08:54:17',	NULL,	NULL,	'img',	NULL,	NULL,	0),
('24b9c3f0-f35f-49b5-91d2-9e97b2998cbc',	'2020-07-20 08:53:03',	NULL,	NULL,	'三星',	NULL,	NULL,	0),
('32bd822a-c459-4648-a6a1-e317d078aa8b',	'2020-07-20 08:53:26',	NULL,	NULL,	'vulnerability',	NULL,	NULL,	0),
('35e23535-93cf-4db2-8c24-da629c5d519f',	'2020-07-20 08:54:17',	NULL,	NULL,	'loading',	NULL,	NULL,	0),
('39bc641d-2809-46ed-a51f-4a2c24090acf',	'2020-07-20 08:53:13',	NULL,	NULL,	'機能',	NULL,	NULL,	0),
('424483a6-dfb1-4f4e-97c3-bdd6b9ae1b16',	'2020-07-20 08:52:58',	NULL,	NULL,	'TypeORM',	NULL,	NULL,	0),
('498f1a4b-a4bc-4896-8d50-ff5aea0d4648',	'2020-07-20 08:53:13',	NULL,	NULL,	'乾燥',	NULL,	NULL,	0),
('4b56b22f-aa45-49f6-86c9-f9f0cd22c943',	'2020-07-20 08:54:17',	NULL,	NULL,	'parts',	NULL,	NULL,	0),
('4bf13e6f-d38e-451d-bcf7-5bf550bfbd30',	'2020-07-20 08:53:13',	NULL,	NULL,	'通知',	NULL,	NULL,	0),
('565461de-9755-4d24-80e5-5c8a673d577c',	'2020-07-20 08:53:07',	NULL,	NULL,	'game',	NULL,	NULL,	0),
('5c7cae77-e8cf-4917-9606-770c5b343cff',	'2020-07-20 08:52:54',	NULL,	NULL,	'backup',	NULL,	NULL,	0),
('670791b5-ee9a-4e3a-93d3-72aa4c358919',	'2020-07-20 08:53:07',	NULL,	NULL,	'September',	NULL,	NULL,	0),
('69e9b9e6-3776-4ae6-befd-e534d3cc0562',	'2020-07-20 08:53:03',	NULL,	NULL,	'nm',	NULL,	NULL,	0),
('6b1f77c0-4b19-4ab8-b6fb-a651c8ea100c',	'2020-07-20 08:52:58',	NULL,	NULL,	'Cordova',	NULL,	NULL,	0),
('6d7bff4b-4bed-4419-9a4b-82c5edb9dc12',	'2020-07-20 08:52:54',	NULL,	NULL,	'TB',	NULL,	NULL,	0),
('728d0ea4-bb14-4508-bc0c-b5e7bd364ea3',	'2020-07-20 08:53:03',	NULL,	NULL,	'芯片组',	NULL,	NULL,	0),
('771e7f0d-a933-4370-9e71-952ab72412af',	'2020-07-20 08:53:03',	NULL,	NULL,	'EUV',	NULL,	NULL,	0),
('78582fc0-5d6c-4699-976d-75ed35d263f1',	'2020-07-20 08:53:26',	NULL,	NULL,	'attacker',	NULL,	NULL,	0),
('7d0ca0d5-d487-4502-a4e7-3c85954288a9',	'2020-07-20 08:54:17',	NULL,	NULL,	'文字',	NULL,	NULL,	0),
('81e1a70f-027a-477f-927f-ec7546578f7e',	'2020-07-20 08:52:58',	NULL,	NULL,	'JavaScript',	NULL,	NULL,	0),
('8aa8b0af-c24b-40a8-a318-bd9ca31cf140',	'2020-07-20 08:52:46',	NULL,	NULL,	'公开',	NULL,	NULL,	0),
('939f97fa-edda-492a-94c6-35dd3aa52c9c',	'2020-07-20 08:53:07',	NULL,	NULL,	'Project',	NULL,	NULL,	0),
('97475809-cb45-41c1-8870-9eb3047e5830',	'2020-07-20 08:53:41',	NULL,	NULL,	'LG',	NULL,	NULL,	0),
('9dd01cd3-85cc-46b4-bfcc-9cf84b8dea7a',	'2020-07-20 08:52:58',	NULL,	NULL,	'applications',	NULL,	NULL,	0),
('9f685082-c208-4125-af6a-9c4d2ef5a8cf',	'2020-07-20 08:53:41',	NULL,	NULL,	'Innotek',	NULL,	NULL,	0),
('a0327454-3490-4d3c-92ab-02b07f023085',	'2020-07-20 08:52:54',	NULL,	NULL,	'drives',	NULL,	NULL,	0),
('a687cd5e-e234-40ed-99e7-7e2eb6dec41e',	'2020-07-20 08:52:58',	NULL,	NULL,	'ES5',	NULL,	NULL,	0),
('a6d5ae72-3112-4fe9-8cbb-5d4b8460e5a6',	'2020-07-20 08:53:26',	NULL,	NULL,	'NetWeaver',	NULL,	NULL,	0),
('aa2f0c50-128e-47dc-b0f9-a4615b607c8c',	'2020-07-20 08:52:46',	NULL,	NULL,	'任天堂',	NULL,	NULL,	0),
('bcbd3d00-0795-4204-a206-7260dc775a2a',	'2020-07-20 08:53:13',	NULL,	NULL,	'SMART',	NULL,	NULL,	0),
('bcbf1e94-ffa8-46e4-a99f-3ecc539ae0a8',	'2020-07-20 08:52:46',	NULL,	NULL,	'夏日',	NULL,	NULL,	0),
('c26d8a04-06f7-41fe-a683-13918ca2adf7',	'2020-07-20 08:53:41',	NULL,	NULL,	'蓝牙',	NULL,	NULL,	0),
('c690aa39-6051-4799-9e54-2824eeb768e0',	'2020-07-20 08:53:07',	NULL,	NULL,	'cloud',	NULL,	NULL,	0),
('d92f8853-4911-4f90-a50e-1134bb454f0e',	'2020-07-20 08:53:26',	NULL,	NULL,	'systems',	NULL,	NULL,	0),
('e1367a2e-09dc-43b9-91ae-51b1ed21137d',	'2020-07-20 08:54:17',	NULL,	NULL,	'png',	NULL,	NULL,	0),
('e1855436-2f8b-40c6-9c54-84c91f999057',	'2020-07-20 08:53:41',	NULL,	NULL,	'模组',	NULL,	NULL,	0),
('e789d9c1-0b57-4c50-aebe-e8c1710458f7',	'2020-07-20 08:53:03',	NULL,	NULL,	'875',	NULL,	NULL,	0),
('eab35469-6616-4a2e-91d1-1eccab36d0cf',	'2020-07-20 08:53:13',	NULL,	NULL,	'今回',	NULL,	NULL,	0),
('fa1ae95b-7a33-4026-b970-ace6ef3ab1ce',	'2020-07-20 08:53:07',	NULL,	NULL,	'Microsoft',	NULL,	NULL,	0),
('ff321bde-e4b3-4ac5-a85a-f6dd3a925dd9',	'2020-07-20 08:52:54',	NULL,	NULL,	'SSD',	NULL,	NULL,	0);

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `phone` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_admin` int(11) NOT NULL DEFAULT '0',
  `is_superuser` int(11) NOT NULL DEFAULT '0',
  `last_login_ip` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_login_at` timestamp NULL DEFAULT NULL,
  `last_token_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_a000cca60bcf04454e72769949` (`phone`),
  UNIQUE KEY `IDX_97672ac88f789774dd47f7c8be` (`email`),
  UNIQUE KEY `account` (`phone`,`email`),
  KEY `account_unique` (`phone`,`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `phone`, `email`, `avatar_url`, `status`, `password`, `is_admin`, `is_superuser`, `last_login_ip`, `last_login_at`, `last_token_at`) VALUES
('086221b8-f25c-494f-af5b-2b4719ccd22c',	'2020-07-20 08:51:47',	NULL,	NULL,	'MOBILE01',	'18688889999',	NULL,	'/assets/images/default-avatar.svg',	1,	'$2a$10$2.TC6s3mV2mZViRVT/YYEOjCqeDO3EZzUsOh7gnfpaFQWqiwBEX3W',	1,	0,	NULL,	NULL,	NULL),
('199d5259-a2b0-499a-8bb6-b3fdcf431fed',	'2020-07-20 08:51:46',	'2020-07-20 08:52:19',	NULL,	'Admin',	NULL,	'admin@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$S2lgwKsP1DAGYWAGdAM3X.MaTOtxp5WQC70sQ6rsVs.2olSruKWe.',	1,	0,	'::ffff:192.168.169.99',	'2020-07-20 08:52:19',	'2020-07-20 08:51:49'),
('3f42bfca-c8dc-4b39-85b7-91617f02f8ec',	'2020-07-20 08:51:47',	NULL,	NULL,	'空号用户',	NULL,	'empty-cn@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$zr7HNCAzhBKwnRsq9/snl.u8U4KgypgzdFQwxLQL5yntAwVFrZBZ6',	0,	0,	NULL,	NULL,	NULL),
('43dc051a-369f-4788-9144-c1eb5ff7889b',	'2020-07-20 08:51:47',	NULL,	NULL,	'空のユーザー',	NULL,	'empty-jp@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$wvk1CUAPt98s9qBEOLUQYOcyFjTaQY1zYb/ng2fEUqkdHMTPaD9CK',	0,	0,	NULL,	NULL,	NULL),
('47975ff8-8aac-43ba-83c3-cd229e4afe46',	'2020-07-20 08:51:47',	NULL,	NULL,	'Empty User',	NULL,	'empty-en@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$0pT8ZROUw6OhlAf98H11tuTdc4uUQ56qEDn8VHdLwZ2R5PPw13/Pm',	0,	0,	NULL,	NULL,	NULL),
('517cdc58-0091-4011-81c0-96a8eccc5477',	'2020-07-20 08:51:47',	NULL,	NULL,	'Disabled',	NULL,	'disabled@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$GQxLX/riKZruGuqUY/xU5O0LQDfCeUqBDvWvS6hx7wy2U8tuYy5hG',	0,	0,	NULL,	NULL,	NULL),
('6602f617-dc13-45f6-a45f-f695b045eabf',	'2020-07-20 08:51:47',	NULL,	NULL,	'RAM-02',	NULL,	'ram-02@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$I4zxv0w1N43f2suZnBHRQuVYGalDP0vFfF.NRSjn5TuCS3LRSXENG',	0,	0,	NULL,	NULL,	NULL),
('7cdbfc0f-7c00-4523-8010-f9d36dd611e2',	'2020-07-20 08:51:48',	NULL,	NULL,	'RAM-03',	NULL,	'ram-03@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$mWDTDPsIUM6KaMSyQ0j2meYBmNyMjjN664gofpY3v2UpuKAK3iULe',	0,	0,	NULL,	NULL,	NULL),
('9916aa94-bee5-4302-97c8-d22434b2a8ca',	'2020-07-20 08:51:48',	NULL,	NULL,	'RAM-05',	NULL,	'ram-05@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$2Dtuu.icZNBhG.ulx2103eDJjXT729gIUUuxDV/dinoePwa5Oi8bO',	0,	0,	NULL,	NULL,	NULL),
('a7d05673-bce6-457f-b4db-b171246bff5b',	'2020-07-20 08:51:46',	'2020-07-20 08:51:48',	NULL,	'Super User',	NULL,	'superuser@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$GPFNT4xF3GNkAMWsMvp82OMHL6zZCMZojzwtnQKDUioyxnGWt9eUe',	1,	1,	NULL,	NULL,	'2020-07-20 08:51:49'),
('cab6edfa-439b-43cd-a4ec-bd51d18a5fb3',	'2020-07-20 08:51:47',	NULL,	NULL,	'RAM-01',	NULL,	'ram-01@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$bNVMaJNoMyPvf41zgbzfjeH3DywlX2y/BJw2HETfUSDv2MeMZlahu',	0,	0,	NULL,	NULL,	NULL),
('d6174ff7-a5f5-445d-b0af-14bda69775a2',	'2020-07-20 08:51:47',	'2020-07-20 08:51:48',	NULL,	'Staff',	NULL,	'staff@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$T1GVRldIvTdCRx4jrThlJuR.Tv2Cg0tgnL8Z6mB89ZP8Abds/IOZi',	1,	0,	NULL,	NULL,	'2020-07-20 08:51:49'),
('dd0808ce-9a34-4d3e-abf8-48dd11e12896',	'2020-07-20 08:51:48',	NULL,	NULL,	'RAM-06',	NULL,	'ram-06@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$bnfxj0ICJrcY.cm0BtPEHuZT07MXMDJQAdFvv5yR.L93gEkSE8xgC',	0,	0,	NULL,	NULL,	NULL),
('f0d60bad-6565-4dfc-840a-776acc063a58',	'2020-07-20 08:51:48',	NULL,	NULL,	'RAM-04',	NULL,	'ram-04@local.com',	'/assets/images/default-avatar.svg',	1,	'$2a$10$l8kpVFcx42gVcICY013fsOs7NH/4LeFbKyo/BR6ktljKRye7mjb3y',	0,	0,	NULL,	NULL,	NULL);

DROP TABLE IF EXISTS `users_addresses_addresses`;
CREATE TABLE `users_addresses_addresses` (
  `usersId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addressesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`usersId`,`addressesId`),
  KEY `IDX_e64aa444ebcd1a999fca5c6d75` (`usersId`),
  KEY `IDX_f4a14656154013ccd7d6bc0202` (`addressesId`),
  CONSTRAINT `FK_e64aa444ebcd1a999fca5c6d75d` FOREIGN KEY (`usersId`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_f4a14656154013ccd7d6bc02029` FOREIGN KEY (`addressesId`) REFERENCES `addresses` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `users_roles_roles`;
CREATE TABLE `users_roles_roles` (
  `usersId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rolesId` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`usersId`,`rolesId`),
  KEY `IDX_df951a64f09865171d2d7a502b` (`usersId`),
  KEY `IDX_b2f0366aa9349789527e0c36d9` (`rolesId`),
  CONSTRAINT `FK_b2f0366aa9349789527e0c36d97` FOREIGN KEY (`rolesId`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_df951a64f09865171d2d7a502b1` FOREIGN KEY (`usersId`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users_roles_roles` (`usersId`, `rolesId`) VALUES
('199d5259-a2b0-499a-8bb6-b3fdcf431fed',	'239cccca-e313-4c56-ba4b-591590c9d74d'),
('a7d05673-bce6-457f-b4db-b171246bff5b',	'239cccca-e313-4c56-ba4b-591590c9d74d'),
('d6174ff7-a5f5-445d-b0af-14bda69775a2',	'711c6baa-ac8c-4694-abc2-9d94a6ce2ad0'),
('d6174ff7-a5f5-445d-b0af-14bda69775a2',	'f7611ad1-b532-4967-a5cb-0e682ec160c8');

DROP TABLE IF EXISTS `verifications`;
CREATE TABLE `verifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- 2020-07-20 08:56:34
