{ lib, stdenv, fetchurl }:

stdenv.mkDerivation rec {
  name = "creepster-caps-${version}";
  version = "2016-01-11-164358";

  phases = [ "unpackPhase" "installPhase" ];

  srcs = [
    (fetchurl {
      url = "https://github.com/google/fonts/blob/90abd17b4f97671435798b6147b698aa9087612f/apache/creepstercaps/CreepsterCaps-Regular.ttf?raw=true";
      name = "CreepsterCaps-Regular.ttf";
      sha256 = "65280da05a53ce22401277170ff13f220a32a40bd85d6427f67866af378b913d";
    })
  ];

  unpackPhase = ''
    for font in $srcs; do
      cp "$font" "$(echo "$font" | cut -d- -f2-)"
    done
  '';

  installPhase = ''
     install -Dm644 CreepsterCaps-Regular.ttf $out/share/fonts/truetype/CreepsterCaps-Regular.ttf
  '';

  meta = with lib; {
    description = "Creepster Caps";
    license = licenses.asl20;
    platforms = platforms.all;
  };
}
