// @ts-check
// `@type` JSDoc annotations allow editor autocompletion and type checking
// (when paired with `@ts-check`).
// There are various equivalent ways to declare your Docusaurus config.
// See: https://docusaurus.io/docs/api/docusaurus-config

import { themes as prismThemes } from 'prism-react-renderer';

/** @type {import('@docusaurus/types').Config} */
const config = {
  title: 'zig.guide',
  tagline: 'Dinosaurs are cool',
  favicon: 'img/favicon.ico',

  // Set the production url of your site here
  url: 'https://zig.guide',
  // Set the /<baseUrl>/ pathname under which your site is served
  // For GitHub pages deployment, it is often '/<projectName>/'
  baseUrl: '/',

  // GitHub pages deployment config.
  // If you aren't using GitHub pages, you don't need these.
  organizationName: 'sobeston', // Usually your GitHub org/user name.
  projectName: 'zig.guide', // Usually your repo name.

  onBrokenLinks: 'throw',
  onBrokenMarkdownLinks: 'warn',

  // Even if you don't use internationalization, you can use this field to set
  // useful metadata like html lang. For example, if your site is Chinese, you
  // may want to replace "en" with "zh-Hans".
  i18n: {
    defaultLocale: 'en',
    locales: ['en'],
  },

  scripts: [
    {
      src: '//gc.zgo.at/count.js',
      async: true,
      "data-goatcounter": "https://ziglearn.goatcounter.com/count",
    },
  ],

  plugins: [[require.resolve('docusaurus-lunr-search'), {
    indexBaseUrl: true,
    maxHits: 7,
    disableVersioning: true,
    excludeRoutes: [
      '/master/**/*', '/0.11/**/*', '/0.12/**/*',
    ],
  }]],
  presets: [
    [
      'classic',
      /** @type {import('@docusaurus/preset-classic').Options} */
      ({
        docs: {
          includeCurrentVersion: false,
          routeBasePath: '/', // Serve the docs at the site's root
          sidebarPath: './sidebars.js',
          // Please change this to your repo.
          // Remove this to remove the "edit this page" links.
          editUrl:
            'https://github.com/Sobeston/zig.guide/tree/master/website/',
          showLastUpdateAuthor: true,
          showLastUpdateTime: true,
          lastVersion: "0.13",
          versions: {
            "0.14": {
              label: 'Zig 0.14.0 (dev)',
              path: 'master',
            },
            "0.13": {
              label: 'Zig 0.13.0',
              path: '/',
            },
            "0.12": {
              label: 'Zig 0.12.0',
              path: '/0.12',
            },
            "0.11": {
              label: "Zig 0.11.0",
              path: '/0.11',
            }
          },
        },
        blog: {
          routeBasePath: 'posts',
          showReadingTime: true,
          // Please change this to your repo.
          // Remove this to remove the "edit this page" links.
          editUrl:
            'https://github.com/Sobeston/zig.guide/tree/master/website/',
        },
        theme: {
          customCss: './src/css/custom.css',
        },
      }),
    ],
  ],

  themeConfig:
    /** @type {import('@docusaurus/preset-classic').ThemeConfig} */
    ({
      colorMode: {
        defaultMode: 'dark',
        disableSwitch: false,
        respectPrefersColorScheme: true,
      },
      metadata: [
        { name: 'keywords', content: 'programming, zig, guide, tutorial, ziglang, learn, ziglearn, language, install, book' },
      ],
      // Replace with your project's social card
      image: 'img/docusaurus-social-card.jpg',
      navbar: {
        title: 'zig.guide',
        logo: {
          alt: 'zig.guide Logo',
          src: 'img/logo.svg',
        },
        items: [
          {
            type: 'docSidebar',
            sidebarId: 'tutorialSidebar',
            position: 'left',
            label: 'Guide',
          },
          { to: '/posts', label: 'Posts', position: 'left' },
          {
            href: 'https://github.com/sobeston/zig.guide',
            label: 'GitHub',
            position: 'right',
          },
          {
            type: 'docsVersionDropdown',
            position: 'right',
            dropdownActiveClassDisabled: true,
          },
        ],
      },
      footer: {
        style: 'dark',
        links: [
          {
            title: 'Community',
            items: [
              {
                label: 'GitHub',
                href: 'https://github.com/sobeston/zig.guide',
              },
              {
                label: 'Mastodon',
                href: 'https://hachyderm.io/@sobeston',
              },
              {
                label: 'Sponsor zig.guide',
                href: 'https://github.com/sponsors/Sobeston',
              },
            ],
          },
        ],
      },
      prism: {
        theme: prismThemes.github,
        darkTheme: prismThemes.dracula,
        additionalLanguages: ['powershell', 'zig'],
        magicComments: [
          {
            className: 'theme-code-block-highlighted-line',
            line: 'highlight-next-line',
            block: { start: 'highlight-start', end: 'highlight-end' },
          },
          {
            className: 'code-block-hidden',
            line: 'hide-next-line',
            block: { start: 'hide-start', end: 'hide-end' },
          }],
      },
    }),
};

export default config;
