// This file is autogenerated. See look at the .lzz files in the src/ directory for a more human-friendly version
// sttFont.hh
//

#ifndef LZZ_sttFont_hh
#define LZZ_sttFont_hh

#ifndef STTR_ENABLED
namespace sttr {
	template<typename T> inline const char * getTypeName() { return "sttr_not_defined"; }
	template<typename T> inline char * getTypeSignature() { return (char*) 0; }
	}
#endif

#ifndef STB_TRUETYPE_INCLUDE_HANDLED
	////////////////////////////////////////
	// STB TRUETYPE 
	// Handle double-including
	#ifdef STB_TRUETYPE_IMPLEMENTATION
		#undef STB_TRUETYPE_IMPLEMENTATION
	#endif
	#include "stb_truetype.h"
	////////////////////////////////////////
#endif

// Defines
#ifndef SSF_MAP
	#include <map>
	#define SSF_MAP std::map
#endif
#ifndef SSF_VECTOR
	#include <vector>
	#define SSF_VECTOR std::vector
#endif
#ifndef SSF_STRING
	#include <string>
	#define SSF_STRING std::string
#endif
#ifndef SSF_STRING_VIEW
	#include <string_view>
	#define SSF_STRING_VIEW std::string_view
#endif
#ifndef SSF_ATOMIC_INT
	#include <atomic>
	#define SSF_ATOMIC_INT std::atomic<int>
#endif

// new and delete macros
// all calls in this library are done with "foo * f = SSF_NEW(f)"
// implement your custom allocator by defining SSF_NEW and SSF_DEL
#ifndef SSF_NEW
	#define SSF_NEW(X) new X
#endif
#ifndef SSF_NEW_ARR
	#define SSF_NEW_ARR(X,S) new X[S]
#endif
#ifndef SSF_DEL
	#define SSF_DEL(X) delete X
#endif
#ifndef SSF_DEL_ARR
	#define SSF_DEL_ARR(X) delete[] X
#endif

struct sttfont_uintQuad {
	uint32_t first, second, third, fourth;
	
	inline sttfont_uintQuad() : first(0), second(0), third(0), fourth(0) {}
	inline sttfont_uintQuad(uint32_t a, uint32_t b = 0, uint32_t c = 0, uint32_t d = 0) : first(a), second(b), third(c), fourth(d) {}
	};

// workaround for temp arrays not being a thing on msvc
// used for stack allocated temporary arrays in function or block scope
template <typename T, int S>
struct sttfont_tmpArr {
	T stackBuff[S];
	T* heapBuff;
	T* arr;
	
	inline void reserve(const uint64_t sz) {
		if (heapBuff) abort();
		if (sz > S) {
			heapBuff = SSF_NEW_ARR(T, sz);
			arr = heapBuff;
			}
		}
	inline sttfont_tmpArr() : heapBuff(NULL), arr(&stackBuff[0]) {}
	inline sttfont_tmpArr(const uint64_t sz) : heapBuff(NULL), arr(&stackBuff[0]) { reserve(sz); }
	inline ~sttfont_tmpArr() { if (heapBuff) SSF_DEL_ARR(heapBuff); }
	};

#include <cstdint>

// move semantics - makes lzz happy
#define SSF_STRING_MS SSF_STRING&&
#define sttfont_formatted_text_item_MS sttfont_formatted_text_item&&
#define sttfont_formatted_text_MS sttfont_formatted_text&&

// misc
#ifdef INT32_MIN
	#define SSF_INT_MIN  INT32_MIN
#else
	#define SSF_INT_MIN 0x8000000;
#endif
struct sttfont_formatted_text;
class sttfont_font_cache;
namespace stt {
	struct allocatorI;
	}
// purpose: an allocator that puts string objects onto a stack memory buffer
// when the buffer falls out of scope then the buffer is released
#ifndef SSF_STT_STL_ALLOCATOR_ENABLED
	#define SSF_STT_STL_ALLOCATOR_ENABLED 0
#endif
#define LZZ_INLINE inline
struct sttfont_lookupHint
{
  unsigned int index;
  unsigned int workingLen;
  int workingX;
  int workingY;
  uint32_t uCharLast;
  bool writeOut;
  sttfont_lookupHint ();
};
struct sttfont_format_callback
{
  virtual void callbackOnDraw (sttfont_formatted_text const & text, int index, int x, int y, int xOffsetInitial, int xOffsetAfter, int segmentWidth, int segmentHeight);
};
struct sttfont_format_reset
{
};
struct sttfont_format
{
  uint8_t r;
  uint8_t g;
  uint8_t b;
  uint8_t a;
  uint8_t format;
  uint8_t flags;
  uint16_t padding;
  static uint8_t const FORMAT_NONE;
  static uint8_t const FORMAT_BOLD;
  static uint8_t const FORMAT_ITALIC;
  static uint8_t const FORMAT_UNDERLINE;
  static uint8_t const FORMAT_STRIKETHROUGH;
  static uint8_t const FORMAT_RENDER_EVEN_IF_CALLBACK_EXISTS;
  static uint8_t const FORMAT_FLAGS_COLOUR_SET;
  sttfont_format ();
  sttfont_format (uint8_t const _format);
  sttfont_format (uint8_t const _format, uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a = 255);
  sttfont_format clone () const;
  bool operator == (sttfont_format const & other) const;
  void setBold (bool const on);
  void setItalic (bool const on);
  void setUnderline (bool const on);
  void setStrikethrough (bool const on);
  bool isBold () const;
  bool isItaic () const;
  bool isUnderline () const;
  bool isStrikethrough () const;
  bool hasFormats () const;
  void resetColour ();
  void combine (sttfont_format const & other);
  void combineWithColour (sttfont_format const & other);
  static sttfont_format color (uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a = 255);
  static sttfont_format colour (uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a = 255);
  static sttfont_format color_luasafe (uint8_t const _r, uint8_t const _g, uint8_t const _b);
  static sttfont_format colour_luasafe (uint8_t const _r, uint8_t const _g, uint8_t const _b);
  static sttfont_format const bold;
  static sttfont_format const italic;
  static sttfont_format const underline;
  static sttfont_format const strikethrough;
  static sttfont_format const red;
  static sttfont_format const green;
  static sttfont_format const blue;
  static sttfont_format const yellow;
  static sttfont_format const black;
  static sttfont_format const white;
  static sttfont_format const magenta;
  static sttfont_format const cyan;
  static sttfont_format const grey;
  static sttfont_format const light_red;
  static sttfont_format const light_green;
  static sttfont_format const light_blue;
  static sttfont_format const light_yellow;
  static sttfont_format const light_black;
  static sttfont_format const light_white;
  static sttfont_format const light_magenta;
  static sttfont_format const light_cyan;
  static sttfont_format const light_grey;
  static sttfont_format const dark_red;
  static sttfont_format const dark_green;
  static sttfont_format const dark_blue;
  static sttfont_format const dark_yellow;
  static sttfont_format const dark_black;
  static sttfont_format const dark_white;
  static sttfont_format const dark_magenta;
  static sttfont_format const dark_cyan;
  static sttfont_format const dark_grey;
  static int const COLOUR_MODE_NORMAL = 0;
  static int const COLOUR_MODE_DARKEN = 1;
  static int const COLOUR_MODE_LIGHTEN = 2;
  static sttfont_format const & selectColour (int const colourMode, sttfont_format const & colourIf0, sttfont_format const & colourIf1, sttfont_format const & colourIf2);
  static sttfont_format_reset const reset;
  void swap (sttfont_format & other);
  SSF_STRING getTtyFormatCodeBegin () const;
  SSF_STRING getTtyFormatCodeEnd () const;
  void ttyFmtWorker (SSF_STRING & rs) const;
  SSF_STRING debugDump () const;
  static void sttr_register ();
  void * sttr_getClassSig () const;
  char const * const sttr_getClassName () const;
};
struct sttfont_formatted_text_item
{
  SSF_STRING text;
  sttfont_format format;
  sttfont_format_callback * callback;
  sttfont_formatted_text_item ();
  sttfont_formatted_text_item (SSF_STRING const & _text, sttfont_format const & _format);
  sttfont_formatted_text_item (SSF_STRING_MS _text, sttfont_format const & _format);
  sttfont_formatted_text_item & setCallback (sttfont_format_callback * _cb);
  void setAllocator (stt::allocatorI * alloc);
  static void sttr_register ();
  void * sttr_getClassSig () const;
  char const * const sttr_getClassName () const;
};
struct sttfont_formatted_uipair
{
  unsigned int a;
  unsigned int b;
  static void sttr_register ();
  void * sttr_getClassSig () const;
  char const * const sttr_getClassName () const;
};
struct sttfont_formatted_text
{
  SSF_VECTOR <sttfont_formatted_text_item> mItems;
  sttfont_format activeFormat;
  sttfont_formatted_text ();
  sttfont_formatted_text (stt::allocatorI * alloc);
  sttfont_formatted_text (sttfont_formatted_text const & obj);
  sttfont_formatted_text (SSF_STRING const & text);
  sttfont_formatted_text (SSF_STRING_MS text);
  sttfont_formatted_text (char const * text);
  sttfont_formatted_text (char const * text, uint32_t const maxLen);
  sttfont_formatted_text (sttfont_formatted_text_item_MS text);
  sttfont_formatted_text (sttfont_formatted_text_item const & text);
  sttfont_formatted_text (sttfont_formatted_text_MS obj);
  sttfont_formatted_text & operator = (sttfont_formatted_text_MS obj);
  sttfont_formatted_text & operator = (sttfont_formatted_text const & obj);
  void resetFormat ();
  sttfont_formatted_text & operator << (SSF_STRING_VIEW const & text);
  sttfont_formatted_text & operator << (SSF_STRING const & text);
  sttfont_formatted_text & operator << (SSF_STRING_MS text);
  sttfont_formatted_text & operator << (char const * text);
  sttfont_formatted_text & operator += (SSF_STRING_VIEW const & text);
  sttfont_formatted_text & operator += (SSF_STRING const & text);
  sttfont_formatted_text & operator += (SSF_STRING_MS text);
  sttfont_formatted_text & operator += (char const * text);
  sttfont_formatted_text & operator << (sttfont_format const & format);
  sttfont_formatted_text & operator << (sttfont_format_reset const & reset);
  sttfont_formatted_text & operator << (sttfont_formatted_text_item const & obj);
  sttfont_formatted_text & operator << (sttfont_formatted_text_item_MS obj);
  sttfont_formatted_text & appendCBuff (char const * text, uint32_t const maxLen);
  void allocatorAwareAppend (sttfont_formatted_text_item const & obj);
  void allocatorAwareAppendMv (sttfont_formatted_text_item_MS obj);
  void allocatorAwareAssign (sttfont_formatted_text const & other);
  void allocatorAwareAssignMv (sttfont_formatted_text_MS other);
  static void sttr_register ();
  void * sttr_getClassSig () const;
  char const * const sttr_getClassName () const;
  void setAllocator (stt::allocatorI * alloc);
  void setCustomAllocatorForTextItem (sttfont_formatted_text_item & ti);
  static void copyInterned (stt::allocatorI * alloc, sttfont_formatted_text & dst, sttfont_formatted_text const & src, bool const internStrings);
  void markInterned ();
  sttfont_formatted_text copy () const;
  void swap (sttfont_formatted_text & other);
  size_t size () const;
  size_t length () const;
  bool isEmpty () const;
  SSF_STRING getString () const;
  SSF_STRING getTtyString () const;
  SSF_STRING getStringTruncated (unsigned int const maxLen) const;
  void append_luasafe (sttfont_formatted_text const & obj);
  void append_plaintext_MS (SSF_STRING_MS str, sttfont_format const * fmt);
  void append_plaintext_BUF (char const * str, uint32_t const len, sttfont_format const * fmt);
  void append_plaintext (char const * str, uint32_t const len, sttfont_format const * fmt);
  void append_plaintext_str (SSF_STRING const & str, sttfont_format const * fmt);
  void append (sttfont_formatted_text const & obj);
  void append (sttfont_formatted_text_MS obj);
  void clear ();
  void overrideColour_worker (sttfont_format const & fmt, bool const force);
  void overrideColour (sttfont_format const & fmt);
  void forceOverrideColour (sttfont_format const & fmt);
  void consolidateSegments ();
protected:
  void consolidateSegments_worker ();
public:
  bool back (unsigned int const num);
  sttfont_formatted_uipair getIndexAt_luasafe (unsigned int const position, sttfont_lookupHint * mHint) const;
  void getIndexAt (unsigned int const position, unsigned int & indexOut, unsigned int & localPosOut, sttfont_lookupHint * mHint = NULL) const;
  sttfont_formatted_uipair utf8_charsizeAt_luasafe (unsigned int const position, sttfont_lookupHint * mHint);
  void utf8_charsizeAt (unsigned int const position, unsigned int & posOut, unsigned int & sizeOut, sttfont_lookupHint * mHint = NULL);
  void insert (unsigned int const position, SSF_STRING const & str, sttfont_lookupHint * mHint = NULL);
  void insert (unsigned int const position, SSF_STRING_MS str, sttfont_lookupHint * mHint = NULL);
  void insert_luasafe (unsigned int const position, sttfont_formatted_text const & str, sttfont_lookupHint * mHint);
  void insert (unsigned int const position, sttfont_formatted_text const & str, sttfont_lookupHint * mHint = NULL);
  void insert (unsigned int const position, sttfont_formatted_text_MS str, sttfont_lookupHint * mHint = NULL);
  void remove_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint);
  void remove (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint = NULL);
  SSF_STRING substr (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint = NULL) const;
  SSF_STRING substr_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const;
  sttfont_formatted_text extract (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint = NULL) const;
  sttfont_formatted_text extract_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const;
  void tokenise (SSF_VECTOR <sttfont_formatted_text> & arrOut, uint32_t const delimiter, bool const checkQuoteMarks = true, uint32_t const escapeChar = '\\', bool const includeDelimiterInToken = false) const;
  void tokenise_luasafe (SSF_VECTOR <sttfont_formatted_text> * arrOut, uint32_t const delimiter, bool const checkQuoteMarks, uint32_t const escapeChar, bool const includeDelimiterInToken) const;
};
struct sttfont_uint32_t_range
{
  uint32_t start;
  uint32_t end;
  static void populateRangesLatin (SSF_VECTOR <sttfont_uint32_t_range> & mRanges);
  static void populateRangesCyrillic (SSF_VECTOR <sttfont_uint32_t_range> & mRanges);
};
struct sttfont_prerendered_text
{
  int width;
  int height;
  sttfont_prerendered_text ();
  virtual ~ sttfont_prerendered_text ();
  virtual void freeTexture ();
  virtual int draw (int const x, int const y);
  virtual int drawWithColorMod (int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a = 255);
  virtual int draw (sttfont_font_cache * fc, int const x, int const y);
  virtual int drawWithColorMod (sttfont_font_cache * fc, int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
};
struct sttfont_glyph
{
  int advance;
  int leftSideBearing;
  int width;
  int height;
  int xOffset;
  int yOffset;
  sttfont_glyph ();
};
struct sttfont_memory
{
  char * data;
  size_t size;
  bool ownsData;
  void alloc (size_t const _size);
  void transferTo (sttfont_memory & destination);
  void cloneTo (sttfont_memory & other);
  sttfont_memory ();
  ~ sttfont_memory ();
};
struct sttfont_font_list
{
  stbtt_fontinfo mFont;
  sttfont_memory mMemory;
  uint8_t format;
  SSF_VECTOR <sttfont_font_list*> mFormatedVariants;
  sttfont_font_list * next;
  sttfont_font_list ();
  ~ sttfont_font_list ();
  void fetchFontForCodepoint (uint32_t const codepoint, uint8_t const format, stbtt_fontinfo * * mFontOut, int * indexOut);
};
class sttfont_font_cache
{
public:
  sttfont_font_list mFont;
  int ascent;
  int descent;
  int lineGap;
  int baseline;
  int rowSize;
  int tabWidth;
  float scale;
  float underlineThickness;
  float strikethroughThickness;
  float underlinePosition;
  float strikethroughPosition;
  int faceSize;
  int tabWidthInSpaces;
  void * userData;
  sttfont_font_cache ();
  virtual ~ sttfont_font_cache ();
  void setFaceSize (int const _faceSize);
  int getScaledRowSize () const;
  void syncFrom (sttfont_font_cache const & other);
  void loadFont (char const * ttf_buffer, int index = 0);
  void loadFontManaged (sttfont_memory & memory, int index = 0);
  void addFont (char const * ttf_buffer, int index = 0);
  void addFontManaged (sttfont_memory & memory, int index = 0);
  void addFormatFont (uint8_t formatMask, char const * ttf_buffer, int index = 0);
  void addFormatFontManaged (uint8_t formatMask, sttfont_memory & memory, int index = 0);
protected:
  struct addFontWrap
  {
    char const * ttf_buffer;
    sttfont_memory * memory;
    int index;
    addFontWrap (char const * c);
  };
  void addFont_worker (addFontWrap & fwm, bool isFormatVariant, uint8_t formatMask = 0);
public:
  void genGlyph (uint32_t const codepoint, uint8_t const format, sttfont_glyph * gOut, unsigned char * * bitmapOut = NULL);
  virtual void pregenGlyphs (SSF_VECTOR <sttfont_uint32_t_range> & mRanges, uint8_t const format);
  virtual void genGlyph_writeData (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h);
  virtual sttfont_glyph * getGlyph (uint64_t const target);
  sttfont_glyph * getGenGlyph (uint32_t const codepoint, uint8_t const format);
  virtual sttfont_glyph * genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format);
  int getKerningAdvance (uint32_t const cp1, uint32_t const cp2);
  static int utf8_charsize (char const * c);
  static int utf8_charsize (uint32_t const codepoint);
  static uint32_t utf8_read (char const * c, uint32_t & seek, uint32_t const maxLen);
  int drawText (int const x, int const y, char const * c, uint32_t const maxLen = -1);
  int drawText (int const x, int const y, SSF_STRING const & str);
  int drawText (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen = -1);
  int drawText (int const x, int const y, sttfont_format const format, SSF_STRING const & str);
  int drawText (int const x, int const y, int & widthOut, int & heightOut, char const * c, uint32_t const maxLen = -1);
  int drawText (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int & widthOut, int & heightOut);
  int drawText (int const x, int const y, int & widthOut, int & heightOut, sttfont_format const format, char const * c, uint32_t const maxLen = -1);
  int drawText (int const x, int const y, SSF_STRING const & str, int & widthOut, int & heightOut);
  int drawText (int const x, int const y, sttfont_formatted_text const & text);
  int drawText (int const x, int const y, sttfont_formatted_text const & text, int & widthOut, int & heightOut);
  int getTextSize (int & w, int & h, char const * c, uint32_t const maxLen = -1, sttfont_lookupHint * mHint = NULL, int const * const maxWidth = NULL);
  int getTextSize (int & w, int & h, SSF_STRING const & str, sttfont_lookupHint * mHint = NULL, int const * const maxWidth = NULL);
  int getTextSize (int & w, int & h, sttfont_formatted_text const & str, sttfont_lookupHint * mHint = NULL, int const * const maxWidth = NULL);
  int countNewlines (SSF_STRING const & str);
  int getNumberOfRows (SSF_STRING const & str);
  int getNumberOfRows (sttfont_formatted_text const & str);
  int getTextHeight (SSF_STRING const & str);
  int getTextHeight (sttfont_formatted_text const & str);
  int getTextWidth (SSF_STRING const & str, sttfont_lookupHint * mHint = NULL, int const * const maxWidth = NULL);
  int getTextWidth (sttfont_formatted_text const & str, sttfont_lookupHint * mHint = NULL, int const * const maxWidth = NULL);
  virtual void onStartDrawing ();
  virtual void onCompletedDrawing ();
  int processString (int const x, int const y, char const * c, uint32_t const maxLen, sttfont_format const * const format, bool const isDrawing, int * const widthOut = NULL, int * const heightOut = NULL, int const * const maxWidth = NULL, sttfont_lookupHint * mHint = NULL, int const * const threshX = NULL, int const * const threshY = NULL, int * const caretPosition = NULL, int initialXOffset = 0);
  int processString_worker (int const x, int const y, char const * c, uint32_t const maxLen, sttfont_format const * const format, bool const isDrawing, int * const widthOut, int * const heightOut, int const * const maxWidth, sttfont_lookupHint * mHint, int const * const threshX, int const * const threshY, int * const caretPosition, int initialXOffset);
  int processFormatted (sttfont_formatted_text const & text, int x, int y, bool const isDrawing, int * const widthOut = NULL, int * const heightOut = NULL, int const * const maxHeight = NULL, sttfont_lookupHint * mHint = NULL, int const * const threshX = NULL, int const * const threshY = NULL, int * const caretPosition = NULL, int initialXOffset = 0);
  int getCaretPos (SSF_STRING const & str, int const relMouseX, int const relMouseY, sttfont_lookupHint * mHint = NULL);
  int getCaretPos (sttfont_formatted_text const & str, int const relMouseX, int const relMouseY, sttfont_lookupHint * mHint = NULL);
  bool isTofu (sttfont_glyph * G);
  sttfont_glyph * getGlyphOrTofu (uint32_t const codepoint, uint8_t const format);
  void processCodepoint (int & x, int & y, uint32_t const codepoint, sttfont_format const * const format, bool isDrawing, int kerningAdv, int & overdraw);
  virtual void drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw);
  virtual void renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen = -1);
  virtual void renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str);
  virtual void renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str);
  void breakString (sttfont_formatted_text const & stringIn, SSF_VECTOR <sttfont_formatted_text> & arrOut, int const xs, bool const tokeniseNewLines = true, SSF_VECTOR <sttfont_uintQuad> * breakPoints = NULL);
  void breakString (SSF_STRING const & stringIn, SSF_VECTOR <SSF_STRING> & arrOut, int const xs, bool const tokeniseNewLines = true, SSF_VECTOR <sttfont_uintQuad> * breakPoints = NULL);
};
LZZ_INLINE sttfont_format::sttfont_format ()
  : r (255), g (255), b (255), a (255), format (0), flags (0), padding (0)
                                                                                                  {}
LZZ_INLINE sttfont_format::sttfont_format (uint8_t const _format)
  : r (255), g (255), b (255), a (255), format (_format), flags (0), padding (0)
                                                                                                                {}
LZZ_INLINE sttfont_format::sttfont_format (uint8_t const _format, uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a)
  : r (_r), g (_g), b (_b), a (_a), format (_format), flags (FORMAT_FLAGS_COLOUR_SET), padding (0)
                                                                                                                                  {}
LZZ_INLINE sttfont_format sttfont_format::clone () const
                                            { sttfont_format r; r = *this; return r; }
LZZ_INLINE bool sttfont_format::operator == (sttfont_format const & other) const
                                                                     { // use default operator
		return (r == other.r) && (g == other.g) && (b == other.b) && (a == other.a) && (format == other.format) && (flags == other.flags);
		}
LZZ_INLINE void sttfont_format::setBold (bool const on)
                                           { if (on) format |= FORMAT_BOLD; else format &= ~FORMAT_BOLD; }
LZZ_INLINE void sttfont_format::setItalic (bool const on)
                                             { if (on) format |= FORMAT_ITALIC; else format &= ~FORMAT_ITALIC; }
LZZ_INLINE void sttfont_format::setUnderline (bool const on)
                                                { if (on) format |= FORMAT_UNDERLINE; else format &= ~FORMAT_UNDERLINE; }
LZZ_INLINE void sttfont_format::setStrikethrough (bool const on)
                                                    { if (on) format |= FORMAT_STRIKETHROUGH; else format &= ~FORMAT_STRIKETHROUGH; }
LZZ_INLINE bool sttfont_format::isBold () const
                                   { return format & FORMAT_BOLD; }
LZZ_INLINE bool sttfont_format::isItaic () const
                                    { return format & FORMAT_ITALIC; }
LZZ_INLINE bool sttfont_format::isUnderline () const
                                        { return format & FORMAT_UNDERLINE; }
LZZ_INLINE bool sttfont_format::isStrikethrough () const
                                            { return format & FORMAT_STRIKETHROUGH; }
LZZ_INLINE bool sttfont_format::hasFormats () const
                                       { return format; }
LZZ_INLINE void sttfont_formatted_text::append_plaintext (char const * str, uint32_t const len, sttfont_format const * fmt)
                                                                                                       {
		append_plaintext_BUF(str,len, fmt);
		}
LZZ_INLINE void sttfont_formatted_text::append_plaintext_str (SSF_STRING const & str, sttfont_format const * fmt)
                                                                                            {
		append_plaintext_BUF(str.data(), str.size(), fmt);
		}
LZZ_INLINE void sttfont_formatted_text::append (sttfont_formatted_text const & obj)
                                                               { return append_luasafe(obj); }
LZZ_INLINE void sttfont_formatted_text::insert (unsigned int const position, sttfont_formatted_text const & str, sttfont_lookupHint * mHint)
                                                                                                                               { insert_luasafe(position, str, mHint); }
LZZ_INLINE void sttfont_formatted_text::remove (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint)
                                                                                                                   { remove_luasafe(position, num, mHint); }
LZZ_INLINE SSF_STRING sttfont_formatted_text::substr_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const
                                                                                                                                {
		return substr(position, num, mHint);
		}
LZZ_INLINE sttfont_formatted_text sttfont_formatted_text::extract_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const
                                                                                                                                             { return extract(position, num, mHint); }
LZZ_INLINE void sttfont_formatted_text::tokenise_luasafe (SSF_VECTOR <sttfont_formatted_text> * arrOut, uint32_t const delimiter, bool const checkQuoteMarks, uint32_t const escapeChar, bool const includeDelimiterInToken) const
                                                                                                                                                                                                             {
		return tokenise(*arrOut, delimiter, checkQuoteMarks, escapeChar, includeDelimiterInToken);
		}
#undef LZZ_INLINE
#endif

////////////////////////////////////////////////////////////////////////

#ifdef SDL_STB_FONT_IMPL
#ifndef SDL_STB_FONT_IMPL_DOUBLE_GUARD_sttFont
#define SDL_STB_FONT_IMPL_DOUBLE_GUARD_sttFont
// sttFont.cpp
//

#include <stdio.h>

#ifndef STB_TRUETYPE_INCLUDE_HANDLED
	////////////////////////////////////////
	// STB TRUETYPE 
	#define STB_TRUETYPE_IMPLEMENTATION
	#include <math.h>
	#include <string.h>
	#include <assert.h>
	#include <stdlib.h>
	#include "stb_truetype.h"
	////////////////////////////////////////
#endif

#define LZZ_INLINE inline
sttfont_lookupHint::sttfont_lookupHint ()
  : index (0), workingLen (0), workingX (0), workingY (0), uCharLast (0), writeOut (false)
                                                                                                                {}
void sttfont_format_callback::callbackOnDraw (sttfont_formatted_text const & text, int index, int x, int y, int xOffsetInitial, int xOffsetAfter, int segmentWidth, int segmentHeight)
                                                                                                                                                                             {}
uint8_t const sttfont_format::FORMAT_NONE = 0 << 0;
uint8_t const sttfont_format::FORMAT_BOLD = 1 << 0;
uint8_t const sttfont_format::FORMAT_ITALIC = 1 << 1;
uint8_t const sttfont_format::FORMAT_UNDERLINE = 1 << 2;
uint8_t const sttfont_format::FORMAT_STRIKETHROUGH = 1 << 3;
uint8_t const sttfont_format::FORMAT_RENDER_EVEN_IF_CALLBACK_EXISTS = 1 << 7;
uint8_t const sttfont_format::FORMAT_FLAGS_COLOUR_SET = 1 << 0;
void sttfont_format::resetColour ()
                           { r = 255, b = 255, g = 255, a = 255; flags &= ~FORMAT_FLAGS_COLOUR_SET; }
void sttfont_format::combine (sttfont_format const & other)
                                                   {
		// merges flags and blends colours multiplicatively
		format |= other.format;
		flags |= other.flags;
		r = 255*((r/255.0)*(other.r/255.0));
		g = 255*((g/255.0)*(other.g/255.0));
		b = 255*((b/255.0)*(other.b/255.0));
		a = 255*((a/255.0)*(other.a/255.0));
		}
void sttfont_format::combineWithColour (sttfont_format const & other)
                                                             {
		// merges formats and overrides colour
		format |= other.format;
		flags |= other.flags;
		r = other.r;
		g = other.g;
		b = other.b;
		a = other.a;
		}
sttfont_format sttfont_format::color (uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a)
                                                                                                                   { sttfont_format ret(FORMAT_NONE,_r,_g,_b,_a); ret.flags |= FORMAT_FLAGS_COLOUR_SET; return ret; }
sttfont_format sttfont_format::colour (uint8_t const _r, uint8_t const _g, uint8_t const _b, uint8_t const _a)
                                                                                                                   { sttfont_format ret(FORMAT_NONE,_r,_g,_b,_a); ret.flags |= FORMAT_FLAGS_COLOUR_SET; return ret; }
sttfont_format sttfont_format::color_luasafe (uint8_t const _r, uint8_t const _g, uint8_t const _b)
                                                                                                   { return color(_r,_g,_b,255); }
sttfont_format sttfont_format::colour_luasafe (uint8_t const _r, uint8_t const _g, uint8_t const _b)
                                                                                                   { return colour(_r,_g,_b,255); }
sttfont_format const sttfont_format::bold = sttfont_format(FORMAT_BOLD);
sttfont_format const sttfont_format::italic = sttfont_format(FORMAT_ITALIC);
sttfont_format const sttfont_format::underline = sttfont_format(FORMAT_UNDERLINE);
sttfont_format const sttfont_format::strikethrough = sttfont_format(FORMAT_STRIKETHROUGH);
sttfont_format const sttfont_format::red = sttfont_format(FORMAT_NONE,255,  0,  0,255);
sttfont_format const sttfont_format::green = sttfont_format(FORMAT_NONE,  0,255,  0,255);
sttfont_format const sttfont_format::blue = sttfont_format(FORMAT_NONE,  0,  0,255,255);
sttfont_format const sttfont_format::yellow = sttfont_format(FORMAT_NONE,255,255,  0,255);
sttfont_format const sttfont_format::black = sttfont_format(FORMAT_NONE,  0,  0,  0,255);
sttfont_format const sttfont_format::white = sttfont_format(FORMAT_NONE,255,255,255,255);
sttfont_format const sttfont_format::magenta = sttfont_format(FORMAT_NONE,255,  0,255,255);
sttfont_format const sttfont_format::cyan = sttfont_format(FORMAT_NONE,  0,255,255,255);
sttfont_format const sttfont_format::grey = sttfont_format(FORMAT_NONE,128,128,128,255);
sttfont_format const sttfont_format::light_red = sttfont_format(FORMAT_NONE,255,  128,  128,255);
sttfont_format const sttfont_format::light_green = sttfont_format(FORMAT_NONE,  128,255,  128,255);
sttfont_format const sttfont_format::light_blue = sttfont_format(FORMAT_NONE,  128,  128,255,255);
sttfont_format const sttfont_format::light_yellow = sttfont_format(FORMAT_NONE,255,255,  128,255);
sttfont_format const sttfont_format::light_black = sttfont_format(FORMAT_NONE,  128,  128,  128,255);
sttfont_format const sttfont_format::light_white = sttfont_format(FORMAT_NONE,255,255,255,255);
sttfont_format const sttfont_format::light_magenta = sttfont_format(FORMAT_NONE,255,  128,255,255);
sttfont_format const sttfont_format::light_cyan = sttfont_format(FORMAT_NONE,  128,255,255,255);
sttfont_format const sttfont_format::light_grey = sttfont_format(FORMAT_NONE,192,192,192,255);
sttfont_format const sttfont_format::dark_red = sttfont_format(FORMAT_NONE,128,  0,  0,255);
sttfont_format const sttfont_format::dark_green = sttfont_format(FORMAT_NONE,  0,128,  0,255);
sttfont_format const sttfont_format::dark_blue = sttfont_format(FORMAT_NONE,  0,  0,128,255);
sttfont_format const sttfont_format::dark_yellow = sttfont_format(FORMAT_NONE,128,128,  0,255);
sttfont_format const sttfont_format::dark_black = sttfont_format(FORMAT_NONE,  0,  0,  0,255);
sttfont_format const sttfont_format::dark_white = sttfont_format(FORMAT_NONE,128,128,128,255);
sttfont_format const sttfont_format::dark_magenta = sttfont_format(FORMAT_NONE,128,  0,128,255);
sttfont_format const sttfont_format::dark_cyan = sttfont_format(FORMAT_NONE,  0,128,128,255);
sttfont_format const sttfont_format::dark_grey = sttfont_format(FORMAT_NONE,64,64,64,255);
int const sttfont_format::COLOUR_MODE_NORMAL;
int const sttfont_format::COLOUR_MODE_DARKEN;
int const sttfont_format::COLOUR_MODE_LIGHTEN;
sttfont_format const & sttfont_format::selectColour (int const colourMode, sttfont_format const & colourIf0, sttfont_format const & colourIf1, sttfont_format const & colourIf2)
                                                                                                                                                                           {
		if (colourMode == 1) return colourIf1;
		if (colourMode == 2) return colourIf2;
		return colourIf0;
		}
sttfont_format_reset const sttfont_format::reset;
void sttfont_format::swap (sttfont_format & other)
                                          {
		sttfont_format tmp = *this;
		*this = other;
		other = tmp;
		}
SSF_STRING sttfont_format::getTtyFormatCodeBegin () const
                                                 {
		if (!(hasFormats() || r != 255 || g != 255 || b != 255))
			return "";
		SSF_STRING rs = "\033[";
		ttyFmtWorker(rs);
		return rs + "m";
		}
SSF_STRING sttfont_format::getTtyFormatCodeEnd () const
                                               {
		if (!(hasFormats() || r != 255 || g != 255 || b != 255))
			return "";
		return "\033[0m";
		}
void sttfont_format::ttyFmtWorker (SSF_STRING & rs) const
                                                 {
		bool first = false;
		if (r != 255 || g != 255 || b != 255) {
			if (first) rs += ";";
			char arr[64];
			snprintf(arr, 63, "38;2;%i;%i;%i", r, g, b);
			rs += arr;
			first = true;
			}
		if (isBold()) {
			if (first) rs += ";";
			rs += "1";
			first = true;
			}
		if (isItaic()) {
			if (first) rs += ";";
			rs += "3";
			first = true;
			}
		if (isUnderline()) {
			if (first) rs += ";";
			rs += "4";
			first = true;
			}
		if (isStrikethrough()) {
			if (first) rs += ";";
			rs += "9";
			first = true;
			}
		}
SSF_STRING sttfont_format::debugDump () const
                                     {
		SSF_STRING rs;
		ttyFmtWorker(rs);
		return "[fmt:" + rs + "]";
		}
void sttfont_format::sttr_register ()
                                    {
		#ifdef STTR_ENABLED
		#define STTR_REGF_ALIAS(C,X,A,F) regField<C,decltype(&C::X),F>(&C::X,#A).setUserFlags(F)
		// Reflection stuff - see snappertt/sttr on github for more info. You don't need STTR to use this library
		sttr::RegNamespace & R = *sttr::getGlobalNamespace();
		R.beginClass<sttfont_format>("sttfont_format")
			.STTR_REGF(sttfont_format,r,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_format,g,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_format,b,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_format,a,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_format,format,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_format,flags,STTR_JSON_ENABLED)
			
			.STTR_REG(sttfont_format,clone)
			.STTR_REG(sttfont_format,combine)
			.STTR_REG(sttfont_format,combineWithColour)
			
			.STTR_REG(sttfont_format,setBold)
			.STTR_REG(sttfont_format,setItalic)
			.STTR_REG(sttfont_format,setUnderline)
			.STTR_REG(sttfont_format,setStrikethrough)
			.STTR_REG(sttfont_format,isBold)
			.STTR_REG(sttfont_format,isItaic)
			.STTR_REG(sttfont_format,isUnderline)
			.STTR_REG(sttfont_format,isStrikethrough)
			.STTR_REG(sttfont_format,hasFormats)
			.STTR_REG(sttfont_format,resetColour)
			
			.STTR_REGF_ALIAS(sttfont_format,colour_luasafe,colour,0)
			.STTR_REGF_ALIAS(sttfont_format,color_luasafe,color,0)
			.STTR_REG(sttfont_format,bold)
			.STTR_REG(sttfont_format,italic)
			.STTR_REG(sttfont_format,underline)
			.STTR_REG(sttfont_format,strikethrough)
			
			.STTR_REG(sttfont_format,red)
			.STTR_REG(sttfont_format,green)
			.STTR_REG(sttfont_format,blue)
			.STTR_REG(sttfont_format,yellow)
			.STTR_REG(sttfont_format,black)
			.STTR_REG(sttfont_format,white)
			.STTR_REG(sttfont_format,magenta)
			.STTR_REG(sttfont_format,cyan)
			.STTR_REG(sttfont_format,grey)
			
			.STTR_REG(sttfont_format,light_red)
			.STTR_REG(sttfont_format,light_green)
			.STTR_REG(sttfont_format,light_blue)
			.STTR_REG(sttfont_format,light_yellow)
			.STTR_REG(sttfont_format,light_black)
			.STTR_REG(sttfont_format,light_white)
			.STTR_REG(sttfont_format,light_magenta)
			.STTR_REG(sttfont_format,light_cyan)
			.STTR_REG(sttfont_format,light_grey)
			
			.STTR_REG(sttfont_format,dark_red)
			.STTR_REG(sttfont_format,dark_green)
			.STTR_REG(sttfont_format,dark_blue)
			.STTR_REG(sttfont_format,dark_yellow)
			.STTR_REG(sttfont_format,dark_black)
			.STTR_REG(sttfont_format,dark_white)
			.STTR_REG(sttfont_format,dark_magenta)
			.STTR_REG(sttfont_format,dark_cyan)
			.STTR_REG(sttfont_format,dark_grey)
			
			.STTR_REG(sttfont_format,COLOUR_MODE_NORMAL)
			.STTR_REG(sttfont_format,COLOUR_MODE_DARKEN)
			.STTR_REG(sttfont_format,COLOUR_MODE_LIGHTEN)
			.STTR_REG(sttfont_format,selectColour)
			
			.STTR_REG(sttfont_format,reset)
			
			.STTR_REG(sttfont_format,getTtyFormatCodeBegin)
			.STTR_REG(sttfont_format,getTtyFormatCodeEnd)
			.STTR_REG(sttfont_format,debugDump)
		.endClass();
		#undef STTR_REGF_ALIAS
		#endif
		}
void * sttfont_format::sttr_getClassSig () const
        { return ( void * ) sttr :: getTypeSignature < sttfont_format > ( ) ; }
char const * const sttfont_format::sttr_getClassName () const
        { return sttr :: getTypeName < sttfont_format > ( ) ; }
sttfont_formatted_text_item::sttfont_formatted_text_item ()
  : callback (0)
                                                     {}
sttfont_formatted_text_item::sttfont_formatted_text_item (SSF_STRING const & _text, sttfont_format const & _format)
  : text (_text), format (_format), callback (0)
                                                                                                                                            {}
sttfont_formatted_text_item::sttfont_formatted_text_item (SSF_STRING_MS _text, sttfont_format const & _format)
  : text (std::move(_text)), format (_format), callback (0)
                                                                                                                                                               {}
sttfont_formatted_text_item & sttfont_formatted_text_item::setCallback (sttfont_format_callback * _cb)
                                                                               { callback = _cb; return *this; }
void sttfont_formatted_text_item::setAllocator (stt::allocatorI * alloc)
                                                  {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			text.setAllocator(alloc);
		#endif
		}
void sttfont_formatted_text_item::sttr_register ()
                                    {
		#ifdef STTR_ENABLED
		sttr::RegNamespace & R = *sttr::getGlobalNamespace();
		R.beginClass<sttfont_formatted_text_item>("sttfont_formatted_text_item")
			.STTR_REGF(sttfont_formatted_text_item,text,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_formatted_text_item,format,STTR_JSON_ENABLED)
		.endClass();
		#endif
		}
void * sttfont_formatted_text_item::sttr_getClassSig () const
        { return ( void * ) sttr :: getTypeSignature < sttfont_formatted_text_item > ( ) ; }
char const * const sttfont_formatted_text_item::sttr_getClassName () const
        { return sttr :: getTypeName < sttfont_formatted_text_item > ( ) ; }
void sttfont_formatted_uipair::sttr_register ()
                                    {
		#ifdef STTR_ENABLED
		sttr::RegNamespace & R = *sttr::getGlobalNamespace();
		R.beginClass<sttfont_formatted_uipair>("sttfont_formatted_uipair")
			.STTR_REGF(sttfont_formatted_uipair,a,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_formatted_uipair,b,STTR_JSON_ENABLED)
		.endClass();
		#endif
		}
void * sttfont_formatted_uipair::sttr_getClassSig () const
        { return ( void * ) sttr :: getTypeSignature < sttfont_formatted_text_item > ( ) ; }
char const * const sttfont_formatted_uipair::sttr_getClassName () const
        { return sttr :: getTypeName < sttfont_formatted_text_item > ( ) ; }
sttfont_formatted_text::sttfont_formatted_text ()
                                {}
sttfont_formatted_text::sttfont_formatted_text (stt::allocatorI * alloc)
                                                        {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
		if (alloc)
			mItems.setAllocator(alloc);
		#endif
		}
sttfont_formatted_text::sttfont_formatted_text (sttfont_formatted_text const & obj)
                                                                   { allocatorAwareAssign(obj); }
sttfont_formatted_text::sttfont_formatted_text (SSF_STRING const & text)
                                                        { *this << text; }
sttfont_formatted_text::sttfont_formatted_text (SSF_STRING_MS text)
                                                                { *this << text; }
sttfont_formatted_text::sttfont_formatted_text (char const * text)
                                                                { *this << text; }
sttfont_formatted_text::sttfont_formatted_text (char const * text, uint32_t const maxLen)
                                                                         { appendCBuff(text, maxLen); }
sttfont_formatted_text::sttfont_formatted_text (sttfont_formatted_text_item_MS text)
                                                                                        { allocatorAwareAppendMv(std::move(text)); }
sttfont_formatted_text::sttfont_formatted_text (sttfont_formatted_text_item const & text)
                                                                                { allocatorAwareAppend(text); }
sttfont_formatted_text::sttfont_formatted_text (sttfont_formatted_text_MS obj)
                                                             { allocatorAwareAssignMv(std::move(obj)); }
sttfont_formatted_text & sttfont_formatted_text::operator = (sttfont_formatted_text_MS obj)
                                                                          { allocatorAwareAssignMv(std::move(obj)); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator = (sttfont_formatted_text const & obj)
                                                                               { allocatorAwareAssign(obj); return *this; }
void sttfont_formatted_text::resetFormat ()
                           { activeFormat = sttfont_format(); }
sttfont_formatted_text & sttfont_formatted_text::operator << (SSF_STRING_VIEW const & text)
                                                                                        { append_plaintext_BUF(text.data(), text.length(), &activeFormat); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator << (SSF_STRING const & text)
                                                                        { append_plaintext_str(text, &activeFormat); resetFormat(); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator << (SSF_STRING_MS text)
                                                                                { append_plaintext_MS(std::move(text), &activeFormat); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator << (char const * text)
                                                                                { appendCBuff(text, -1); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator += (SSF_STRING_VIEW const & text)
                                                                                        { append_plaintext_BUF(text.data(), text.length(),  &activeFormat); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator += (SSF_STRING const & text)
                                                                        { append_plaintext_str(text, &activeFormat); resetFormat(); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator += (SSF_STRING_MS text)
                                                                                { append_plaintext_MS(std::move(text), &activeFormat); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator += (char const * text)
                                                                                        { appendCBuff(text, -1); resetFormat(); return *this;  }
sttfont_formatted_text & sttfont_formatted_text::operator << (sttfont_format const & format)
                                                                                        { activeFormat.combine(format); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator << (sttfont_format_reset const & reset)
                                                                                        { resetFormat(); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator << (sttfont_formatted_text_item const & obj)
                                                                                      { allocatorAwareAppend(obj); return *this; }
sttfont_formatted_text & sttfont_formatted_text::operator << (sttfont_formatted_text_item_MS obj)
                                                                                        { allocatorAwareAppendMv(std::move(obj)); return *this; }
sttfont_formatted_text & sttfont_formatted_text::appendCBuff (char const * text, uint32_t const maxLen)
                                                                                      {
		const char* p = text;
		while (*p) p++;
		uint32_t len = (p - text);
		if (len > maxLen) len = maxLen;
		append_plaintext_BUF(text, len, NULL);
		return *this;
		}
void sttfont_formatted_text::allocatorAwareAppend (sttfont_formatted_text_item const & obj)
                                                                           {
		// appends into this using this' allocator
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			sttfont_formatted_text_item tmp;
				setCustomAllocatorForTextItem(tmp);
			tmp = obj; // copy into custom allocated memory
			mItems.push_back(std::move(tmp));
		#else
			mItems.push_back(obj);
		#endif
		}
void sttfont_formatted_text::allocatorAwareAppendMv (sttfont_formatted_text_item_MS obj)
                                                                        {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			if (mItems.getCustomAllocator())
				return allocatorAwareAppend(obj);
		#else
			mItems.push_back(std::move(obj));
		#endif
		}
void sttfont_formatted_text::allocatorAwareAssign (sttfont_formatted_text const & other)
                                                                       {
		// copies other's data -> this, keeping this' allocator
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			stt::allocatorI * a = mItems.getCustomAllocator();
			if (a)
				return copyInterned(a, *this, other, false);
		#endif
		mItems = other.mItems;
		activeFormat = other.activeFormat;
		}
void sttfont_formatted_text::allocatorAwareAssignMv (sttfont_formatted_text_MS other)
                                                                     {
		// moving other -> this, keeping this' allocator
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			if (mItems.getCustomAllocator())
				return allocatorAwareAssign(other);
			//if (other.mItems.getCustomAllocator())
			//	mItems = std::move(other.items); // stt::vector(stt::vector&&) will auto-move allocator
		#endif
		mItems = std::move(other.mItems);
		activeFormat = other.activeFormat;
		}
void sttfont_formatted_text::sttr_register ()
                                    {
		#ifdef STTR_ENABLED
		#define STTR_REGF_ALIAS(C,X,A,F) regField<C,decltype(&C::X),F>(&C::X,#A).setUserFlags(F)
		
		sttr::RegNamespace & R = *sttr::getGlobalNamespace();
		R.beginClass<sttfont_formatted_text>("sttfont_formatted_text")
			.STTR_REGF(sttfont_formatted_text,mItems,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_formatted_text,activeFormat,STTR_JSON_ENABLED)
			.STTR_REGF(sttfont_formatted_text,swap,0)
			.STTR_REGF(sttfont_formatted_text,copy,0)
			.STTR_REGF(sttfont_formatted_text,size,0)
			.STTR_REGF(sttfont_formatted_text,length,0)
			.STTR_REGF(sttfont_formatted_text,isEmpty,0)
			.STTR_REGF(sttfont_formatted_text,getString,0)
			.STTR_REGF(sttfont_formatted_text,getTtyString,0)
			.STTR_REGF(sttfont_formatted_text,getStringTruncated,0)
			.STTR_REGF(sttfont_formatted_text,append_luasafe,0)
			.STTR_REGF(sttfont_formatted_text,append_plaintext_str,0)
			.STTR_REGF(sttfont_formatted_text,clear,0)
			.STTR_REGF(sttfont_formatted_text,overrideColour,0)
			.STTR_REGF(sttfont_formatted_text,consolidateSegments,0)
			.STTR_REGF(sttfont_formatted_text,back,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,getIndexAt_luasafe,getIndexAt,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,utf8_charsizeAt_luasafe,utf8_charsizeAt,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,insert_luasafe,insert,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,remove_luasafe,remove,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,substr_luasafe,substr,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,extract_luasafe,extract,0)
			.STTR_REGF_ALIAS(sttfont_formatted_text,tokenise_luasafe,tokenise,0)
			
			
		.endClass();
		#undef STTR_REGF_ALIAS
		#endif
		}
void * sttfont_formatted_text::sttr_getClassSig () const
        { return ( void * ) sttr :: getTypeSignature < sttfont_formatted_text > ( ) ; }
char const * const sttfont_formatted_text::sttr_getClassName () const
        { return sttr :: getTypeName < sttfont_formatted_text > ( ) ; }
void sttfont_formatted_text::setAllocator (stt::allocatorI * alloc)
                                                   {
		// For use with stt-stl
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			mItems.setAllocator(alloc);
		#endif
		}
void sttfont_formatted_text::setCustomAllocatorForTextItem (sttfont_formatted_text_item & ti)
                                                                             {
		// Internal function that propgoates mItem.sso.d.store.mAllocator to any text its
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			stt::allocatorI* alloc = mItems.getCustomAllocator();
			if (alloc)
				ti.setAllocator(alloc);
		#endif
		}
void sttfont_formatted_text::copyInterned (stt::allocatorI * alloc, sttfont_formatted_text & dst, sttfont_formatted_text const & src, bool const internStrings)
                                                                                                                                                      {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			// copies to an empty container which will use allocator alloc
			// strings within this item can be optionally marked as interned
			assert(dst.isEmpty());
			assert(alloc);
			
			dst.mItems.setAllocator(alloc);
			uint32_t nItems = src.mItems.size();
			dst.mItems.resize(nItems);
			for (uint32_t i = 0; i < nItems; ++i) {
				dst.mItems[i].text.setAllocator(alloc);
				dst.mItems[i].text = src.mItems[i].text;
				if (internStrings)
					dst.mItems[i].text.markInterned(); // do not deallocate through destructor
				dst.mItems[i].format = src.mItems[i].format;
				}
			dst.activeFormat = src.activeFormat;
		#else
			// copy
			dst = src;
		#endif
		}
void sttfont_formatted_text::markInterned ()
                            {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
		// marks all elements as interned
			uint32_t nItems = mItems.size();
			for (uint32_t i = 0; i < nItems; ++i)
				mItems[i].text.markInterned();
			mItems.markInterned();
		#endif
		}
sttfont_formatted_text sttfont_formatted_text::copy () const
                                            {
		// Explicit copy - named function
		sttfont_formatted_text r = *this;
		return r;
		}
void sttfont_formatted_text::swap (sttfont_formatted_text & other)
                                                  {
		other.mItems.swap(mItems);
		other.activeFormat.swap(activeFormat);
		}
size_t sttfont_formatted_text::size () const
                            {
		/// Combined length of all the segments
		size_t workingLen = 0;
		for (unsigned int  i = 0; i < mItems.size(); ++i ) {
			workingLen += mItems[i].text.size();
			}
		return workingLen;
		}
size_t sttfont_formatted_text::length () const
                              { return size(); }
bool sttfont_formatted_text::isEmpty () const
                             {
		/// Returns true if there are no segments, or there are only empty segments
		/// Ie, returns true if this contains no characters
		if (!mItems.size()) return true;
		//if (mItems.size() == 1) return !mItems[0].text.size();
		for (sttfont_formatted_text_item item : mItems)
			if (item.text.size()) return false;
		return true; // none of the elements have text
		}
SSF_STRING sttfont_formatted_text::getString () const
                                     {
		/// Returns a plain unformatted string of all the segments stitched together
		SSF_STRING r;
		r.reserve(size());
		for (unsigned int  i = 0; i < mItems.size(); ++i ) {
			r += mItems[i].text;
			}
		return r;
		}
SSF_STRING sttfont_formatted_text::getTtyString () const
                                        {
		/// Returns a string of all the segments linked together with Tty format codes applied
		SSF_STRING r;
		r.reserve(size() + mItems.size()*32);
		for (unsigned int  i = 0; i < mItems.size(); ++i ) {
			r += mItems[i].format.getTtyFormatCodeBegin();
			r += mItems[i].text;
			r += mItems[i].format.getTtyFormatCodeEnd();
			}
		return r;
		}
SSF_STRING sttfont_formatted_text::getStringTruncated (unsigned int const maxLen) const
                                                                       {
		/// Returns a plain unformatted string of all the segments stitched together, cut to max len
		SSF_STRING r;
		r.reserve(size());
		for (unsigned int  i = 0; i < mItems.size(); ++i ) {
			r += mItems[i].text;
			if (r.size() > maxLen) {
				if (maxLen > 3)
					return r.substr(0, maxLen-3)+"...";
				return r.substr(0, maxLen);
				}
			}
		return r;
		}
void sttfont_formatted_text::append_luasafe (sttfont_formatted_text const & obj)
                                                                {
		/// Appends a sttfont_formatted_text to this
		if (obj.mItems.size() == 1 && mItems.size()) {
			if (mItems[mItems.size()-1].format == obj.mItems[0].format) {
				mItems[mItems.size()-1].text += obj.mItems[0].text;
				return;
				}
			}
		activeFormat = obj.activeFormat;
		#if SSF_STT_STL_ALLOCATOR_ENABLED
		stt::allocatorI* a = mItems.getCustomAllocator();
		if (a) {
			uint32_t szInit = mItems.size();
			uint32_t otherSz = obj.mItems.size();
			if (!otherSz) return;
			mItems.resize(szInit + otherSz);
			for (uint32_t i = 0; i < otherSz; ++i) {
				mItems[szInit+i].text.setAllocator(a);
				mItems[szInit+i].text = obj.mItems[i].text;
				mItems[szInit+i].format = obj.mItems[i].format;
				}
			return;
			}
		#endif
		mItems.insert(mItems.end(), obj.mItems.begin(), obj.mItems.end());
		}
void sttfont_formatted_text::append_plaintext_MS (SSF_STRING_MS str, sttfont_format const * fmt)
                                                                                {
		/// Appends a plaintext string with optional formatting
		/// if fmt is NULL then use activeFormat
		/// if fmt matches the format of the last segment then append to the last segment
		/// if not create a new segment with the specified text and format
		if (!fmt)
			return append_plaintext_MS(std::move(str), &activeFormat);
		const uint32_t sz = mItems.size();
		if (sz) {
			if (mItems[sz-1].format == *fmt) {
				mItems[sz-1].text.append(str);
				return;
				}
			}
		sttfont_formatted_text_item ti;
			setCustomAllocatorForTextItem(ti);
		ti.text = std::move(str);
		ti.format = *fmt;
		mItems.push_back(std::move(ti));
		}
void sttfont_formatted_text::append_plaintext_BUF (char const * str, uint32_t const len, sttfont_format const * fmt)
                                                                                                   {
		if (!fmt)
			return append_plaintext_BUF(str, len, &activeFormat);
		const uint32_t sz = mItems.size();
		if (sz) {
			if (mItems[sz-1].format == *fmt) {
				mItems[sz-1].text.append(str, len);
				return;
				}
			}
		sttfont_formatted_text_item ti;
			setCustomAllocatorForTextItem(ti);
		ti.text.append(str, len);
		ti.format = *fmt;
		#if SSF_STT_STL_ALLOCATOR_ENABLED
		// for debugging spurrious copies
		//	stt::stt_dbg_log("append_plaintext_BUF, allocators: %p %p, [%s]", mItems.getCustomAllocator(), ti.text.getCustomAllocator(), str);
		//	if (strcmp("Render Thread", str) == 0 && !mItems.getCustomAllocator())
		//		abort();
		#endif
		mItems.push_back(std::move(ti));
		}
void sttfont_formatted_text::append (sttfont_formatted_text_MS obj)
                                                   {
		#if SSF_STT_STL_ALLOCATOR_ENABLED
			if (mItems.getCustomAllocator()) {
				return append_luasafe(obj); //copy into allocator
				}
		#endif
		if (obj.mItems.size() == 1 && mItems.size()) {
			if (mItems[mItems.size()-1].format == obj.mItems[0].format) {
				mItems[mItems.size()-1].text += std::move(obj.mItems[0].text);
				return;
				}
			}
		mItems.insert(mItems.end(), std::make_move_iterator(obj.mItems.begin()), std::make_move_iterator(obj.mItems.end()));
		activeFormat = obj.activeFormat;
		}
void sttfont_formatted_text::clear ()
                     {
		*this = sttfont_formatted_text();
		}
void sttfont_formatted_text::overrideColour_worker (sttfont_format const & fmt, bool const force)
                                                                                 {
		for (sttfont_formatted_text_item & sfti : mItems) {
			if (force || !(sfti.format.flags & sttfont_format::FORMAT_FLAGS_COLOUR_SET)) {
				uint8_t nfmt  = fmt.format | sfti.format.format;
				uint8_t nflg  = fmt.flags;
				sfti.format = fmt;
				sfti.format.format = nfmt;
				sfti.format.flags  = nflg;
				}
			}
		}
void sttfont_formatted_text::overrideColour (sttfont_format const & fmt)
                                                        {
		/// If any pieces do not have their colour set, then override the default colour to @fmt's colour
		overrideColour_worker(fmt, false);
		}
void sttfont_formatted_text::forceOverrideColour (sttfont_format const & fmt)
                                                             {
		/// Force override colour in all segments
		overrideColour_worker(fmt, true);
		}
void sttfont_formatted_text::consolidateSegments ()
                                   {
		/// "Cleans" up this object by merging adjacent items if they have
		/// the same format, and removes empty segments
		
		// Strip empty segments
		for (unsigned int  i = mItems.size() - 1; i < mItems.size(); --i ) {
			if (!mItems[i].text.size())
				mItems.erase(mItems.begin() + i + 1);
			}
		size_t szStart;
		size_t szEnd;
		do {
			szStart = mItems.size();
			consolidateSegments_worker();
			szEnd = mItems.size();
			}
		while (szEnd < szStart);
		}
void sttfont_formatted_text::consolidateSegments_worker ()
                                          {
		/// "Cleans" up this object by merging adjacent items if they have the same format
		/// Removes empty segments
		for (unsigned int  i = mItems.size() - 2; i < mItems.size(); --i ) {
			if (mItems[i].format == mItems[i+1].format) {
				mItems[i].text += mItems[i+1].text;
				mItems.erase(mItems.begin() + i + 1);
				}
			}
		
		}
bool sttfont_formatted_text::back (unsigned int const num)
                                          {
		/// Removes @num bytes from the end of this
		/// Returns true if changed
		unsigned int nToRemove = num;
		for (unsigned int  i = mItems.size() - 1; i < mItems.size(); --i ) {
			if ( mItems[i].text.size() <= nToRemove) {
				nToRemove -= mItems[i].text.size();
				mItems.erase(mItems.begin() + i);
				if (nToRemove == 0 || i == 0) {
					return true;
					}
				}
			else {
				SSF_STRING& s = mItems[i].text;
				s = s.erase(s.length()-nToRemove);
				return true;
				}
			}
		return false;
		}
sttfont_formatted_uipair sttfont_formatted_text::getIndexAt_luasafe (unsigned int const position, sttfont_lookupHint * mHint) const
                                                                                                                   {
		sttfont_formatted_uipair r;
		getIndexAt(position, r.a, r.b, mHint);
		return r;
		}
void sttfont_formatted_text::getIndexAt (unsigned int const position, unsigned int & indexOut, unsigned int & localPosOut, sttfont_lookupHint * mHint) const
                                                                                                                                                 {
		/// Returns the segment index and position within the segment of a character position
		/// A hint can be used to prevent itterating over the whole thing
		/// Hint is updated if mHint->writeOut is true
		indexOut = -1;
		localPosOut = -1;
		
		unsigned int start = 0;		
		unsigned int workingLen = 0;
		
		if (mHint) {
			if (position >= mHint->workingLen) {
				start = mHint->index;
				workingLen = mHint->workingLen;
				}
			else {
				// Uncomment below to test for useless hints
				//std::cout << "Hint is useless!: " << position << " " << mHint->workingLen << std::endl;
				}
			}
		
		for (unsigned int  i = start; i < mItems.size(); ++i ) {
			if (mItems[i].text.size() + workingLen > position && workingLen <= position) {
				indexOut = i;
				localPosOut = position - workingLen;
				
				if (mHint) {
					if (mHint->writeOut) {
						mHint->index = i;
						mHint->workingLen = workingLen;
						}
					}
				
				return;
				}
			workingLen += mItems[i].text.size();
			}
		}
sttfont_formatted_uipair sttfont_formatted_text::utf8_charsizeAt_luasafe (unsigned int const position, sttfont_lookupHint * mHint)
                                                                                                                  {
		sttfont_formatted_uipair r;
		utf8_charsizeAt(position, r.a, r.b, mHint);
		return r;
		}
void sttfont_formatted_text::utf8_charsizeAt (unsigned int const position, unsigned int & posOut, unsigned int & sizeOut, sttfont_lookupHint * mHint)
                                                                                                                                            {
		/// At @position, what is the character size? Returns this in @sizeOut
		/// If this is in the middle of a character, return the position of the start of the character in @posOut
		posOut = position;
		sizeOut = 0;
		
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) return; // not found
		
		// Lookup to 3 characters back and get the charSize
		for (unsigned int lookup = 0; lookup <= offset;) {
			int thisSz = sttfont_font_cache::utf8_charsize(&mItems[index].text[lookup]);
			
			//std::cout << "Lookup utf8_charsizeAt " << lookup << " " << thisSz
			//		<< " char[" << mItems[index].text.substr(lookup, thisSz) << "] " << offset << std::endl;
			
			if (thisSz + lookup > offset) {				
				//std::cout << "Out! size: " << thisSz << std::endl;
				posOut = lookup + position - offset;
				sizeOut = thisSz;
				return;
				}
			if (thisSz)
				lookup += thisSz;
			else
				lookup++;
			}
		}
void sttfont_formatted_text::insert (unsigned int const position, SSF_STRING const & str, sttfont_lookupHint * mHint)
                                                                                                            {
		/// Inserts @str at character position @pos
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) { *this << str; return; } // not found, append to end
		mItems[index].text.insert(offset, str);
		}
void sttfont_formatted_text::insert (unsigned int const position, SSF_STRING_MS str, sttfont_lookupHint * mHint)
                                                                                                       {
		/// Inserts @str at character position @pos. Moving version
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) { *this << std::move(str); return; } // not found, append to end
		mItems[index].text.insert(offset, std::move(str));
		}
void sttfont_formatted_text::insert_luasafe (unsigned int const position, sttfont_formatted_text const & str, sttfont_lookupHint * mHint)
                                                                                                                         {
		/// Inserts @str at character position @pos. Copying formatted text version
		if (str.mItems.size() == 0) return;
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) { append(str); return; } // not found, append to end

		if (str.mItems.size() == 1) { // Quickie - only 1 format being inserted. Do not split
			if (mItems[index].format == str.mItems[0].format) {
				mItems[index].text.insert(offset, str.mItems[0].text); return;
				}
			}
			
		sttfont_formatted_text_item after;	
			setCustomAllocatorForTextItem(after);
			after = mItems[index];
		mItems[index].text.erase(offset);
		after.text.erase(0, offset);	
		
		unsigned int strSz = str.mItems.size();
		mItems.insert(mItems.begin()+index+1, str.mItems.begin(), str.mItems.end());
		
		if (after.text.length())
			mItems.insert(mItems.begin()+index+1+strSz, std::move(after));
		}
void sttfont_formatted_text::insert (unsigned int const position, sttfont_formatted_text_MS str, sttfont_lookupHint * mHint)
                                                                                                                   {
		/// Inserts @str at character position @pos. Moving version
		if (str.mItems.size() == 0) return;
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) { append(std::move(str)); return; } // not found, append to end
		
		if (str.mItems.size() == 1) { // Quickie - only 1 format being inserted. Do not split
			if (mItems[index].format == str.mItems[0].format) {
				mItems[index].text.insert(offset, std::move(str.mItems[0].text)); return;
				}
			}
			
		sttfont_formatted_text_item after;	
			setCustomAllocatorForTextItem(after);
			after = mItems[index];
		mItems[index].text.erase(offset);
		after.text.erase(0, offset);	
		
		unsigned int strSz = str.mItems.size();
		mItems.insert(mItems.begin()+index+1, std::make_move_iterator(str.mItems.begin()), std::make_move_iterator(str.mItems.end()));
		
		if (after.text.length())
			mItems.insert(mItems.begin()+index+1+strSz, std::move(after));
		}
void sttfont_formatted_text::remove_luasafe (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint)
                                                                                                             {
		/// Removes @num characters after position num
		/// Note that if you're using hints that they might be invalid after removing text
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) return; // not found
		
		unsigned int numToRemove = num;
		
		for (unsigned int i = index; i < mItems.size(); ++i) {
			unsigned int nToRemove = mItems[i].text.size() - offset;
			if (nToRemove > numToRemove) nToRemove = numToRemove;
			
			if (nToRemove == mItems[i].text.size() && offset == 0) {
				mItems.erase(mItems.begin() + i);
				--i;
				return;
				}
			mItems[i].text.erase(offset, nToRemove);
			
			numToRemove -= nToRemove;
			offset = 0;
			}
			
		}
SSF_STRING sttfont_formatted_text::substr (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const
                                                                                                                        {
		/// Reads @num characters after @position. If num goes past the end of a string
		/// then returns the end of the string. Returns as a plain string
		/// To get a "formatted" substr use this->extract(position, num);
		SSF_STRING r;
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) return r; // not found
		
		unsigned int numToRemove = num;
		
		for (unsigned int i = index; i < mItems.size(); ++i) {
			unsigned int nToRemove = mItems[i].text.size() - offset;
			if (nToRemove > numToRemove) nToRemove = numToRemove;
			
			r += mItems[i].text.substr(offset, nToRemove);
			
			numToRemove -= nToRemove;
			offset = 0;
			}
		return r;
		}
sttfont_formatted_text sttfont_formatted_text::extract (unsigned int const position, unsigned int const num, sttfont_lookupHint * mHint) const
                                                                                                                                     {
		/// Creates a new @sttfont_formatted_text containing the segments starting at character @position and of length @num in bytes
		/// To get a std::string substring use this->substr(position, num)
		sttfont_formatted_text r;
		
		unsigned int index, offset;
		getIndexAt(position, index, offset, mHint);
		if (index >= mItems.size()) {
			return r;
			}
			
		unsigned int numToRemove = num;
		
		for (unsigned int i = index; i < mItems.size() && numToRemove; ++i) {
			unsigned int nToRemove = mItems[i].text.size() - offset;
			if (nToRemove > numToRemove) nToRemove = numToRemove;
			
			//std::cout << "extracting: " << i << " " << " offset: " << offset << ", nToRemove: " << nToRemove << "/" << numToRemove << " " << mItems[i].text.size() << std::endl;
			
			if (nToRemove == mItems[i].text.size() && offset == 0) {
				r.mItems.push_back(mItems[i]);
				}
			else {
				sttfont_formatted_text_item sfti;
				sfti.format = mItems[i].format;
				sfti.text = mItems[i].text.substr(offset, nToRemove);
				r.mItems.push_back(std::move(sfti));
				}
			//r += mItems[i].text.substr(offset, nToRemove);
			
			numToRemove -= nToRemove;
			offset = 0;
			}
		return r;
		}
void sttfont_formatted_text::tokenise (SSF_VECTOR <sttfont_formatted_text> & arrOut, uint32_t const delimiter, bool const checkQuoteMarks, uint32_t const escapeChar, bool const includeDelimiterInToken) const
                                                                                                                                                                                                                     {
		/// Breaks this into an array of sttfont_formatted_text objects
		/// tokenised by "delimter" (unless inbetween two `"` marks).
		/// An escape character negates the delimiter
		/// Handles UTF-8
		///
		/// Example usage - tokenise on newlines:
		///     vector<sttfont_formatted_text> output;
		///     input.tokenise(output, '\n', true, '\\');
		///
		const sttfont_formatted_text & stringIn = *this;
		
		bool open = false;
		bool escape = false;
		
		uint32_t segmentStart = 0;	// The start of the working token
		uint32_t workingPos = 0;	// The cumulative positon along the string
		uint32_t offset = 0;		// A small offset to prevent including the token character in the extracted strings
		
		uint32_t workingPosLastStart = 0;
		uint32_t siLastStart = 0;
		
		uint32_t delimiterSize = 1;
		if (delimiter > 0x007F) delimiterSize = 2;
		if (delimiter > 0x07FF) delimiterSize = 3;
		if (delimiter > 0xFFFF) delimiterSize = 4;
		
		for (size_t si = 0; si < stringIn.mItems.size(); ++si) {
			const SSF_STRING & s = stringIn.mItems[si].text;
			uint32_t seek = 0;
			const uint32_t len = s.length();
			
			while (seek < len) {
				const uint32_t seekBefore = seek;
				uint32_t uChar = sttfont_font_cache::utf8_read(&s[seek], seek, len);
				
				if (escape) {
					escape = false;
					continue;
					}
			
				if (uChar == escapeChar) {
					// Add the next charcter in regardless
					escape = true;
					continue;
					}
				if (uChar != delimiter || open) {
					if (uChar != '"' || !checkQuoteMarks) {
						// No-op
						}
					else {
						open = !open;
						}
					}
				else {
					sttfont_lookupHint mHint;
						mHint.index = siLastStart;
						mHint.workingLen = workingPosLastStart;
						
					if (includeDelimiterInToken)
						workingPos+=delimiterSize;
						
					workingPosLastStart = workingPos;
					siLastStart = si;
					
					sttfont_formatted_text d = stringIn.extract(segmentStart + offset, (workingPos + seekBefore) - segmentStart - offset, &mHint);
					segmentStart = workingPos + seekBefore;
					offset = sttfont_font_cache::utf8_charsize(uChar); // Used to skip including the newline
					arrOut.push_back(std::move(d));
					}
				}
			workingPos += len;
			}
		
		sttfont_lookupHint mHint;
			mHint.index = siLastStart;
			mHint.workingLen = workingPosLastStart;
		sttfont_formatted_text d = stringIn.extract(segmentStart + offset, -1, &mHint);
		arrOut.push_back(std::move(d));
		}
void sttfont_uint32_t_range::populateRangesLatin (SSF_VECTOR <sttfont_uint32_t_range> & mRanges)
                                                                                       {
		sttfont_uint32_t_range r;
		r.start = 0x20;
		r.end  = 0xff;
		mRanges.push_back(r);
		}
void sttfont_uint32_t_range::populateRangesCyrillic (SSF_VECTOR <sttfont_uint32_t_range> & mRanges)
                                                                                          {
		sttfont_uint32_t_range r;
		r.start = 0x0400; r.end  = 0x052F; // Cyrillic + Cyrillic Supplement
		mRanges.push_back(r);
		r.start = 0x2DE0; r.end  = 0x2DFF; // Cyrillic Extended-A
		mRanges.push_back(r);
		r.start = 0xA640; r.end  = 0xA69F; // Cyrillic Extended-B
		mRanges.push_back(r);
		}
sttfont_prerendered_text::sttfont_prerendered_text ()
  : width (0), height (0)
                                                          {}
sttfont_prerendered_text::~ sttfont_prerendered_text ()
                                            {}
void sttfont_prerendered_text::freeTexture ()
                                   {
		// Make your own implmentation for your own frontend here
		// Used to clear any resources held here
		}
int sttfont_prerendered_text::draw (int const x, int const y)
                                                    { return x + width; }
int sttfont_prerendered_text::drawWithColorMod (int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                         {
		return x + width;
		}
int sttfont_prerendered_text::draw (sttfont_font_cache * fc, int const x, int const y)
                                                                           { return draw(x, y); }
int sttfont_prerendered_text::drawWithColorMod (sttfont_font_cache * fc, int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                                           { return drawWithColorMod(x,y,r,g,b,a); }
sttfont_glyph::sttfont_glyph ()
  : advance (0), leftSideBearing (0), width (0), height (0), xOffset (0), yOffset (0)
                                                                                                       {}
void sttfont_memory::alloc (size_t const _size)
                                       {
		data = SSF_NEW_ARR(char, _size);
		size = _size;
		ownsData = true;
		}
void sttfont_memory::transferTo (sttfont_memory & destination)
                                                      {
		destination.data = data;
		destination.size = size;
		destination.ownsData = ownsData;
		ownsData = false;
		}
void sttfont_memory::cloneTo (sttfont_memory & other)
                                            {
		other.alloc(size);
		memcpy(other.data, data, size);
		other.ownsData = true;
		}
sttfont_memory::sttfont_memory ()
  : data (NULL), size (0), ownsData (false)
                                                                 {}
sttfont_memory::~ sttfont_memory ()
                           {
		if (ownsData) {
			SSF_DEL_ARR(data);
			data = NULL;
			}
		}
sttfont_font_list::sttfont_font_list ()
  : format (0), next (NULL)
                                                    {}
sttfont_font_list::~ sttfont_font_list ()
                             {
		for (sttfont_font_list * fl : mFormatedVariants)
			delete fl;
		if (next) delete next;
		}
void sttfont_font_list::fetchFontForCodepoint (uint32_t const codepoint, uint8_t const format, stbtt_fontinfo * * mFontOut, int * indexOut)
                                                                                                                               {
		sttfont_font_list * working = this;
		
		*mFontOut = NULL;
		*indexOut = 0;
		
		while (working) {
			int index = stbtt_FindGlyphIndex(&(working->mFont), codepoint);
			if (index) {
				// Check for format in the variants
				if (format) {
					int bestBitsCount = 0;
					sttfont_font_list * bestMatch = NULL;
					sttfont_font_list * bestMatch2 = NULL;
					for (sttfont_font_list * f : mFormatedVariants) {
						uint8_t mask = (format & f->format);
						if (mask) {
							int nBits = 0;
							for (int i = 0; i < 7; ++i)
								if (mask & (1 << i)) nBits++;
							if (nBits > bestBitsCount) {
								bestBitsCount = nBits;
								bestMatch2 = bestMatch;
								bestMatch = f;
								}
							}
						}
					
					if (bestMatch) {
						int index2 = stbtt_FindGlyphIndex(&(bestMatch->mFont), codepoint);
						*mFontOut = &(bestMatch->mFont);
						*indexOut = index2;
						return;
						}
					if (bestMatch2) {
						int index2 = stbtt_FindGlyphIndex(&(bestMatch2->mFont), codepoint);
						*mFontOut = &(bestMatch2->mFont);
						*indexOut = index2;
						return;
						}
					}
				
				// Format not found/no format
				*mFontOut = &(working->mFont);
				*indexOut = index;
				return;
				}
			working = working->next;
			}
		}
sttfont_font_cache::sttfont_font_cache ()
  : ascent (0), descent (0), lineGap (0), baseline (0), rowSize (0), tabWidth (1), scale (1.f), underlineThickness (1.0), strikethroughThickness (1.0), underlinePosition (0.0), strikethroughPosition (0.0), faceSize (20), tabWidthInSpaces (8), userData (NULL)
                                                                  {}
sttfont_font_cache::~ sttfont_font_cache ()
                                       {}
void sttfont_font_cache::setFaceSize (int const _faceSize)
                                              { faceSize = _faceSize; }
int sttfont_font_cache::getScaledRowSize () const
                                      { return scale * rowSize; }
void sttfont_font_cache::syncFrom (sttfont_font_cache const & other)
                                                        {
		tabWidth = other.tabWidth;
		faceSize = other.faceSize;
		tabWidthInSpaces = other.tabWidthInSpaces;
		}
void sttfont_font_cache::loadFont (char const * ttf_buffer, int index)
                                                               {
		stbtt_InitFont(&mFont.mFont, (const unsigned char *) ttf_buffer, stbtt_GetFontOffsetForIndex((const unsigned char *) ttf_buffer,index));
		stbtt_GetFontVMetrics(&mFont.mFont, &ascent, &descent, &lineGap);
		
		scale = stbtt_ScaleForPixelHeight(&mFont.mFont, faceSize);
		baseline = ascent*scale;
		rowSize = ascent - descent + lineGap;
		
		strikethroughThickness = faceSize/20.0;
		if (strikethroughThickness < 1) strikethroughThickness = 1;
		strikethroughPosition = baseline * 0.75 - strikethroughThickness/2;
		underlineThickness = strikethroughThickness;
		underlinePosition = baseline + underlineThickness;
		
		int w,h;
		getTextSize(w,h,"                                                                                                                                ", tabWidthInSpaces <= 128 ? tabWidthInSpaces : 128);
		tabWidth = w;
		if (tabWidth < 1) tabWidth = 1;
		}
void sttfont_font_cache::loadFontManaged (sttfont_memory & memory, int index)
                                                                      {
		memory.transferTo(mFont.mMemory);
		loadFont(mFont.mMemory.data, index);
		}
void sttfont_font_cache::addFont (char const * ttf_buffer, int index)
                                                              {
		addFontWrap afw(ttf_buffer);
		afw.index = index;
		addFont_worker(afw, false);
		}
void sttfont_font_cache::addFontManaged (sttfont_memory & memory, int index)
                                                                     {
		addFontWrap afw(NULL);
		afw.memory = &memory;
		afw.index = index;
		addFont_worker(afw, false);
		}
void sttfont_font_cache::addFormatFont (uint8_t formatMask, char const * ttf_buffer, int index)
                                                                                        {
		addFontWrap afw(ttf_buffer);
		afw.index = index;
		addFont_worker(afw, true, formatMask);
		}
void sttfont_font_cache::addFormatFontManaged (uint8_t formatMask, sttfont_memory & memory, int index)
                                                                                               {
		addFontWrap afw(NULL);
		afw.memory = &memory;
		afw.index = index;
		addFont_worker(afw, true, formatMask);
		}
sttfont_font_cache::addFontWrap::addFontWrap (char const * c)
  : ttf_buffer (c), memory (NULL), index (0)
                                                                                     {}
void sttfont_font_cache::addFont_worker (addFontWrap & fwm, bool isFormatVariant, uint8_t formatMask)
                                                                                             { 
		sttfont_font_list * n = SSF_NEW(sttfont_font_list);
		sttfont_font_list * w = &mFont;
		while (w->next)
			w = w->next;
		n->format = formatMask;
		
		if (fwm.memory) {
			sttfont_memory & memory = *(fwm.memory);
			memory.transferTo(n->mMemory);
			stbtt_InitFont(&n->mFont, (const unsigned char *) n->mMemory.data, stbtt_GetFontOffsetForIndex((const unsigned char *) n->mMemory.data,fwm.index));
			}
		else {
			stbtt_InitFont(&n->mFont, (const unsigned char *) fwm.ttf_buffer, stbtt_GetFontOffsetForIndex((const unsigned char *) fwm.ttf_buffer,fwm.index));
			}
		if (isFormatVariant)
			w->mFormatedVariants.push_back(n);
		else
			w->next = n;
		}
void sttfont_font_cache::genGlyph (uint32_t const codepoint, uint8_t const format, sttfont_glyph * gOut, unsigned char * * bitmapOut)
                                                                                                                                {
		// Fetch font and index - existance check for glyph in font
		stbtt_fontinfo * mFontContaining;
		int mIndex;
		mFont.fetchFontForCodepoint(codepoint, format, &mFontContaining, &mIndex);
		
		if (!mIndex)
			return;
		
		// found the font! generate the glyph
	   	unsigned char *bitmap;
	   	int w,h,woff,hoff;
		bitmap = stbtt_GetCodepointBitmap(mFontContaining, 0, scale, codepoint, &w, &h, &woff, &hoff);
		
        // Convert bitmap to RGBA
		unsigned int sz = w*h;
		if (sz) {
			if (bitmapOut) {
				//memcpy, the frontend will bulk store glyphs
				(*bitmapOut) = SSF_NEW_ARR(unsigned char,sz*4);
				unsigned char* bitmap2 = *bitmapOut;

				for (unsigned int i = 0; i < sz; ++i) {
					bitmap2[i*4+0] = 255;
					bitmap2[i*4+1] = 255;
					bitmap2[i*4+2] = 255;
					bitmap2[i*4+3] = bitmap[i];
					}
				}
			else {
				// wirte single character directly
				unsigned char bitmap2[sz*4];
				for (unsigned int i = 0; i < sz; ++i) {
					bitmap2[i*4+0] = 255;
					bitmap2[i*4+1] = 255;
					bitmap2[i*4+2] = 255;
					bitmap2[i*4+3] = bitmap[i];
					}
				genGlyph_writeData(codepoint, gOut, bitmap2, w, h);
				}
			}
        
			
        stbtt_FreeBitmap (bitmap, 0);
		
		gOut->width = w;
		gOut->height = h;
		stbtt_GetCodepointHMetrics(mFontContaining, codepoint, &gOut->advance, &gOut->leftSideBearing);
		
		gOut->xOffset = woff;
		gOut->yOffset = hoff;
		}
void sttfont_font_cache::pregenGlyphs (SSF_VECTOR <sttfont_uint32_t_range> & mRanges, uint8_t const format)
                                                                                                      {
		// Make your own implmentation for your own frontend here
		for (const sttfont_uint32_t_range & r : mRanges) {
			for (uint32_t codepoint = r.start; codepoint <= r.end; ++codepoint) {
				uint64_t target = codepoint | (uint64_t(format) << 32);
				genGlyph_createAndInsert(target, codepoint, format);
				}
			}
		}
void sttfont_font_cache::genGlyph_writeData (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h)
                                                                                                                                {
		// Make your own implmentation for your own frontend here
		}
sttfont_glyph * sttfont_font_cache::getGlyph (uint64_t const target)
                                                                {
		// Make your own implmentation for your own frontend here
		return NULL;
		}
sttfont_glyph * sttfont_font_cache::getGenGlyph (uint32_t const codepoint, uint8_t const format)
                                                                                    {
		uint64_t target = codepoint | (uint64_t(format) << 32);
		sttfont_glyph * r = getGlyph(target);
		if (r) return r;
		return genGlyph_createAndInsert(target, codepoint, format);
		}
sttfont_glyph * sttfont_font_cache::genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format)
                                                                                                                                {
		// Make your own implmentation for your own frontend here
		return getGlyph(target);
		}
int sttfont_font_cache::getKerningAdvance (uint32_t const cp1, uint32_t const cp2)
                                                                      {
		return stbtt_GetCodepointKernAdvance(&mFont.mFont, cp1, cp2);
		}
int sttfont_font_cache::utf8_charsize (char const * c)
                                                {
		if (!c) return 0;
		if ((uint8_t)*c <= 0x7F) return 1;
		else if ((uint8_t)*c <= 0xE0) return 2;
		else if ((uint8_t)*c <= 0xF0) return 3;
		else
			return 4;
		}
int sttfont_font_cache::utf8_charsize (uint32_t const codepoint)
                                                           {
		if ((codepoint & 0x000000ff) == codepoint) return 1;
		if ((codepoint & 0x0000ffff) == codepoint) return 2;
		if ((codepoint & 0x00ffffff) == codepoint) return 3;
		return 4;
		}
uint32_t sttfont_font_cache::utf8_read (char const * c, uint32_t & seek, uint32_t const maxLen)
                                                                                         {
		if (!c) return 0;
		int chsz = utf8_charsize(c);
		seek += chsz;
	
		if (seek > maxLen) {
			return *c; //Buffer overflow - stop to be safe!
			}
			
		if (chsz == 1) return *c;		
		if (chsz == 2)
			return (((uint32_t((uint8_t) c[0] & 0b00111111) << 6)) | uint32_t((uint8_t) c[1] & 0b00111111));
		if (chsz == 3)
			return (uint32_t((uint8_t) c[0] & 0b00011111) << 12) | (uint32_t((uint8_t) c[1] & 0b00111111) << 6) | uint32_t((uint8_t) c[2] & 0b00111111);
		return (uint32_t((uint8_t) c[0] & 0b00001111) << 18) | (uint32_t((uint8_t) c[1] & 0b00111111) << 12) | (uint32_t((uint8_t) c[2] & 0b00111111) << 6) | uint32_t((uint8_t) c[3] & 0b00111111);
		}
int sttfont_font_cache::drawText (int const x, int const y, char const * c, uint32_t const maxLen)
                                                                                           {
		return processString(x, y, c, maxLen, NULL, true);
		}
int sttfont_font_cache::drawText (int const x, int const y, SSF_STRING const & str)
                                                                        {
		return drawText(x,y,str.data(),str.size());
		}
int sttfont_font_cache::drawText (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen)
                                                                                                                        {
		return processString(x, y, c, maxLen, &format, true);
		}
int sttfont_font_cache::drawText (int const x, int const y, sttfont_format const format, SSF_STRING const & str)
                                                                                                     {
		return drawText(x,y,format, str.data(),str.size());
		}
int sttfont_font_cache::drawText (int const x, int const y, int & widthOut, int & heightOut, char const * c, uint32_t const maxLen)
                                                                                                                            {
		return processString(x, y, c, maxLen, NULL, true, &widthOut, &heightOut);
		}
int sttfont_font_cache::drawText (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int & widthOut, int & heightOut)
                                                                                                                                      {
		return drawText(x,y,widthOut, heightOut, format, str.data(),str.size());
		}
int sttfont_font_cache::drawText (int const x, int const y, int & widthOut, int & heightOut, sttfont_format const format, char const * c, uint32_t const maxLen)
                                                                                                                                                         {
		return processString(x, y, c, maxLen, &format, true, &widthOut, &heightOut);
		}
int sttfont_font_cache::drawText (int const x, int const y, SSF_STRING const & str, int & widthOut, int & heightOut)
                                                                                                         {
		return drawText(x,y,widthOut, heightOut, str.data(),str.size());
		}
int sttfont_font_cache::drawText (int const x, int const y, sttfont_formatted_text const & text)
                                                                                    {
		int dummyWidth, dummyHeight;
		return drawText(x, y, text, dummyWidth, dummyHeight);
		}
int sttfont_font_cache::drawText (int const x, int const y, sttfont_formatted_text const & text, int & widthOut, int & heightOut)
                                                                                                                     {
		return processFormatted(text, x, y, true, &widthOut, &heightOut);
		}
int sttfont_font_cache::getTextSize (int & w, int & h, char const * c, uint32_t const maxLen, sttfont_lookupHint * mHint, int const * const maxWidth)
                                                                                                                                                             {
		return processString(0, 0, c, maxLen, NULL, false, &w, &h, maxWidth);
		}
int sttfont_font_cache::getTextSize (int & w, int & h, SSF_STRING const & str, sttfont_lookupHint * mHint, int const * const maxWidth)
                                                                                                                                         {
		return processString(0, 0, str.data(), str.size(), NULL, false, &w, &h, maxWidth, mHint);
		}
int sttfont_font_cache::getTextSize (int & w, int & h, sttfont_formatted_text const & str, sttfont_lookupHint * mHint, int const * const maxWidth)
                                                                                                                                                     {
		return processFormatted(str, 0, 0, false, &w, &h, maxWidth, mHint);
		}
int sttfont_font_cache::countNewlines (SSF_STRING const & str)
                                                  {
		int n = 0;
		
		uint32_t seek = 0;
		const uint32_t len = str.length();
		while (seek < len) {
			uint32_t uChar = sttfont_font_cache::utf8_read(&str[seek], seek, len);
			if (uChar == uint32_t('\n')) n++;
			}
		return n;
		}
int sttfont_font_cache::getNumberOfRows (SSF_STRING const & str)
                                                     {
		int n = 1 + countNewlines(str);
		return n;
		}
int sttfont_font_cache::getNumberOfRows (sttfont_formatted_text const & str)
                                                                 {
		int n = 1;
		for (const sttfont_formatted_text_item & item : str.mItems) {
			n += countNewlines(item.text);
			}
		return n;
		}
int sttfont_font_cache::getTextHeight (SSF_STRING const & str)
                                                   {
		return scale*rowSize*getNumberOfRows(str);
		}
int sttfont_font_cache::getTextHeight (sttfont_formatted_text const & str)
                                                               {
		return scale*rowSize*getNumberOfRows(str);
		}
int sttfont_font_cache::getTextWidth (SSF_STRING const & str, sttfont_lookupHint * mHint, int const * const maxWidth)
                                                                                                                       {
		int w,h;
		getTextSize(w, h, str, mHint, maxWidth);
		return w;
		}
int sttfont_font_cache::getTextWidth (sttfont_formatted_text const & str, sttfont_lookupHint * mHint, int const * const maxWidth)
                                                                                                                                   {
		int w,h;
		getTextSize(w, h, str, mHint, maxWidth);
		return w;
		}
void sttfont_font_cache::onStartDrawing ()
                                      {}
void sttfont_font_cache::onCompletedDrawing ()
                                          {}
int sttfont_font_cache::processString (int const x, int const y, char const * c, uint32_t const maxLen, sttfont_format const * const format, bool const isDrawing, int * const widthOut, int * const heightOut, int const * const maxWidth, sttfont_lookupHint * mHint, int const * const threshX, int const * const threshY, int * const caretPosition, int initialXOffset)
                                                                                                                                                                                                                                                                                                                                                                                                                     {
		onStartDrawing();
		int r = processString_worker(x, y, c, maxLen, format, isDrawing, widthOut, heightOut, maxWidth, mHint, threshX, threshY, caretPosition, initialXOffset);
		onCompletedDrawing();
		return r;
		}
int sttfont_font_cache::processString_worker (int const x, int const y, char const * c, uint32_t const maxLen, sttfont_format const * const format, bool const isDrawing, int * const widthOut, int * const heightOut, int const * const maxWidth, sttfont_lookupHint * mHint, int const * const threshX, int const * const threshY, int * const caretPosition, int initialXOffset)
                                                                                                                                                                                                                                                                                                                                                                       {
		// Scan through function and extract the glyphs
		// returns the x position at the end
		uint32_t seek = 0;
		uint32_t seekLast = 0;
		uint32_t uCharLast = 0;
		
		int xx = x + initialXOffset;
		int overdraw = SSF_INT_MIN;
		int yy = y;
		
		if (mHint) {
			seek = mHint->workingLen;
			seekLast = seek;
			xx = mHint->workingX;
			yy = mHint->workingY;
			uCharLast = mHint->uCharLast;
			}
			
		uint32_t uChar = utf8_read(c+seek, seek, maxLen);
		if (widthOut) { *widthOut = 0; if (mHint) *widthOut = mHint->workingX-x; }
		if (heightOut) { *heightOut = 0; if (mHint) *heightOut = mHint->workingY-y; }
		
		const bool lookupCaret = caretPosition && threshX && threshY;
		if (lookupCaret) {
			*caretPosition = -1;
			}
		
		int xxl = xx;
		while (uChar && seek <= maxLen) {
			//if (mHint)
			//	std::cout << "Processing: (" << seekLast << "," << (seek-seekLast) << ") " << std::string(&c[seekLast], seek-seekLast) << ", codePoint " << uChar << ", suibstring: [" << std::string(&c[seekLast]) << "], fullstring:["<<maxLen<<"] " << c << std::endl;
			xxl = xx;
			if (uChar == '\t') {
				// Next tab position:
				int nTabsSoFar = (xx - x)/tabWidth;
				xx = x + (nTabsSoFar+1)*tabWidth;
				}
			else if (uChar == '\n') {
				if (widthOut)
					if (*widthOut < xx) *widthOut = xx;
				xx = x;
				yy += scale*rowSize;
				overdraw = SSF_INT_MIN;
				}
			else {
				int dx = scale*getKerningAdvance(uCharLast, uChar);
				xx += dx;
				processCodepoint(xx, yy, uChar, format, isDrawing, dx, overdraw);
				}
			
			if (lookupCaret) {
				//const int dx = xx - x;
				if (xx > *threshX && xxl <= *threshX ) {
					if (*threshX > xxl + (xx - xxl)/2)
						*caretPosition = seek; // right half of char
					else
						*caretPosition = seekLast; // left half of char
						
					if (mHint) {
						if (mHint->writeOut) {
							mHint->workingLen = seek;
							mHint->workingX = xx;
							mHint->workingY = yy;
							mHint->uCharLast = uCharLast;
							}
						}
					return xx;
					}
				}
				
			if (mHint) {
				if (mHint->writeOut) {
					mHint->uCharLast = uCharLast;
					mHint->workingLen = seek;
					mHint->workingX = xx;
					mHint->workingY = yy;
					}
				}
			uCharLast = uChar;
			seekLast = seek;
			uChar = utf8_read(c + seek, seek, maxLen);
			if (maxWidth) {
				if (xx > *maxWidth) break;
				}
			}
		if (widthOut) {
			if (*widthOut < xx) *widthOut = xx;
			*widthOut -= x;
			}
		if (heightOut) {
			if (*heightOut < yy) *heightOut = yy;
			*heightOut += scale*rowSize;
			*heightOut -= y;
			}
		return xx;
		}
int sttfont_font_cache::processFormatted (sttfont_formatted_text const & text, int x, int y, bool const isDrawing, int * const widthOut, int * const heightOut, int const * const maxHeight, sttfont_lookupHint * mHint, int const * const threshX, int const * const threshY, int * const caretPosition, int initialXOffset)
                                                                                                                                                                                                                                                                                                                                                                      {
		onStartDrawing();
		
		int xOffset = initialXOffset;
		int yOffset = 0;
		
		if (widthOut) *widthOut = 0;
		if (heightOut) *heightOut = 0;
		
		size_t runningLength = 0;
		
		unsigned int start = 0;
		if (mHint) start = mHint->index;
		
		for (unsigned int i = start; i < text.mItems.size(); ++i) {
			const sttfont_formatted_text_item & ssfti = text.mItems[i];
			
			bool isDrawingWorking = isDrawing;
			if (ssfti.callback && isDrawingWorking)
				isDrawingWorking = (ssfti.format.format & sttfont_format::FORMAT_RENDER_EVEN_IF_CALLBACK_EXISTS);
			
			int widthWorking, heightWorking;
			
			int xOffsetBefore = xOffset;
			int carretPosition2 = -1;
			
			if (mHint) {
				if (mHint->writeOut) {
					mHint->index = i;
					}
				if (i != start) {
					mHint->workingLen = 0;
					mHint->workingX = 0;
					mHint->workingY = 0;
					}
				}
				
			xOffset = processString_worker(x,y + yOffset, ssfti.text.data(), ssfti.text.size(), &ssfti.format, isDrawingWorking, &widthWorking, &heightWorking, maxHeight, mHint, threshX, threshY, caretPosition ? &carretPosition2 : NULL, xOffset); // color!!!
			
			if (caretPosition) {
				if (carretPosition2 >= 0)
					*caretPosition = runningLength + carretPosition2;
				runningLength += ssfti.text.size(); // running length is only calculated here as its only used here
				}
			
			xOffset -= x;
			yOffset += heightWorking - scale*rowSize;
			if (widthOut) *widthOut = *widthOut > widthWorking ? *widthOut : widthWorking;
			
			heightWorking = yOffset + scale*rowSize;
			if (heightOut) *heightOut = *heightOut > heightWorking ? *heightOut : heightWorking;
			
			if (ssfti.callback)
				ssfti.callback->callbackOnDraw(text, i, x, y, xOffsetBefore, xOffset, widthWorking, heightWorking);
			}
		
		int ret = xOffset + x; 
		onCompletedDrawing();
		return ret;
		}
int sttfont_font_cache::getCaretPos (SSF_STRING const & str, int const relMouseX, int const relMouseY, sttfont_lookupHint * mHint)
                                                                                                                             {
		int caretPosition = -1;
		processString(0,0, str.data(), str.length(), NULL, false, NULL, NULL, NULL, mHint, &relMouseX, &relMouseY, &caretPosition);
		return caretPosition;
		}
int sttfont_font_cache::getCaretPos (sttfont_formatted_text const & str, int const relMouseX, int const relMouseY, sttfont_lookupHint * mHint)
                                                                                                                                         {
		int caretPosition = -1;
		processFormatted(str, 0,0, false, NULL, NULL, NULL, mHint, &relMouseX, &relMouseY, &caretPosition);
		return caretPosition;
		}
bool sttfont_font_cache::isTofu (sttfont_glyph * G)
                                        {
		if (!G) return true;
		if (!G->advance) return true; //unprintable characters have no width
		return false;
		}
sttfont_glyph * sttfont_font_cache::getGlyphOrTofu (uint32_t const codepoint, uint8_t const format)
                                                                                        {
		const uint8_t format_wo_underline_or_strike = format & ~(sttfont_format::FORMAT_STRIKETHROUGH | sttfont_format::FORMAT_UNDERLINE);
		sttfont_glyph * G = getGenGlyph(codepoint, format_wo_underline_or_strike);
		if (!isTofu(G)) return G;
		
		G = getGenGlyph((uint32_t) 0xFFFD, format_wo_underline_or_strike); // https://en.wikipedia.org/wiki/Specials_(Unicode_block)#Replacement_character
		if (!isTofu(G)) return G;
			
		G = getGenGlyph((uint32_t) '?', format_wo_underline_or_strike);
		if (!isTofu(G)) return G;
		
		if (format_wo_underline_or_strike)
			return getGlyphOrTofu(codepoint, 0);
		
		return NULL;
		}
void sttfont_font_cache::processCodepoint (int & x, int & y, uint32_t const codepoint, sttfont_format const * const format, bool isDrawing, int kerningAdv, int & overdraw)
                                                                                                                                                                {
		// Draws the character, advances x & y to the next position
		uint8_t formatCode = 0;
		if (format)
			formatCode = format->format;
			
		sttfont_glyph * G = getGlyphOrTofu(codepoint, formatCode);
		if (!G) {
			x += faceSize/2;
			return;
			}
		if (isDrawing) {
			drawCodepoint(G, x, y, codepoint, format, formatCode, kerningAdv, overdraw); //<--- implement your custom version of this
			}
		x += scale*G->advance;
		}
void sttfont_font_cache::drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw)
                                                                                                                                                                                                                             {
		// Draws the character
		// @overdraw: This is used for fixing pixel bleed on some backends (such as SDL). If your backend doesn't bleed then you can ignore it
		// Make your own implmentation for your own frontend here
		}
void sttfont_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen)
                                                                                                                         {
		// Make your own implmentation for your own frontend here
		//textOut->mSdlTexture = renderTextToTexture(c, maxLen, &(textOut->width), &(textOut->height));
		}
void sttfont_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str)
                                                                                                     {
		// Make your own implmentation for your own frontend here
		//textOut->mSdlTexture = renderTextToTexture(str, &(textOut->width), &(textOut->height));
		}
void sttfont_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str)
                                                                                                                 {
		// Make your own implmentation for your own frontend here
		//textOut->mSdlTexture = renderTextToTexture(str, &(textOut->width), &(textOut->height));
		}
void sttfont_font_cache::breakString (sttfont_formatted_text const & stringIn, SSF_VECTOR <sttfont_formatted_text> & arrOut, int const xs, bool const tokeniseNewLines, SSF_VECTOR <sttfont_uintQuad> * breakPoints)
                                                                                                       {
		// Note: This some of the ugliest code I have ever written. Look upon it and weap
		if (tokeniseNewLines) {
			SSF_VECTOR<sttfont_formatted_text> tokenised;
			stringIn.tokenise(tokenised, '\n', false, 0);
			
			for (sttfont_formatted_text & sft : tokenised) {
				breakString(sft, arrOut, xs, false, breakPoints);
				}
			return;
			}
		
		//std::cout << "Breaking: " << stringIn.getString() << ", xs: " << xs << std::endl;
		
		// Trivial cases
		if (getTextWidth(stringIn) < xs) {
			if (breakPoints) breakPoints->push_back(sttfont_uintQuad(arrOut.size(), 0, stringIn.size()));
			arrOut.push_back(stringIn.copy());
			return;
			}
			
		SSF_VECTOR<sttfont_formatted_text> tokenised;
		stringIn.tokenise(tokenised, ' ', false, 0, true);
		
		
		size_t lastInsert = 0;
		uint32_t workingLen = 0;	// Working length in pixels
		uint32_t iWorkingLen = 0;	// Working length in bytes
		uint32_t iWorkingLenLastBreak = 0;	// The length at the last break. Effectivley the start point of a split
		uint32_t spaceLen = 0;
		
		spaceLen = getTextWidth(sttfont_formatted_text(" "));
		
		#if 0
			{
			std::cout << "String [" << stringIn.getString() << "], Tokens: (" << tokenised.size() << ") ";
			for (size_t ti = 0; ti < tokenised.size(); ++ti) {
				if (ti) std::cout <<", ";
				std::cout << "[" << tokenised[ti].getString() << "]";
				}
			std::cout << std::endl;
			}
		#endif
		
		int maxLenLookup = xs + spaceLen; // If a string is longer than this, stop calcualting its length (early out)
		
		for (size_t ti = 0; ti < tokenised.size(); ++ti) {
			bool breakLongWord = false;
			int tokLen = 0;
			//uint64_t TSTART = 0;
			//topOfLoop:
			//TSTART = SDL_GetPerformanceCounter();
			const sttfont_formatted_text & thisTokenS = tokenised[ti];
			
			tokLen = getTextWidth(thisTokenS, NULL, &maxLenLookup);
			
			// Check last character is space. If it is, ignore the length of it
			if (thisTokenS.mItems.size()) {
				const SSF_STRING & str = thisTokenS.mItems[thisTokenS.mItems.size()-1].text;
				if (str.size()) {
					if (str[str.size()-1] == ' ')
						tokLen -= spaceLen;
					}
				}
			
			if (tokLen > xs) {
				// Break this token
				uint32_t subWorkingLen = 0;
				sttfont_lookupHint mHint;
					mHint.writeOut = true;
				sttfont_lookupHint mHint2;
					mHint.writeOut = true;
					
				sttfont_formatted_text subToken;
				int tokLen2Last = 0;
					
				for (size_t si = 0; si < thisTokenS.mItems.size(); ++si) {
					const SSF_STRING & s = thisTokenS.mItems[si].text;
					const uint32_t len = s.length();
					
					uint32_t seek = 0;
					uint32_t seekBefore = 0;
					
					while (seek < len) {
						seekBefore = seek;
						sttfont_font_cache::utf8_read(&s[seek], seek, len); // Look ahead and discard value
					
						sttfont_formatted_text subToken2 =  thisTokenS.extract(seekBefore+subWorkingLen, seek-seekBefore, &mHint2);
						subToken.append(std::move(subToken2));
						
						int tokLen2 = getTextWidth(subToken, &mHint);
						
						if (tokLen2 > xs) {
							//split!
							uint32_t splitPos = subWorkingLen + seekBefore;
							if (splitPos == 0) splitPos = 1;
							if (splitPos < len) {
								sttfont_formatted_text before = thisTokenS.extract(0, splitPos);
								sttfont_formatted_text after  = thisTokenS.extract(splitPos, -1);
								//std::cout << "here!!! ["<< thisTokenS.getString() <<"] (" << splitPos << "/" << thisTokenS.size() << ") before: [" << before.getString() << "], after: [" << before.getString() << "]" << std::endl;

								tokenised.insert(tokenised.begin() + ti + 1, std::move(after));
								tokenised[ti].swap(before);
								
								
								//std::cout << "here!!! [" << tokenised[ti].getString() << std::endl;
				//uint64_t TSPLIT = SDL_GetPerformanceCounter();
				//const double deltaTime = (double)((TSPLIT - TSTART)*1000 / (double)SDL_GetPerformanceFrequency() );
				//std::cout  << std::endl << "TokLen: [" << tokenised[ti].size() << "/" << tokenised[ti+1].size() << "],  Split time: " << deltaTime <<"ms" << " before: [" << tokenised[ti].getStringTruncated(64) << "] after: [" << tokenised[ti+1].getStringTruncated(64) << "] "<< std::endl << std::endl;
								//ti--;
								}
							
							tokLen = tokLen2Last;
							breakLongWord = true;
							goto breaken;
							}
						tokLen2Last = tokLen2;
						}
					subWorkingLen += len;
					}
				}
				
			// I told you this is ugly code. Look, it even has a Goto!
			breaken:
			
			//				std::cout << "breaken: [" << tokenised[ti].getString() << "] " << ti << "/" << tokenised.size() << " " << (workingLen + tokLen) << "/" << xs << std::endl;
			
			/////////////////////////////////////////////////////////////////////
			// Token for 
			//const sttfont_formatted_text & thisToken = tokenised[ti];
			
			bool isOverLength = (workingLen + tokLen > unsigned(xs));
			bool isLastPiece = (ti == tokenised.size()-1);
			
				
			if (isOverLength || isLastPiece || breakLongWord) {
				sttfont_formatted_text working;
				//bool first = true;
				unsigned int tokStride = 0;
				size_t limit = ti;
				if (!isOverLength)
					limit = ti+1;
					
				//bool isLastPiece2 = (limit == tokenised.size());
				for (size_t tj = lastInsert; tj < limit; ++tj) {
					//std::cout << "tok: [" << tokenised[tj].getString() << "] " << (tj+1 < limit ) << " " << tokStride << std::endl;
					working.append(std::move(tokenised[tj]));
					}
				//const bool trailingSpace = (!isLastPiece2) && (!breakLongWord);
				//if (trailingSpace)
				//	working << " ";
					
				working.consolidateSegments();
				
				if (breakPoints) {
					//if (isLastPiece)
					//tokStride = 0;
					iWorkingLen = working.size();
					
					//std::cout << "Insert B " << tokLen << "/" << Vgui_ContextI::aContext->getTextWidth(working) << "/" << xs << "\t[" << working.getString() << "], this piece: " << thisToken.getString() << ", arrSize: " << arrOut.size() << ", workingLen: " << iWorkingLen  << " workingLenLastBreak : " << iWorkingLenLastBreak << ", tokStride: " << tokStride << ", breakLongWord: " << breakLongWord << " isLastPiece2: " << isLastPiece2 << " trailingSpace: " << (trailingSpace) << std::endl << std::endl;
					
					breakPoints->push_back(sttfont_uintQuad(arrOut.size(), iWorkingLenLastBreak, iWorkingLen, tokStride));
					iWorkingLenLastBreak += iWorkingLen + tokStride;
					}
				arrOut.push_back(std::move(working));
				
				lastInsert = limit;
				if (isOverLength)
					ti--;
					
				workingLen = 0;
				//iWorkingLen = 0;
				}
			else {
				workingLen += tokLen + spaceLen;
				}
			
			//exit(1);
			}
		}
void sttfont_font_cache::breakString (SSF_STRING const & stringIn, SSF_VECTOR <SSF_STRING> & arrOut, int const xs, bool const tokeniseNewLines, SSF_VECTOR <sttfont_uintQuad> * breakPoints)
                                                                                                       {
		sttfont_formatted_text sft;
		sft << stringIn;
		
		SSF_VECTOR<sttfont_formatted_text> arrTemp;
		breakString(sft, arrTemp, xs, tokeniseNewLines, breakPoints);
		arrOut.resize(arrTemp.size());
		for (uint32_t i = 0; i < arrTemp.size(); ++i) {
			if (arrTemp[i].isEmpty()) continue;
			arrOut[i].swap(arrTemp[i].mItems[0].text);
			}
		}
#undef LZZ_INLINE
#endif //SDL_STB_FONT_IMPL_DOUBLE_GUARD_sttFont
#endif //SDL_STB_FONT_IMPL_IMPL
