// This file is autogenerated. See look at the .lzz files in the src/ directory for a more human-friendly version
// producerConsumerFrontend.hh
//

#ifndef LZZ_producerConsumerFrontend_hh
#define LZZ_producerConsumerFrontend_hh
/// Used for when you want to have, eg, an Update thread and a Render thread
/// 
#ifndef SSF_MUTEX
	#define SSF_MUTEX std::mutex
	#include <mutex>
#endif

// SSF_PCFC_TEMPORARY_ALLOCATOR
// Purpose: allows data to be stored in a temporary container (such as a bump allocator)
// that is disposed of after consuming. Object level scope
// Must implement stt::allocatorI from github/SnapperTT/stt-stl

#ifndef SSF_PCFC_TEMPORARY_ALLOCATOR
	#define SSF_PCFC_TEMPORARY_ALLOCATOR int
	#define SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED 0
#else
	#ifndef SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
		#define SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED 1
	#endif
#endif

// SSF_STACK_TEMPORATY_ALLOCATOR
// Purpose: for an explictly temporary allocator that has function level scope
// Must implement stt::allocatorI from github/SnapperTT/stt-stl

#ifndef SSF_STACK_TEMPORATY_ALLOCATOR
	#define SSF_STACK_TEMPORATY_ALLOCATOR int
	#define SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED 0
#else
	#ifndef SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
		#define SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED 1
	#endif
#endif

#if (SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED) && (!SSF_STT_STL_ALLOCATOR_ENABLED)
	#error Stack temporary allocator is enabled buy stt-stl allocators are not (define SSF_STT_STL_ALLOCATOR_ENABLED 1 and include stt-stl/pages)
#endif
#if (SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED) && (!SSF_STT_STL_ALLOCATOR_ENABLED)
	#error Object temporary allocator is enabled buy stt-stl allocators are not (define SSF_STT_STL_ALLOCATOR_ENABLED 1 and include stt-stl/pages)
#endif

typedef uint32_t pcfc_handle;
class producer_consumer_font_cache;

#ifdef SSF_CONCURRENT_QUEUE
	#define SSF_STATE_TRANSFER SSF_CONCURRENT_QUEUE<state_t*>
#else
	#define SSF_STATE_TRANSFER SSF_MUTEX mMutex; state_t
#endif

#define SSF_PCFC_PFCF_FORMATTED_TEXT_MS producer_consumer_font_cache::pcfc_formatted_text&&
#define LZZ_INLINE inline
struct pcfc_prerendered_text : public sttfont_prerendered_text
{
  pcfc_handle handle;
  producer_consumer_font_cache * owner;
  void initToZero ();
  void freeTexture ();
};
class producer_consumer_font_cache : public sttfont_font_cache
{
protected:
  struct pcfc_consumer_prerendered_text : public sttfont_prerendered_text
  {
    pcfc_handle handle;
    sttfont_formatted_text text;
    pcfc_consumer_prerendered_text ();
  };
  struct pcfc_formatted_text
  {
    sttfont_formatted_text text;
    int x;
    int y;
  };
public:
  sttfont_font_cache * consumer_font_cache;
protected:
  pcfc_handle nextPrerenderTokenId;
  SSF_MAP <pcfc_handle, sttfont_prerendered_text*> prerenderMap;
  SSF_MAP <uint64_t, sttfont_glyph> mGlyphs;
  struct state_t
  {
    SSF_PCFC_TEMPORARY_ALLOCATOR temporaryAllocator;
    SSF_VECTOR <producer_consumer_font_cache::pcfc_consumer_prerendered_text> prerender;
    SSF_VECTOR <pcfc_handle> destroyPrerender;
    SSF_VECTOR <producer_consumer_font_cache::pcfc_formatted_text> text;
    void * userdata;
  private:
    state_t (state_t const & other);
    state_t & operator = (state_t const & other);
  public:
    state_t ();
    ~ state_t ();
    void push_back_prerender (producer_consumer_font_cache::pcfc_consumer_prerendered_text const & prt);
    void push_back_destroyPrerender (pcfc_handle const prt);
    void push_back_text_cr (producer_consumer_font_cache::pcfc_formatted_text const & prt);
    void push_back_text (producer_consumer_font_cache::pcfc_formatted_text const & prt);
    void push_back_text (SSF_PCFC_PFCF_FORMATTED_TEXT_MS prt);
    void swap (state_t & s);
    void clear (bool const checkForJobs = true);
  };
  state_t producerState;
  SSF_STATE_TRANSFER txQueue;
  state_t consumerState;
  SSF_ATOMIC_INT numInQueue;
  pcfc_handle getNextPrerenderToken ();
public:
  producer_consumer_font_cache ();
  int getNumInQueue ();
  void freeStoredPrerenderedText (bool const freeTextures);
  sttfont_glyph * getGlyph (uint64_t const target);
  sttfont_glyph * genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format);
  void loadFontManagedBoth (sttfont_memory & memory, int index = 0);
  void addFontManagedBoth (sttfont_memory & memory, int index = 0);
  void addFormatFontManagedBoth (uint8_t formatMask, sttfont_memory & memory, int index = 0);
  pcfc_handle pushText (int const x, int const y, char const * c, uint32_t const maxLen = -1, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushText (int const x, int const y, SSF_STRING const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushText (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen = -1, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushText (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushText (int const x, int const y, sttfont_formatted_text const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  void drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw);
  void renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen = -1);
  void renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str);
  void renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str);
  void destroyPrerender (pcfc_handle const handle);
  void pushUserdata (void * data);
  void submitToConsumer ();
  pcfc_handle pushTextConsumerSide (int const x, int const y, char const * c, uint32_t const maxLen = -1, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushTextConsumerSide (int const x, int const y, SSF_STRING const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushTextConsumerSide (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen = -1, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushTextConsumerSide (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  pcfc_handle pushTextConsumerSide (int const x, int const y, sttfont_formatted_text const & str, int * xOut = NULL, int * widthOut = NULL, int * heightOut = NULL);
  bool receiveFromProducer ();
  template <typename T>
  int dispatchPrerenderJobs ();
  template <typename T>
  int dispatchDestroy ();
  bool hasPrerenderOrDestroyJobs () const;
  bool dispatchSinglePrerendered (pcfc_handle const prtId, int x, int y) const;
  bool dispatchSinglePrerenderedWColorMod (pcfc_handle const prtId, int x, int y, int const r, int const g, int const b, int const a) const;
  bool dispatchSingleText (pcfc_handle const texId);
  void * getUserdata ();
  void * consumeUserdata ();
};
LZZ_INLINE void producer_consumer_font_cache::state_t::push_back_text (producer_consumer_font_cache::pcfc_formatted_text const & prt)
                                                                                                         {
			push_back_text_cr(prt);
			}
LZZ_INLINE void producer_consumer_font_cache::state_t::push_back_text (SSF_PCFC_PFCF_FORMATTED_TEXT_MS prt)
                                                                                {
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				push_back_text_cr(prt);
			#else
				text.push_back(std::move(prt));
			#endif
			}
template <typename T>
int producer_consumer_font_cache::dispatchPrerenderJobs ()
                                    {
		// T is the sttfont_prerendered_text subclass that is used by consumer_font_cache
		int nDone = 0;
		for (pcfc_consumer_prerendered_text & p2 : consumerState.prerender) {
			auto itt = prerenderMap.find(p2.handle);
			if (itt != prerenderMap.end())
				abort(); // Idx reusued, this will leak memory
			T* t = SSF_NEW(T);
			consumer_font_cache->renderTextToObject(t, p2.text);
			prerenderMap[p2.handle] = t;
			nDone++;
			}
		consumerState.prerender.clear();
		return nDone;
		}
template <typename T>
int producer_consumer_font_cache::dispatchDestroy ()
                              {
		// T is the sttfont_prerendered_text subclass that is used by consumer_font_cache
		int nDone = 0;
		for (const pcfc_handle idx : consumerState.destroyPrerender) {
			auto itt = prerenderMap.find(idx);
			if (itt != prerenderMap.end()) {
				itt->second->freeTexture();
				SSF_DEL(itt->second);
				prerenderMap.erase(itt);
				nDone++;
				}
			}
		consumerState.destroyPrerender.clear();
		return nDone;
		}
#undef LZZ_INLINE
#endif

////////////////////////////////////////////////////////////////////////

#ifdef SDL_STB_FONT_IMPL
#ifndef SDL_STB_FONT_IMPL_DOUBLE_GUARD_producerConsumerFrontend
#define SDL_STB_FONT_IMPL_DOUBLE_GUARD_producerConsumerFrontend
// producerConsumerFrontend.cpp
//

#define LZZ_INLINE inline
void pcfc_prerendered_text::initToZero ()
                          {
		handle = 0;
		owner = NULL;
		}
void pcfc_prerendered_text::freeTexture ()
                           {
		if (owner && handle)
			owner->destroyPrerender(handle);
		handle = 0; // we no longer own the texture 
		}
producer_consumer_font_cache::pcfc_consumer_prerendered_text::pcfc_consumer_prerendered_text ()
                                                 {}
producer_consumer_font_cache::state_t::state_t ()
  : userdata (NULL)
                                           {
			// binds a custom allocator to the vectors (see github/SnapperTT/stt-stl)
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				prerender.setAllocator(&temporaryAllocator);
				destroyPrerender.setAllocator(&temporaryAllocator);
				text.setAllocator(&temporaryAllocator);
			#endif
			}
producer_consumer_font_cache::state_t::~ state_t ()
                           {
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				// no not deallocate or call destructors for the vectors
				// just let ~temporaryAllocator() release the underlying arenas
				prerender.markInterned();
				destroyPrerender.markInterned();
				text.markInterned();
			#endif
			}
void producer_consumer_font_cache::state_t::push_back_prerender (producer_consumer_font_cache::pcfc_consumer_prerendered_text const & prt)
                                                                                                                  {
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				// copy into temporaryAllocator and push_back
				prerender.push_back(producer_consumer_font_cache::pcfc_consumer_prerendered_text());
				producer_consumer_font_cache::pcfc_consumer_prerendered_text& p = prerender.back();
				
				p.width = prt.width;
				p.height = prt.height;
				p.handle = prt.handle;
				sttfont_formatted_text::copyInterned(&temporaryAllocator, p.text, prt.text, true);
				p.text.markInterned();
				
				//stt::stt_dbg_log("push back PCRT %i (w: %i, h: %i, [%s])", p.text.size(), p.width, p.height, p.text.getString().c_str());
				//stt::stt_dbg_log("resLen: %i, %i", prerender.back().text.size(), prerender.back().text.mItems.size());
			#else
				prerender.push_back(prt);
			#endif
			}
void producer_consumer_font_cache::state_t::push_back_destroyPrerender (pcfc_handle const prt)
                                                                       {
			destroyPrerender.push_back(prt);
			}
void producer_consumer_font_cache::state_t::push_back_text_cr (producer_consumer_font_cache::pcfc_formatted_text const & prt)
                                                                                                     {
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				// create a copy of prt using temporaryAllocator, then "intern" it
				// markInterned() makes containers not deallocate through destructor
				// instead the allocator itself must be discarded to deallocate
				
				text.push_back(producer_consumer_font_cache::pcfc_formatted_text());
				producer_consumer_font_cache::pcfc_formatted_text& tmp = text.back();
				// pushing_back seems to invoke sttfont_formatted_text::copy/move which causes allocator information to be lost
				// i'm not sure why that happens but text.resize -> realloc doesn't cause this to happen
				
				
				sttfont_formatted_text::copyInterned(&temporaryAllocator, tmp.text, prt.text, true);
				tmp.text.mItems.markInterned();
				tmp.x = prt.x;
				tmp.y = prt.y;
				
				//stt::stt_dbg_log("push back TEXT %i (x: %i, y: %i, [%s])", tmp.text.size(), tmp.x, tmp.y, tmp.text.getString().c_str());
				//stt::stt_dbg_log("resLen: %i, %i", text.back().text.size(), text.back().text.mItems.size());
			#else
				text.push_back(prt);
			#endif
			}
void producer_consumer_font_cache::state_t::swap (state_t & s)
                                       {
			prerender.swap(s.prerender);
			destroyPrerender.swap(s.destroyPrerender);
			text.swap(s.text);
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				temporaryAllocator.swap(s.temporaryAllocator);
				// all data with store.mAllocatorI = &temporaryAllocator must
				// have their allocator pointers swapped too 
				prerender.swap_allocator_pointers(s.prerender);
				destroyPrerender.swap_allocator_pointers(s.destroyPrerender);
				text.swap_allocator_pointers(s.text);
				// we don't need to swap the allocator pointers of
				// text->mItems as they are interned on push_back
			#endif
			void * tmp = s.userdata;
			s.userdata = userdata;
			userdata = tmp;
			}
void producer_consumer_font_cache::state_t::clear (bool const checkForJobs)
                                                           {
			if (checkForJobs) {
				if (prerender.size() || destroyPrerender.size()) {
					std::cerr << "sdlStbFont: Destroying state with jobs still pending " << prerender.size() << " " << destroyPrerender.size() << std::endl;
					abort();
					}
				}
			prerender.clear();
			destroyPrerender.clear();
			text.clear();
			userdata = NULL;
			#if SSF_PCFC_TEMPORARY_ALLOCATOR_ENABLED
				temporaryAllocator.clear();
			#endif
			}
pcfc_handle producer_consumer_font_cache::getNextPrerenderToken ()
                                            {
		return nextPrerenderTokenId++;
		}
producer_consumer_font_cache::producer_consumer_font_cache ()
  : consumer_font_cache (NULL), nextPrerenderTokenId (1)
                                                                                            { numInQueue = 0; }
int producer_consumer_font_cache::getNumInQueue ()
                             { return numInQueue; }
void producer_consumer_font_cache::freeStoredPrerenderedText (bool const freeTextures)
                                                                {
		for (auto ppair : prerenderMap) {
			sttfont_prerendered_text* prt = ppair.second;
			if (!prt) continue;
			if (freeTextures) {
				prt->freeTexture();
				}
			SSF_DEL(prt);
			}
		prerenderMap.clear();
		}
sttfont_glyph * producer_consumer_font_cache::getGlyph (uint64_t const target)
                                                        {
		auto it = mGlyphs.find(target);
		if (it == mGlyphs.end())
			return NULL;
		return &((*it).second);
		}
sttfont_glyph * producer_consumer_font_cache::genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format)
                                                                                                                        {
		sttfont_glyph g;
		genGlyph(codepoint, format, &g);
		mGlyphs[target] = g;
		return getGlyph(target);
		}
void producer_consumer_font_cache::loadFontManagedBoth (sttfont_memory & memory, int index)
                                                                          {
		sttfont_memory memory2;
		memory.cloneTo(memory2);
		
		consumer_font_cache->syncFrom(*this);
		consumer_font_cache->loadFontManaged(memory2, index);
		this->syncFrom(*consumer_font_cache);
		this->loadFontManaged(memory2, index);
		}
void producer_consumer_font_cache::addFontManagedBoth (sttfont_memory & memory, int index)
                                                                         {
		sttfont_memory memory2;
		memory.cloneTo(memory2);
		
		consumer_font_cache->syncFrom(*this);
		consumer_font_cache->addFontManaged(memory2, index);
		this->syncFrom(*consumer_font_cache);
		this->addFontManaged(memory, index);
		}
void producer_consumer_font_cache::addFormatFontManagedBoth (uint8_t formatMask, sttfont_memory & memory, int index)
                                                                                                   {
		sttfont_memory memory2;
		memory.cloneTo(memory2);
		
		consumer_font_cache->syncFrom(*this);
		consumer_font_cache->addFormatFontManaged(formatMask, memory2, index);
		this->syncFrom(*consumer_font_cache);
		this->addFormatFontManaged(formatMask, memory, index);
		}
pcfc_handle producer_consumer_font_cache::pushText (int const x, int const y, char const * c, uint32_t const maxLen, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                 {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp.appendCBuff(c, maxLen);
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			assert(tmp.mItems.getCustomAllocator() == &alloc);
		#endif
		return pushText(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushText (int const x, int const y, SSF_STRING const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                              {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp += str;
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			assert(tmp.mItems.getCustomAllocator() == &alloc);
		#endif
		return pushText(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushText (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                                              {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp << format; tmp.appendCBuff(c, maxLen);
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			assert(tmp.mItems.getCustomAllocator() == &alloc);
		#endif
		return pushText(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushText (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                           {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp << format << str; // HERE ARE THE ALLOCS
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			assert(tmp.mItems.getCustomAllocator() == &alloc);
		#endif
		
		return pushText(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushText (int const x, int const y, sttfont_formatted_text const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                          {
		if (xOut || widthOut || heightOut) {
			int xx = processFormatted(str, x, y, false, widthOut, heightOut);
			if (xOut) *xOut = xx;
			}
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			pcfc_formatted_text p;
			p.text.setAllocator(&alloc);
		#else
			pcfc_formatted_text p;
		#endif
		p.text = str;
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			assert(p.text.mItems.getCustomAllocator() == &alloc);
		#endif
		
		p.x = x;
		p.y = y;
		producerState.push_back_text(std::move(p));
		return producerState.text.size() - 1; 
		}
void producer_consumer_font_cache::drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw)
                                                                                                                                                                                                                     {
		// This function should never be called for this frontend. Use pushText instead of drawText
		abort();
		}
void producer_consumer_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen)
                                                                                                                 {
		sttfont_formatted_text tmp(c, maxLen);
		renderTextToObject (textOut, tmp);
		}
void producer_consumer_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str)
                                                                                             {
		sttfont_formatted_text tmp(str);
		renderTextToObject (textOut, tmp);
		}
void producer_consumer_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str)
                                                                                                         {
		pcfc_prerendered_text* p = (pcfc_prerendered_text*) textOut;
		getTextSize(textOut->width, textOut->height, str);
		p->handle = getNextPrerenderToken();
		p->owner = this;
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
		#endif
		pcfc_consumer_prerendered_text p2;
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			p2.text.setAllocator(&alloc);
		#endif
		p2.width = p->width;
		p2.height = p->height;
		p2.handle = p->handle;
		p2.text = str;
		
		
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
		assert(p2.text.mItems.getCustomAllocator() == &alloc);
		#endif
		
		producerState.push_back_prerender(p2);
		}
void producer_consumer_font_cache::destroyPrerender (pcfc_handle const handle)
                                                        {
		producerState.push_back_destroyPrerender(handle);
		}
void producer_consumer_font_cache::pushUserdata (void * data)
                                      {
		producerState.userdata = data;
		}
void producer_consumer_font_cache::submitToConsumer ()
                                {
		#ifdef SSF_CONCURRENT_QUEUE
			state_t * s = SSF_NEW(state_t);
			s->swap(producerState);
			txQueue.enqueue(s);
		#else
			mMutex.lock();
			txQueue.clear();
			txQueue.swap(producerState);
			mMutex.unlock();
		#endif
		numInQueue++;
		}
pcfc_handle producer_consumer_font_cache::pushTextConsumerSide (int const x, int const y, char const * c, uint32_t const maxLen, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                             {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp.appendCBuff(c, maxLen);
		return pushTextConsumerSide(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushTextConsumerSide (int const x, int const y, SSF_STRING const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                          {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp += str;
		return pushTextConsumerSide(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushTextConsumerSide (int const x, int const y, sttfont_format const format, char const * c, uint32_t const maxLen, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                                                          {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp << format; tmp.appendCBuff(c, maxLen);
		return pushTextConsumerSide(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushTextConsumerSide (int const x, int const y, sttfont_format const format, SSF_STRING const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                                       {
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			sttfont_formatted_text tmp(&alloc);
		#else
			sttfont_formatted_text tmp;
		#endif
		tmp << format << str;
		return pushTextConsumerSide(x, y, tmp, xOut, widthOut, heightOut);
		}
pcfc_handle producer_consumer_font_cache::pushTextConsumerSide (int const x, int const y, sttfont_formatted_text const & str, int * xOut, int * widthOut, int * heightOut)
                                                                                                                                                                      {
		if (xOut || widthOut || heightOut) {
			int xx = processFormatted(str, x, y, false, widthOut, heightOut);
			if (xOut) *xOut = xx;
			}
		#if SSF_STACK_TEMPORATY_ALLOCATOR_ENABLED
			SSF_STACK_TEMPORATY_ALLOCATOR alloc;
			pcfc_formatted_text p;
			p.text.setAllocator(&alloc);
		#else
			pcfc_formatted_text p;
		#endif
		p.text = str;
		p.x = x;
		p.y = y;
		consumerState.push_back_text(std::move(p));
		return consumerState.text.size() - 1; 
		}
bool producer_consumer_font_cache::receiveFromProducer ()
                                   {
		#ifdef SSF_CONCURRENT_QUEUE
			state_t * s = NULL;
			if (txQueue.try_dequeue(s)) {
				s->swap(consumerState);
				SSF_DEL(s);
				numInQueue--;
				return true;
				}
			return false;
		#else
			consumerState.clear();
			mMutex.lock();
			consumerState.swap(txQueue);
			mMutex.unlock();
			numInQueue--;
			return true;
		#endif
		}
bool producer_consumer_font_cache::hasPrerenderOrDestroyJobs () const
                                               {
		// Returns true if there are unprocessed prerender or destroy jobs
		return consumerState.prerender.size() + consumerState.destroyPrerender.size();
		}
bool producer_consumer_font_cache::dispatchSinglePrerendered (pcfc_handle const prtId, int x, int y) const
                                                                                    {
		auto itt = prerenderMap.find(prtId);
		if (itt != prerenderMap.end()) {
			itt->second->draw(consumer_font_cache, x, y);
			return true;
			}
		else {
			return false;
			//std::cout << "Could not find prerendered text #" << prtId << std::endl;
			}
		}
bool producer_consumer_font_cache::dispatchSinglePrerenderedWColorMod (pcfc_handle const prtId, int x, int y, int const r, int const g, int const b, int const a) const
                                                                                                                                                 {
		auto itt = prerenderMap.find(prtId);
		if (itt != prerenderMap.end()) {
			itt->second->drawWithColorMod(consumer_font_cache, x, y, r, g, b, a);
			return true;
			}
		return false;
		}
bool producer_consumer_font_cache::dispatchSingleText (pcfc_handle const texId)
                                                         {
		if (texId < consumerState.text.size() && texId >= 0) {
			pcfc_formatted_text & pcf = consumerState.text[texId];
			consumer_font_cache->drawText(pcf.x, pcf.y, pcf.text);
			return true;
			}
		return false;
		}
void * producer_consumer_font_cache::getUserdata ()
                            {
		return consumerState.userdata;
		}
void * producer_consumer_font_cache::consumeUserdata ()
                                {
		void* r = consumerState.userdata;
		if (r) consumerState.userdata = NULL;
		return r;
		}
#undef LZZ_INLINE
#endif //SDL_STB_FONT_IMPL_DOUBLE_GUARD_producerConsumerFrontend
#endif //SDL_STB_FONT_IMPL_IMPL
