// This file is autogenerated. See look at the .lzz files in the src/ directory for a more human-friendly version
// bgfxFrontend.hh
//

#ifndef LZZ_bgfxFrontend_hh
#define LZZ_bgfxFrontend_hh
// SdlStbFont bgfxFrontend
// By Liam Twigger - 2021
// Public Domain
//
// Note that this also depends on stb_rect_pack.h
//
#include "bgfxh_embedded_shader.h"

//#define BGFXSFH_IS_VALID(X) std::cout << "is valid " << #X << ": " << bgfx::isValid(X) << std::endl 
#define BGFXSFH_IS_VALID(X) BX_NOOP(X)

#define SSF_UINT32_ALIASING uint32_t __attribute((__may_alias__))
#define LZZ_INLINE inline
struct bgfxsfh
{
public:
  static bgfx::ShaderHandle vert_passthrough;
  static bgfx::ShaderHandle frag_passthrough;
  static bgfx::ShaderHandle textured_vert_passthrough;
  static bgfx::ShaderHandle textured_frag_passthrough;
  static bgfx::ProgramHandle untexturedProgram;
  static bgfx::ProgramHandle texturedProgram;
  static bgfx::UniformHandle u_colour;
  static bgfx::UniformHandle s_texture;
  static uint32_t const RENDER_STATE;
  static uint32_t const RENDER_STATE_PRERENDER;
  static int refCount;
  struct rect
  {
    float x;
    float y;
    float w;
    float h;
  };
  typedef SSF_UINT32_ALIASING uint32_aliasing_t;
  static bool compareColoursLt (uint8_t const (rgba1) [4], uint8_t const (rgba2) [4]);
  static bool compareColoursEq (uint8_t const (rgba1) [4], uint8_t const (rgba2) [4]);
  struct draw_quad
  {
    bgfx::TextureHandle textureId;
    uint8_t (colour) [4];
    bgfxsfh::rect drawRect;
    bgfxsfh::rect texRect;
    void setColour (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
    bool operator < (draw_quad const & other) const;
    bool stateChange (draw_quad const & other) const;
  };
  struct untextured_draw_quad
  {
    uint8_t (colour) [4];
    bgfxsfh::rect drawRect;
    void setColour (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
    bool operator < (untextured_draw_quad const & other) const;
    bool stateChange (untextured_draw_quad const & other) const;
  };
  struct Vec4
  {
    float (v) [4];
    Vec4 ();
    static bgfxsfh::Vec4 fromUint8 (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
  };
  static Vec4 toVec4 (uint8_t const a, uint8_t const b, uint8_t const c, uint8_t const d);
  static void initialise ();
  static void deinitialise ();
  struct PosTexCoord0Vertex
  {
    float m_x;
    float m_y;
    float m_z;
    float m_u;
    float m_v;
    static void init ();
    static bgfx::VertexLayout ms_decl;
  };
  struct PosVertex
  {
    float m_x;
    float m_y;
    float m_z;
    static void init ();
    static bgfx::VertexLayout ms_decl;
  };
  static rect scissorIntersect (rect const & r, rect const & scissor);
  static rect scissorIntersectTexCoord (rect const & r, rect const & uv, rect const & rIntersect, bool const dontFlipY);
  static void pushTexturedQuad (rect const & r, rect const & r2, bool dontFlipY = false);
  static void pushTexturedQuadWScissor (rect const & r, rect const & r2, rect const & scissor, bool dontFlipY = false);
  static void getTexturedQuadWScissor (rect const & r, rect const & r2, rect & rOut, rect & r2Out, rect const & scissor, bool dontFlipY = false);
  static void pushTexturedQuads (rect const * pos, rect const * uv, draw_quad const * drawQuads, int const numQuads, bool const dontFilpY, float const _framebufferWidth = 0.f, float const _framebufferHeight = 0.f);
  static void pushUntexturedQuad (rect const & r);
  static void pushUntexturedQuadWScissor (rect const & r, rect const & scissor);
  static void getUntexturedQuadsWScissor (rect const & r, rect & rOut, rect const & scissor, bool dontFlipY = false);
  static void pushUntexturedQuads (rect const * pos, untextured_draw_quad const * drawQuads, int const numQuads, float const _framebufferWidth = 0.f, float const _framebufferHeight = 0.f);
  struct cpuBuffer
  {
    uint8_t * buff;
    int w;
    int h;
    uint32_t sz;
    bool flipY;
    cpuBuffer ();
    ~ cpuBuffer ();
    void allocate ();
    void clearBuff ();
    void blend (uint8_t * dst, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
    void writeRGBA (int const x, int const y, uint8_t const * const src, int const bw, int const bh);
    void writeA (int const x, int const y, uint8_t const * const src, int const bw, int const bh, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
    void writeFill (int const x, int const y, int const bw, int const bh, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a);
  };
};
struct bgfx_stb_prerendered_text : public sttfont_prerendered_text
{
  bgfx::TextureHandle mBgfxTexture;
  bgfx::ViewId mViewId;
  bgfx_stb_prerendered_text ();
  void freeTexture ();
  int draw (sttfont_font_cache * fc, int const x, int const y);
  int draw (int const x, int const y);
  int drawWithColorMod (int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a = 255);
  int drawWithColorMod (sttfont_font_cache * fc, int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a = 255);
  int draw_worker (bgfx::ViewId mViewIdOverride, bgfxsfh::rect * scissor, int const x, int const y, bool const resetColour);
};
struct bgfx_stb_glyph : public sttfont_glyph
{
  bgfx::TextureHandle mAtlasTexture;
  float x;
  float y;
  float w;
  float h;
  SSF_STRING glypthData;
  bgfx_stb_glyph ();
};
struct bgfx_stb_glyph_atlas
{
  bgfx::TextureHandle mAtlasTexture;
  stbrp_context * mStbRectPackCtx;
  stbrp_node * mNodes;
  bool isFull;
  bgfx_stb_glyph_atlas ();
};
class deferred_stb_font_cache
{
public:
  sttfont_font_cache * renderFontCache;
};
class bgfx_stb_font_cache : public sttfont_font_cache
{
public:
  bgfx::ViewId mViewId;
  int mAtlasSize;
  SSF_VECTOR <bgfx_stb_glyph_atlas> mAtlases;
  bgfxsfh::rect scissor;
  bgfxsfh::cpuBuffer * renderTarget;
  SSF_MAP <uint64_t, bgfx_stb_glyph> mGlyphs;
  SSF_VECTOR <bgfxsfh::draw_quad> drawBuffer;
  SSF_VECTOR <bgfxsfh::untextured_draw_quad> untexturedDrawBuffer;
  bool bufferDraws;
  bgfx_stb_font_cache ();
  ~ bgfx_stb_font_cache ();
  void setScissor (float const x, float const y, float const w, float const h);
  void resetScissor ();
  bool doScissorTest () const;
  bool scissorTest (bgfxsfh::rect const & t);
  void clearGlyphs ();
  void bindRenderer (bgfx::ViewId const _viewId);
  bgfx_stb_glyph_atlas * getGenAtlasPage ();
  bgfx_stb_glyph_atlas * createAtlasPage ();
  struct tempGlyph
  {
    unsigned char * bitmapData;
    uint64_t target;
  };
  void pregenGlyphs (SSF_VECTOR <sttfont_uint32_t_range> & mRanges, uint8_t const format);
  void pregenGlyphs_pack (SSF_VECTOR <tempGlyph> & tempGlyphs, SSF_VECTOR <stbrp_rect> & rects, bool force);
  void genGlyph_writeData (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h);
  void populateGlyphData (bgfx_stb_glyph * bOut, unsigned char * bitmap2, int w, int h);
  void genGlyph_writeData2 (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h, bool firstCall);
  sttfont_glyph * getGlyph (uint64_t const target);
  sttfont_glyph * genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format);
  void onStartDrawing ();
  void onCompletedDrawing ();
  void drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw);
  bgfx::TextureHandle renderTextToTexture (char const * c, uint32_t const maxLen = -1, int * widthOut = NULL, int * heightOut = NULL);
  bgfx::TextureHandle renderTextToTexture (sttfont_formatted_text const & formatted, int * widthOut = NULL, int * heightOut = NULL);
protected:
  bgfx::TextureHandle renderTextToTexture_worker (sttfont_formatted_text const * formatted, char const * c, uint32_t const maxLen = -1, int * widthOut = NULL, int * heightOut = NULL);
public:
  bgfx::TextureHandle renderTextToTexture (SSF_STRING const & str, int * widthOut = NULL, int * heightOut = NULL);
  void renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen = -1);
  void renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str);
  void renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str);
};
LZZ_INLINE bool bgfxsfh::compareColoursLt (uint8_t const (rgba1) [4], uint8_t const (rgba2) [4])
                                                                                            {
		const uint32_aliasing_t rgba1_c = *((uint32_aliasing_t*) rgba1);
		const uint32_aliasing_t rgba2_c = *((uint32_aliasing_t*) rgba2);
		return rgba1_c < rgba2_c;
		}
LZZ_INLINE bool bgfxsfh::compareColoursEq (uint8_t const (rgba1) [4], uint8_t const (rgba2) [4])
                                                                                            {
		const uint32_aliasing_t rgba1_c = *((uint32_aliasing_t*) rgba1);
		const uint32_aliasing_t rgba2_c = *((uint32_aliasing_t*) rgba2);
		return rgba1_c == rgba2_c;
		}
LZZ_INLINE void bgfxsfh::draw_quad::setColour (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                          {
			colour[0] = r;
			colour[1] = g;
			colour[2] = b;
			colour[3] = a;
			}
LZZ_INLINE bool bgfxsfh::draw_quad::operator < (draw_quad const & other) const
                                                                       {
			// sort by texture, then by colour
			if (textureId.idx == other.textureId.idx) {
				return compareColoursLt(colour, other.colour);
				}
			return (textureId.idx < other.textureId.idx);
			}
LZZ_INLINE bool bgfxsfh::draw_quad::stateChange (draw_quad const & other) const
                                                                        {
			if (textureId.idx == other.textureId.idx) 
				return !compareColoursEq(colour, other.colour);
			return true;
			}
LZZ_INLINE void bgfxsfh::untextured_draw_quad::setColour (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                          {
			colour[0] = r;
			colour[1] = g;
			colour[2] = b;
			colour[3] = a;
			}
LZZ_INLINE bool bgfxsfh::untextured_draw_quad::operator < (untextured_draw_quad const & other) const
                                                                                  {
			return compareColoursLt(colour, other.colour);
			}
LZZ_INLINE bool bgfxsfh::untextured_draw_quad::stateChange (untextured_draw_quad const & other) const
                                                                                   {
			return !compareColoursEq(colour, other.colour);
			}
LZZ_INLINE bgfxsfh::Vec4::Vec4 ()
                             {}
LZZ_INLINE bgfxsfh::Vec4 bgfxsfh::Vec4::fromUint8 (uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                          {
			Vec4 rv;
			rv.v[0] = r/255.0;
			rv.v[1] = g/255.0;
			rv.v[2] = b/255.0;
			rv.v[3] = a/255.0;
			return rv;
			}
LZZ_INLINE bool bgfx_stb_font_cache::doScissorTest () const
                                          {
		return !(scissor.x == 0 && scissor.y == 0 && scissor.w == 0 && scissor.h == 0);
		}
#undef LZZ_INLINE
#endif

////////////////////////////////////////////////////////////////////////

#ifdef SDL_STB_FONT_IMPL
#ifndef SDL_STB_FONT_IMPL_DOUBLE_GUARD_bgfxFrontend
#define SDL_STB_FONT_IMPL_DOUBLE_GUARD_bgfxFrontend
// bgfxFrontend.cpp
//

#define LZZ_INLINE inline
bgfx::ShaderHandle bgfxsfh::vert_passthrough = BGFX_INVALID_HANDLE;
bgfx::ShaderHandle bgfxsfh::frag_passthrough = BGFX_INVALID_HANDLE;
bgfx::ShaderHandle bgfxsfh::textured_vert_passthrough = BGFX_INVALID_HANDLE;
bgfx::ShaderHandle bgfxsfh::textured_frag_passthrough = BGFX_INVALID_HANDLE;
bgfx::ProgramHandle bgfxsfh::untexturedProgram = BGFX_INVALID_HANDLE;
bgfx::ProgramHandle bgfxsfh::texturedProgram = BGFX_INVALID_HANDLE;
bgfx::UniformHandle bgfxsfh::u_colour = BGFX_INVALID_HANDLE;
bgfx::UniformHandle bgfxsfh::s_texture = BGFX_INVALID_HANDLE;
uint32_t const bgfxsfh::RENDER_STATE = BGFX_STATE_WRITE_RGB | BGFX_STATE_WRITE_A | BGFX_STATE_BLEND_FUNC(BGFX_STATE_BLEND_SRC_ALPHA, BGFX_STATE_BLEND_INV_SRC_ALPHA);
uint32_t const bgfxsfh::RENDER_STATE_PRERENDER = BGFX_STATE_WRITE_RGB | BGFX_STATE_WRITE_A | BGFX_STATE_BLEND_EQUATION(BGFX_STATE_BLEND_EQUATION_ADD);
int bgfxsfh::refCount = 0;
bgfxsfh::Vec4 bgfxsfh::toVec4 (uint8_t const a, uint8_t const b, uint8_t const c, uint8_t const d)
                                                                                               {
		return Vec4::fromUint8(a,b,c,d);
		}
void bgfxsfh::initialise ()
                                 {
		if (refCount == 0) {
			PosVertex::init();
			PosTexCoord0Vertex::init();
		
			#include "bgfxFrontendShaders.h"
			
			static const bgfx::EmbeddedShader s_embeddedShaders[] = {
				BGFXH_EMBEDDED_SHADER(fs_textured_passthrough_bin),
				BGFXH_EMBEDDED_SHADER(vs_textured_passthrough_bin),
				BGFXH_EMBEDDED_SHADER(fs_untextured_passthrough_bin),
				BGFXH_EMBEDDED_SHADER(vs_untextured_passthrough_bin),
				
				BGFX_EMBEDDED_SHADER_END()
				};
				
			
			bgfx::RendererType::Enum type = bgfx::getRendererType();
			vert_passthrough = bgfx::createEmbeddedShader(s_embeddedShaders, type, "vs_untextured_passthrough_bin");
			frag_passthrough = bgfx::createEmbeddedShader(s_embeddedShaders, type, "fs_untextured_passthrough_bin");
			textured_vert_passthrough = bgfx::createEmbeddedShader(s_embeddedShaders, type, "vs_textured_passthrough_bin");
			textured_frag_passthrough = bgfx::createEmbeddedShader(s_embeddedShaders, type, "fs_textured_passthrough_bin");
			
			untexturedProgram = bgfx::createProgram(vert_passthrough, frag_passthrough, false);
			texturedProgram = bgfx::createProgram(textured_vert_passthrough, textured_frag_passthrough, false);
			//bgfx::setName(untexturedProgram, "stdStbFont_untexturedProgram"); // doesn't compile
			//bgfx::setName(untexturedProgram, "stdStbFont_texturedProgram");
			
			u_colour = bgfx::createUniform("u_colour", bgfx::UniformType::Vec4);
			s_texture = bgfx::createUniform("s_texture", bgfx::UniformType::Sampler);
			
			BGFXSFH_IS_VALID(vert_passthrough);
			BGFXSFH_IS_VALID(frag_passthrough);
			BGFXSFH_IS_VALID(textured_vert_passthrough);
			BGFXSFH_IS_VALID(textured_frag_passthrough);
			BGFXSFH_IS_VALID(untexturedProgram);
			BGFXSFH_IS_VALID(texturedProgram);
			
			BGFXSFH_IS_VALID(u_colour);
			BGFXSFH_IS_VALID(s_texture);
			}
		refCount++;
		}
void bgfxsfh::deinitialise ()
                                   {
		refCount--;
		if (refCount == 0) {
			bgfx::destroy(untexturedProgram); 	untexturedProgram = BGFX_INVALID_HANDLE;
			bgfx::destroy(texturedProgram); 	texturedProgram = BGFX_INVALID_HANDLE;
			
			bgfx::destroy(vert_passthrough); 	vert_passthrough = BGFX_INVALID_HANDLE;
			bgfx::destroy(frag_passthrough); 	frag_passthrough = BGFX_INVALID_HANDLE;
			bgfx::destroy(textured_vert_passthrough); textured_vert_passthrough = BGFX_INVALID_HANDLE;
			bgfx::destroy(textured_frag_passthrough); textured_frag_passthrough = BGFX_INVALID_HANDLE;
			
			bgfx::destroy(u_colour); 			u_colour = BGFX_INVALID_HANDLE;
			bgfx::destroy(s_texture); 			s_texture = BGFX_INVALID_HANDLE;
			}
		}
void bgfxsfh::PosTexCoord0Vertex::init ()
                                   {
			ms_decl.begin()
				.add(bgfx::Attrib::Position,  3, bgfx::AttribType::Float)
				.add(bgfx::Attrib::TexCoord0, 2, bgfx::AttribType::Float)
			.end();
			}
bgfx::VertexLayout bgfxsfh::PosTexCoord0Vertex::ms_decl;
void bgfxsfh::PosVertex::init ()
                                   {
			ms_decl.begin()
				.add(bgfx::Attrib::Position,  3, bgfx::AttribType::Float)
			.end();
			}
bgfx::VertexLayout bgfxsfh::PosVertex::ms_decl;
bgfxsfh::rect bgfxsfh::scissorIntersect (rect const & r, rect const & scissor)
                                                                           {
		rect rIntersect;
		rIntersect.x = bx::max(r.x, scissor.x);
		rIntersect.y = bx::max(r.y, scissor.y);
		rIntersect.w = bx::max(0.f, bx::min(r.x + r.w, scissor.x + scissor.w) - rIntersect.x);
		rIntersect.h = bx::max(0.f, bx::min(r.y + r.h, scissor.y + scissor.h) - rIntersect.y);
	
		return rIntersect;
		}
bgfxsfh::rect bgfxsfh::scissorIntersectTexCoord (rect const & r, rect const & uv, rect const & rIntersect, bool const dontFlipY)
                                                                                                                             {
		// it doesn't know if we've chopped the bottom off r or the top
		rect uvi = uv;
		if (r.w < 0.000001f || r.h < 0.000001f) return uvi;
		uvi.w *= (rIntersect.w / r.w);
		uvi.h *= (rIntersect.h / r.h);
		float offx = (rIntersect.x - r.x) / r.w;
		float offy;
		
		bool _originBottomLeft = false; 
		if (!dontFlipY)
			_originBottomLeft = bgfx::getCaps()->originBottomLeft; // Prevent double flipping
			
		if (_originBottomLeft)
			offy = -(rIntersect.y + rIntersect.h - r.y - r.h) / r.h;
		else
			offy = (rIntersect.y - r.y) / r.h;
			
		uvi.x = uvi.x + uv.w*offx;
		uvi.y = uvi.y + uv.h*offy;
		return uvi;
		}
void bgfxsfh::pushTexturedQuad (rect const & r, rect const & r2, bool dontFlipY)
                                                                                              { pushTexturedQuads(&r, &r2, NULL, 1, dontFlipY); }
void bgfxsfh::pushTexturedQuadWScissor (rect const & r, rect const & r2, rect const & scissor, bool dontFlipY)
                                                                                                                            { 
		rect rIntersect, uvi;
		getTexturedQuadWScissor(r, r2, rIntersect, uvi, scissor, dontFlipY);
		pushTexturedQuads(&rIntersect, &uvi, NULL, 1, dontFlipY);
		}
void bgfxsfh::getTexturedQuadWScissor (rect const & r, rect const & r2, rect & rOut, rect & r2Out, rect const & scissor, bool dontFlipY)
                                                                                                                                                    {
		rOut  = bgfxsfh::scissorIntersect(r, scissor);
		r2Out = bgfxsfh::scissorIntersectTexCoord(r, r2, rOut, dontFlipY);
		}
void bgfxsfh::pushTexturedQuads (rect const * pos, rect const * uv, draw_quad const * drawQuads, int const numQuads, bool const dontFilpY, float const _framebufferWidth, float const _framebufferHeight)
                                                                                                                                                                                                                        {
		// Pass drawQuads=NULL to use pos and uv arrays and vice versa
		/*
		* From the BGFX Examples, the following license applies to only this function:
		* Copyright 2011-2018 Branimir Karadzic. All rights reserved.
		* License: https://github.com/bkaradzic/bgfx#license-bsd-2-clause
		*/
		const bgfx::RendererType::Enum renderer = bgfx::getRendererType();
		const float _texelHalf = 0.0f;//bgfx::RendererType::Direct3D9 == renderer ? 0.5f : 0.0f;
		bool _originBottomLeft = false; 
		if (!dontFilpY)
			_originBottomLeft = bgfx::getCaps()->originBottomLeft; // Prevent double flipping
			
		if (uint32_t(6*numQuads) == bgfx::getAvailTransientVertexBuffer(6*numQuads, bgfxsfh::PosTexCoord0Vertex::ms_decl) ) {
			bgfx::TransientVertexBuffer vb;
			bgfx::allocTransientVertexBuffer(&vb, 6*numQuads, bgfxsfh::PosTexCoord0Vertex::ms_decl);
			bgfxsfh::PosTexCoord0Vertex* vertex = (bgfxsfh::PosTexCoord0Vertex*)vb.data;

			for (int i = 0; i < numQuads; ++i) {
				const rect& r = drawQuads ? drawQuads[i].drawRect : pos[i];
				const rect& r2 = drawQuads ? drawQuads[i].texRect : uv[i];
				
				const float minx = r.x;
				const float maxx = (r.x + r.w);
				const float miny = r.y;
				const float maxy = (r.y + r.h);

				float texelHalfW = 0.f;
				float texelHalfH = 0.f;
				if (_framebufferWidth > 0.0f && _framebufferHeight > 0.0f) {
					texelHalfW = _texelHalf/_framebufferWidth;
					texelHalfH = _texelHalf/_framebufferHeight;
					}
				const float minu = r2.x + texelHalfW;
				const float maxu = r2.x+r2.w + texelHalfH;

				const float zz = 0.0f;

				float minv = r2.y + texelHalfH;
				float maxv = r2.y+r2.h + texelHalfH;

				if (_originBottomLeft) {
					float temp = minv;
					minv = maxv;
					maxv = temp;
					}

				int j = i*6;
				vertex[j+0].m_x = minx;
				vertex[j+0].m_y = miny;
				vertex[j+0].m_z = zz;
				vertex[j+0].m_u = minu;
				vertex[j+0].m_v = minv;

				vertex[j+1].m_x = maxx;
				vertex[j+1].m_y = miny;
				vertex[j+1].m_z = zz;
				vertex[j+1].m_u = maxu;
				vertex[j+1].m_v = minv;

				vertex[j+2].m_x = maxx;
				vertex[j+2].m_y = maxy;
				vertex[j+2].m_z = zz;
				vertex[j+2].m_u = maxu;
				vertex[j+2].m_v = maxv;
				
				vertex[j+3].m_x = minx;
				vertex[j+3].m_y = miny;
				vertex[j+3].m_z = zz;
				vertex[j+3].m_u = minu;
				vertex[j+3].m_v = minv;

				vertex[j+4].m_x = maxx;
				vertex[j+4].m_y = maxy;
				vertex[j+4].m_z = zz;
				vertex[j+4].m_u = maxu;
				vertex[j+4].m_v = maxv;
				
				vertex[j+5].m_x = minx;
				vertex[j+5].m_y = maxy;
				vertex[j+5].m_z = zz;
				vertex[j+5].m_u = minu;
				vertex[j+5].m_v = maxv;
				}


			bgfx::setVertexBuffer(0, &vb);
			}
		}
void bgfxsfh::pushUntexturedQuad (rect const & r)
                                                       { pushUntexturedQuads(&r, NULL, 1); }
void bgfxsfh::pushUntexturedQuadWScissor (rect const & r, rect const & scissor)
                                                                                     {
		rect rIntersect;
		getUntexturedQuadsWScissor(r, rIntersect, scissor);
		pushUntexturedQuads(&r, NULL, 1);
		}
void bgfxsfh::getUntexturedQuadsWScissor (rect const & r, rect & rOut, rect const & scissor, bool dontFlipY)
                                                                                                                         {
		rOut  = bgfxsfh::scissorIntersect(r, scissor);
		}
void bgfxsfh::pushUntexturedQuads (rect const * pos, untextured_draw_quad const * drawQuads, int const numQuads, float const _framebufferWidth, float const _framebufferHeight)
                                                                                                                                                                                               {
		/*
		* From the BGFX Examples, the following license applies to only this function:
		* Copyright 2011-2018 Branimir Karadzic. All rights reserved.
		* License: https://github.com/bkaradzic/bgfx#license-bsd-2-clause
		*/
		if (uint32_t(6*numQuads) == bgfx::getAvailTransientVertexBuffer(6*numQuads, bgfxsfh::PosVertex::ms_decl) ) {
			bgfx::TransientVertexBuffer vb;
			bgfx::allocTransientVertexBuffer(&vb, 6*numQuads, bgfxsfh::PosVertex::ms_decl);
			
			for (int i = 0; i < numQuads; ++i) {
				bgfxsfh::PosVertex* vertex = (bgfxsfh::PosVertex*)vb.data;

				const rect& r = drawQuads ? drawQuads[i].drawRect : pos[i];
					
				const float minx = r.x;
				const float maxx = (r.x + r.w);
				const float miny = r.y;
				const float maxy = (r.y + r.h);

				const float zz = 0.0f;

				int j = i*6;
				vertex[j+0].m_x = minx;
				vertex[j+0].m_y = miny;
				vertex[j+0].m_z = zz;

				vertex[j+1].m_x = maxx;
				vertex[j+1].m_y = miny;
				vertex[j+1].m_z = zz;

				vertex[j+2].m_x = maxx;
				vertex[j+2].m_y = maxy;
				vertex[j+2].m_z = zz;
				
				vertex[j+3].m_x = minx;
				vertex[j+3].m_y = miny;
				vertex[j+3].m_z = zz;

				vertex[j+4].m_x = maxx;
				vertex[j+4].m_y = maxy;
				vertex[j+4].m_z = zz;
				
				vertex[j+5].m_x = minx;
				vertex[j+5].m_y = maxy;
				vertex[j+5].m_z = zz;

				}
			bgfx::setVertexBuffer(0, &vb);
			}
		}
bgfxsfh::cpuBuffer::cpuBuffer ()
  : buff (NULL), w (0), h (0), sz (0), flipY (false)
                                                                          {}
bgfxsfh::cpuBuffer::~ cpuBuffer ()
                             {
			if (buff)
				SSF_DEL_ARR(buff);
			}
void bgfxsfh::cpuBuffer::allocate ()
                                {
			sz = w*h*4;
			buff = SSF_NEW_ARR(uint8_t, sz);
			}
void bgfxsfh::cpuBuffer::clearBuff ()
                                 {
			memset(buff, 0, sz);
			}
void bgfxsfh::cpuBuffer::blend (uint8_t * dst, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                             {
			float srcf = 255.f/a;
			if (a == 255 || dst[3] == 0) { 
				dst[0] = bx::min(255.f, float(dst[0]) + r*srcf);
				dst[1] = bx::min(255.f, float(dst[1]) + g*srcf);
				dst[2] = bx::min(255.f, float(dst[2]) + b*srcf);
				dst[3] = bx::max(dst[3], a);
				}
				
			}
void bgfxsfh::cpuBuffer::writeRGBA (int const x, int const y, uint8_t const * const src, int const bw, int const bh)
                                                                                                              {
			for (int i = 0; i < bw; ++i) {
				for (int j = 0; j < bh; ++j) {
					int lx = x + i;
					int ly = y + j;
					if (lx >= 0 && lx < w && ly >= 0 && ly < h) {
						uint32_t idst = (lx+ly*w)*4;
						if (flipY) idst = (lx+(h-ly-1)*w)*4;
						uint32_t isrc = (i+j*bw)*4;
						blend(&buff[idst], src[isrc+0], src[isrc+1], src[isrc+2], src[isrc+3]);
						}
					}
				}
			}
void bgfxsfh::cpuBuffer::writeA (int const x, int const y, uint8_t const * const src, int const bw, int const bh, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                                                               {
			if (!a) return;
			float f = 255.f/a;
			for (int i = 0; i < bw; ++i) {
				for (int j = 0; j < bh; ++j) {
					int lx = x + i;
					int ly = y + j;
					if (lx >= 0 && lx < w && ly >= 0 && ly < h) {
						uint32_t idst = (lx+ly*w)*4;
						if (flipY) idst = (lx+(h-ly-1)*w)*4;
						uint32_t isrc = (i+j*bw);
						blend(&buff[idst], r, g, b, f*src[isrc]);
						}
					}
				}
			}
void bgfxsfh::cpuBuffer::writeFill (int const x, int const y, int const bw, int const bh, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                                         {
			for (int i = 0; i < bw; ++i) {
				for (int j = 0; j < bh; ++j) {
					int lx = x + i;
					int ly = y + j;
					if (lx >= 0 && lx < w && ly >= 0 && ly < h) {
						uint32_t idst = (lx+ly*w)*4;
						if (flipY) idst = (lx+(h-ly-1)*w)*4;
						blend(&buff[idst], r, g, b, a);
						}
					}
				}
			}
bgfx_stb_prerendered_text::bgfx_stb_prerendered_text ()
  : sttfont_prerendered_text (), mBgfxTexture (BGFX_INVALID_HANDLE)
                                                                                                     {}
void bgfx_stb_prerendered_text::freeTexture ()
                            {
		if (bgfx::isValid(mBgfxTexture))
			bgfx::destroy(mBgfxTexture);
		mBgfxTexture = BGFX_INVALID_HANDLE;
		}
int bgfx_stb_prerendered_text::draw (sttfont_font_cache * fc, int const x, int const y)
                                                                    {
		bgfx_stb_font_cache* bc = (bgfx_stb_font_cache*) fc;
		return draw_worker(mViewId, bc->doScissorTest() ? &bc->scissor : NULL, x, y, true);
		}
int bgfx_stb_prerendered_text::draw (int const x, int const y)
                                            {
		return draw_worker(mViewId, NULL, x, y, true);
		}
int bgfx_stb_prerendered_text::drawWithColorMod (int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                 {
		bgfx::setUniform(bgfxsfh::u_colour, bgfxsfh::toVec4(r,g,b,a).v);
		return draw_worker(mViewId, NULL, x, y, false);
		}
int bgfx_stb_prerendered_text::drawWithColorMod (sttfont_font_cache * fc, int const x, int const y, uint8_t const r, uint8_t const g, uint8_t const b, uint8_t const a)
                                                                                                                                                         {
		bgfx_stb_font_cache* bc = (bgfx_stb_font_cache*) fc;
		bgfx::setUniform(bgfxsfh::u_colour, bgfxsfh::toVec4(r,g,b,a).v);
		return draw_worker(mViewId, bc->doScissorTest() ? &bc->scissor : NULL, x, y, false);
		}
int bgfx_stb_prerendered_text::draw_worker (bgfx::ViewId mViewIdOverride, bgfxsfh::rect * scissor, int const x, int const y, bool const resetColour)
                                                                                                                                  {
		if (!width) return 0; // don't print null texture
		bgfxsfh::rect r;
		r.x = x;
		r.y = y;
		r.w = width;
		r.h = height;
		
		bgfxsfh::rect rt;
		rt.x = 0;
		rt.y = 0;
		rt.w = 1;
		rt.h = 1;
		
		if (scissor) {
			bgfxsfh::rect rIntersect = bgfxsfh::scissorIntersect(r, *scissor);
			bgfxsfh::rect uvi = bgfxsfh::scissorIntersectTexCoord(r, rt, rIntersect, false);
			r = rIntersect;
			rt = uvi;
			}
		
		if (resetColour)
			bgfx::setUniform(bgfxsfh::u_colour, bgfxsfh::toVec4(255,255,255,255).v);
		bgfx::setTexture(0, bgfxsfh::s_texture, mBgfxTexture);
		bgfxsfh::pushTexturedQuad(r, rt);
		bgfx::setState(bgfxsfh::RENDER_STATE);
		bgfx::submit(mViewIdOverride, bgfxsfh::texturedProgram);
		
		//std::cout << "drawing prerendered!!! " << x << ", " << y << ", "  << width << ", " << height << ", viewId: " << mViewId << " " << mViewIdOverride << std::endl;
		BGFXSFH_IS_VALID(mBgfxTexture);
		return r.x + r.w;
		}
bgfx_stb_glyph::bgfx_stb_glyph ()
  : sttfont_glyph (), mAtlasTexture (BGFX_INVALID_HANDLE), x (0), y (0), w (1), h (1)
                                                                                                        {}
bgfx_stb_glyph_atlas::bgfx_stb_glyph_atlas ()
  : mAtlasTexture (BGFX_INVALID_HANDLE), mStbRectPackCtx (NULL), mNodes (NULL), isFull (false)
                                                                                                                        {}
bgfx_stb_font_cache::bgfx_stb_font_cache ()
  : sttfont_font_cache (), mViewId (0), mAtlasSize (1024), renderTarget (NULL), bufferDraws (false)
                                                                                                                            {
		resetScissor();
		}
bgfx_stb_font_cache::~ bgfx_stb_font_cache ()
                                {
		clearGlyphs();
		bgfxsfh::deinitialise();
		}
void bgfx_stb_font_cache::setScissor (float const x, float const y, float const w, float const h)
                                                                                    {
		scissor.x = x;
		scissor.y = y;
		scissor.w = w;
		scissor.h = h;
		}
void bgfx_stb_font_cache::resetScissor ()
                            {
		scissor.x = 0;
		scissor.y = 0;
		scissor.w = 0;
		scissor.h = 0;
		}
bool bgfx_stb_font_cache::scissorTest (bgfxsfh::rect const & t)
                                                  {
		// returns false if culled
		return !(  (scissor.x > t.x + t.w)
				|| (scissor.y > t.y + t.h)
				|| (scissor.x + scissor.w < t.x)
				|| (scissor.y + scissor.h < t.y)
				);
		}
void bgfx_stb_font_cache::clearGlyphs ()
                            {
		for (auto & g : mAtlases) {
			bgfx::destroy(g.mAtlasTexture);
			SSF_DEL_ARR(g.mNodes);
			SSF_DEL(g.mStbRectPackCtx);
			}
			
		mAtlases.clear();
		mGlyphs.clear();
		}
void bgfx_stb_font_cache::bindRenderer (bgfx::ViewId const _viewId)
                                                      {
		mViewId = _viewId;
		bgfxsfh::initialise();
		}
bgfx_stb_glyph_atlas * bgfx_stb_font_cache::getGenAtlasPage ()
                                                {
		if (mAtlases.empty()) {
			return createAtlasPage();
			}
		bgfx_stb_glyph_atlas * r = &mAtlases.back();
		if (r->isFull)
			return createAtlasPage();
		return r;
		}
bgfx_stb_glyph_atlas * bgfx_stb_font_cache::createAtlasPage ()
                                                {
		bgfx_stb_glyph_atlas a;
		a.mAtlasTexture = bgfx::createTexture2D(mAtlasSize, mAtlasSize, false, 1, bgfx::TextureFormat::RGBA8, BGFX_TEXTURE_NONE, NULL);
		bgfx::setName(a.mAtlasTexture, ("sdlStbFont_atlasPg" + std::to_string(mAtlases.size())).c_str());
		
		/*	
		const bgfx::Memory* mem = bgfx::alloc(mAtlasSize*mAtlasSize*4);
		memset(mem->data, 0, mem->size);
		for (uint32_t i = 0; i < mem->size; ++i) {
			mem->data[i] = 255;//(i^1337)%255;
			}
		bgfx::updateTexture2D(a.mAtlasTexture, 0, 0, 0, 0, mAtlasSize, mAtlasSize, mem, mAtlasSize);
		bgfx::frame();
		bgfx::frame();
		bgfx::frame();
		bgfx::frame();*/
		
		int nNodes = mAtlasSize;
		a.mStbRectPackCtx = SSF_NEW(stbrp_context);
		a.mNodes = SSF_NEW_ARR(stbrp_node, nNodes);
		
		for (int i = 0; i < nNodes; ++i) {
			a.mNodes[i].x = 0;
			a.mNodes[i].y = 0;
			a.mNodes[i].next = NULL;
			}
		
		stbrp_init_target(a.mStbRectPackCtx, mAtlasSize, mAtlasSize, a.mNodes, nNodes);
		
		mAtlases.push_back(a);
		return &mAtlases.back();
		}
void bgfx_stb_font_cache::pregenGlyphs (SSF_VECTOR <sttfont_uint32_t_range> & mRanges, uint8_t const format)
                                                                                              {
		// Make your own implmentation for your own frontend here
		SSF_VECTOR<tempGlyph> tempGlyphs;
		SSF_VECTOR<stbrp_rect> rects;
		
		uint32_t size = 0;
		for (sttfont_uint32_t_range & sur : mRanges)
			size += sur.end - sur.start + 1;
		
		tempGlyphs.reserve(size);
		rects.reserve(size);
		
		for (sttfont_uint32_t_range & sur : mRanges) {
			for (uint32_t codepoint = sur.start; codepoint <= sur.end; ++codepoint) {
				uint64_t target = codepoint | (uint64_t(format & ~(sttfont_format::FORMAT_STRIKETHROUGH | sttfont_format::FORMAT_UNDERLINE)) << 32);
				
				// does the codepoint exist already?
				auto check = mGlyphs.find(target);
				if (check != mGlyphs.end()) continue;
				
				bgfx_stb_glyph g;
				tempGlyph t;
				stbrp_rect r;
				
				t.bitmapData = NULL;
				
				genGlyph(codepoint, format, &g, &t.bitmapData);
				
				if (t.bitmapData) {
					r.id = *((int*) &codepoint);
					r.x = 0;
					r.y = 0;
					r.w = g.width;
					r.h = g.height;
					r.was_packed = 0;
					
					mGlyphs[target] = std::move(g);
					t.target = target;
					
					tempGlyphs.push_back(std::move(t));
					rects.push_back(std::move(r));
					}
				}
			}
		
		pregenGlyphs_pack(tempGlyphs, rects, true);
		}
void bgfx_stb_font_cache::pregenGlyphs_pack (SSF_VECTOR <tempGlyph> & tempGlyphs, SSF_VECTOR <stbrp_rect> & rects, bool force)
                                                                                                               {
		bgfx_stb_glyph_atlas* activeAtlas = getGenAtlasPage();
		stbrp_pack_rects(activeAtlas->mStbRectPackCtx, rects.data(), rects.size());
		
		SSF_VECTOR<tempGlyph> glyphs_rejected;
		SSF_VECTOR<stbrp_rect> rects_rejected;
		
		bool anyNotPacked = false;
		
		for (unsigned int i = 0; i < rects.size(); ++i) {
			stbrp_rect & r = rects[i];
			tempGlyph & t = tempGlyphs[i];
			bgfx_stb_glyph * bOut = (bgfx_stb_glyph*) &mGlyphs[t.target];
			
			if (r.was_packed) {
				const bgfx::Memory* mem = bgfx::copy(t.bitmapData, bOut->width*bOut->height*4);
				bgfx::updateTexture2D(activeAtlas->mAtlasTexture, 0, 0, r.x, r.y, r.w, r.h, mem);
				bOut->x = r.x/float(mAtlasSize);
				bOut->y = r.y/float(mAtlasSize);
				bOut->w = r.w/float(mAtlasSize);
				bOut->h = r.h/float(mAtlasSize); 
				bOut->mAtlasTexture = activeAtlas->mAtlasTexture;
				populateGlyphData(bOut, t.bitmapData, r.w, r.h);
				}
			else {
				glyphs_rejected.push_back(std::move(t));
				rects_rejected.push_back(std::move(r));
				anyNotPacked = true;
				}
			}
		if (anyNotPacked)
			activeAtlas->isFull = true;
		
		//std::cout << " pregenGlyphs_pack " << tempGlyphs.size() << " " << glyphs_rejected.size() << std::endl;
		
		if ((glyphs_rejected.size() != tempGlyphs.size() || force) && glyphs_rejected.size())
			pregenGlyphs_pack(glyphs_rejected, rects_rejected, false);
		}
void bgfx_stb_font_cache::genGlyph_writeData (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h)
                                                                                                                        {
		genGlyph_writeData2(codepoint, gOut, bitmap2, w, h, true);
		}
void bgfx_stb_font_cache::populateGlyphData (bgfx_stb_glyph * bOut, unsigned char * bitmap2, int w, int h)
                                                                                           {
		int sz = w*h;
		//bOut->glypthData = SSF_STRING();
		bOut->glypthData.resize(sz);
		for (int i = 0; i < sz; ++i) {
			bOut->glypthData[i] = bitmap2[i*4+3];
			}
		}
void bgfx_stb_font_cache::genGlyph_writeData2 (uint32_t const codepoint, sttfont_glyph * gOut, unsigned char * bitmap2, int w, int h, bool firstCall)
                                                                                                                                         {
		// fetch or create atlas
		bgfx_stb_glyph * bOut = (bgfx_stb_glyph*) gOut;
		bgfx_stb_glyph_atlas * activeAtlas = getGenAtlasPage();
		
		//std::cout << "genGlyph_writeData2 " << char(codepoint) << " #" << codepoint << ", firstCall: " << firstCall << ", activeAtlas "<< activeAtlas << std::endl;
		
		// try to pack
		stbrp_rect r;
		r.id = *((int*) &codepoint);
		r.x = 0;
		r.y = 0;
		r.w = w;
		r.h = h;
		r.was_packed = 0;
		
		stbrp_pack_rects(activeAtlas->mStbRectPackCtx, &r, 1);
		if (r.was_packed) {
			//std::cout << "packing: " << r.x << ", " << r.y << ", " << r.w << ", " << r.h << std::endl;
			const bgfx::Memory* mem = bgfx::copy(bitmap2, w*h*4);
			bgfx::updateTexture2D(activeAtlas->mAtlasTexture, 0, 0, r.x, r.y, r.w, r.h, mem);
			bOut->x = r.x/float(mAtlasSize);
			bOut->y = r.y/float(mAtlasSize);
			bOut->w = r.w/float(mAtlasSize);
			bOut->h = r.h/float(mAtlasSize); 
			bOut->mAtlasTexture = activeAtlas->mAtlasTexture;
			populateGlyphData(bOut, bitmap2, r.w, r.h);
			BGFXSFH_IS_VALID(bOut->mAtlasTexture);
			return;
			}
		else {
			activeAtlas->isFull = true;
			}
		
		// failed to pack, generate a new atlas
		if (firstCall)
			genGlyph_writeData2(codepoint, gOut, bitmap2, w, h, false);
		}
sttfont_glyph * bgfx_stb_font_cache::getGlyph (uint64_t const target)
                                                        {
		auto it = mGlyphs.find(target);
		if (it == mGlyphs.end())
			return NULL;
		return &((*it).second);
		}
sttfont_glyph * bgfx_stb_font_cache::genGlyph_createAndInsert (uint64_t const target, uint32_t const codepoint, uint8_t const format)
                                                                                                                        {
		bgfx_stb_glyph g;
		genGlyph(codepoint, format, &g);
		mGlyphs[target] = g;
		return getGlyph(target);
		}
void bgfx_stb_font_cache::onStartDrawing ()
                              {
		if (renderTarget) return;
		bufferDraws = true;
		}
void bgfx_stb_font_cache::onCompletedDrawing ()
                                  {
		if (renderTarget) return;
		if (!bufferDraws) return;
		bufferDraws = false;
		
		// Submit batched draw commands
		if (drawBuffer.size()) {
			// tbd: is sorting more expensive than more draw calls? bucketing can fix this
			// most strings use the same texture & format so we won't sort for now
			//std::sort(drawBuffer.begin(), drawBuffer.end()); 
			uint32_t drawLast = 0;
			for (uint32_t i = 1; i < drawBuffer.size(); ++i) {
				if (drawBuffer[i].stateChange(drawBuffer[i-1])) { // state change
					bgfxsfh::draw_quad & d = drawBuffer[drawLast];
					bgfx::setTexture(0, bgfxsfh::s_texture, d.textureId);
					bgfxsfh::Vec4 temp = bgfxsfh::toVec4(d.colour[0],d.colour[1],d.colour[2],d.colour[3]);
					bgfx::setUniform(bgfxsfh::u_colour, temp.v);
					
					bgfxsfh::pushTexturedQuads(NULL, NULL, &drawBuffer[drawLast], i-drawLast, true); 
					
					bgfx::setState(bgfxsfh::RENDER_STATE);
					bgfx::submit(mViewId, bgfxsfh::texturedProgram);
					
					drawLast = i;
					}
				}
			if (drawBuffer.size() - drawLast) {
				//drawLast = 0;
				uint32_t i = drawBuffer.size();
				bgfxsfh::draw_quad & d = drawBuffer[drawLast];
				bgfx::setTexture(0, bgfxsfh::s_texture, d.textureId);
				bgfxsfh::Vec4 temp = bgfxsfh::toVec4(d.colour[0],d.colour[1],d.colour[2],d.colour[3]);
				bgfx::setUniform(bgfxsfh::u_colour, temp.v);
				
				bgfxsfh::pushTexturedQuads(NULL, NULL, &drawBuffer[drawLast], i-drawLast, true); 
				
				bgfx::setState(bgfxsfh::RENDER_STATE);
				bgfx::submit(mViewId, bgfxsfh::texturedProgram);
				}
			drawBuffer.clear();
			}
		
		if (untexturedDrawBuffer.size()) {
			//std::sort(untexturedDrawBuffer.begin(), untexturedDrawBuffer.end());
			uint32_t drawLast = 0;
			for (uint32_t i = 1; i < untexturedDrawBuffer.size(); ++i) {
				if (untexturedDrawBuffer[i].stateChange(untexturedDrawBuffer[i-1])) { // state change
					bgfxsfh::untextured_draw_quad & d = untexturedDrawBuffer[drawLast];
					bgfxsfh::Vec4 temp = bgfxsfh::toVec4(d.colour[0],d.colour[1],d.colour[2],d.colour[3]);
					bgfx::setUniform(bgfxsfh::u_colour, temp.v);
					
					bgfxsfh::pushUntexturedQuads(NULL, &untexturedDrawBuffer[drawLast], i-drawLast); 
					
					bgfx::setState(bgfxsfh::RENDER_STATE);
					bgfx::submit(mViewId, bgfxsfh::untexturedProgram);
					
					drawLast = i;
					}
				}
			if (untexturedDrawBuffer.size() - drawLast) {
				//drawLast = 0;
				uint32_t i = untexturedDrawBuffer.size();
				bgfxsfh::untextured_draw_quad & d = untexturedDrawBuffer[drawLast];
				bgfxsfh::Vec4 temp = bgfxsfh::toVec4(d.colour[0],d.colour[1],d.colour[2],d.colour[3]);
				bgfx::setUniform(bgfxsfh::u_colour, temp.v);
				
				bgfxsfh::pushUntexturedQuads(NULL, &untexturedDrawBuffer[drawLast], i-drawLast); 
				
				bgfx::setState(bgfxsfh::RENDER_STATE);
				bgfx::submit(mViewId, bgfxsfh::untexturedProgram);
				}
			
			untexturedDrawBuffer.clear();
			}
		}
void bgfx_stb_font_cache::drawCodepoint (sttfont_glyph const * const GS, int const x, int const y, uint32_t const codepoint, sttfont_format const * const format, uint8_t const formatCode, int const kerningAdv, int & overdraw)
                                                                                                                                                                                                                     {
		const bgfx_stb_glyph * const G = (const bgfx_stb_glyph * const) GS;
		// Draws the character
		const uint64_t RSTATE = renderTarget ? bgfxsfh::RENDER_STATE_PRERENDER : bgfxsfh::RENDER_STATE;
		const bgfx::ViewId _viewId = renderTarget ? 0 : mViewId; 
		
		bgfxsfh::rect r;	// render coords
		r.x = x + G->xOffset;
		r.y = y + G->yOffset + baseline;
		r.w = G->width;
		r.h = G->height;
		
		bgfxsfh::rect rt;	// glyph texcoords
		rt.x = G->x;
		rt.y = G->y;
		rt.w = G->w;
		rt.h = G->h;
		
		bool st = true;
		bool useScissor = false;
		if (!renderTarget) {
			if (doScissorTest()) {
				st = scissorTest(r);
				useScissor = true;
				}
			}
		
		if (st) {//bgfx::isValid(G->mAtlasTexture)) {
			if (format) {
				int charAdv = kerningAdv + G->xOffset;
				//bool isColoured = (format->r < 255) || (format->g < 255) || (format->b < 255);
				
				// Draw the glypth
				if (!renderTarget) {
					if (bgfx::isValid(G->mAtlasTexture)) {
						if (bufferDraws) {
							bgfxsfh::draw_quad dc;
							dc.setColour(format->r, format->g, format->b, format->a);
							dc.textureId = G->mAtlasTexture;
							dc.drawRect = r;
							dc.texRect = rt;
							if (useScissor)
								bgfxsfh::getTexturedQuadWScissor(r, rt, dc.drawRect, dc.texRect, scissor, true);
							drawBuffer.push_back(dc);
							}
						else {
							bgfx::setUniform(bgfxsfh::u_colour, bgfxsfh::toVec4(format->r, format->g, format->b, format->a).v);
							bgfx::setTexture(0, bgfxsfh::s_texture, G->mAtlasTexture);
							
							if (useScissor)
								bgfxsfh::pushTexturedQuadWScissor(r, rt, scissor, true);
							else
								bgfxsfh::pushTexturedQuad(r, rt, true);
							bgfx::setState(RSTATE);
							bgfx::submit(_viewId, bgfxsfh::texturedProgram);
							}
						}
					}
				else {
					renderTarget->writeA(r.x, r.y, (const uint8_t*const)G->glypthData.data(), r.w, r.h, format->r, format->g, format->b, format->a);
					}
				
				if (formatCode & sttfont_format::FORMAT_STRIKETHROUGH) {
					bgfxsfh::rect r2;
					r2.w = G->width+strikethroughThickness + charAdv; r2.h = strikethroughThickness;
					if (r2.h < 1) r2.h = 1;
					r2.x = r.x-strikethroughThickness/2 - charAdv; r2.y = y + strikethroughPosition;
					if (!renderTarget) {
						if (bufferDraws) {
							bgfxsfh::untextured_draw_quad dc;
							dc.setColour(format->r, format->g, format->b, format->a);
							dc.drawRect = r2;
							if (useScissor)
								bgfxsfh::getUntexturedQuadsWScissor(r2, dc.drawRect, scissor, true);
							untexturedDrawBuffer.push_back(dc);
							}
						else {
							if (useScissor)
								bgfxsfh::pushUntexturedQuadWScissor(r2, scissor);
							else
								bgfxsfh::pushUntexturedQuad(r2);
							bgfx::setState(bgfxsfh::RENDER_STATE);
							bgfx::submit(_viewId, bgfxsfh::untexturedProgram);
							}
						}
					else {
						renderTarget->writeFill(r2.x, r2.y, r2.w, r2.h, format->r, format->g, format->b, format->a);
						}
					}
				if (formatCode & sttfont_format::FORMAT_UNDERLINE) {
					bgfxsfh::rect r2;
					r2.w = G->width+underlineThickness + charAdv; r2.h = underlineThickness;
					if (r2.h < 1) r2.h = 1;
					r2.x = r.x-underlineThickness/2 - charAdv; r2.y = y + underlinePosition;
					if (!renderTarget) {
						if (bufferDraws) {
							bgfxsfh::untextured_draw_quad dc;
							dc.setColour(format->r, format->g, format->b, format->a);
							dc.drawRect = r2;
							if (useScissor)
								bgfxsfh::getUntexturedQuadsWScissor(r2, dc.drawRect, scissor, true);
							untexturedDrawBuffer.push_back(dc);
							}
						else {
							if (useScissor)
								bgfxsfh::pushUntexturedQuadWScissor(r2, scissor);
							else
								bgfxsfh::pushUntexturedQuad(r2);
							bgfx::setState(bgfxsfh::RENDER_STATE);
							bgfx::submit(_viewId, bgfxsfh::untexturedProgram);
							}
						}
					else {
						renderTarget->writeFill(r2.x, r2.y, r2.w, r2.h, format->r, format->g, format->b, format->a);
						}
					}
				}
			else {
				if (!renderTarget) {
					overdraw = SSF_INT_MIN;
					
					if (bufferDraws) {
						bgfxsfh::draw_quad dc;
						dc.setColour(255,255,255,255);
						dc.textureId = G->mAtlasTexture;
						dc.drawRect = r;
						dc.texRect = rt;
						if (useScissor)
							bgfxsfh::getTexturedQuadWScissor(dc.drawRect, dc.texRect, dc.drawRect, dc.texRect, scissor, true);
						drawBuffer.push_back(dc);
						std::cout << "submitting 1! " << char(codepoint) << std::endl;
						}
					else {
						bgfx::setTexture(0, bgfxsfh::s_texture, G->mAtlasTexture);
						bgfxsfh::Vec4 temp = bgfxsfh::toVec4(255,255,255,255);
						bgfx::setUniform(bgfxsfh::u_colour, temp.v);
						
						if (useScissor)
							bgfxsfh::pushTexturedQuadWScissor(r, rt, scissor, true);
						else
							bgfxsfh::pushTexturedQuad(r, rt, true);
						bgfx::setState(RSTATE);
						bgfx::submit(_viewId, bgfxsfh::texturedProgram);
						//std::cout << "submitting! " << char(codepoint) << std::endl;
						}
					}
				else {
					renderTarget->writeA(r.x, r.y, (const uint8_t*const)G->glypthData.data(), r.w, r.h, 255, 255, 255, 255);
					}
				}
			}
		}
bgfx::TextureHandle bgfx_stb_font_cache::renderTextToTexture (char const * c, uint32_t const maxLen, int * widthOut, int * heightOut)
                                                                                                                                            {
		return renderTextToTexture_worker(NULL, c, maxLen, widthOut, heightOut);
		}
bgfx::TextureHandle bgfx_stb_font_cache::renderTextToTexture (sttfont_formatted_text const & formatted, int * widthOut, int * heightOut)
                                                                                                                                          {
		return renderTextToTexture_worker(&formatted, NULL, -1, widthOut, heightOut);
		}
bgfx::TextureHandle bgfx_stb_font_cache::renderTextToTexture_worker (sttfont_formatted_text const * formatted, char const * c, uint32_t const maxLen, int * widthOut, int * heightOut)
                                                                                                                                                                                             {
		int width, height;
		if (formatted)
			getTextSize(width, height, *formatted);
		else
			getTextSize(width, height, c, maxLen);
			
		if (width < 1) {
			return BGFX_INVALID_HANDLE; // empty string
			}
			
		// This is bad - Bgfx is not meant to be used this way
		// Possible improvements
		// 1. Store all glpyhs on cpu, make texture by copying to buffer
		// 2. Have an atlas-page system for prerenders. The object created will have to keep track of bits of the atlas being used and clear pages not used anymore
		// 3. Accumulate view slots + call frame() automatically when some limit is reached. Have some kind of dispatchRenderToTexture() to call frame() and reset the view counter when done
		// 4. Reusue the damn framebuffer. Only regenerate it if we need a bigger one on at least one axis
		bgfxsfh::cpuBuffer buff;
		buff.w = width;
		buff.h = height;
		buff.sz = buff.w*buff.h*4;
		
		#ifdef _MSC_VER
			sttfont_tmpArr<uint8_t, 4096> tmpArr(buff.sz);
			uint8_t* chr = tmpArr.arr;
		#else
			uint8_t chr[buff.sz];
		#endif
		
		buff.buff = &chr[0];
		buff.clearBuff();
		buff.flipY = bgfx::getCaps()->originBottomLeft;
		renderTarget = &buff;
		if (formatted)
			drawText(0, 0, *formatted);
		else
			drawText(0, 0, c, maxLen);
			
		const bgfx::Memory* mem = bgfx::copy(buff.buff, buff.sz);
			
		bgfx::TextureHandle RT = bgfx::createTexture2D(width, height, false, 1, bgfx::TextureFormat::RGBA8, BGFX_TEXTURE_NONE, mem);
		bgfx::setName(RT, "ssf_prt");
		
		buff.buff = NULL;
		renderTarget = NULL;
		
		if (widthOut)  *widthOut = width;
		if (heightOut) *heightOut = height;
		
		return RT;
		}
bgfx::TextureHandle bgfx_stb_font_cache::renderTextToTexture (SSF_STRING const & str, int * widthOut, int * heightOut)
                                                                                                                        {
		return renderTextToTexture(str.data(), str.length(), widthOut, heightOut);
		}
void bgfx_stb_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, char const * c, uint32_t const maxLen)
                                                                                                                 {
		bgfx_stb_prerendered_text * textOut2 = (bgfx_stb_prerendered_text*) textOut;
		textOut2->mBgfxTexture = renderTextToTexture(c, maxLen, &(textOut->width), &(textOut->height));
		textOut2->mViewId = mViewId;
		}
void bgfx_stb_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, SSF_STRING const & str)
                                                                                             {
		bgfx_stb_prerendered_text * textOut2 = (bgfx_stb_prerendered_text*) textOut;
		textOut2->mBgfxTexture = renderTextToTexture(str, &(textOut->width), &(textOut->height));
		textOut2->mViewId = mViewId;
		}
void bgfx_stb_font_cache::renderTextToObject (sttfont_prerendered_text * textOut, sttfont_formatted_text const & str)
                                                                                                         {
		bgfx_stb_prerendered_text * textOut2 = (bgfx_stb_prerendered_text*) textOut;
		textOut2->mBgfxTexture = renderTextToTexture(str, &(textOut->width), &(textOut->height));
		textOut2->mViewId = mViewId;
		}
#undef LZZ_INLINE
#endif //SDL_STB_FONT_IMPL_DOUBLE_GUARD_bgfxFrontend
#endif //SDL_STB_FONT_IMPL_IMPL
