package io.github.thebusybiscuit.sensibletoolbox.api.recipes;

/**
 * Store information about a particular item's fuel properties.
 * 
 * @author desht
 */
public class FuelValues {

    // Charge per tick
    private final double charge;

    // total ticks
    private final int burnTime;

    private final double totalFuelValue;

    public FuelValues(double charge, int burnTime) {
        this.charge = charge;
        this.burnTime = burnTime;
        totalFuelValue = charge * burnTime;
    }

    /**
     * Get the SCU per tick generated by converting this fuel.
     *
     * @return the SCU per tick
     */
    public double getCharge() {
        return charge;
    }

    /**
     * Get the time in server ticks to convert the item into SCU.
     *
     * @return the burn time, in ticks
     */
    public int getBurnTime() {
        return burnTime;
    }

    /**
     * Get the total fuel value, in SCU, of this fuel.
     *
     * @return the total SCU produced
     */
    public double getTotalFuelValue() {
        return totalFuelValue;
    }

    @Override
    public String toString() {
        return charge + " SCU/t over " + burnTime + "t = " + totalFuelValue + " SCU";
    }
}