# :toolbox: Sensible Toolbox
Looking for the download link? [**Click here**](#floppy_disk-download-sensible-toolbox)

Sensible Toolbox is a Spigot/Paper plugin which adds a bunch of new items, tools and machines to your Minecraft Server.
It's heavily inspired by certain Forge-based mods, but of course requires no client modifications at all.

Also check out [Slimefun4](https://github.com/Slimefun/Slimefun4), they pair really well together!

## :notebook_with_decorative_cover: About the project
SensibleToolbox was created in early 2014 and originally developed by [@desht](https://github.com/desht), here is a link to the original GitHub Repository: https://github.com/desht/sensibletoolbox.<br>
I took over the project back in late 2014 and continued to update it for some time until I have quit plugin development altogether in late 2016.<br>
In late 2020 STB was finally updated once more but it is currently very unstable, so please report any bugs you can find!

## :floppy_disk: Download Sensible Toolbox
You can download SensibleToolbox for free right here: [Development Builds](https://thebusybiscuit.github.io/builds/Slimefun/SensibleToolbox/master/)<br>
STB has no dependencies, so you can just drop it into your `/plugins/` folder and you are good to go!

**WARNING: STB has only just been updated to newer versions of Minecraft, builds are extremely unstable and we don't recommend you to use them on any live server.**
**For private testing and bug reporting only! Please report any bug you come across!**

<p align="center">
  <a href="https://thebusybiscuit.github.io/builds/Slimefun/SensibleToolbox/master/">
    <img src="https://thebusybiscuit.github.io/builds/Slimefun/SensibleToolbox/master/badge.svg" alt="Build Server"/>
  </a>
</p>

## :headphones: Discord Support Server
You can join the official Slimefun Discord Server to chat about Slimefun and some of our other projects, including SensibleToolbox.<br>
Please head to the `#sensible-toolbox` channel for this.

**Important**: We do **not** accept bug reports on discord, please use our [Issue Tracker](https://github.com/Slimefun/SensibleToolbox/issues) to submit bug reports!

<p align="center">
  <a href="https://discord.gg/slimefun">
    <img src="https://discordapp.com/api/guilds/565557184348422174/widget.png?style=banner3" alt="Discord Invite"/>
  </a>
</p>

## :wave: Contributing to this project
Sensible Toolbox is an Open-Source project and licensed under
[GNU GPLv3](https://github.com/Slimefun/SensibleToolbox/blob/master/LICENSE).<br>
Please consider helping us maintain this project too, your engagement keeps the project alive <3.

You can find more info on how to contribute to this project in our [CONTRIBUTING.md](https://github.com/Slimefun/SensibleToolbox/blob/master/CONTRIBUTING.md).

## :bulb: Credits
This is a fork of [desht/sensibletoolbox](https://github.com/desht/sensibletoolbox).

Sensible Toolbox is primarily original code, but many of its ideas stem from popular Forge mods.
So credit where credit is due:
* The BSU/HSU blocks are based on Barrels from Factorization and Jabba, also the Deep Storage Unit from Minefactory Reloaded.
* The processing machines get their inspiration from multiple Forge-based mods, in particular IC2 and Thermal Expansion.
* The energy system is primarily inspired by Thermal Expansion.
* Numerous miscellaneous items are adapted (sometimes blatantly!) from Misc Utilities and OpenBlocks.
* The item routing system is entirely original (as far as I'm aware), mainly due to the fact that it's difficult to do pipes with vanilla Minecraft blocks :)
* The ender storage system is inspired by and works similarly (but not identically) to Ender Storage.

### Disclaimer
SensibleToolbox uses [bStats](https://bstats.org/plugin/bukkit/SensibleToolbox/6354) to collect anonymous information about the usage of this plugin.<br>
This is solely for statistical purposes, as we are interested in how Servers/Players use this plugin.<br>
All available data is anonymous and aggregated, at no point can we see individual server or player information.<br>
All of the collected data is publicly accessible: https://bstats.org/plugin/bukkit/SensibleToolbox/6354

You can also disable this behaviour under `/plugins/bStats/config.yml`.<br>
For more info see [bStats' Privacy Policy](https://bstats.org/privacy-policy)
