# SensibleToolbox - Code of Conduct
### What is a Code of Conduct?
> A code of conduct is a document that establishes expectations for behavior for your project’s participants. 
> Adopting, and enforcing, a code of conduct can help create a positive social atmosphere for your community.
<br>\- *Source: [https://opensource.guide](https://opensource.guide/code-of-conduct/#why-do-i-need-a-code-of-conduct)*

This document should serve the purpose of outlining the behaviour we expect from any participant of the project.

## :mag_right: Scope
This Code of Conduct applies to all sections of the [SensibleToolbox GitHub repository](https://github.com/Slimefun/SensibleToolbox), our [Slimefun GitHub organization](https://github.com/Slimefun) and all repositories owned by said organization.<br>
For our official Discord server, please refer to our article on [Discord Rules](https://github.com/Slimefun/Slimefun4/wiki/Discord-Rules).

Everyone who engages with this project on any of these repositories is expected to follow the Code of Conduct.<br>
This includes maintainers, contributors, sponsors and anyone who engages in the "Issues" section on GitHub.

## :loudspeaker: Engagement
This is an Open-Source project, anyone is welcome to engage and contribute!<br>
We generally expect users to engage in the Issues section by reporting bugs or commenting on bug reports to give additional context, help, guidance or to propose possible solutions and fixes.
Pull Requests are very much welcome and encouraged! They keep the project alive, so if you see an Issue and know how to fix it, feel free to create a Pull Request!

Issues that are considered "good first issues", indicated by the [good first issue](https://github.com/Slimefun/SensibleToolbox/labels/good%20first%20issue) label, are generally expected to be beginner-friendly. 
And even if you shouldn't know where to start or how to proceed, our [Discord Server](https://discord.gg/slimefun) and its community will be there for you!

When commenting, please keep in mind that this software is offered for **free**. Don't expect to receive lightning-fast replies 24 hours a day. 
Everyone here works on this project in their free time and usually has work, school, university or family to take care of, so we appreciate patience and understanding.

## :scroll: Our Standards
Examples of behavior that contributes to a positive environment for our community include but are not limited to:
* Demonstrating empathy and kindness towards other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologizing to those affected by our mistakes and learning from the experience
* Focusing on what is best not just for us as individuals, but for the overall community
* Having patience and understanding for contributors, even if reply times are slow

<hr>

Examples of unacceptable behavior include but are not limited to:
* The use of sexualized language or imagery, and sexual attention or advances of any kind
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email address, without their explicit permission
* Impatient, aggresive and toxic behaviour
* Other conduct which could reasonably be considered inappropriate in a professional setting

## :round_pushpin: Enforcement Responsibilities
Our project maintainers are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Maintainers have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

You can see a list of people who are recognized as "project maintainers" for Slimefun on the Slimefun GitHub organization:<br>
https://github.com/orgs/Slimefun/people

## :wrench: Enforcement
Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the community leaders (labelled on Discord as "Admins" or "Moderators") responsible for enforcement on our [Discord Server](https://discord.gg/slimefun).
If you want your issue to be handled discreetly, message `TheBusyBiscuit#2610` or `Walshy#9709` privately on Discord and state your concerns.

All complaints will be reviewed and investigated promptly and fairly.
All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## :balance_scale: Attribution
This Code of Conduct is a **modified version** of the original [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org),
version 2.0, available at
https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.

The Contributor Covenant was created by Coraline Ada Ehmke in 2014 and is released under the [CC BY 4.0 License](https://github.com/ContributorCovenant/contributor_covenant/blob/release/LICENSE.md).
