#2015-3-13 PROVIDE( kernstart = .); 无法得到正确内核起始位置
最终使用`kernstart = . ;` 配合在pmm.h中定义 `uint8_t kernstart`，取得了比较靠谱的结果，但是内核大小达到了20KB? 我的kernel文件才12KB, 怀疑问题出在 floppy.s (F叔的做法好像和我一样.
#2015-3-24 内存中内核长度比内核文件长度大得多
内存中的内核长度是正确的，ld 不会为 bss 段提供空间，所以内核文件比内存中内核长度小，且内核没有加载器，bss段只能放在所有段的最后。
#2015-3-27 将vmm编译进kernel后错误
在vmm只是被编译进去的情况下(并没有执行), kernel在一开始即出错, 用bochs调试器定位, 错误发生在kernel的第一个函数里, 错误的语句为 `mov ds:[0x010e008], 0x0`, 如果不将cmm编译进去, 结果则是`mov ds:[8e008], 0x0` ,寻址的长度增大了导致错误? 仔细想了一下最大的可能就是段错误了...
用bochs自带的查看器查看GDT, 发现段界限只有0xfffff, 明显地: 0x10e008 > 0xfffff

这是在看Orange's的时候就埋下的坑, 当时将Orange's里的descriptor宏抄过来的时候, 就出现自己定义的段界限和实际段界限不符的情况, 那时候内核还能正常运行, 所以就忽略了这个细节.

 事实上, GDT的limit只有20位, 最多只能表示0xfffff的界限, 如果开启GDT表项的第55位Gr的时候, 就能将粒度表示为4k...而这个在Orange's里面是没有开启的, 因此在段属性后面加上`DA_LIMIT_4K`即可.
 (我也没有再去看descriptor里面怎么处理Gr了...它提供了选项, 我就先用着...(迟早作死.

#2015-4-5 vmm填充页表数组后花屏.
这个花屏超级漂亮的...因为这几天懒, 就暂且没动代码了, 晚上洗衣服的时候突然想到, 花屏肯定是因为写了不该写的内存, 可是我指定的显存是在0xb8000, 内核起始地址在0x8000, 内核长度150K+, 已经互相覆盖了. 刚查了一下pte_kern起始地址在0x8e000, 长度 1024 * 1024, 八九不离十了...又是以前挖下的坑, 把内核移到0x100000是有好处的...
重定位后问题解决...
##2012-4-5 在ld脚本中将基址定位到0x100000报错.
`relocation truncated to fit: R_386_16 against .text'`
没指望看懂错误提示, 搜了一下, 在OSDEV有个帖子:
[link](http://forum.osdev.org/viewtopic.php?f=1&t=13848)
大意是: 需要一个16位的值, 但是实际上我给的是32位值.
我的代码里原本有`mov si, msg_str`这样的指令, 因为把基址从0x8000改成了0x100000, 所以`msg_str`
就成了32位值, 所以这个指令错了, done.

#2015-4-20 分页映射失效
失效个鬼啊，我根本就没启用分页啊摔！缺了对cr0的操作！
接下来可能会参考xv6了。

#2015-5-21
内核线程切换的问题仍然没法解决, 打算先做别的.
比如磁盘驱动

#2015-5-30 磁盘驱动
都是些愚蠢的错误
* 无法读取磁盘状态: 在生成一个磁盘文件后, `ide_wait`死循环, 原因是因为生成文件的时候用了root权限, 导致bochs读不了.
* 执行`ide_rw`后没有接收到操作完成的中断: 指定错了磁盘号, 磁盘号从0开始.
* 在没有从磁盘读取的情况下, 读到了`buf->data`里面又奇怪的东西并且页异常:
我将`_buf`定义成了局部变量了.
* 目测线代要挂.

#2015-7-14 heap_test 的时候 page fault
在把文件系统相关代码编译入内核的时候, 偶然发现之前工作良好的 `heap_test` page fault 了, 多次排查后发现大概是内核没有完全没读入内存?

经过排查, 修正了载入内核时候的错误...之前没出错还真是好运.(事实证明这只是偶然发现了另一个错误, 和 page fault 没什么关系)
现在一次载入一个扇区, 总共载入 20 个柱面(360 KB, 当前内核 70+ KB), 至少可以保证以后的内核都正确载入.
但是如果不载入那么多扇区的话, 依旧会 page fault, 然而内核远没有那么大, 好奇怪, 问题未解决.
(bootloader 的坑还真多, 都是自己挖的)
###2015-7-15 解决
又是愚蠢的错误... 在 Nami 的鼓励下发现了. `vmm_init` 的时候没有把 `PTE_COUNT` 之后的页目录初始化为 0, 在 bochs 里那一段内存刚好就不为0, 访问了不存在的页表, 而 `qemu` 里面这里是0所以不报错...(qemu是有多不靠谱啊...) 如果多载入扇区的话会把 bss 段覆盖一次, 相当于把余下的页表初始化了... ~~话说我已经看不懂页表那里的代码了完全是二分定位 bug 然后胡改一通...~~

#2015-7-14 kernel 最后的值没有被复制
生成了 kernel 文件最后的值是 0x0a, 可是为什么无论如何这个 0x0a 就无法被读到内存中去呢...
无法理解.

#2015-8-14 关于 bitmap 的操作还是不太清楚, 尽管结果是正确的

#2015-8-20 执行 userland 的第一条指令时, 莫名奇妙地 PageFault, 而用 bochs 单步错误则不发生
stupid! 错误并不是发生在执行 userland 的时候, 而是因为刚进入 userland 时, IF 位是置位的... 因此有时钟中断发生... 错误发生在执行中断的代码上.
因此暂且把中断关掉, 问题解决. 感谢 #archlinux-cn@fixme

#2015-8-21 userland 中执行 int 时, CPU 没有从 tss 取得内核的 ss 和 esp
当要执行的 ISR 的段的 `DPL` < `CPL` 时, CPU 会从 tss 取出对应特权级的 ss 和 esp(这里是 ss0 和 esp0), 然而...

如果段描述符的 Access bit `DC` 置位时, 意味着该段可以被与之相等或更低特权级的段访问(所以就没有取出 tss 的内容了甚至 cs 寄存器的 CPL 也不改变)...但是 kerenl 的页表可是 `PTE_K`的, 所以发生 Page Fault.

#2015-9-6 进入 fork 生成的进程后, PIC 中断不发生, 而第一个进程却不会这样
不清楚为什么会这样, 只能强制在 `fork_ret` 中再初始化一次, 代码勉强工作.
// TODO

感谢F叔提供的思路!
