/* isr.c
 * This file is modified form Bram's Kernel Development Tutorial
 * set up the Interrupt Service Routines,
 * which handle excepitons generated by processor 
 */
// std
#include <type.h>
#include <vga.h>
#include <dbg.h>
// x86
#include <pm.h>
#include <isr.h>
#include <syscall.h>
// mm
#include <vmm.h>
// libs
#include <printk.h>

extern void isr_unknown();

void isr_init(){
    fault_init();
    /* treat unknown interrupt as fault */
    int i;
    for (i = ISR_IRQ0; i < NIDT; i++){
        idt_install(i,(uint32_t)isr_unknown, SEL_KCODE << 3, GATE_INT, IDT_PR|IDT_DPL_KERN);
    }

    irq_init();
    sys_init();
}

void isr_stub(struct int_frame *r){
    assert(r->int_no >= 0, "isr_stub: wrong intrrupt number < 0");

    if (r->int_no < ISR_IRQ0 || r->int_no == ISR_UNKNOWN){
        fault_handler(r);
    }
    else if (r->int_no < ISR_IRQ0 + 16){
        irq_handler(r);
    }
    else if (r->int_no == ISR_SYSCALL){
        syscall();  // syscall get syscall number form proc->fm
    } 
    else {
        panic("isr_stub: wrong intrrupt number");
    }
}
