import Vue from 'vue'
import Router from 'vue-router'

// in development-env not use lazy-loading, because lazy-loading too many pages will cause webpack hot update too slow. so only in production use lazy-loading;
// detail: https://panjiachen.github.io/vue-element-admin-site/#/lazy-loading

Vue.use(Router)

/* Layout */
import Layout from '../views/layout/Layout'

/**
* hidden: true                   if `hidden:true` will not show in the sidebar(default is false)
* alwaysShow: true               if set true, will always show the root menu, whatever its child routes length
*                                if not set alwaysShow, only more than one route under the children
*                                it will becomes nested mode, otherwise not show the root menu
* redirect: noredirect           if `redirect:noredirect` will no redirct in the breadcrumb
* name:'router-name'             the name is used by <keep-alive> (must set!!!)
* meta : {
    title: 'title'               the name show in submenu and breadcrumb (recommend set)
    icon: 'svg-name'             the icon show in the sidebar,
  }
**/
export const constantRouterMap = [

  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    name: 'Dashboard',
    hidden: true,
    children: [{
      path: 'dashboard',
      component: () => import('@/views/dashboard/index')
    }]
  },

  {
    path: '/connect',
    component: Layout,
    children: [
      {
        path: '/form/new',
        name: 'ConnectNewForm',
        component: () => import('@/views/connect/form'),
        meta: { title: 'New Connect', icon: 'form' },
        props: { editable: false }
      },
      {
        path: '/form/edit/:name',
        name: 'ConnectEditForm',
        component: () => import('@/views/connect/form'),
        meta: { title: 'Edit Connect', icon: 'form' },
        props: { editable: true }
      },
      {
        path: '/db/:name',
        name: 'DB',
        component: () => import('@/views/connect/db'),
        meta: { title: 'DB', icon: 'form' }
      },
      {
        path: '/keys/:db',
        name: 'Keys',
        component: () => import('@/views/connect/keys'),
        meta: { title: 'Keys', icon: 'form' }
      }
    ]
  },

  { path: '*', redirect: '/404', hidden: true }
]

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
})

