# 3 使用张量表示真实数据

本章将介绍

* 将不同类型的现实世界数据表示为PyTorch张量
* 处理各种数据类型，包括电子表格、时间序列、文本、图像和医学成像
* 从文件加载数据
* 将数据转换为张量
* 调整张量以便于它们可以用作神经网络模型的输入

-------------------------------

张量是PyTorch中数据的基础。神经网络将张量输入并产生张量作为输出。实际上，神经网络内部和优化期间的所有操作都是张量之间的操作，而神经网络中的所有参数（例如权重和偏差）也都是张量。掌握如何在张量上执行操作并对其进行有效索引是成功使用PyTorch等工具的关键。现在你已经了解了张量的基本知识，你对它们灵活性的理解将会大大增强。

我们现在可以解决一个问题：你怎样获取一条数据、一段视频或一段文本，并且用张量表示它们，然后用适合于训练深度学习模型的方式进行处理。

答案就是你将在本章中所学到的内容。本章涵盖了不同类型的数据，并向你展示了如何使它们表示为张量。然后，我们向你展示如何从最常见的磁盘格式中加载数据，并了解这些数据类型的结构，以便于你可以理解怎样为训练神经网络做准备。通常，对于需要解决的问题，原始数据的格式可能并不完美，因此你将有机会在更多有趣的张量操作中练习你的张量处理技巧。你将使用大量的图像和立体数据，因为这些数据类型很常见并且可以以书本格式（book format）很好地复制。我们还将介绍表格数据、时间序列和文本，这也是许多读者感兴趣的。

本章的每个部分都会描述一种数据类型，并且每种数据类型都有其自己的数据集。尽管我们已经对本章进行了结构设计，以便于每种数据类型都建立在前一章的基础上，但如果你愿意，可以随时跳过去。

正如你在电子表格中所发现的一样，我们首先从关于葡萄酒数据的表格数据开始。接下来，我们转到有序的表格数据——来自共享单车程序的时间序列数据集。之后，我们向你展示如何使用Jane Austen的文本数据。文本数据保留了有序的方面，但是引入了将单词表示为数字数组的问题。因为一图胜千言，所以我们还演示了如何处理图像数据。最后，我们使用包含患者解剖结构的3D数组来深入研究医学数据。

在接下来的每个部分中，我们都会在深度学习研究者开始的地方停下来：在将数据输入模型之前。我们鼓励你保留这些数据集。当你开始学习如何训练神经网络模型时，它们将成为极好的数据集。